/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier.v2.messaging;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.glacier.v2.messaging.GlacierMessage;

public class GlacierRangeQueryMessage
extends GlacierMessage {
    protected IdRange requestedRange;
    public static final short TYPE = 7;

    public GlacierRangeQueryMessage(int uid, IdRange requestedRange, NodeHandle source, Id dest, char tag) {
        super(uid, source, dest, false, tag);
        this.requestedRange = requestedRange;
    }

    private GlacierRangeQueryMessage(InputBuffer buf, Endpoint endpoint) throws IOException {
        super(buf, endpoint);
        this.requestedRange = endpoint.readIdRange(buf);
    }

    public IdRange getRequestedRange() {
        return this.requestedRange;
    }

    public short getType() {
        return 7;
    }

    public String toString() {
        return "[GlacierRangeQuery #" + this.getUID() + " for " + this.requestedRange + "]";
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        super.serialize(buf);
        this.requestedRange.serialize(buf);
    }

    public static GlacierRangeQueryMessage build(InputBuffer buf, Endpoint endpoint) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return new GlacierRangeQueryMessage(buf, endpoint);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }
}

