/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier.v2.messaging;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawMessage;

public abstract class GlacierMessage
implements RawMessage {
    protected int id;
    protected char tag;
    protected NodeHandle source;
    protected Id dest;
    protected boolean isResponse;
    private static final long serialVersionUID = -5849182107707420256L;

    protected GlacierMessage(int id, NodeHandle source, Id dest, boolean isResponse, char tag) {
        this.id = id;
        this.source = source;
        this.dest = dest;
        this.isResponse = isResponse;
        this.tag = tag;
    }

    public GlacierMessage(InputBuffer buf, Endpoint endpoint) throws IOException {
        this.id = buf.readInt();
        this.tag = buf.readChar();
        this.isResponse = buf.readBoolean();
        this.dest = endpoint.readId(buf, buf.readShort());
        this.source = endpoint.readNodeHandle(buf);
    }

    public byte getPriority() {
        return 25;
    }

    public int getUID() {
        return this.id;
    }

    public NodeHandle getSource() {
        return this.source;
    }

    public Id getDestination() {
        return this.dest;
    }

    public boolean isResponse() {
        return this.isResponse;
    }

    public char getTag() {
        return this.tag;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeInt(this.id);
        buf.writeChar(this.tag);
        buf.writeBoolean(this.isResponse);
        buf.writeShort(this.dest.getType());
        this.dest.serialize(buf);
        this.source.serialize(buf);
    }
}

