/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier.v2.messaging;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.glacier.Fragment;
import rice.p2p.glacier.FragmentKey;
import rice.p2p.glacier.v2.Manifest;
import rice.p2p.glacier.v2.messaging.GlacierMessage;

public class GlacierDataMessage
extends GlacierMessage {
    protected FragmentKey[] keys;
    protected Fragment[] fragments;
    protected Manifest[] manifests;
    public static final short TYPE = 1;

    public GlacierDataMessage(int uid, FragmentKey key, Fragment fragment, Manifest manifest, NodeHandle source, Id dest, boolean isResponse, char tag) {
        this(uid, new FragmentKey[]{key}, new Fragment[]{fragment}, new Manifest[]{manifest}, source, dest, isResponse, tag);
    }

    public GlacierDataMessage(int uid, FragmentKey[] keys, Fragment[] fragments, Manifest[] manifests, NodeHandle source, Id dest, boolean isResponse, char tag) {
        super(uid, source, dest, isResponse, tag);
        this.keys = keys;
        this.fragments = fragments;
        this.manifests = manifests;
    }

    private GlacierDataMessage(InputBuffer buf, Endpoint endpoint) throws IOException {
        super(buf, endpoint);
        int i;
        this.fragments = new Fragment[buf.readInt()];
        for (i = 0; i < this.fragments.length; ++i) {
            if (!buf.readBoolean()) continue;
            this.fragments[i] = new Fragment(buf);
        }
        this.keys = new FragmentKey[buf.readInt()];
        for (i = 0; i < this.keys.length; ++i) {
            this.keys[i] = new FragmentKey(buf, endpoint);
        }
        this.manifests = new Manifest[buf.readInt()];
        for (i = 0; i < this.manifests.length; ++i) {
            if (!buf.readBoolean()) continue;
            this.manifests[i] = new Manifest(buf);
        }
    }

    public FragmentKey getKey(int index) {
        return this.keys[index];
    }

    public Fragment getFragment(int index) {
        return this.fragments[index];
    }

    public Manifest getManifest(int index) {
        return this.manifests[index];
    }

    public short getType() {
        return 1;
    }

    public int numKeys() {
        return this.keys.length;
    }

    public String toString() {
        return "[GlacierData for " + this.keys[0] + " (" + (this.numKeys() - 1) + " more keys)]";
    }

    public void serialize(OutputBuffer buf) throws IOException {
        int i;
        buf.writeByte((byte)0);
        super.serialize(buf);
        int l = this.fragments.length;
        buf.writeInt(l);
        for (i = 0; i < l; ++i) {
            if (this.fragments[i] == null) {
                buf.writeBoolean(false);
                continue;
            }
            buf.writeBoolean(true);
            this.fragments[i].serialize(buf);
        }
        l = this.keys.length;
        buf.writeInt(l);
        for (i = 0; i < l; ++i) {
            this.keys[i].serialize(buf);
        }
        l = this.manifests.length;
        buf.writeInt(l);
        for (i = 0; i < l; ++i) {
            if (this.manifests[i] == null) {
                buf.writeBoolean(false);
                continue;
            }
            buf.writeBoolean(true);
            this.manifests[i].serialize(buf);
        }
    }

    public static GlacierDataMessage build(InputBuffer buf, Endpoint endpoint) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return new GlacierDataMessage(buf, endpoint);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }
}

