/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier;

import java.io.IOException;
import java.io.Serializable;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.multiring.RingId;
import rice.p2p.util.MathUtils;

public class VersionKey
implements Id,
Serializable,
Comparable {
    protected Id id;
    protected long version;
    public static final short TYPE = 41;
    private static final long serialVersionUID = -7473630685140924130L;

    public VersionKey(Id id, long version) {
        this.id = id;
        this.version = version;
    }

    public VersionKey(InputBuffer buf, Endpoint endpoint) throws IOException {
        this.version = buf.readLong();
        this.id = endpoint.readId(buf, buf.readShort());
    }

    public long getVersion() {
        return this.version;
    }

    public Id getId() {
        return this.id;
    }

    public int getByteArrayLength() {
        return this.id.getByteArrayLength() + 8;
    }

    public boolean isBetween(Id ccw, Id cw) {
        throw new RuntimeException("VersionKey.isBetween() is not supported!");
    }

    public short getType() {
        return 41;
    }

    public boolean equals(Object peer) {
        if (!(peer instanceof VersionKey)) {
            return false;
        }
        VersionKey fk = (VersionKey)peer;
        return fk.version == this.version && fk.id.equals(this.id);
    }

    public String toString() {
        return this.id.toString() + "v" + this.version;
    }

    public String toStringFull() {
        return this.id.toStringFull() + "v" + this.version;
    }

    public int compareTo(Object o) {
        int idResult = this.id.compareTo(((VersionKey)o).id);
        if (idResult != 0) {
            return idResult;
        }
        if (this.version - ((VersionKey)o).version < 0L) {
            return -1;
        }
        if (this.version - ((VersionKey)o).version > 0L) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return this.id.hashCode() + new Long(this.version).hashCode();
    }

    public byte[] toByteArray() {
        byte[] result = new byte[this.getByteArrayLength()];
        this.toByteArray(result, 0);
        return result;
    }

    public void toByteArray(byte[] result, int offset) {
        this.id.toByteArray(result, offset);
        MathUtils.longToByteArray(this.version, result, offset + this.id.getByteArrayLength());
    }

    public Id.Distance longDistanceFromId(Id nid) {
        throw new RuntimeException("VersionKey.longDistanceFromId() is not supported!");
    }

    public Id.Distance distanceFromId(Id nid) {
        throw new RuntimeException("VersionKey.distanceFromId() is not supported!");
    }

    public Id addToId(Id.Distance offset) {
        throw new RuntimeException("VersionKey.addToId() is not supported!");
    }

    public boolean clockwise(Id nid) {
        throw new RuntimeException("VersionKey.clockwise() is not supported!");
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeLong(this.version);
        buf.writeShort(this.id.getType());
        this.id.serialize(buf);
    }

    public static VersionKey build(String s) {
        String[] sArray = s.split("v");
        return new VersionKey(RingId.build(sArray[0]), Long.parseLong(sArray[1]));
    }
}

