/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier;

import java.io.IOException;
import java.util.Arrays;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.glacier.Fragment;
import rice.p2p.past.PastContent;
import rice.p2p.past.rawserialization.JavaSerializedPastContent;
import rice.p2p.past.rawserialization.PastContentDeserializer;
import rice.p2p.past.rawserialization.RawPastContent;
import rice.p2p.util.rawserialization.SimpleInputBuffer;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;

public class ErasureCodec {
    protected int numFragments;
    protected int numSurvivors;
    protected Environment environment;
    protected Logger logger;
    static final int Lfield = 10;
    static final int MultField = 1023;
    static int[] ExpToFieldElt;
    static int[] FieldEltToExp;
    static boolean isEltInitialized;

    public ErasureCodec(int _numFragments, int _numSurvivors, Environment env) {
        this.environment = env;
        this.logger = this.environment.getLogManager().getLogger(this.getClass(), null);
        this.numFragments = _numFragments;
        this.numSurvivors = _numSurvivors;
        if (!isEltInitialized) {
            this.initElt();
        }
    }

    public void dump(byte[] data) {
        String hex = "0123456789ABCDEF";
        String s = "";
        for (int i = 0; i < data.length; ++i) {
            int d = data[i];
            if (d < 0) {
                d += 256;
            }
            int hi = d >> 4;
            int lo = d & 0xF;
            s = s + hex.charAt(hi) + "" + hex.charAt(lo);
            s = i % 16 == 15 || i == data.length - 1 ? s + "\n" : s + " ";
        }
        if (this.logger.level <= 800) {
            this.logger.log(s);
        }
    }

    public Fragment[] encodeObject(PastContent obj, boolean[] generateFragment) {
        return this.encodeObject(obj instanceof RawPastContent ? (RawPastContent)obj : new JavaSerializedPastContent(obj), generateFragment);
    }

    public Fragment[] encodeObject(RawPastContent obj, boolean[] generateFragment) {
        if (this.logger.level <= 400) {
            this.logger.log("Serialize object: " + obj);
        }
        try {
            SimpleOutputBuffer sob = new SimpleOutputBuffer();
            sob.writeShort(obj.getType());
            obj.serialize(sob);
            return this.encode(sob.getBytes(), sob.getWritten(), generateFragment);
        }
        catch (IOException ioe) {
            if (this.logger.level <= 900) {
                this.logger.log("Cannot serialize object: " + ioe);
            }
            return null;
        }
    }

    protected void encodeChunk(int[] buffer) {
        for (int row = 0; row < this.numFragments - this.numSurvivors; ++row) {
            for (int col = 0; col < this.numSurvivors; ++col) {
                int exponent = (1023 - FieldEltToExp[row ^ col ^ 0x200]) % 1023;
                for (int row_bit = 0; row_bit < 10; ++row_bit) {
                    for (int col_bit = 0; col_bit < 10; ++col_bit) {
                        if ((ExpToFieldElt[exponent + row_bit] & 1 << col_bit) == 0) continue;
                        int n = this.numSurvivors * 10 + row * 10 + row_bit;
                        buffer[n] = buffer[n] ^ buffer[col_bit + col * 10];
                    }
                }
            }
        }
    }

    public Fragment[] encode(byte[] bytes, int length, boolean[] generateFragment) {
        int wantFragments = 0;
        for (int i = 0; i < generateFragment.length; ++i) {
            if (!generateFragment[i]) continue;
            ++wantFragments;
        }
        int numWords = (length + 3) / 4;
        int wordsPerGroup = this.numSurvivors * 10;
        int numGroups = (numWords + (wordsPerGroup - 1)) / wordsPerGroup;
        int wordsPerFragment = numGroups * 10;
        int[] buffer = new int[this.numFragments * 10];
        Fragment[] frag = new Fragment[this.numFragments];
        for (int i = 0; i < this.numFragments; ++i) {
            frag[i] = generateFragment[i] ? new Fragment(wordsPerFragment * 4) : null;
        }
        for (int g = 0; g < numGroups; ++g) {
            int i;
            int offset = g * wordsPerGroup * 4;
            int wordsHere = Math.min((length - offset + 3) / 4, wordsPerGroup);
            Arrays.fill(buffer, 0);
            for (i = 0; i < wordsHere; ++i) {
                byte b0 = offset + 4 * i + 0 < length ? bytes[offset + 4 * i + 0] : (byte)0;
                byte b1 = offset + 4 * i + 1 < length ? bytes[offset + 4 * i + 1] : (byte)0;
                byte b2 = offset + 4 * i + 2 < length ? bytes[offset + 4 * i + 2] : (byte)0;
                byte b3 = offset + 4 * i + 3 < length ? bytes[offset + 4 * i + 3] : (byte)0;
                buffer[i] = b0 << 24 | b1 << 16 & 0xFF0000 | b2 << 8 & 0xFF00 | b3 & 0xFF;
            }
            this.encodeChunk(buffer);
            for (i = 0; i < this.numFragments; ++i) {
                if (!generateFragment[i]) continue;
                for (int j = 0; j < 10; ++j) {
                    frag[i].payload[4 * (g * 10 + j) + 0] = (byte)(buffer[i * 10 + j] & 0xFF);
                    frag[i].payload[4 * (g * 10 + j) + 1] = (byte)(buffer[i * 10 + j] >> 8 & 0xFF);
                    frag[i].payload[4 * (g * 10 + j) + 2] = (byte)(buffer[i * 10 + j] >> 16 & 0xFF);
                    frag[i].payload[4 * (g * 10 + j) + 3] = (byte)(buffer[i * 10 + j] >> 24 & 0xFF);
                }
            }
        }
        return frag;
    }

    protected void decodeChunk(int[] buffer, int nExtra, int[] RowInd, boolean[] haveFragment, long[][] InvMat, int[] ColInd) {
        int col_bit;
        int row_bit;
        int exponent;
        int col;
        int row;
        int[] M = new int[(this.numFragments - this.numSurvivors) * 10];
        for (int i = 0; i < nExtra; ++i) {
            for (int j = 0; j < 10; ++j) {
                M[i * 10 + j] = buffer[(RowInd[i] + this.numSurvivors) * 10 + j];
            }
        }
        for (row = 0; row < nExtra; ++row) {
            for (col = 0; col < this.numSurvivors; ++col) {
                if (!haveFragment[col]) continue;
                exponent = (1023 - FieldEltToExp[RowInd[row] ^ col ^ 0x200]) % 1023;
                for (row_bit = 0; row_bit < 10; ++row_bit) {
                    for (col_bit = 0; col_bit < 10; ++col_bit) {
                        if ((ExpToFieldElt[exponent + row_bit] & 1 << col_bit) == 0) continue;
                        int n = row_bit + row * 10;
                        M[n] = M[n] ^ buffer[col_bit + col * 10];
                    }
                }
            }
        }
        for (row = 0; row < nExtra; ++row) {
            for (col = 0; col < nExtra; ++col) {
                exponent = (int)InvMat[row][col];
                for (row_bit = 0; row_bit < 10; ++row_bit) {
                    for (col_bit = 0; col_bit < 10; ++col_bit) {
                        if ((ExpToFieldElt[exponent + row_bit] & 1 << col_bit) == 0) continue;
                        int n = row_bit + ColInd[row] * 10;
                        buffer[n] = buffer[n] ^ M[col_bit + col * 10];
                    }
                }
            }
        }
    }

    public PastContent decode(Fragment[] frag, Endpoint endpoint, PastContentDeserializer pcd) {
        block23: {
            int i;
            Fragment firstFrag = null;
            for (int i2 = 0; i2 < frag.length; ++i2) {
                if (frag[i2] == null) continue;
                firstFrag = frag[i2];
            }
            if (frag.length != this.numFragments) {
                return null;
            }
            int firstFragment = -1;
            for (int i3 = 0; i3 < this.numFragments && firstFragment == -1; ++i3) {
                if (frag[i3] == null) continue;
                firstFragment = i3;
            }
            int wordsPerFragment = (frag[firstFragment].payload.length + 3) / 4;
            int numGroups = wordsPerFragment / 10;
            boolean[] haveFragment = new boolean[this.numFragments];
            Arrays.fill(haveFragment, false);
            for (int i4 = 0; i4 < this.numFragments; ++i4) {
                if (frag[i4] == null) continue;
                haveFragment[i4] = true;
            }
            int[] ColInd = new int[this.numSurvivors];
            int[] RowInd = new int[this.numFragments - this.numSurvivors];
            int nMissing = 0;
            int nExtra = 0;
            for (i = 0; i < this.numSurvivors; ++i) {
                if (haveFragment[i]) continue;
                ColInd[nMissing++] = i;
            }
            for (i = 0; i < this.numFragments - this.numSurvivors; ++i) {
                if (!haveFragment[this.numSurvivors + i]) continue;
                RowInd[nExtra++] = i;
            }
            if (nMissing > nExtra) {
                return null;
            }
            if (nMissing < nExtra) {
                nExtra = nMissing;
            }
            int[] C = new int[this.numFragments - this.numSurvivors];
            Arrays.fill(C, 0);
            int[] D = new int[this.numFragments - this.numSurvivors];
            Arrays.fill(D, 0);
            int[] E = new int[this.numFragments - this.numSurvivors];
            Arrays.fill(E, 0);
            int[] F = new int[this.numFragments - this.numSurvivors];
            Arrays.fill(F, 0);
            for (int row = 0; row < nExtra; ++row) {
                for (int col = 0; col < nExtra; ++col) {
                    if (col != row) {
                        int n = row;
                        C[n] = C[n] + FieldEltToExp[RowInd[row] ^ RowInd[col]];
                        int n2 = row;
                        D[n2] = D[n2] + FieldEltToExp[ColInd[row] ^ ColInd[col]];
                    }
                    int n = row;
                    E[n] = E[n] + FieldEltToExp[RowInd[row] ^ ColInd[col] ^ 0x200];
                    int n3 = col;
                    F[n3] = F[n3] + FieldEltToExp[RowInd[row] ^ ColInd[col] ^ 0x200];
                }
            }
            long[][] InvMat = new long[nExtra][nExtra];
            for (int row = 0; row < nExtra; ++row) {
                for (int col = 0; col < nExtra; ++col) {
                    InvMat[row][col] = E[col] + F[row] - C[col] - D[row] - FieldEltToExp[RowInd[col] ^ ColInd[row] ^ 0x200];
                    InvMat[row][col] = InvMat[row][col] >= 0L ? InvMat[row][col] % 1023L : (1023L - -InvMat[row][col] % 1023L) % 1023L;
                }
            }
            byte[] bytes = new byte[this.numSurvivors * wordsPerFragment * 4];
            int[] buffer = new int[this.numFragments * 10];
            for (int g = 0; g < numGroups; ++g) {
                int i5;
                Arrays.fill(buffer, 0);
                for (i5 = 0; i5 < this.numFragments; ++i5) {
                    if (!haveFragment[i5]) continue;
                    for (int j = 0; j < 10; ++j) {
                        buffer[i5 * 10 + j] = (frag[i5].payload[4 * (g * 10 + j) + 0] & 0xFF) + (frag[i5].payload[4 * (g * 10 + j) + 1] << 8 & 0xFF00) + (frag[i5].payload[4 * (g * 10 + j) + 2] << 16 & 0xFF0000) + (frag[i5].payload[4 * (g * 10 + j) + 3] << 24);
                    }
                }
                this.decodeChunk(buffer, nExtra, RowInd, haveFragment, InvMat, ColInd);
                for (i5 = 0; i5 < this.numSurvivors * 10; ++i5) {
                    bytes[4 * (g * (this.numSurvivors * 10) + i5) + 0] = (byte)(buffer[i5] >> 24);
                    bytes[4 * (g * (this.numSurvivors * 10) + i5) + 1] = (byte)(buffer[i5] >> 16 & 0xFF);
                    bytes[4 * (g * (this.numSurvivors * 10) + i5) + 2] = (byte)(buffer[i5] >> 8 & 0xFF);
                    bytes[4 * (g * (this.numSurvivors * 10) + i5) + 3] = (byte)(buffer[i5] & 0xFF);
                }
            }
            try {
                return this.deserialize(bytes, endpoint, pcd);
            }
            catch (IOException ioe) {
                if (this.logger.level <= 900) {
                    this.logger.logException("", ioe);
                }
            }
            catch (ClassNotFoundException cnfe) {
                if (this.logger.level <= 900) {
                    this.logger.logException("", cnfe);
                }
            }
            catch (IllegalStateException ise) {
                if (this.logger.level > 900) break block23;
                this.logger.logException("", ise);
            }
        }
        return null;
    }

    protected PastContent deserialize(byte[] bytes, Endpoint endpoint, PastContentDeserializer pcd) throws IOException, ClassNotFoundException {
        SimpleInputBuffer sib = new SimpleInputBuffer(bytes);
        short type = sib.readShort();
        return pcd.deserializePastContent(sib, endpoint, type);
    }

    protected void initElt() {
        int i;
        int[] polymask = new int[]{0, 3, 7, 11, 19, 37, 67, 131, 285, 529, 1033, 2053, 4179, 8219, 16427, 32771};
        ExpToFieldElt = new int[1033];
        ErasureCodec.ExpToFieldElt[0] = 1;
        for (i = 1; i < 1032; ++i) {
            ErasureCodec.ExpToFieldElt[i] = ExpToFieldElt[i - 1] << 1;
            if ((ExpToFieldElt[i] & 0x400) == 0) continue;
            int n = i;
            ExpToFieldElt[n] = ExpToFieldElt[n] ^ polymask[10];
        }
        FieldEltToExp = new int[1024];
        ErasureCodec.FieldEltToExp[0] = -1;
        for (i = 0; i < 1023; ++i) {
            ErasureCodec.FieldEltToExp[ErasureCodec.ExpToFieldElt[i]] = i;
        }
    }

    static {
        isEltInitialized = false;
    }
}

