/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.aggregation.messaging;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.past.Past;
import rice.p2p.past.PastContent;
import rice.p2p.past.PastContentHandle;
import rice.p2p.past.PastException;
import rice.p2p.past.rawserialization.JavaSerializedPastContent;
import rice.p2p.past.rawserialization.PastContentDeserializer;
import rice.p2p.past.rawserialization.RawPastContent;

public class NonAggregate
implements RawPastContent {
    public RawPastContent content;
    public static final short TYPE = 2;

    public NonAggregate(PastContent content) {
        this(content instanceof RawPastContent ? (RawPastContent)content : new JavaSerializedPastContent(content));
    }

    public NonAggregate(RawPastContent subContent) {
        this.content = subContent;
    }

    public NonAggregate(InputBuffer buf, Endpoint endpoint, RawPastContent subContent, PastContentDeserializer pcd) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                short subType = buf.readShort();
                PastContent temp = pcd.deserializePastContent(buf, endpoint, subType);
                if (subType == 0) {
                    this.content = new JavaSerializedPastContent(temp);
                    break;
                }
                this.content = (RawPastContent)temp;
                break;
            }
            default: {
                throw new IOException("Unknown Version: " + version);
            }
        }
    }

    public PastContentHandle getHandle(Past local) {
        return this.content.getHandle(local);
    }

    public Id getId() {
        return this.content.getId();
    }

    public boolean isMutable() {
        return this.content.isMutable();
    }

    public short getType() {
        return 2;
    }

    public PastContent checkInsert(Id id, PastContent existingContent) throws PastException {
        this.content = (RawPastContent)this.content.checkInsert(id, ((NonAggregate)existingContent).content);
        return this;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        buf.writeShort(this.content.getType());
        this.content.serialize(buf);
    }
}

