/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.aggregation;

import java.io.Serializable;
import rice.p2p.commonapi.Id;

public class ObjectDescriptor
implements Serializable,
Comparable {
    public Id key;
    public long version;
    public long currentLifetime;
    public long refreshedLifetime;
    public int size;
    private static final long serialVersionUID = -3035115249019556223L;

    public ObjectDescriptor(Id key, long version, long currentLifetime, long refreshedLifetime, int size) {
        this.key = key;
        this.currentLifetime = currentLifetime;
        this.refreshedLifetime = refreshedLifetime;
        this.size = size;
        this.version = version;
    }

    public boolean isAliveAt(long pointInTime) {
        return this.currentLifetime > pointInTime || this.refreshedLifetime > pointInTime;
    }

    public String toString() {
        return "objDesc[" + this.key.toStringFull() + "v" + this.version + ", lt=" + this.currentLifetime + ", rt=" + this.refreshedLifetime + ", size=" + this.size + "]";
    }

    public int compareTo(Object other) {
        ObjectDescriptor metadata = (ObjectDescriptor)other;
        int result = this.key.compareTo(metadata.key);
        if (result != 0) {
            return result;
        }
        if (metadata.version > this.version) {
            return -1;
        }
        if (metadata.version < this.version) {
            return 1;
        }
        if (metadata.currentLifetime > this.currentLifetime) {
            return -1;
        }
        if (metadata.currentLifetime < this.currentLifetime) {
            return 1;
        }
        if (metadata.refreshedLifetime > this.refreshedLifetime) {
            return -1;
        }
        if (metadata.refreshedLifetime < this.refreshedLifetime) {
            return 1;
        }
        if (metadata.size > this.size) {
            return -1;
        }
        if (metadata.size < this.size) {
            return 1;
        }
        return 0;
    }
}

