/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.aggregation;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import rice.Continuation;
import rice.Executable;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.environment.params.Parameters;
import rice.p2p.aggregation.Aggregate;
import rice.p2p.aggregation.AggregateDescriptor;
import rice.p2p.aggregation.AggregateFactory;
import rice.p2p.aggregation.AggregateHandle;
import rice.p2p.aggregation.AggregateList;
import rice.p2p.aggregation.Aggregation;
import rice.p2p.aggregation.AggregationDefaultPolicy;
import rice.p2p.aggregation.AggregationException;
import rice.p2p.aggregation.AggregationImpl;
import rice.p2p.aggregation.AggregationPolicy;
import rice.p2p.aggregation.AggregationStatistics;
import rice.p2p.aggregation.ObjectDescriptor;
import rice.p2p.aggregation.messaging.AggregationMessage;
import rice.p2p.aggregation.messaging.AggregationTimeoutMessage;
import rice.p2p.aggregation.messaging.NonAggregate;
import rice.p2p.aggregation.raw.RawAggregate;
import rice.p2p.aggregation.raw.RawAggregateFactory;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.CancellableTask;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.IdSet;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.p2p.glacier.VersionKey;
import rice.p2p.glacier.VersioningPast;
import rice.p2p.glacier.v2.DebugContent;
import rice.p2p.glacier.v2.GlacierContentHandle;
import rice.p2p.past.Past;
import rice.p2p.past.PastContent;
import rice.p2p.past.PastContentHandle;
import rice.p2p.past.PastImpl;
import rice.p2p.past.gc.GCPast;
import rice.p2p.past.gc.GCPastContent;
import rice.p2p.past.gc.GCPastContentHandle;
import rice.p2p.past.gc.rawserialization.RawGCPastContent;
import rice.p2p.past.rawserialization.JavaPastContentDeserializer;
import rice.p2p.past.rawserialization.JavaPastContentHandleDeserializer;
import rice.p2p.past.rawserialization.JavaSerializedPastContent;
import rice.p2p.past.rawserialization.PastContentDeserializer;
import rice.p2p.past.rawserialization.PastContentHandleDeserializer;
import rice.p2p.past.rawserialization.RawPastContent;
import rice.p2p.util.DebugCommandHandler;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;
import rice.persistence.StorageManager;

public class AggregationImpl
implements GCPast,
VersioningPast,
Aggregation,
Application,
DebugCommandHandler {
    protected final Past aggregateStore;
    protected final StorageManager waitingList;
    protected final AggregationPolicy policy;
    protected final AggregateList aggregateList;
    protected final Endpoint endpoint;
    protected final Past objectStore;
    protected final String instance;
    protected final IdFactory factory;
    protected final Node node;
    private final char tiFlush = '\u0001';
    private final char tiMonitor = (char)2;
    private final char tiConsolidate = (char)3;
    private final char tiStatistics = (char)4;
    private final char tiExpire = (char)5;
    protected Hashtable timers;
    protected Continuation flushWait;
    protected boolean rebuildInProgress;
    protected Vector monitorIDs;
    protected AggregationStatistics stats;
    private final boolean logStatistics;
    private final long flushDelayAfterJoin;
    private final long flushStressInterval;
    private long flushInterval;
    private int maxAggregateSize;
    private int maxObjectsInAggregate;
    private int maxAggregatesPerRun;
    private final boolean addMissingAfterRefresh;
    private final int maxReaggregationPerRefresh;
    private final int nominalReferenceCount;
    private final int maxPointersPerAggregate;
    private final long pointerArrayLifetime;
    private final long aggregateGracePeriod;
    private final long aggrRefreshInterval;
    private final long aggrRefreshDelayAfterJoin;
    private long expirationRenewThreshold;
    private final boolean monitorEnabled;
    private final long monitorRefreshInterval;
    private final long consolidationDelayAfterJoin;
    private long consolidationInterval;
    private long consolidationThreshold;
    private int consolidationMinObjectsInAggregate;
    private double consolidationMinComponentsAlive;
    private int reconstructionMaxConcurrentLookups;
    private final boolean aggregateLogEnabled;
    private final long statsGranularity;
    private final long statsRange;
    private final long statsInterval;
    private final double jitterRange;
    private Environment environment;
    protected Logger logger;
    protected PastContentDeserializer contentDeserializer;
    protected PastContentHandleDeserializer contentHandleDeserializer;
    protected AggregateFactory aggregateFactory;
    private static final long SECONDS = 1000L;
    private static final long MINUTES = 60000L;
    private static final long HOURS = 3600000L;
    private static final long DAYS = 86400000L;
    private static final long WEEKS = 604800000L;

    public AggregationImpl(Node node, Past aggregateStore, Past objectStore, StorageManager waitingList, String configFileName, IdFactory factory, String instance) throws IOException {
        this(node, aggregateStore, objectStore, waitingList, configFileName, factory, instance, null, null);
    }

    public AggregationImpl(Node node, Past aggregateStore, Past objectStore, StorageManager waitingList, String configFileName, IdFactory factory, String instance, AggregationPolicy policy, AggregateFactory aggregateFactory) throws IOException {
        this.environment = node.getEnvironment();
        this.logger = this.environment.getLogManager().getLogger(AggregationImpl.class, instance);
        Parameters p = this.environment.getParameters();
        this.logStatistics = p.getBoolean("p2p_aggregation_logStatistics");
        this.flushDelayAfterJoin = p.getLong("p2p_aggregation_flushDelayAfterJoin");
        this.flushStressInterval = p.getLong("p2p_aggregation_flushStressInterval");
        this.flushInterval = p.getLong("p2p_aggregation_flushInterval");
        this.maxAggregateSize = p.getInt("p2p_aggregation_maxAggregateSize");
        this.maxObjectsInAggregate = p.getInt("p2p_aggregation_maxObjectsInAggregate");
        this.maxAggregatesPerRun = p.getInt("p2p_aggregation_maxAggregatesPerRun");
        this.addMissingAfterRefresh = p.getBoolean("p2p_aggregation_addMissingAfterRefresh");
        this.maxReaggregationPerRefresh = p.getInt("p2p_aggregation_maxReaggregationPerRefresh");
        this.nominalReferenceCount = p.getInt("p2p_aggregation_nominalReferenceCount");
        this.maxPointersPerAggregate = p.getInt("p2p_aggregation_maxPointersPerAggregate");
        this.pointerArrayLifetime = p.getLong("p2p_aggregation_pointerArrayLifetime");
        this.aggregateGracePeriod = p.getLong("p2p_aggregation_aggregateGracePeriod");
        this.aggrRefreshInterval = p.getLong("p2p_aggregation_aggrRefreshInterval");
        this.aggrRefreshDelayAfterJoin = p.getLong("p2p_aggregation_aggrRefreshDelayAfterJoin");
        this.expirationRenewThreshold = p.getLong("p2p_aggregation_expirationRenewThreshold");
        this.monitorEnabled = p.getBoolean("p2p_aggregation_monitorEnabled");
        this.monitorRefreshInterval = p.getLong("p2p_aggregation_monitorRefreshInterval");
        this.consolidationDelayAfterJoin = p.getLong("p2p_aggregation_consolidationDelayAfterJoin");
        this.consolidationInterval = p.getLong("p2p_aggregation_consolidationInterval");
        this.consolidationThreshold = p.getLong("p2p_aggregation_consolidationThreshold");
        this.consolidationMinObjectsInAggregate = p.getInt("p2p_aggregation_consolidationMinObjectsInAggregate");
        this.consolidationMinComponentsAlive = p.getDouble("p2p_aggregation_consolidationMinComponentsAlive");
        this.reconstructionMaxConcurrentLookups = p.getInt("p2p_aggregation_reconstructionMaxConcurrentLookups");
        this.aggregateLogEnabled = p.getBoolean("p2p_aggregation_aggregateLogEnabled");
        this.statsGranularity = p.getLong("p2p_aggregation_statsGranularity");
        this.statsRange = p.getLong("p2p_aggregation_statsRange");
        this.statsInterval = p.getLong("p2p_aggregation_statsInterval");
        this.jitterRange = p.getDouble("p2p_aggregation_jitterRange");
        this.aggregateFactory = aggregateFactory;
        if (this.aggregateFactory == null) {
            this.aggregateFactory = AggregationImpl.getDefaultAggregateFactory();
        }
        this.endpoint = node.buildEndpoint(this, instance);
        this.endpoint.setDeserializer(new MessageDeserializer(){

            public Message deserialize(InputBuffer buf, short type, byte priority, NodeHandle sender) throws IOException {
                return null;
            }
        });
        this.waitingList = waitingList;
        this.instance = instance;
        this.contentDeserializer = new JavaPastContentDeserializer();
        this.contentHandleDeserializer = new JavaPastContentHandleDeserializer();
        this.aggregateStore = aggregateStore;
        this.aggregateStore.setContentDeserializer(new PastContentDeserializer(){

            public PastContent deserializePastContent(InputBuffer buf, Endpoint endpoint, short contentType) throws IOException {
                switch (contentType) {
                    case 1: {
                        return new RawAggregate(buf, endpoint, AggregationImpl.this.contentDeserializer);
                    }
                    case 2: {
                        short subType = buf.readShort();
                        return AggregationImpl.this.contentDeserializer.deserializePastContent(buf, endpoint, subType);
                    }
                }
                throw new IllegalArgumentException("Unknown Type:" + contentType);
            }
        });
        this.aggregateStore.setContentHandleDeserializer(new PastContentHandleDeserializer(){

            public PastContentHandle deserializePastContentHandle(InputBuffer buf, Endpoint endpoint, short contentType) throws IOException {
                switch (contentType) {
                    case 1: {
                        return new AggregateHandle(buf, endpoint);
                    }
                }
                throw new IllegalArgumentException("Unknown Type:" + contentType);
            }
        });
        this.objectStore = objectStore;
        this.node = node;
        this.timers = new Hashtable();
        this.aggregateList = new AggregateList(configFileName, this.getLocalNodeHandle().getId().toString(), factory, this.aggregateLogEnabled, instance, this.environment);
        this.stats = this.aggregateList.getStatistics(this.statsGranularity, this.statsRange, this.nominalReferenceCount);
        this.policy = policy == null ? AggregationImpl.getDefaultPolicy() : policy;
        this.factory = factory;
        this.flushWait = null;
        this.rebuildInProgress = false;
        this.monitorIDs = new Vector();
        if (!this.aggregateList.readOK()) {
            if (this.logger.level <= 900) {
                this.logger.log("Failed to read configuration file; aggregate list must be rebuilt!");
            } else if (this.logger.level <= 800) {
                this.logger.log("Aggregate list read OK -- current root: " + (this.aggregateList.getRoot() == null ? "null" : this.aggregateList.getRoot().toStringFull()));
            }
        }
        this.removeDeadAggregates();
        this.addTimer(this.jitterTerm(this.flushDelayAfterJoin), '\u0001');
        this.addTimer(this.jitterTerm(this.aggrRefreshDelayAfterJoin), '\u0005');
        this.addTimer(this.jitterTerm(this.consolidationDelayAfterJoin), '\u0003');
        this.addTimer(this.statsInterval, '\u0004');
        if (this.monitorEnabled) {
            this.addTimer(this.monitorRefreshInterval, '\u0002');
        }
        this.endpoint.register();
    }

    private int getSize(PastContent obj) {
        try {
            RawPastContent rpc = obj instanceof RawPastContent ? (RawPastContent)obj : new JavaSerializedPastContent(obj);
            SimpleOutputBuffer buf = new SimpleOutputBuffer();
            buf.writeShort(rpc.getType());
            rpc.serialize(buf);
            return buf.getWritten();
        }
        catch (IOException ioe) {
            if (this.logger.level <= 900) {
                this.logger.log("Cannot serialize object, size unknown: " + ioe);
            }
            return 0;
        }
    }

    public Serializable getHandle() {
        return this.aggregateList.getRoot();
    }

    public NodeHandle getLocalNodeHandle() {
        return this.objectStore.getLocalNodeHandle();
    }

    public int getReplicationFactor() {
        return this.objectStore.getReplicationFactor();
    }

    public Past getAggregateStore() {
        return this.aggregateStore;
    }

    public Past getObjectStore() {
        return this.objectStore;
    }

    public int getNumObjectsWaiting() {
        return this.waitingList.scan().numElements();
    }

    public AggregationStatistics getStatistics() {
        return this.stats;
    }

    public String getInstance() {
        return this.instance;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setHandle(Serializable handle, Continuation command) {
        if (this.logger.level <= 800) {
            this.logger.log("setHandle(" + handle + ")");
        }
        if (!(handle instanceof Id)) {
            command.receiveException(new AggregationException("Illegal handle"));
            return;
        }
        if (this.aggregateList.getADC((Id)handle) != null) {
            if (this.logger.level <= 800) {
                this.logger.log("Rebuild: Handle " + handle + " is already covered by current root");
            }
            command.receiveResult(new Boolean(true));
        }
        this.aggregateList.setRoot((Id)handle);
        this.rebuildAggregateList(command);
    }

    public void setFlushInterval(int flushIntervalSec) {
        this.flushInterval = (long)flushIntervalSec * 1000L;
    }

    public void setMaxAggregateSize(int maxAggregateSize) {
        this.maxAggregateSize = maxAggregateSize;
    }

    public void setMaxObjectsInAggregate(int maxObjectsInAggregate) {
        this.maxObjectsInAggregate = maxObjectsInAggregate;
    }

    public void setRenewThreshold(int expirationRenewThresholdHrs) {
        this.expirationRenewThreshold = (long)expirationRenewThresholdHrs * 3600000L;
    }

    public void setConsolidationInterval(long consolidationIntervalSec) {
        this.consolidationInterval = consolidationIntervalSec * 1000L;
    }

    public void setConsolidationThreshold(long consolidationThresholdSec) {
        this.consolidationThreshold = consolidationThresholdSec * 1000L;
    }

    public void setConsolidationMinObjectsPerAggregate(int minObjectsInAggregateArg) {
        this.consolidationMinObjectsInAggregate = minObjectsInAggregateArg;
    }

    public void setConsolidationMinUtilization(double minUtilization) {
        this.consolidationMinComponentsAlive = minUtilization;
    }

    public void setContentDeserializer(PastContentDeserializer deserializer) {
        this.contentDeserializer = deserializer;
        this.objectStore.setContentDeserializer(this.contentDeserializer);
    }

    public void setContentHandleDeserializer(PastContentHandleDeserializer deserializer) {
        this.contentHandleDeserializer = deserializer;
        this.objectStore.setContentHandleDeserializer(deserializer);
    }

    private long jitterTerm(long basis) {
        return (long)((1.0 - this.jitterRange) * (double)basis) + (long)this.environment.getRandomSource().nextInt((int)(2.0 * this.jitterRange * (double)basis));
    }

    private void addTimer(long timeoutMsec, char timeoutID) {
        CancellableTask timer = this.endpoint.scheduleMessage(new AggregationTimeoutMessage(timeoutID, this.getLocalNodeHandle()), timeoutMsec);
        this.timers.put(new Integer(timeoutID), timer);
    }

    private void removeTimer(int timeoutID) {
        CancellableTask timer = (CancellableTask)this.timers.remove(new Integer(timeoutID));
        if (timer != null) {
            timer.cancel();
        }
    }

    private void panic(String s) throws Error {
        Error err = new Error("Panic " + s);
        if (this.logger.level <= 1000) {
            this.logger.logException("PANIC: " + s, err);
        }
        throw err;
    }

    public String handleDebugCommand(String command) {
        if (command.indexOf(" ") < 0) {
            return null;
        }
        String requestedInstance = command.substring(0, command.indexOf(" "));
        String myInstance = "aggr." + this.instance.substring(this.instance.lastIndexOf("-") + 1);
        String cmd = command.substring(requestedInstance.length() + 1);
        if (!requestedInstance.equals(myInstance) && !requestedInstance.equals("a")) {
            String subResult = null;
            if (subResult == null && this.aggregateStore instanceof DebugCommandHandler) {
                subResult = ((DebugCommandHandler)((Object)this.aggregateStore)).handleDebugCommand(command);
            }
            if (subResult == null && this.objectStore instanceof DebugCommandHandler) {
                subResult = ((DebugCommandHandler)((Object)this.objectStore)).handleDebugCommand(command);
            }
            return subResult;
        }
        if (this.logger.level <= 800) {
            this.logger.log("Debug command: " + cmd);
        }
        if (cmd.startsWith("status")) {
            return this.stats.numObjectsTotal + " objects total\n" + this.stats.numObjectsAlive + " objects alive\n" + this.stats.numAggregatesTotal + " aggregates total\n" + this.stats.numPointerArrays + " pointer arrays\n" + this.stats.criticalAggregates + " critical aggregates\n" + this.stats.orphanedAggregates + " orphaned aggregates\n";
        }
        if (cmd.startsWith("insert")) {
            int numObjects = Integer.parseInt(cmd.substring(7));
            String result = "";
            for (int i = 0; i < numObjects; ++i) {
                Id randomID = this.factory.buildRandomId(this.environment.getRandomSource());
                result = result + randomID.toStringFull() + "\n";
                this.insert(new DebugContent(randomID, false, 0L, new byte[0]), this.environment.getTimeSource().currentTimeMillis() + 120000L, new Continuation(){

                    public void receiveResult(Object o) {
                    }

                    public void receiveException(Exception e) {
                    }
                });
            }
            return result + numObjects + " object(s) created\n";
        }
        if (cmd.startsWith("show config")) {
            return "flushDelayAfterJoin = " + (int)(this.flushDelayAfterJoin / 1000L) + " sec\n" + "flushInterval = " + (int)(this.flushInterval / 1000L) + " sec\n" + "maxAggregateSize = " + this.maxAggregateSize + " bytes\n" + "maxObjectsInAggregate = " + this.maxObjectsInAggregate + " objects\n" + "maxAggregatesPerRun = " + this.maxAggregatesPerRun + " aggregates\n" + "addMissingAfterRefresh = " + this.addMissingAfterRefresh + "\n" + "nominalReferenceCount = " + this.nominalReferenceCount + "\n" + "maxPointersPerAggregate = " + this.maxPointersPerAggregate + "\n" + "pointerArrayLifetime = " + (int)(this.pointerArrayLifetime / 86400000L) + " days\n" + "aggrRefreshInterval = " + (int)(this.aggrRefreshInterval / 1000L) + " sec\n" + "aggrRefreshDelayAfterJoin = " + (int)(this.aggrRefreshDelayAfterJoin / 1000L) + " sec\n" + "expirationRenewThreshold = " + (int)(this.expirationRenewThreshold / 3600000L) + " hrs\n" + "consolidationDelayAfterJoin = " + (int)(this.consolidationDelayAfterJoin / 1000L) + " sec\n" + "consolidationInterval = " + (int)(this.consolidationInterval / 1000L) + " sec\n" + "consolidationThreshold = " + (int)(this.consolidationThreshold / 3600000L) + " hrs\n" + "consolidationMinObjectsInAggregate = " + this.consolidationMinObjectsInAggregate + "\n" + "consolidationMinComponentsAlive = " + this.consolidationMinComponentsAlive + "\n";
        }
        if (cmd.startsWith("ls")) {
            Enumeration enumeration = this.aggregateList.elements();
            StringBuffer result = new StringBuffer();
            int numAggr = 0;
            int numObj = 0;
            long now = this.environment.getTimeSource().currentTimeMillis();
            if (cmd.indexOf("-r") < 0) {
                now = 0L;
            }
            this.aggregateList.recalculateReferenceCounts(null);
            this.aggregateList.resetMarkers();
            while (enumeration.hasMoreElements()) {
                int i;
                AggregateDescriptor aggr = (AggregateDescriptor)enumeration.nextElement();
                if (aggr.marker) continue;
                result.append("***" + aggr.key.toStringFull() + " (" + aggr.objects.length + " obj, " + aggr.pointers.length + " ptr, " + aggr.referenceCount + " ref, exp=" + (aggr.currentLifetime - now) + ")\n");
                for (i = 0; i < aggr.objects.length; ++i) {
                    result.append("    #" + i + " " + aggr.objects[i].key.toStringFull() + "v" + aggr.objects[i].version + ", lt=" + (aggr.objects[i].currentLifetime - now) + ", rt=" + (aggr.objects[i].refreshedLifetime - now) + ", size=" + aggr.objects[i].size + " bytes\n");
                }
                for (i = 0; i < aggr.pointers.length; ++i) {
                    result.append("    Ref " + aggr.pointers[i].toStringFull() + "\n");
                }
                result.append("\n");
                aggr.marker = true;
                ++numAggr;
                numObj += aggr.objects.length;
            }
            result.append(numAggr + " aggregate(s), " + numObj + " object(s)");
            return result.toString();
        }
        if (cmd.startsWith("write list")) {
            this.aggregateList.writeToDisk();
            return "Done, new root is " + (this.aggregateList.getRoot() == null ? "null" : this.aggregateList.getRoot().toStringFull());
        }
        if (cmd.length() >= 5 && cmd.substring(0, 5).equals("reset")) {
            final String[] ret = new String[]{null};
            this.reset(new Continuation(){

                public void receiveResult(Object o) {
                    ret[0] = "result(" + o + ")";
                }

                public void receiveException(Exception e) {
                    ret[0] = "exception(" + e + ")";
                }
            });
            while (ret[0] == null) {
                Thread.yield();
            }
            return ret[0];
        }
        if (cmd.startsWith("flush")) {
            final String[] ret = new String[]{null};
            this.flush(new Continuation(){

                public void receiveResult(Object o) {
                    ret[0] = "result(" + o + ")";
                }

                public void receiveException(Exception e) {
                    ret[0] = "exception(" + e + ")";
                }
            });
            while (ret[0] == null) {
                Thread.yield();
            }
            return ret[0];
        }
        if (cmd.startsWith("get root")) {
            return "root=" + (this.aggregateList.getRoot() == null ? "null" : this.aggregateList.getRoot().toStringFull());
        }
        if (cmd.startsWith("set root")) {
            final String[] ret = new String[]{null};
            this.setHandle(this.factory.buildIdFromToString(cmd.substring(9)), new Continuation(){

                public void receiveResult(Object o) {
                    ret[0] = "result(" + o + ")";
                }

                public void receiveException(Exception e) {
                    ret[0] = "exception(" + e + ")";
                }
            });
            while (ret[0] == null) {
                Thread.yield();
            }
            return ret[0];
        }
        if (cmd.startsWith("lookup")) {
            Id id = this.factory.buildIdFromToString(cmd.substring(7));
            final String[] ret = new String[]{null};
            this.lookup(id, false, new Continuation(){

                public void receiveResult(Object o) {
                    ret[0] = "result(" + o + ")";
                }

                public void receiveException(Exception e) {
                    ret[0] = "exception(" + e + ")";
                }
            });
            while (ret[0] == null) {
                Thread.yield();
            }
            return "lookup(" + id + ")=" + ret[0];
        }
        if (cmd.startsWith("handles")) {
            String args = cmd.substring(8);
            Id id = this.factory.buildIdFromToString(args.substring(args.indexOf(32) + 1));
            int max = Integer.parseInt(args.substring(0, args.indexOf(32)));
            final String[] ret = new String[]{null};
            this.lookupHandles(id, max, new Continuation(){

                public void receiveResult(Object o) {
                    if (o instanceof PastContentHandle[]) {
                        PastContentHandle[] oA = (PastContentHandle[])o;
                        ret[0] = "";
                        for (int i = 0; i < oA.length; ++i) {
                            ret[0] = ret[0] + "#" + i + " " + oA[i] + "\n";
                        }
                        ret[0] = ret[0] + oA.length + " handle(s) returned\n";
                    } else {
                        ret[0] = "result(" + o + ") -- no handles returned!";
                    }
                }

                public void receiveException(Exception e) {
                    ret[0] = "exception(" + e + ")";
                }
            });
            while (ret[0] == null) {
                Thread.yield();
            }
            return "Handles(" + max + "," + id + "):\n" + ret[0];
        }
        if (cmd.startsWith("refresh all")) {
            String result;
            int i;
            long expiration = this.environment.getTimeSource().currentTimeMillis() + Long.parseLong(cmd.substring(12));
            TreeSet<Id> ids = new TreeSet<Id>();
            this.aggregateList.resetMarkers();
            Enumeration enumeration = this.aggregateList.elements();
            while (enumeration.hasMoreElements()) {
                AggregateDescriptor aggr = (AggregateDescriptor)enumeration.nextElement();
                if (aggr.marker) continue;
                aggr.marker = true;
                for (i = 0; i < aggr.objects.length; ++i) {
                    ids.add(aggr.objects[i].key);
                }
            }
            if (!ids.isEmpty()) {
                Id[] allIds = ids.toArray(new Id[0]);
                result = "Refreshing " + allIds.length + " keys...\n";
                for (i = 0; i < allIds.length; ++i) {
                    result = result + "#" + i + " " + allIds[i].toStringFull() + "\n";
                }
                final String[] ret = new String[]{null};
                this.refresh(allIds, expiration, new Continuation(){

                    public void receiveResult(Object o) {
                        ret[0] = "result(" + o + ")";
                    }

                    public void receiveException(Exception e) {
                        ret[0] = "exception(" + e + ")";
                    }
                });
                while (ret[0] == null) {
                    Thread.yield();
                }
                result = result + ret[0];
            } else {
                result = "Aggregate list is empty; nothing to refresh!";
            }
            return result;
        }
        if (cmd.startsWith("refresh")) {
            String args = cmd.substring(8);
            String expirationArg = args.substring(args.lastIndexOf(32) + 1);
            String keyArg = args.substring(0, args.lastIndexOf(32));
            Id id = this.factory.buildIdFromToString(keyArg);
            long expiration = this.environment.getTimeSource().currentTimeMillis() + Long.parseLong(expirationArg);
            final String[] ret = new String[]{null};
            this.refresh(new Id[]{id}, expiration, new Continuation(){

                public void receiveResult(Object o) {
                    ret[0] = "result(" + o + ")";
                }

                public void receiveException(Exception e) {
                    ret[0] = "exception(" + e + ")";
                }
            });
            while (ret[0] == null) {
                Thread.yield();
            }
            return "refresh(" + id + ", " + expiration + ")=" + ret[0];
        }
        if (cmd.startsWith("monitor remove") && this.monitorEnabled) {
            String[] args = cmd.substring(15).split(" ");
            if (args.length == 1) {
                int howMany = Integer.parseInt(args[0]);
                if (howMany > this.monitorIDs.size()) {
                    howMany = this.monitorIDs.size();
                }
                for (int i = 0; i < howMany; ++i) {
                    this.monitorIDs.removeElementAt(this.environment.getRandomSource().nextInt(this.monitorIDs.size()));
                }
                return "Removed " + howMany + " elements; " + this.monitorIDs.size() + " elements left";
            }
            return "Syntax: monitor remove <howMany>";
        }
        if (cmd.startsWith("monitor status") && this.monitorEnabled) {
            return "Monitor is " + (this.monitorEnabled ? "enabled, monitoring " + this.monitorIDs.size() + " objects" : "disabled");
        }
        if (cmd.startsWith("monitor ls") && this.monitorEnabled) {
            StringBuffer result = new StringBuffer();
            Enumeration enumeration = this.monitorIDs.elements();
            while (enumeration.hasMoreElements()) {
                result.append(((Id)enumeration.nextElement()).toStringFull() + "\n");
            }
            result.append(this.monitorIDs.size() + " object(s)");
            return result.toString();
        }
        if (cmd.startsWith("monitor check") && this.monitorEnabled) {
            final StringBuffer result = new StringBuffer();
            final String[] ret = new String[]{null};
            if (this.monitorIDs.isEmpty()) {
                return "Add objects first!";
            }
            final long now = this.environment.getTimeSource().currentTimeMillis();
            Continuation c = new Continuation(){
                int currentLookup = 0;
                boolean lookupInAggrStore = false;

                public void receiveResult(Object o) {
                    if (AggregationImpl.this.logger.level <= 500) {
                        AggregationImpl.this.logger.log("Monitor: Retr " + this.currentLookup + " a=" + this.lookupInAggrStore + " got " + o);
                    }
                    Id currentId = (Id)AggregationImpl.this.monitorIDs.elementAt(this.currentLookup);
                    PastContentHandle[] handles = (PastContentHandle[])o;
                    GCPastContentHandle handle = null;
                    boolean skipToNext = true;
                    for (int i = 0; i < handles.length; ++i) {
                        if (handles[i] == null) continue;
                        handle = (GCPastContentHandle)handles[i];
                    }
                    if (!this.lookupInAggrStore) {
                        result.append(currentId.toStringFull() + " - OS ");
                        result.append(handle == null ? "--" : "" + (handle.getExpiration() - now));
                        AggregateDescriptor adc = AggregationImpl.this.aggregateList.getADC(currentId);
                        if (adc != null) {
                            result.append(" AD " + (adc.currentLifetime - now));
                            int objDescIndex = adc.lookupNewest(currentId);
                            if (objDescIndex >= 0) {
                                ObjectDescriptor odc = adc.objects[objDescIndex];
                                result.append(" OD " + (odc.currentLifetime - now));
                                this.lookupInAggrStore = true;
                                skipToNext = false;
                                AggregationImpl.this.aggregateStore.lookupHandles(adc.key, 1, this);
                            } else {
                                result.append(" OD ??\n");
                            }
                        } else {
                            result.append(" AD ??\n");
                        }
                    } else {
                        result.append(" AS " + (handle == null ? "--\n" : "" + (handle.getExpiration() - now) + "\n"));
                        this.lookupInAggrStore = false;
                    }
                    if (skipToNext) {
                        ++this.currentLookup;
                        if (this.currentLookup < AggregationImpl.this.monitorIDs.size()) {
                            if (AggregationImpl.this.logger.level <= 500) {
                                AggregationImpl.this.logger.log("Monitor: Continuing with element " + this.currentLookup);
                            }
                            AggregationImpl.this.objectStore.lookupHandles((Id)AggregationImpl.this.monitorIDs.elementAt(this.currentLookup), 1, this);
                        } else {
                            if (AggregationImpl.this.logger.level <= 500) {
                                AggregationImpl.this.logger.log("Monitor: Done");
                            }
                            ret[0] = "done";
                        }
                    }
                }

                public void receiveException(Exception e) {
                    if (AggregationImpl.this.logger.level <= 900) {
                        AggregationImpl.this.logger.logException("Montior: Failed, e=", e);
                    }
                    ret[0] = "done";
                }
            };
            this.objectStore.lookupHandles((Id)this.monitorIDs.elementAt(0), 1, c);
            while (ret[0] == null) {
                Thread.yield();
            }
            return result.toString();
        }
        if (cmd.startsWith("monitor add") && this.monitorEnabled) {
            String[] args = cmd.substring(12).split(" ");
            if (args.length == 6) {
                final int numFiles = Integer.parseInt(args[0]);
                final int avgBurstSize = Integer.parseInt(args[1]);
                final double sizeSkew = Double.parseDouble(args[2]);
                final int smallSize = Integer.parseInt(args[3]);
                final int largeSize = Integer.parseInt(args[4]);
                final long expiration = this.environment.getTimeSource().currentTimeMillis() + Long.parseLong(args[5]);
                Continuation c = new Continuation(){
                    int remainingTotal;
                    {
                        this.remainingTotal = numFiles;
                    }

                    public void receiveResult(Object o) {
                        if (this.remainingTotal > 0) {
                            int burstSize = Math.min((int)((double)avgBurstSize * 0.3 + (double)AggregationImpl.this.environment.getRandomSource().nextInt((int)(1.4 * (double)avgBurstSize))), this.remainingTotal);
                            13 outerContinuation = this;
                            this.remainingTotal -= burstSize;
                            if (AggregationImpl.this.logger.level <= 500) {
                                AggregationImpl.this.logger.log("Inserting burst of size " + burstSize + ", remaining objects: " + this.remainingTotal);
                            }
                            Continuation c2 = new Continuation(this, burstSize, outerContinuation){
                                long remainingHere;
                                private final /* synthetic */ int val$burstSize;
                                private final /* synthetic */ Continuation val$outerContinuation;
                                private final /* synthetic */ 13 this$1;
                                {
                                    this.this$1 = this$1;
                                    this.val$burstSize = val$burstSize;
                                    this.val$outerContinuation = val$outerContinuation;
                                    this.remainingHere = this.val$burstSize;
                                }

                                public void receiveResult(Object o) {
                                    if (this.remainingHere > 0L) {
                                        if (13.access$100(this.this$1).logger.level <= 500) {
                                            13.access$100(this.this$1).logger.log("Continuing burst insert, " + this.remainingHere + " remaining");
                                        }
                                        int thisAvgSize = 0.001 * (double)AggregationImpl.access$000(13.access$100(this.this$1)).getRandomSource().nextInt(1000) < 13.access$200(this.this$1) ? 13.access$300(this.this$1) : 13.access$400(this.this$1);
                                        int thisSize = (int)(0.3 * (double)thisAvgSize + (double)AggregationImpl.access$000(13.access$100(this.this$1)).getRandomSource().nextInt((int)(1.4 * (double)thisAvgSize)));
                                        Id randomID = 13.access$100(this.this$1).factory.buildRandomId(AggregationImpl.access$000(13.access$100(this.this$1)).getRandomSource());
                                        --this.remainingHere;
                                        13.access$100(this.this$1).monitorIDs.add(randomID);
                                        13.access$100(this.this$1).insert(new DebugContent(randomID, false, 0L, new byte[thisSize]), 13.access$500(this.this$1), this);
                                    } else {
                                        if (13.access$100(this.this$1).logger.level <= 500) {
                                            13.access$100(this.this$1).logger.log("Burst insertion complete, flushing...");
                                        }
                                        13.access$100(this.this$1).flush(this.val$outerContinuation);
                                    }
                                }

                                public void receiveException(Exception e) {
                                    if (13.access$100(this.this$1).logger.level <= 900) {
                                        13.access$100(this.this$1).logger.logException("Monitor.add component insertion failed: ", e);
                                    }
                                    this.receiveResult(e);
                                }
                            };
                            c2.receiveResult(new Boolean(true));
                        } else if (AggregationImpl.this.logger.level <= 800) {
                            AggregationImpl.this.logger.log("Monitor add completed, " + numFiles + " objects created successfully");
                        }
                    }

                    public void receiveException(Exception e) {
                        if (AggregationImpl.this.logger.level <= 900) {
                            AggregationImpl.this.logger.logException("Monitor.add aggregate insertion failed: ", e);
                        }
                        this.receiveResult(e);
                    }

                    static /* synthetic */ AggregationImpl access$100(13 x0) {
                        return x0.AggregationImpl.this;
                    }

                    static /* synthetic */ double access$200(13 x0) {
                        return x0.sizeSkew;
                    }

                    static /* synthetic */ int access$300(13 x0) {
                        return x0.smallSize;
                    }

                    static /* synthetic */ int access$400(13 x0) {
                        return x0.largeSize;
                    }

                    static /* synthetic */ long access$500(13 x0) {
                        return x0.expiration;
                    }
                };
                c.receiveResult(new Boolean(true));
                return "In progress...";
            }
            return "Syntax: monitor add <#files> <avgBurstSize> <sizeSkew> <smallSize> <largeSize> <lifetime>";
        }
        if (cmd.startsWith("killall")) {
            String args = cmd.substring(8);
            String expirationArg = args.substring(args.lastIndexOf(32) + 1);
            String keyArg = args.substring(0, args.lastIndexOf(32));
            Id id = this.factory.buildIdFromToString(keyArg);
            long expiration = this.environment.getTimeSource().currentTimeMillis() + Long.parseLong(expirationArg);
            AggregateDescriptor aggr = this.aggregateList.getADC(id);
            if (aggr != null) {
                this.aggregateList.setAggregateLifetime(aggr, Math.min(aggr.currentLifetime, expiration));
                for (int i = 0; i < aggr.objects.length; ++i) {
                    this.aggregateList.setObjectCurrentLifetime(aggr, i, Math.min(aggr.objects[i].currentLifetime, expiration));
                    this.aggregateList.setObjectRefreshedLifetime(aggr, i, Math.min(aggr.objects[i].refreshedLifetime, expiration));
                }
                return "OK";
            }
            return "Aggregate " + id + " not found in aggregate list";
        }
        if (cmd.startsWith("waiting")) {
            Iterator iter = this.waitingList.scan().getIterator();
            String result = "";
            result = result + this.waitingList.scan().numElements() + " object(s) waiting\n";
            while (iter.hasNext()) {
                Id thisId = (Id)iter.next();
                result = result + thisId.toStringFull() + " " + this.waitingList.getMetadata(thisId) + "\n";
            }
            return result;
        }
        if (cmd.startsWith("vlookup")) {
            String[] vkeyS = cmd.substring(8).split("v");
            Id key = this.factory.buildIdFromToString(vkeyS[0]);
            long version = Long.parseLong(vkeyS[1]);
            final String[] ret = new String[]{null};
            this.lookup(key, version, new Continuation(){

                public void receiveResult(Object o) {
                    ret[0] = "result(" + o + ")";
                }

                public void receiveException(Exception e) {
                    ret[0] = "exception(" + e + ")";
                }
            });
            while (ret[0] == null) {
                Thread.yield();
            }
            return "vlookup(" + key + "v" + version + ")=" + ret[0];
        }
        return null;
    }

    private void removeDeadAggregates() {
        Vector<AggregateDescriptor> toRemove = new Vector<AggregateDescriptor>();
        Enumeration enumeration = this.aggregateList.elements();
        long now = this.environment.getTimeSource().currentTimeMillis();
        while (enumeration.hasMoreElements()) {
            AggregateDescriptor adc = (AggregateDescriptor)enumeration.nextElement();
            if (adc.currentLifetime >= now - this.aggregateGracePeriod) continue;
            if (!toRemove.contains(adc)) {
                toRemove.add(adc);
            }
            if (this.logger.level > 900) continue;
            this.logger.log("Scheduling dead aggregate for removal: " + adc.key.toStringFull() + "(expired " + adc.currentLifetime + ")");
        }
        if (toRemove.size() > 0) {
            if (this.logger.level <= 800) {
                this.logger.log("Removing " + toRemove.size() + " dead aggregates...");
            }
            Enumeration rem = toRemove.elements();
            while (rem.hasMoreElements()) {
                this.aggregateList.removeAggregateDescriptor((AggregateDescriptor)rem.nextElement());
            }
        }
    }

    private void storeAggregate(final Aggregate aggr, final long expiration, final ObjectDescriptor[] desc, final Id[] pointers, final Continuation command) {
        if (this.logger.level <= 500) {
            this.logger.log("storeAggregate() schedules content hash computation...");
        }
        this.endpoint.process(new Executable(){

            public Object execute() {
                if (AggregationImpl.this.logger.level <= 500) {
                    AggregationImpl.this.logger.log("storeAggregate() starts working on content hash...");
                }
                return AggregationImpl.this.factory.buildId(aggr.getContentHash());
            }
        }, new Continuation(){

            public void receiveResult(Object o) {
                if (o instanceof Id) {
                    aggr.setId((Id)o);
                    if (AggregationImpl.this.logger.level <= 800) {
                        AggregationImpl.this.logger.log("Storing aggregate, CH=" + aggr.getId() + ", expiration=" + expiration + " (rel " + (expiration - AggregationImpl.this.environment.getTimeSource().currentTimeMillis()) + ") with " + desc.length + " objects:");
                    }
                    for (int j = 0; j < desc.length; ++j) {
                        if (AggregationImpl.this.logger.level > 800) continue;
                        AggregationImpl.this.logger.log("#" + j + ": " + desc[j]);
                    }
                    Continuation c = new Continuation(this){
                        private final /* synthetic */ 17 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void receiveResult(Object o) {
                            AggregateDescriptor adc = new AggregateDescriptor(17.access$600(this.this$1).getId(), 17.access$700(this.this$1), 17.access$800(this.this$1), 17.access$900(this.this$1));
                            if (o instanceof Boolean[]) {
                                17.access$1000(this.this$1).aggregateList.addAggregateDescriptor(adc);
                                17.access$1000(this.this$1).aggregateList.setRoot(17.access$600(this.this$1).getId());
                                17.access$1000(this.this$1).aggregateList.writeToDisk();
                                if (17.access$1000(this.this$1).logger.level <= 500) {
                                    17.access$1000(this.this$1).logger.log("Aggregate inserted successfully");
                                }
                                17.access$1100(this.this$1).receiveResult(new Boolean(true));
                            } else {
                                if (17.access$1000(this.this$1).logger.level <= 900) {
                                    17.access$1000(this.this$1).logger.log("Unexpected result in aggregate insert (commit): " + o);
                                }
                                17.access$1100(this.this$1).receiveException(new AggregationException("Unexpected result (commit): " + o));
                            }
                        }

                        public void receiveException(Exception e) {
                            17.access$1100(this.this$1).receiveException(e);
                        }
                    };
                    if (AggregationImpl.this.aggregateStore instanceof GCPast) {
                        ((GCPast)AggregationImpl.this.aggregateStore).insert(aggr, expiration, c);
                    } else {
                        AggregationImpl.this.aggregateStore.insert(aggr, c);
                    }
                } else {
                    if (AggregationImpl.this.logger.level <= 900) {
                        AggregationImpl.this.logger.log("storeAggregate() cannot determine content hash, received " + o);
                    }
                    command.receiveException(new AggregationException("storeAggregate() cannot determine content hash"));
                }
            }

            public void receiveException(Exception e) {
                if (AggregationImpl.this.logger.level <= 900) {
                    AggregationImpl.this.logger.logException("storeAggregate() cannot determine content hash, exception ", e);
                }
                command.receiveException(e);
            }

            static /* synthetic */ Aggregate access$600(17 x0) {
                return x0.aggr;
            }

            static /* synthetic */ long access$700(17 x0) {
                return x0.expiration;
            }

            static /* synthetic */ ObjectDescriptor[] access$800(17 x0) {
                return x0.desc;
            }

            static /* synthetic */ Id[] access$900(17 x0) {
                return x0.pointers;
            }

            static /* synthetic */ AggregationImpl access$1000(17 x0) {
                return x0.AggregationImpl.this;
            }

            static /* synthetic */ Continuation access$1100(17 x0) {
                return x0.command;
            }
        });
    }

    private void flushComplete(Object o) {
        if (this.flushWait != null) {
            Continuation c = this.flushWait;
            this.flushWait = null;
            if (o instanceof Exception) {
                c.receiveException((Exception)o);
            } else {
                c.receiveResult(o);
            }
        }
    }

    private void formAggregates(final Continuation command) {
        ObjectDescriptor[] desc;
        if (this.flushWait != null) {
            if (this.logger.level <= 800) {
                this.logger.log("Flush in progress... daisy-chaining continuation");
            }
            final Continuation parent = this.flushWait;
            this.flushWait = new Continuation(){

                public void receiveResult(Object o) {
                    if (AggregationImpl.this.logger.level <= 800) {
                        AggregationImpl.this.logger.log("Daisy-chain receiveResult(), restarting " + command);
                    }
                    parent.receiveResult(o);
                    AggregationImpl.this.formAggregates(command);
                }

                public void receiveException(Exception e) {
                    if (AggregationImpl.this.logger.level <= 800) {
                        AggregationImpl.this.logger.log("Daisy-chain receiveException(), restarting " + command);
                    }
                    parent.receiveException(e);
                    AggregationImpl.this.formAggregates(command);
                }
            };
            return;
        }
        this.flushWait = command;
        IdSet waitingKeys = this.waitingList.scan();
        if (waitingKeys.numElements() == 0) {
            if (this.logger.level <= 800) {
                this.logger.log("NO BINS TO PACK");
            }
            this.flushComplete(new Boolean(true));
            return;
        }
        if (this.logger.level <= 800) {
            this.logger.log("BIN PACKING STARTED");
        }
        Vector<ObjectDescriptor> currentAggregate = new Vector<ObjectDescriptor>();
        Vector<ObjectDescriptor[]> aggregates = new Vector<ObjectDescriptor[]>();
        Vector<Id> deletionVector = new Vector<Id>();
        Iterator iter = waitingKeys.getIterator();
        long currentAggregateSize = 0L;
        int currentObjectsInAggregate = 0;
        while (true) {
            int numObjectsInAggregate;
            ObjectDescriptor thisObject = null;
            boolean mustAddObject = false;
            if (aggregates.size() >= this.maxAggregatesPerRun) break;
            while (iter.hasNext()) {
                Id thisId = (Id)iter.next();
                thisObject = (ObjectDescriptor)this.waitingList.getMetadata(thisId);
                if (thisObject != null) {
                    thisObject = new ObjectDescriptor(thisObject.key, thisObject.version, thisObject.currentLifetime, thisObject.refreshedLifetime, thisObject.size);
                    if ((currentAggregateSize + (long)thisObject.size <= (long)this.maxAggregateSize || currentAggregate.isEmpty()) && currentObjectsInAggregate < this.maxObjectsInAggregate) {
                        currentAggregateSize += (long)thisObject.size;
                        ++currentObjectsInAggregate;
                        currentAggregate.add(thisObject);
                        continue;
                    }
                    mustAddObject = true;
                    break;
                }
                if (this.logger.level <= 900) {
                    this.logger.log("Metadata in waiting object " + thisId.toStringFull() + " appears to be damaged. Scheduling for deletion...");
                }
                deletionVector.add(thisId);
            }
            if ((numObjectsInAggregate = currentAggregate.size()) < 1) {
                if (this.logger.level <= 900) {
                    this.logger.log("Waiting list seems to consist entirely of damaged objects -- please remove!");
                }
                this.flushComplete(new Boolean(true));
                return;
            }
            desc = new ObjectDescriptor[numObjectsInAggregate];
            for (int i = 0; i < numObjectsInAggregate; ++i) {
                desc[i] = (ObjectDescriptor)currentAggregate.elementAt(i);
                if (this.logger.level > 500) continue;
                this.logger.log("#" + i + ": " + desc[i].key + " " + desc[i].size + " bytes");
            }
            aggregates.add(desc);
            currentAggregate.clear();
            currentObjectsInAggregate = 0;
            currentAggregateSize = 0L;
            if (mustAddObject) {
                currentAggregate.add(thisObject);
                currentAggregateSize += (long)thisObject.size;
                continue;
            }
            if (!iter.hasNext()) break;
        }
        Enumeration delenda = deletionVector.elements();
        while (delenda.hasMoreElements()) {
            final Id thisId = (Id)delenda.nextElement();
            if (this.logger.level <= 800) {
                this.logger.log("Deleting object " + thisId.toStringFull() + " from waiting list (broken metadata)");
            }
            this.waitingList.unstore(thisId, new Continuation(){

                public void receiveResult(Object o) {
                    if (AggregationImpl.this.logger.level <= 500) {
                        AggregationImpl.this.logger.log("Successfully deleted: " + thisId);
                    }
                }

                public void receiveException(Exception e) {
                    if (AggregationImpl.this.logger.level <= 900) {
                        AggregationImpl.this.logger.logException("Cannot delete: " + thisId + ", e=", e);
                    }
                }
            });
        }
        Continuation.MultiContinuation c = new Continuation.MultiContinuation(new Continuation(){

            public void receiveResult(Object o) {
                AggregationImpl.this.flushComplete(new Boolean(true));
            }

            public void receiveException(Exception e) {
                AggregationImpl.this.flushComplete(e);
            }
        }, aggregates.size());
        for (int i = 0; i < aggregates.size(); ++i) {
            desc = (ObjectDescriptor[])aggregates.elementAt(i);
            final GCPastContent[] obj = new GCPastContent[desc.length];
            final long aggrExpirationF = this.chooseAggregateLifetime(desc, this.environment.getTimeSource().currentTimeMillis(), 0L);
            final Continuation thisContinuation = c.getSubContinuation(i);
            final int iF = i;
            if (this.logger.level <= 500) {
                this.logger.log("Retrieving #" + i + ".0: " + desc[0].key);
            }
            this.waitingList.getObject(new VersionKey(desc[0].key, desc[0].version), new Continuation(){
                int currentQuery = 0;

                public void receiveResult(Object o) {
                    if (o != null && o instanceof GCPastContent) {
                        obj[this.currentQuery++] = (GCPastContent)o;
                        if (this.currentQuery < desc.length) {
                            if (AggregationImpl.this.logger.level <= 500) {
                                AggregationImpl.this.logger.log("Retrieving #" + iF + "." + this.currentQuery + ": " + desc[this.currentQuery].key);
                            }
                            AggregationImpl.this.waitingList.getObject(new VersionKey(desc[this.currentQuery].key, desc[this.currentQuery].version), this);
                        } else {
                            Id[] pointers = AggregationImpl.this.aggregateList.getSomePointers(AggregationImpl.this.nominalReferenceCount, AggregationImpl.this.maxPointersPerAggregate, null);
                            AggregationImpl.this.storeAggregate(AggregationImpl.this.aggregateFactory.buildAggregate(obj, pointers), aggrExpirationF, desc, pointers, new Continuation(this){
                                private final /* synthetic */ 22 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void receiveResult(Object o) {
                                    Continuation.MultiContinuation c2 = new Continuation.MultiContinuation(22.access$1600(this.this$1), 22.access$1700(this.this$1).length);
                                    for (int i = 0; i < 22.access$1700(this.this$1).length; ++i) {
                                        Continuation c2s = c2.getSubContinuation(i);
                                        22.access$1900(this.this$1).waitingList.unstore(new VersionKey(22.access$1700(this.this$1)[i].key, 22.access$1700(this.this$1)[i].version), new Continuation(this, c2s){
                                            private final /* synthetic */ Continuation val$c2s;
                                            private final /* synthetic */ 23 this$2;
                                            {
                                                this.this$2 = this$2;
                                                this.val$c2s = val$c2s;
                                            }

                                            public void receiveResult(Object o) {
                                                this.val$c2s.receiveResult(o);
                                            }

                                            public void receiveException(Exception e) {
                                                if (22.access$1900(23.access$1800(this.this$2)).logger.level <= 900) {
                                                    22.access$1900(23.access$1800(this.this$2)).logger.logException("Exception while unstoring aggregate component: ", e);
                                                }
                                                this.val$c2s.receiveException(e);
                                            }
                                        });
                                    }
                                }

                                public void receiveException(Exception e) {
                                    if (22.access$1900(this.this$1).logger.level <= 900) {
                                        22.access$1900(this.this$1).logger.logException("Exception while storing new aggregate: ", e);
                                    }
                                    22.access$1600(this.this$1).receiveException(e);
                                }

                                static /* synthetic */ 22 access$1800(23 x0) {
                                    return x0.this$1;
                                }
                            });
                        }
                    } else {
                        if (AggregationImpl.this.logger.level <= 900) {
                            AggregationImpl.this.logger.log("Aggregation cannot retrieve " + desc[this.currentQuery].key + " (found o=" + o + ")");
                        }
                        thisContinuation.receiveException(new AggregationException("Cannot retrieve object from waiting list: " + desc[this.currentQuery].key));
                    }
                }

                public void receiveException(Exception e) {
                    if (AggregationImpl.this.logger.level <= 900) {
                        AggregationImpl.this.logger.log("Exception while building aggregate: " + e);
                    }
                    thisContinuation.receiveException(e);
                }

                static /* synthetic */ Continuation access$1600(22 x0) {
                    return x0.thisContinuation;
                }

                static /* synthetic */ ObjectDescriptor[] access$1700(22 x0) {
                    return x0.desc;
                }

                static /* synthetic */ AggregationImpl access$1900(22 x0) {
                    return x0.AggregationImpl.this;
                }
            });
        }
    }

    private long chooseAggregateLifetime(ObjectDescriptor[] components, long now, long currentLifetime) {
        long maxLifetime = 0L;
        for (int i = 0; i < components.length; ++i) {
            if (components[i].refreshedLifetime <= maxLifetime) continue;
            maxLifetime = components[i].refreshedLifetime;
        }
        return maxLifetime;
    }

    private void refreshAggregates() {
        Enumeration enumeration = this.aggregateList.elements();
        long now = this.environment.getTimeSource().currentTimeMillis();
        Vector<AggregateDescriptor> removeList = new Vector<AggregateDescriptor>();
        final Vector<AggregateDescriptor> refreshAggregateList = new Vector<AggregateDescriptor>();
        final Vector<Long> refreshLifetimeList = new Vector<Long>();
        if (this.logger.level <= 800) {
            this.logger.log("Checking aggregate lifetimes");
        }
        this.aggregateList.resetMarkers();
        while (enumeration.hasMoreElements()) {
            long newLifetime;
            AggregateDescriptor aggr = (AggregateDescriptor)enumeration.nextElement();
            if (aggr.marker) continue;
            aggr.marker = true;
            boolean isBeingRefreshed = false;
            if (aggr.currentLifetime < now + this.expirationRenewThreshold && (newLifetime = this.chooseAggregateLifetime(aggr.objects, now, aggr.currentLifetime)) > aggr.currentLifetime) {
                if (this.logger.level <= 800) {
                    this.logger.log("Refreshing aggregate " + aggr.key.toStringFull() + ", new expiration is " + newLifetime);
                }
                isBeingRefreshed = true;
                refreshAggregateList.add(aggr);
                refreshLifetimeList.add(new Long(newLifetime));
            }
            if (aggr.currentLifetime >= now || isBeingRefreshed) continue;
            if (this.logger.level <= 500) {
                this.logger.log("Adding expired aggregate " + aggr.key + " to remove list");
            }
            removeList.add(aggr);
        }
        boolean deletedOne = false;
        while (!removeList.isEmpty()) {
            AggregateDescriptor aggr = (AggregateDescriptor)removeList.elementAt(0);
            if (this.logger.level <= 800) {
                this.logger.log("Removing expired aggregate " + aggr.key.toStringFull() + " from list");
            }
            removeList.removeElementAt(0);
            deletedOne = true;
            this.aggregateList.removeAggregateDescriptor(aggr);
        }
        if (deletedOne) {
            this.aggregateList.writeToDisk();
        }
        if (!refreshAggregateList.isEmpty()) {
            if (this.logger.level <= 800) {
                this.logger.log("Refreshing " + refreshAggregateList.size() + " aggregate(s)");
            }
            if (this.aggregateStore instanceof GCPast) {
                Id[] ids = new Id[refreshAggregateList.size()];
                long[] lifetimes = new long[refreshAggregateList.size()];
                for (int i = 0; i < refreshAggregateList.size(); ++i) {
                    ids[i] = ((AggregateDescriptor)refreshAggregateList.elementAt((int)i)).key;
                    lifetimes[i] = (Long)refreshLifetimeList.elementAt(i);
                }
                ((GCPast)this.aggregateStore).refresh(ids, lifetimes, new Continuation(){

                    public void receiveResult(Object o) {
                        Object[] results = (Object[])o;
                        if (AggregationImpl.this.logger.level <= 500) {
                            AggregationImpl.this.logger.log("Received refresh results for " + results.length + " aggregates");
                        }
                        int numOk = 0;
                        for (int i = 0; i < results.length; ++i) {
                            AggregateDescriptor aggr;
                            if (results[i] instanceof Boolean) {
                                aggr = (AggregateDescriptor)refreshAggregateList.elementAt(i);
                                long newLifetime = (Long)refreshLifetimeList.elementAt(i);
                                if (AggregationImpl.this.logger.level <= 500) {
                                    AggregationImpl.this.logger.log("Aggregate #" + i + " (" + aggr.key.toStringFull() + "): OK, new lifetime is " + newLifetime);
                                }
                                AggregationImpl.this.aggregateList.refreshAggregate(aggr, newLifetime);
                                ++numOk;
                                continue;
                            }
                            aggr = (AggregateDescriptor)refreshAggregateList.elementAt(i);
                            Exception e = (Exception)results[i];
                            if (AggregationImpl.this.logger.level > 900) continue;
                            AggregationImpl.this.logger.logException("Aggregate #" + i + " (" + aggr.key.toStringFull() + "): Refresh failed, e=", e);
                        }
                        AggregationImpl.this.aggregateList.writeToDisk();
                        if (AggregationImpl.this.logger.level <= 800) {
                            AggregationImpl.this.logger.log("Refresh complete, " + numOk + "/" + results.length + " aggregates refreshed OK");
                        }
                    }

                    public void receiveException(Exception e) {
                        if (AggregationImpl.this.logger.level <= 900) {
                            AggregationImpl.this.logger.logException("Interface contract broken; exception " + e + " returned directly", e);
                        }
                    }
                });
            } else {
                if (this.logger.level <= 500) {
                    this.logger.log("Aggregate store does not support GC; refreshing directly");
                }
                for (int i = 0; i < refreshAggregateList.size(); ++i) {
                    AggregateDescriptor aggr = (AggregateDescriptor)refreshAggregateList.elementAt(i);
                    long newLifetime = (Long)refreshLifetimeList.elementAt(i);
                    this.aggregateList.refreshAggregate(aggr, newLifetime);
                }
            }
        }
    }

    private void consolidateAggregates() {
        AggregateDescriptor[] adc;
        final long now = this.environment.getTimeSource().currentTimeMillis();
        Enumeration enumeration = this.aggregateList.elements();
        Vector<AggregateDescriptor> candidateList = new Vector<AggregateDescriptor>();
        if (this.logger.level <= 800) {
            this.logger.log("Looking for aggregates to consolidate");
        }
        this.aggregateList.resetMarkers();
        while (enumeration.hasMoreElements()) {
            AggregateDescriptor aggr = (AggregateDescriptor)enumeration.nextElement();
            if (aggr.marker) continue;
            aggr.marker = true;
            if (aggr.currentLifetime <= now + this.expirationRenewThreshold || aggr.currentLifetime >= now + this.consolidationThreshold || aggr.objectsAliveAt(now) <= 0) continue;
            float fractionAlive = (float)aggr.objectsAliveAt(now) / (float)aggr.objects.length;
            if (aggr.objects.length >= this.consolidationMinObjectsInAggregate && !((double)fractionAlive < this.consolidationMinComponentsAlive)) continue;
            if (this.logger.level <= 500) {
                this.logger.log("Can consolidate: " + aggr.key.toStringFull() + ", " + aggr.objectsAliveAt(now) + "/" + aggr.objects.length + " alive");
            }
            candidateList.add(aggr);
        }
        if (candidateList.isEmpty()) {
            if (this.logger.level <= 800) {
                this.logger.log("No candidates for consolidation");
            }
            return;
        }
        if (this.logger.level <= 500) {
            this.logger.log(candidateList.size() + " candidate(s) for consolidation");
        }
        final Vector<AggregateDescriptor[]> componentList = new Vector<AggregateDescriptor[]>();
        int objectsSoFar = 0;
        int bytesSoFar = 0;
        while (!candidateList.isEmpty()) {
            adc = (AggregateDescriptor[])candidateList.remove(this.environment.getRandomSource().nextInt(candidateList.size()));
            componentList.add(adc);
            if (this.logger.level <= 500) {
                this.logger.log("Picked candidate " + adc.key.toStringFull() + " (" + adc.objectsAliveAt(now) + "/" + adc.objects.length + " objects, " + adc.bytesAliveAt(now) + " bytes alive)");
            }
            objectsSoFar += adc.objectsAliveAt(now);
            bytesSoFar += adc.bytesAliveAt(now);
            int p = 0;
            while (p < candidateList.size()) {
                AggregateDescriptor adx = (AggregateDescriptor)candidateList.elementAt(p);
                if (adx.objectsAliveAt(now) + objectsSoFar > this.maxObjectsInAggregate || adx.bytesAliveAt(now) + bytesSoFar > this.maxAggregateSize) {
                    candidateList.removeElementAt(p);
                    continue;
                }
                ++p;
            }
        }
        if (componentList.isEmpty() || objectsSoFar < this.consolidationMinObjectsInAggregate) {
            if (this.logger.level <= 800) {
                this.logger.log("Not enough objects (" + objectsSoFar + " found, " + this.consolidationMinObjectsInAggregate + " required), postponing...");
            }
            return;
        }
        if (this.logger.level <= 500) {
            this.logger.log("Consolidation: Decided to consolidate " + objectsSoFar + " objects from " + componentList.size() + " aggregates (" + bytesSoFar + " bytes)");
        }
        adc = componentList.toArray(new AggregateDescriptor[0]);
        final Aggregate[] aggr = new Aggregate[adc.length];
        final int objectsTotal = objectsSoFar;
        Id firstKey = adc[0].key;
        if (this.logger.level <= 500) {
            this.logger.log("Consolidation: Fetching aggregate #0: " + firstKey.toStringFull());
        }
        this.aggregateStore.lookup(firstKey, new Continuation(){
            int currentLookup = 0;

            public void receiveResult(Object o) {
                if (o instanceof Aggregate) {
                    aggr[this.currentLookup] = (Aggregate)o;
                    ++this.currentLookup;
                    if (this.currentLookup >= componentList.size()) {
                        RawGCPastContent[] components = new RawGCPastContent[objectsTotal];
                        ObjectDescriptor[] desc = new ObjectDescriptor[objectsTotal];
                        int componentIndex = 0;
                        if (AggregationImpl.this.logger.level <= 800) {
                            AggregationImpl.this.logger.log("Consolidation: All aggregates fetched OK, forming new aggregate...");
                        }
                        for (int i = 0; i < adc.length; ++i) {
                            for (int j = 0; j < adc[i].objects.length; ++j) {
                                if (adc[i].objects[j].isAliveAt(now)) {
                                    GCPastContent temp = aggr[i].getComponent(j);
                                    components[componentIndex] = (RawGCPastContent)temp;
                                    desc[componentIndex] = adc[i].objects[j];
                                    if (AggregationImpl.this.logger.level <= 500) {
                                        AggregationImpl.this.logger.log("  #" + componentIndex + ": " + adc[i].objects[j].key.toStringFull());
                                    }
                                    ++componentIndex;
                                    continue;
                                }
                                if (AggregationImpl.this.logger.level > 500) continue;
                                AggregationImpl.this.logger.log("Skipped (dead): " + adc[i].objects[j].key.toStringFull());
                            }
                        }
                        Id[] obsoleteAggregates = new Id[adc.length];
                        for (int i = 0; i < adc.length; ++i) {
                            obsoleteAggregates[i] = adc[i].key;
                        }
                        Id[] pointers = AggregationImpl.this.aggregateList.getSomePointers(AggregationImpl.this.nominalReferenceCount, AggregationImpl.this.maxPointersPerAggregate, obsoleteAggregates);
                        long aggrExpirationF = AggregationImpl.this.chooseAggregateLifetime(desc, AggregationImpl.this.environment.getTimeSource().currentTimeMillis(), 0L);
                        AggregationImpl.this.storeAggregate(AggregationImpl.this.aggregateFactory.buildAggregate(components, pointers), aggrExpirationF, desc, pointers, new Continuation(this){
                            private final /* synthetic */ 26 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void receiveResult(Object o) {
                                if (26.access$2200(this.this$1).logger.level <= 800) {
                                    26.access$2200(this.this$1).logger.log("Consolidated Aggregate stored OK, removing old descriptors...");
                                }
                                for (int i = 0; i < 26.access$2300(this.this$1).length; ++i) {
                                    if (26.access$2200(this.this$1).logger.level <= 500) {
                                        26.access$2200(this.this$1).logger.log("Removing " + 26.access$2300(this.this$1)[i].key.toStringFull() + " ...");
                                    }
                                    26.access$2200(this.this$1).aggregateList.removeAggregateDescriptor(26.access$2300(this.this$1)[i]);
                                }
                                26.access$2200(this.this$1).aggregateList.writeToDisk();
                                if (26.access$2200(this.this$1).logger.level <= 800) {
                                    26.access$2200(this.this$1).logger.log("Consolidation completed, " + 26.access$2400(this.this$1) + " objects from " + 26.access$2500(this.this$1).length + " aggregates consolidated");
                                }
                            }

                            public void receiveException(Exception e) {
                                if (26.access$2200(this.this$1).logger.level <= 900) {
                                    26.access$2200(this.this$1).logger.logException("Exception during consolidation store: e=" + e + " -- aborting", e);
                                }
                            }
                        });
                    } else {
                        if (AggregationImpl.this.logger.level <= 500) {
                            AggregationImpl.this.logger.log("Consolidation: Fetching aggregate #" + this.currentLookup + ": " + adc[this.currentLookup].key.toStringFull());
                        }
                        AggregationImpl.this.aggregateStore.lookup(adc[this.currentLookup].key, this);
                    }
                }
            }

            public void receiveException(Exception e) {
                if (AggregationImpl.this.logger.level <= 900) {
                    AggregationImpl.this.logger.logException("Exception during consolidation lookup " + adc[this.currentLookup].key.toStringFull() + ": " + e + " -- aborting", e);
                }
            }

            static /* synthetic */ AggregationImpl access$2200(26 x0) {
                return x0.AggregationImpl.this;
            }

            static /* synthetic */ AggregateDescriptor[] access$2300(26 x0) {
                return x0.adc;
            }

            static /* synthetic */ int access$2400(26 x0) {
                return x0.objectsTotal;
            }

            static /* synthetic */ Aggregate[] access$2500(26 x0) {
                return x0.aggr;
            }
        });
    }

    private void reconnectTree() {
        Id[] disconnected;
        if (this.rebuildInProgress) {
            if (this.logger.level <= 800) {
                this.logger.log("Skipping connectivity check (rebuild in progress)");
            }
            return;
        }
        if (this.logger.level <= 800) {
            this.logger.log("Checking for disconnections");
        }
        if ((disconnected = this.aggregateList.getSomePointers(1, this.maxPointersPerAggregate, null)).length < 2) {
            Id newRoot = disconnected.length == 1 ? disconnected[0] : null;
            Id currentRoot = this.aggregateList.getRoot();
            if (newRoot == null && currentRoot != null || newRoot != null && currentRoot == null || newRoot != null && currentRoot != null && !newRoot.equals(currentRoot)) {
                this.aggregateList.setRoot(newRoot);
            }
            if (this.logger.level <= 800) {
                this.logger.log("No aggregates disconnected (n=" + disconnected.length + ")");
            }
            if (this.logger.level <= 500) {
                this.logger.log("root=" + (this.aggregateList.getRoot() == null ? "null" : this.aggregateList.getRoot().toStringFull()));
            }
            return;
        }
        if (this.logger.level <= 800) {
            this.logger.log("Found " + disconnected.length + " disconnected aggregates; inserting pointer array");
        }
        this.storeAggregate(this.aggregateFactory.buildAggregate(new GCPastContent[0], disconnected), this.environment.getTimeSource().currentTimeMillis() + this.pointerArrayLifetime, new ObjectDescriptor[0], disconnected, new Continuation(){

            public void receiveResult(Object o) {
                if (AggregationImpl.this.logger.level <= 500) {
                    AggregationImpl.this.logger.log("Successfully inserted pointer array");
                }
            }

            public void receiveException(Exception e) {
                if (AggregationImpl.this.logger.level <= 900) {
                    AggregationImpl.this.logger.logException("Error while inserting pointer array: ", e);
                }
            }
        });
    }

    private void timerExpired(char timerID) {
        if (this.logger.level <= 500) {
            this.logger.log("TIMER EXPIRED: #" + timerID);
        }
        switch (timerID) {
            case '\u0001': {
                if (this.logger.level <= 800) {
                    this.logger.log("Scheduled flush, waiting list: " + this.waitingList.getSize());
                }
                this.formAggregates(new Continuation(){

                    public void receiveResult(Object o) {
                        if (AggregationImpl.this.logger.level <= 500) {
                            AggregationImpl.this.logger.log("Scheduled flush: Success (o=" + o + ")");
                        }
                    }

                    public void receiveException(Exception e) {
                        if (AggregationImpl.this.logger.level <= 900) {
                            AggregationImpl.this.logger.logException("Scheduled flush: Failure (e=" + e + ")", e);
                        }
                    }
                });
                if (this.logger.level <= 800) {
                    this.logger.log("Waiting list: " + this.waitingList.getSize() + " Scan: " + this.getNumObjectsWaiting() + " Max: " + this.maxObjectsInAggregate * this.maxAggregatesPerRun);
                }
                if (this.getNumObjectsWaiting() >= this.maxObjectsInAggregate * this.maxAggregatesPerRun) {
                    if (this.logger.level <= 800) {
                        this.logger.log("Retrying later");
                    }
                    this.addTimer(this.jitterTerm(this.flushStressInterval), '\u0001');
                    break;
                }
                if (this.logger.level <= 800) {
                    this.logger.log("OK, waiting for next deadline");
                }
                this.addTimer(this.jitterTerm(this.flushInterval), '\u0001');
                break;
            }
            case '\u0005': {
                this.refreshAggregates();
                this.reconnectTree();
                this.addTimer(this.jitterTerm(this.aggrRefreshInterval), '\u0005');
                break;
            }
            case '\u0003': {
                this.consolidateAggregates();
                this.addTimer(this.jitterTerm(this.consolidationInterval), '\u0003');
                break;
            }
            case '\u0002': {
                Id[] ids = this.monitorIDs.toArray(new Id[0]);
                if (this.logger.level <= 800) {
                    this.logger.log("Monitor: Refreshing " + ids.length + " objects");
                }
                this.refresh(ids, this.environment.getTimeSource().currentTimeMillis() + 3L * this.monitorRefreshInterval, new Continuation(){

                    public void receiveResult(Object o) {
                        if (AggregationImpl.this.logger.level <= 500) {
                            AggregationImpl.this.logger.log("Monitor: Refresh completed, result=" + o);
                        }
                    }

                    public void receiveException(Exception e) {
                        if (AggregationImpl.this.logger.level <= 500) {
                            AggregationImpl.this.logger.logException("Monitor: Refresh failed, exception=", e);
                        }
                    }
                });
                this.addTimer(this.monitorRefreshInterval, '\u0002');
                break;
            }
            case '\u0004': {
                this.stats = this.aggregateList.getStatistics(this.statsGranularity, this.statsRange, this.nominalReferenceCount);
                this.stats.dump(this.environment.getLogManager().getLogger(AggregationStatistics.class, this.instance));
                this.addTimer(this.statsInterval, '\u0004');
                break;
            }
            default: {
                this.panic("Unknown timer expired: " + timerID);
            }
        }
    }

    private void refreshInObjectStore(Id[] ids, long[] expirations, Continuation command) {
        if (this.objectStore instanceof GCPast) {
            ((GCPast)this.objectStore).refresh(ids, expirations, command);
        } else {
            command.receiveResult(new Boolean(true));
        }
    }

    public void refresh(Id[] ids, long expiration, Continuation command) {
        long[] expirations = new long[ids.length];
        Arrays.fill(expirations, expiration);
        this.refresh(ids, expirations, command);
    }

    public void refresh(final Id[] ids, final long[] expirations, final Continuation command) {
        if (ids.length < 1) {
            command.receiveResult(new Boolean[0]);
            return;
        }
        if (this.logger.level <= 800) {
            this.logger.log("Refreshing " + ids.length + " keys");
        }
        this.refreshInObjectStore(ids, expirations, new Continuation(){
            Object[] result;

            public void receiveResult(Object o) {
                if (o instanceof Object[]) {
                    this.result = (Object[])o;
                } else {
                    if (AggregationImpl.this.logger.level <= 900) {
                        AggregationImpl.this.logger.log("refresh: ObjectStore result is of incorrect type; expected Object[], got " + o);
                    }
                    this.result = new Object[ids.length];
                    for (int i = 0; i < ids.length; ++i) {
                        this.result[i] = o;
                    }
                }
                this.refreshInAggregates();
            }

            public void receiveException(Exception e) {
                this.result = new Object[ids.length];
                for (int i = 0; i < ids.length; ++i) {
                    this.result[i] = e;
                }
                if (AggregationImpl.this.logger.level <= 900) {
                    AggregationImpl.this.logger.logException("", e);
                }
                this.refreshInAggregates();
            }

            private void refreshInAggregates() {
                Continuation c = new Continuation(this){
                    private final /* synthetic */ 31 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void receiveResult(Object o) {
                        31.access$2600(this.this$1).aggregateList.writeToDisk();
                        31.access$2700(this.this$1).receiveResult(o);
                    }

                    public void receiveException(Exception e) {
                        if (31.access$2600(this.this$1).logger.level <= 900) {
                            31.access$2600(this.this$1).logger.logException("", e);
                        }
                        31.access$2700(this.this$1).receiveException(e);
                    }
                };
                AggregationImpl.this.refreshInternal(ids, expirations, this.result, c);
            }

            static /* synthetic */ AggregationImpl access$2600(31 x0) {
                return x0.AggregationImpl.this;
            }

            static /* synthetic */ Continuation access$2700(31 x0) {
                return x0.command;
            }
        });
    }

    public void refresh(Id[] ids, long[] versions, long[] expirations, final Continuation command) {
        final Object[] result = new Object[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            AggregateDescriptor adc;
            if (this.logger.level <= 800) {
                this.logger.log("Refresh(" + ids[i] + "v" + versions[i] + ", expiration=" + expirations[i] + ")");
            }
            if ((adc = this.aggregateList.getADC(new VersionKey(ids[i], versions[i]))) != null) {
                int objDescIndex = adc.lookupSpecific(ids[i], versions[i]);
                if (objDescIndex < 0) {
                    result[i] = new AggregationException("Inconsistency detected in aggregate list -- try restarting the application");
                    continue;
                }
                if (adc.objects[objDescIndex].refreshedLifetime < expirations[i]) {
                    this.aggregateList.setObjectRefreshedLifetime(adc, objDescIndex, expirations[i]);
                }
                result[i] = new Boolean(true);
                continue;
            }
            result[i] = new AggregationException("Not found");
        }
        if (this.objectStore instanceof VersioningPast) {
            ((VersioningPast)((Object)this.objectStore)).refresh(ids, versions, expirations, new Continuation(){

                public void receiveResult(Object o) {
                    if (o instanceof Object[]) {
                        Object[] subresult = (Object[])o;
                        for (int i = 0; i < result.length; ++i) {
                            if (!(result[i] instanceof Boolean) || subresult[i] instanceof Boolean) continue;
                            result[i] = subresult[i];
                        }
                    } else {
                        AggregationException e = new AggregationException("Object store returns unexpected result: " + o);
                        for (int i = 0; i < result.length; ++i) {
                            result[i] = e;
                        }
                    }
                    command.receiveResult(result);
                }

                public void receiveException(Exception e) {
                    command.receiveException(e);
                }
            });
        } else {
            command.receiveResult(result);
        }
    }

    private void refreshInternal(final Id[] ids, final long[] expirations, final Object[] result, final Continuation command) {
        if (this.logger.level <= 800) {
            this.logger.log("refreshInternal: Accepted " + ids.length + " keys, starting with first key...");
        }
        Continuation theContinuation = new Continuation(){
            int objectsMissing = 0;
            int objectsFetched = 0;
            int currentIndex = -1;

            public void receiveResult(Object o) {
                Object lastResult = o;
                while (true) {
                    AggregateDescriptor adc;
                    if (this.currentIndex >= 0) {
                        if (AggregationImpl.this.logger.level <= 500) {
                            AggregationImpl.this.logger.log("receiveResult(" + lastResult + ") for index " + this.currentIndex + ", length=" + ids.length);
                        }
                        if (AggregationImpl.this.logger.level <= 500) {
                            AggregationImpl.this.logger.log("Internal refresh of " + ids[this.currentIndex].toStringFull() + " returned " + lastResult);
                        }
                        result[this.currentIndex] = lastResult;
                    }
                    ++this.currentIndex;
                    if (this.currentIndex >= ids.length) {
                        int i;
                        if (this.objectsMissing > 0 && AggregationImpl.this.logger.level <= 900) {
                            AggregationImpl.this.logger.log("refresh: " + this.objectsMissing + "/" + ids.length + " objects not in aggregate list, fetched " + this.objectsFetched + " (max " + AggregationImpl.this.maxReaggregationPerRefresh + ")");
                        }
                        int nOK = 0;
                        for (i = 0; i < ids.length; ++i) {
                            if (!(result[i] instanceof Boolean)) continue;
                            ++nOK;
                        }
                        if (AggregationImpl.this.logger.level <= 800) {
                            AggregationImpl.this.logger.log("refreshInternal: Processed " + ids.length + " keys, completed " + nOK);
                        }
                        for (i = 0; i < ids.length; ++i) {
                            if (AggregationImpl.this.logger.level > 400) continue;
                            AggregationImpl.this.logger.log(" - " + ids[i].toStringFull() + ": " + result[i]);
                        }
                        command.receiveResult(result);
                        return;
                    }
                    Id id = ids[this.currentIndex];
                    long expiration = expirations[this.currentIndex];
                    if (AggregationImpl.this.logger.level <= 800) {
                        AggregationImpl.this.logger.log("Refresh(" + id.toStringFull() + ", expiration=" + expiration + ") started");
                    }
                    if ((adc = AggregationImpl.this.aggregateList.getADC(id)) != null) {
                        int objDescIndex = adc.lookupNewest(id);
                        if (objDescIndex < 0) {
                            if (AggregationImpl.this.logger.level <= 900) {
                                AggregationImpl.this.logger.log("NL: Aggregate found, but object not found in aggregate?!? -- aborted");
                            }
                            command.receiveException(new AggregationException("Inconsistency detected in aggregate list -- try restarting the application"));
                            return;
                        }
                        if (adc.objects[objDescIndex].refreshedLifetime < expiration) {
                            if (AggregationImpl.this.logger.level <= 500) {
                                AggregationImpl.this.logger.log("Changing expiration date from " + adc.objects[objDescIndex].refreshedLifetime + " to " + expiration);
                            }
                            AggregationImpl.this.aggregateList.setObjectRefreshedLifetime(adc, objDescIndex, expiration);
                        } else if (AggregationImpl.this.logger.level <= 500) {
                            AggregationImpl.this.logger.log("Expiration is " + adc.objects[objDescIndex].refreshedLifetime + " already, no update needed");
                        }
                        lastResult = new Boolean(true);
                        continue;
                    }
                    IdSet waitingIds = AggregationImpl.this.waitingList.scan();
                    Iterator iter = waitingIds.getIterator();
                    while (iter.hasNext()) {
                        VersionKey vkey = (VersionKey)iter.next();
                        if (!vkey.getId().equals(id)) continue;
                        ObjectDescriptor thisObject = (ObjectDescriptor)AggregationImpl.this.waitingList.getMetadata(vkey);
                        if (AggregationImpl.this.logger.level <= 800) {
                            AggregationImpl.this.logger.log("Refreshing in waiting list: " + vkey.toStringFull());
                        }
                        if (thisObject == null) {
                            if (AggregationImpl.this.logger.level <= 900) {
                                AggregationImpl.this.logger.log("Broken object in waiting list: " + vkey.toStringFull() + ", removing...");
                            }
                            34 myParent = this;
                            AggregationImpl.this.waitingList.unstore(vkey, new Continuation(this, vkey, myParent){
                                private final /* synthetic */ VersionKey val$vkey;
                                private final /* synthetic */ Continuation val$myParent;
                                private final /* synthetic */ 34 this$1;
                                {
                                    this.this$1 = this$1;
                                    this.val$vkey = val$vkey;
                                    this.val$myParent = val$myParent;
                                }

                                public void receiveResult(Object o) {
                                    if (34.access$3000(this.this$1).logger.level <= 800) {
                                        34.access$3000(this.this$1).logger.log("Broken object " + this.val$vkey.toStringFull() + " removed successfully");
                                    }
                                    this.val$myParent.receiveResult(new AggregationException("Object in waiting list, but broken: " + this.val$vkey.toStringFull()));
                                }

                                public void receiveException(Exception e) {
                                    if (34.access$3000(this.this$1).logger.level <= 900) {
                                        34.access$3000(this.this$1).logger.logException("Cannot remove broken object " + this.val$vkey.toStringFull() + " from waiting list (exception: " + e + ")", e);
                                    }
                                    this.val$myParent.receiveResult(new AggregationException("Object broken, in waiting list, and cannot remove: " + this.val$vkey.toStringFull() + " (e=" + e + ")"));
                                }
                            });
                            return;
                        }
                        if (thisObject.refreshedLifetime < expiration) {
                            ObjectDescriptor newDescriptor = new ObjectDescriptor(thisObject.key, thisObject.version, thisObject.currentLifetime, expiration, thisObject.size);
                            34 myParent = this;
                            AggregationImpl.this.waitingList.setMetadata(vkey, newDescriptor, new Continuation(this, vkey, myParent){
                                private final /* synthetic */ VersionKey val$vkey;
                                private final /* synthetic */ Continuation val$myParent;
                                private final /* synthetic */ 34 this$1;
                                {
                                    this.this$1 = this$1;
                                    this.val$vkey = val$vkey;
                                    this.val$myParent = val$myParent;
                                }

                                public void receiveResult(Object o) {
                                    if (34.access$3000(this.this$1).logger.level <= 500) {
                                        34.access$3000(this.this$1).logger.log("Refreshed metadata written ok for " + this.val$vkey.toStringFull());
                                    }
                                    this.val$myParent.receiveResult(new Boolean(true));
                                }

                                public void receiveException(Exception e) {
                                    if (34.access$3000(this.this$1).logger.level <= 900) {
                                        34.access$3000(this.this$1).logger.logException("Cannot refresh waiting object " + this.val$vkey.toStringFull() + ", e=", e);
                                    }
                                    this.val$myParent.receiveResult(new AggregationException("Cannot refresh waiting object " + this.val$vkey.toStringFull() + ", setMetadata() failed (e=" + e + ")"));
                                }
                            });
                            return;
                        }
                        if (AggregationImpl.this.logger.level <= 500) {
                            AggregationImpl.this.logger.log("Object found in waiting list and no update needed: " + vkey.toStringFull());
                        }
                        this.receiveResult(new Boolean(true));
                        return;
                    }
                    ++this.objectsMissing;
                    if (AggregationImpl.this.addMissingAfterRefresh) {
                        if (this.objectsFetched < AggregationImpl.this.maxReaggregationPerRefresh) {
                            ++this.objectsFetched;
                            34 myParent = this;
                            AggregationImpl.this.objectStore.lookup(id, false, new Continuation(this, id, expiration, myParent){
                                private final /* synthetic */ Id val$id;
                                private final /* synthetic */ long val$expiration;
                                private final /* synthetic */ Continuation val$myParent;
                                private final /* synthetic */ 34 this$1;
                                {
                                    this.this$1 = this$1;
                                    this.val$id = val$id;
                                    this.val$expiration = val$expiration;
                                    this.val$myParent = val$myParent;
                                }

                                public void receiveResult(Object o) {
                                    if (o instanceof PastContent) {
                                        PastContent obj = (PastContent)o;
                                        if (34.access$3000(this.this$1).logger.level <= 900) {
                                            34.access$3000(this.this$1).logger.log("Refresh: Found in PAST, but not in aggregate list: " + this.val$id.toStringFull());
                                        }
                                        long theVersion = o instanceof GCPastContent ? ((GCPastContent)obj).getVersion() : 0L;
                                        VersionKey vkey = new VersionKey(obj.getId(), theVersion);
                                        long theVersionF = theVersion;
                                        int theSize = AggregationImpl.access$3200(34.access$3000(this.this$1), obj);
                                        if (34.access$3000(this.this$1).policy.shouldBeAggregated(obj, theSize)) {
                                            if (!34.access$3000(this.this$1).waitingList.exists(vkey)) {
                                                if (34.access$3000(this.this$1).logger.level <= 500) {
                                                    34.access$3000(this.this$1).logger.log("ADDING MISSING OBJECT AFTER REFRESH: " + obj.getId());
                                                }
                                                34.access$3000(this.this$1).waitingList.store(vkey, new ObjectDescriptor(obj.getId(), theVersionF, this.val$expiration, this.val$expiration, theSize), obj, new Continuation(this, obj){
                                                    private final /* synthetic */ PastContent val$obj;
                                                    private final /* synthetic */ 37 this$2;
                                                    {
                                                        this.this$2 = this$2;
                                                        this.val$obj = val$obj;
                                                    }

                                                    public void receiveResult(Object o) {
                                                        ((PastImpl)34.access$3000(37.access$3400(this.this$2)).objectStore).cache(this.val$obj, new Continuation(this){
                                                            private final /* synthetic */ 38 this$3;
                                                            {
                                                                this.this$3 = this$3;
                                                            }

                                                            public void receiveResult(Object o) {
                                                                if (34.access$3000(37.access$3400(38.access$3300(this.this$3))).logger.level <= 500) {
                                                                    34.access$3000(37.access$3400(38.access$3300(this.this$3))).logger.log("Refresh: Missing object " + 37.access$3500(38.access$3300(this.this$3)).toStringFull() + " added ok");
                                                                }
                                                                37.access$3600(38.access$3300(this.this$3)).receiveResult(new Boolean(true));
                                                            }

                                                            public void receiveException(Exception e) {
                                                                if (34.access$3000(37.access$3400(38.access$3300(this.this$3))).logger.level <= 900) {
                                                                    34.access$3000(37.access$3400(38.access$3300(this.this$3))).logger.logException("Refresh: Exception while precaching object: " + 37.access$3500(38.access$3300(this.this$3)).toStringFull() + " (e=" + e + ")", e);
                                                                }
                                                                37.access$3600(38.access$3300(this.this$3)).receiveResult(new Boolean(true));
                                                            }
                                                        });
                                                    }

                                                    public void receiveException(Exception e) {
                                                        if (34.access$3000(37.access$3400(this.this$2)).logger.level <= 900) {
                                                            34.access$3000(37.access$3400(this.this$2)).logger.logException("Refresh: Exception while refreshing aggregate: " + 37.access$3500(this.this$2).toStringFull() + " (e=" + e + ")", e);
                                                        }
                                                        37.access$3600(this.this$2).receiveResult(new AggregationException("Cannot store reaggregated object in waiting list: " + 37.access$3500(this.this$2).toStringFull()));
                                                    }

                                                    static /* synthetic */ 37 access$3300(38 x0) {
                                                        return x0.this$2;
                                                    }
                                                });
                                                return;
                                            }
                                            if (34.access$3000(this.this$1).logger.level <= 500) {
                                                34.access$3000(this.this$1).logger.log("Refresh: Missing object already in waiting list: " + this.val$id.toStringFull());
                                            }
                                            this.val$myParent.receiveResult(new Boolean(true));
                                            return;
                                        }
                                        if (34.access$3000(this.this$1).logger.level <= 500) {
                                            34.access$3000(this.this$1).logger.log("Refresh: Missing object should not be aggregated: " + this.val$id.toStringFull());
                                        }
                                        this.val$myParent.receiveResult(new Boolean(true));
                                        return;
                                    }
                                    if (34.access$3000(this.this$1).logger.level <= 900) {
                                        34.access$3000(this.this$1).logger.log("Refresh: Cannot find refreshed object " + this.val$id.toStringFull() + ", lookup returns " + o);
                                    }
                                    this.val$myParent.receiveException(new AggregationException("Object not found during reaggregation: " + this.val$id.toStringFull()));
                                }

                                public void receiveException(Exception e) {
                                    if (34.access$3000(this.this$1).logger.level <= 900) {
                                        34.access$3000(this.this$1).logger.log("Refresh: Exception received while reaggregating " + this.val$id.toStringFull() + ", e=" + e);
                                    }
                                    this.val$myParent.receiveException(e);
                                }

                                static /* synthetic */ 34 access$3400(37 x0) {
                                    return x0.this$1;
                                }

                                static /* synthetic */ Id access$3500(37 x0) {
                                    return x0.val$id;
                                }

                                static /* synthetic */ Continuation access$3600(37 x0) {
                                    return x0.val$myParent;
                                }
                            });
                            return;
                        }
                        if (AggregationImpl.this.logger.level <= 500) {
                            AggregationImpl.this.logger.log("Refresh: Limit of " + AggregationImpl.this.maxReaggregationPerRefresh + " reaggregations exceeded; postponing id=" + id.toStringFull());
                        }
                        lastResult = new Boolean(true);
                        continue;
                    }
                    if (AggregationImpl.this.logger.level <= 900) {
                        AggregationImpl.this.logger.log("Refresh: Refreshed object not found in any aggregate: " + id.toStringFull());
                    }
                    lastResult = new Boolean(true);
                }
            }

            public void receiveException(Exception e) {
                if (AggregationImpl.this.logger.level <= 900) {
                    AggregationImpl.this.logger.logException("Exception while refreshing " + ids[this.currentIndex].toStringFull() + ", e=", e);
                }
                this.receiveResult(e);
            }

            static /* synthetic */ AggregationImpl access$3000(34 x0) {
                return x0.AggregationImpl.this;
            }
        };
        theContinuation.receiveResult(null);
    }

    private void rebuildRecursive(final Id fromKey, final Vector keysInProgress, final Vector keysPostponed, final Vector keysDone, final Continuation command) {
        keysInProgress.add(fromKey);
        if (this.logger.level <= 800) {
            this.logger.log("Rebuild: Fetching handles for aggregate " + fromKey.toStringFull());
        }
        this.aggregateStore.lookupHandles(fromKey, 999, new Continuation(){

            public void receiveResult(Object o) {
                if (AggregationImpl.this.logger.level <= 500) {
                    AggregationImpl.this.logger.log("Got handles for " + fromKey);
                }
                if (o instanceof PastContentHandle[]) {
                    PastContentHandle[] pch = (PastContentHandle[])o;
                    PastContentHandle bestHandle = null;
                    for (int i = 0; i < pch.length; ++i) {
                        if (pch[i] == null || pch[i] instanceof GCPastContentHandle && ((GCPastContentHandle)pch[i]).getVersion() != 0L || bestHandle != null) continue;
                        bestHandle = pch[i];
                    }
                    if (bestHandle != null) {
                        PastContentHandle thisHandle = bestHandle;
                        40 outerContinuation = this;
                        if (AggregationImpl.this.logger.level <= 500) {
                            AggregationImpl.this.logger.log("Fetching " + thisHandle);
                        }
                        AggregationImpl.this.aggregateStore.fetch(thisHandle, new Continuation(this, thisHandle, outerContinuation){
                            private final /* synthetic */ PastContentHandle val$thisHandle;
                            private final /* synthetic */ Continuation val$outerContinuation;
                            private final /* synthetic */ 40 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$thisHandle = val$thisHandle;
                                this.val$outerContinuation = val$outerContinuation;
                            }

                            public void receiveResult(Object o) {
                                if (o instanceof Aggregate) {
                                    40.access$3800(this.this$1).remove(40.access$3700(this.this$1));
                                    40.access$3900(this.this$1).add(40.access$3700(this.this$1));
                                    if (40.access$4000(this.this$1).logger.level <= 800) {
                                        40.access$4000(this.this$1).logger.log("Rebuild: Got aggregate " + 40.access$3700(this.this$1).toStringFull());
                                    }
                                    Aggregate aggr = (Aggregate)o;
                                    ObjectDescriptor[] objects = new ObjectDescriptor[aggr.numComponents()];
                                    long aggregateExpiration = this.val$thisHandle instanceof GCPastContentHandle ? ((GCPastContentHandle)this.val$thisHandle).getExpiration() : Long.MAX_VALUE;
                                    for (int i = 0; i < aggr.numComponents(); ++i) {
                                        objects[i] = new ObjectDescriptor(aggr.getComponent(i).getId(), aggr.getComponent(i).getVersion(), aggregateExpiration, aggregateExpiration, AggregationImpl.access$3200(40.access$4000(this.this$1), aggr.getComponent(i)));
                                        GCPastContent objData = aggr.getComponent(i);
                                        if (40.access$4000(this.this$1).logger.level <= 500) {
                                            40.access$4000(this.this$1).logger.log("Checking whether " + objData.getId() + "v" + objData.getVersion() + " is in object store...");
                                        }
                                        40.access$4000(this.this$1).objectStore.lookupHandles(objData.getId(), 1, new Continuation(this, objData){
                                            private final /* synthetic */ GCPastContent val$objData;
                                            private final /* synthetic */ 41 this$2;
                                            {
                                                this.this$2 = this$2;
                                                this.val$objData = val$objData;
                                            }

                                            public void receiveResult(Object o) {
                                                PastContentHandle[] result;
                                                PastContentHandle[] pastContentHandleArray = result = o instanceof PastContentHandle[] ? (PastContentHandle[])o : new PastContentHandle[]{};
                                                if (40.access$4000(41.access$4100(this.this$2)).logger.level <= 500) {
                                                    40.access$4000(41.access$4100(this.this$2)).logger.log("Handles for " + this.val$objData.getId() + "v" + this.val$objData.getVersion() + ": " + result + " (" + result.length + ", PCH=" + (o instanceof PastContentHandle[]) + ")");
                                                }
                                                boolean gotOne = false;
                                                for (int i = 0; i < result.length; ++i) {
                                                    if (result[i] == null) continue;
                                                    if (40.access$4000(41.access$4100(this.this$2)).logger.level <= 500) {
                                                        40.access$4000(41.access$4100(this.this$2)).logger.log("Have v" + ((GCPastContentHandle)result[i]).getVersion());
                                                    }
                                                    if (((GCPastContentHandle)result[i]).getVersion() < this.val$objData.getVersion()) continue;
                                                    gotOne = true;
                                                }
                                                if (gotOne) {
                                                    if (40.access$4000(41.access$4100(this.this$2)).logger.level <= 500) {
                                                        40.access$4000(41.access$4100(this.this$2)).logger.log("Got it");
                                                    }
                                                } else {
                                                    if (40.access$4000(41.access$4100(this.this$2)).logger.level <= 500) {
                                                        40.access$4000(41.access$4100(this.this$2)).logger.log("Ain't got it... reinserting");
                                                    }
                                                    40.access$4000(41.access$4100(this.this$2)).objectStore.insert(this.val$objData, new Continuation(this){
                                                        private final /* synthetic */ 42 this$3;
                                                        {
                                                            this.this$3 = this$3;
                                                        }

                                                        public void receiveResult(Object o) {
                                                            if (40.access$4000(41.access$4100(42.access$4200(this.this$3))).logger.level <= 500) {
                                                                40.access$4000(41.access$4100(42.access$4200(this.this$3))).logger.log("Reinsert " + 42.access$4300(this.this$3).getId() + "v" + 42.access$4300(this.this$3).getVersion() + " ok, result=" + o);
                                                            }
                                                        }

                                                        public void receiveException(Exception e) {
                                                            if (40.access$4000(41.access$4100(42.access$4200(this.this$3))).logger.level <= 500) {
                                                                40.access$4000(41.access$4100(42.access$4200(this.this$3))).logger.logException("Reinsert " + 42.access$4300(this.this$3).getId() + "v" + 42.access$4300(this.this$3).getVersion() + " failed, exception=", e);
                                                            }
                                                        }
                                                    });
                                                }
                                            }

                                            public void receiveException(Exception e) {
                                                if (40.access$4000(41.access$4100(this.this$2)).logger.level <= 500) {
                                                    40.access$4000(41.access$4100(this.this$2)).logger.logException("Cannot retrieve handles for object " + this.val$objData.getId() + "v" + this.val$objData.getVersion() + " to be restored; e=", e);
                                                }
                                            }

                                            static /* synthetic */ 41 access$4200(42 x0) {
                                                return x0.this$2;
                                            }

                                            static /* synthetic */ GCPastContent access$4300(42 x0) {
                                                return x0.val$objData;
                                            }
                                        });
                                    }
                                    40.access$4000(this.this$1).aggregateList.addAggregateDescriptor(new AggregateDescriptor(40.access$3700(this.this$1), aggregateExpiration, objects, aggr.getPointers()));
                                    Id[] pointers = aggr.getPointers();
                                    int numAdded = 0;
                                    if (pointers != null) {
                                        for (int i = 0; i < pointers.length; ++i) {
                                            if (!(pointers[i] instanceof Id)) continue;
                                            Id thisPointer = pointers[i];
                                            if (40.access$3900(this.this$1).contains(thisPointer) || 40.access$4400(this.this$1).contains(thisPointer) || 40.access$3800(this.this$1).contains(thisPointer)) continue;
                                            if (40.access$3800(this.this$1).size() >= AggregationImpl.access$4500(40.access$4000(this.this$1))) {
                                                40.access$4400(this.this$1).add(thisPointer);
                                            } else {
                                                AggregationImpl.access$4700(40.access$4000(this.this$1), thisPointer, 40.access$3800(this.this$1), 40.access$4400(this.this$1), 40.access$3900(this.this$1), 40.access$4600(this.this$1));
                                            }
                                            ++numAdded;
                                        }
                                    }
                                    if (40.access$4000(this.this$1).logger.level <= 500) {
                                        40.access$4000(this.this$1).logger.log("Rebuild: Added " + numAdded + " keys, now " + 40.access$3800(this.this$1).size() + " in progress, " + 40.access$4400(this.this$1).size() + " postponed and " + 40.access$3900(this.this$1).size() + " done");
                                    }
                                    if (!40.access$3800(this.this$1).isEmpty() || !40.access$4400(this.this$1).isEmpty()) {
                                        if (40.access$4000(this.this$1).logger.level <= 800) {
                                            40.access$4000(this.this$1).logger.log("Rebuild: " + 40.access$3800(this.this$1).size() + " keys in progress, " + 40.access$4400(this.this$1).size() + " postponed, " + 40.access$3900(this.this$1).size() + " done");
                                        }
                                        while (40.access$3800(this.this$1).size() < AggregationImpl.access$4500(40.access$4000(this.this$1)) && 40.access$4400(this.this$1).size() > 0) {
                                            Id nextKey = (Id)40.access$4400(this.this$1).firstElement();
                                            if (40.access$4000(this.this$1).logger.level <= 500) {
                                                40.access$4000(this.this$1).logger.log("Rebuild: Resuming lookup for postponed key " + nextKey.toStringFull());
                                            }
                                            40.access$4400(this.this$1).remove(nextKey);
                                            AggregationImpl.access$4700(40.access$4000(this.this$1), nextKey, 40.access$3800(this.this$1), 40.access$4400(this.this$1), 40.access$3900(this.this$1), 40.access$4600(this.this$1));
                                        }
                                    } else {
                                        40.access$4000(this.this$1).aggregateList.writeToDisk();
                                        40.access$4000(this.this$1).rebuildInProgress = false;
                                        if (40.access$4000(this.this$1).logger.level <= 800) {
                                            40.access$4000(this.this$1).logger.log("Rebuild: Completed; " + 40.access$3900(this.this$1).size() + " aggregates checked");
                                        }
                                        40.access$4600(this.this$1).receiveResult(new Boolean(true));
                                    }
                                } else {
                                    this.receiveException(new AggregationException("Fetch failed: " + 40.access$3700(this.this$1) + ", returned " + o));
                                }
                            }

                            public void receiveException(Exception e) {
                                this.val$outerContinuation.receiveException(e);
                            }

                            static /* synthetic */ 40 access$4100(41 x0) {
                                return x0.this$1;
                            }
                        });
                    } else {
                        this.receiveException(new AggregationException("LookupHandles did not return any valid handles for " + fromKey));
                    }
                } else {
                    this.receiveException(new AggregationException("LookupHandles for " + fromKey + " failed, returned o=" + o));
                }
            }

            public void receiveException(Exception e) {
                if (AggregationImpl.this.logger.level <= 900) {
                    AggregationImpl.this.logger.logException("Rebuild: Exception ", e);
                }
                keysInProgress.remove(fromKey);
                keysDone.add(fromKey);
                if (keysInProgress.isEmpty() && keysPostponed.isEmpty()) {
                    AggregationImpl.this.rebuildInProgress = false;
                    if (AggregationImpl.this.aggregateList.isEmpty()) {
                        command.receiveException(new AggregationException("Cannot read root aggregate! -- retry later"));
                    } else {
                        AggregationImpl.this.aggregateList.writeToDisk();
                        command.receiveResult(new Boolean(true));
                    }
                }
                while (keysInProgress.size() < AggregationImpl.this.reconstructionMaxConcurrentLookups && keysPostponed.size() > 0) {
                    Id nextKey = (Id)keysPostponed.firstElement();
                    if (AggregationImpl.this.logger.level <= 500) {
                        AggregationImpl.this.logger.log("Rebuild: Resuming lookup for postponed key " + nextKey.toStringFull());
                    }
                    keysPostponed.remove(nextKey);
                    AggregationImpl.this.rebuildRecursive(nextKey, keysInProgress, keysPostponed, keysDone, command);
                }
            }

            static /* synthetic */ Id access$3700(40 x0) {
                return x0.fromKey;
            }

            static /* synthetic */ Vector access$3800(40 x0) {
                return x0.keysInProgress;
            }

            static /* synthetic */ Vector access$3900(40 x0) {
                return x0.keysDone;
            }

            static /* synthetic */ AggregationImpl access$4000(40 x0) {
                return x0.AggregationImpl.this;
            }

            static /* synthetic */ Vector access$4400(40 x0) {
                return x0.keysPostponed;
            }

            static /* synthetic */ Continuation access$4600(40 x0) {
                return x0.command;
            }
        });
    }

    private void rebuildAggregateList(Continuation command) {
        Vector keysInProgress = new Vector();
        Vector keysPostponed = new Vector();
        Vector keysDone = new Vector();
        if (this.logger.level <= 800) {
            this.logger.log("rebuildAggregateList(" + this.aggregateList.getRoot() + ")");
        }
        if (this.aggregateList.getRoot() == null) {
            if (this.logger.level <= 900) {
                this.logger.log("rebuildAggregateList invoked while rootKey is null");
            }
            command.receiveException(new AggregationException("Set handle first!"));
            return;
        }
        this.rebuildInProgress = true;
        this.rebuildRecursive(this.aggregateList.getRoot(), keysInProgress, keysPostponed, keysDone, command);
    }

    public void insert(PastContent obj, Continuation command) {
        this.insert(obj, Long.MAX_VALUE, command);
    }

    public void insert(final PastContent obj, long lifetime, final Continuation command) {
        long theVersion = obj instanceof GCPastContent ? ((GCPastContent)obj).getVersion() : 0L;
        VersionKey vkey = new VersionKey(obj.getId(), theVersion);
        long theVersionF = theVersion;
        int theSize = this.getSize(obj);
        if (this.policy.shouldBeAggregated(obj, theSize)) {
            if (this.logger.level <= 800) {
                this.logger.log("AGGREGATE INSERT: " + obj.getId() + " version=" + theVersion + " size=" + theSize + " class=" + obj.getClass().getName());
            }
            if (this.objectStore instanceof GCPast) {
                ((GCPast)this.objectStore).insert(obj, lifetime, command);
            } else {
                this.objectStore.insert(obj, command);
            }
            this.waitingList.store(vkey, new ObjectDescriptor(obj.getId(), theVersionF, lifetime, lifetime, theSize), obj, new Continuation(){

                public void receiveResult(Object o) {
                }

                public void receiveException(Exception e) {
                    if (AggregationImpl.this.logger.level <= 900) {
                        AggregationImpl.this.logger.logException("Exception while storing aggregate: " + obj.getId() + " (e=" + e + ")", e);
                    }
                }
            });
        } else {
            if (this.logger.level <= 800) {
                this.logger.log("INSERT WITHOUT AGGREGATION: " + obj.getId() + " version=" + theVersionF + " size=" + theSize + " class=" + obj.getClass().getName());
            }
            Continuation c = new Continuation(){
                boolean otherSucceeded = false;
                boolean otherFailed = false;

                public void receiveResult(Object o) {
                    if (AggregationImpl.this.logger.level <= 500) {
                        AggregationImpl.this.logger.log("INSERT " + obj.getId() + " receiveResult(" + o + "), otherSucc=" + this.otherSucceeded + " otherFail=" + this.otherFailed);
                    }
                    if (this.otherSucceeded) {
                        if (!this.otherFailed) {
                            if (AggregationImpl.this.logger.level <= 500) {
                                AggregationImpl.this.logger.log("--reporting Success");
                            }
                            command.receiveResult(new Boolean[]{new Boolean(true)});
                        }
                    } else {
                        this.otherSucceeded = true;
                    }
                }

                public void receiveException(Exception e) {
                    if (AggregationImpl.this.logger.level <= 500) {
                        AggregationImpl.this.logger.log("INSERT " + obj.getId() + " receiveException(" + e + "), otherSucc=" + this.otherSucceeded + " otherFail=" + this.otherFailed);
                    }
                    if (AggregationImpl.this.logger.level <= 500) {
                        AggregationImpl.this.logger.log("--reporting Failure");
                    }
                    command.receiveException(e);
                    this.otherFailed = true;
                }
            };
            if (this.objectStore instanceof GCPast) {
                ((GCPast)this.objectStore).insert(obj, lifetime, c);
            } else {
                this.objectStore.insert(obj, c);
            }
            if (this.aggregateStore instanceof GCPast) {
                ((GCPast)this.aggregateStore).insert(new NonAggregate(obj), lifetime, c);
            } else {
                this.aggregateStore.insert(new NonAggregate(obj), c);
            }
        }
    }

    private void retrieveObjectFromAggregate(final AggregateDescriptor adc, final int objDescIndex, final Continuation command) {
        this.aggregateStore.lookup(adc.key, new Continuation(){

            public void receiveResult(Object o) {
                if (o instanceof Aggregate) {
                    Aggregate aggr = (Aggregate)o;
                    AggregationImpl.this.endpoint.process(new Executable(this, aggr){
                        private final /* synthetic */ Aggregate val$aggr;
                        private final /* synthetic */ 46 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$aggr = val$aggr;
                        }

                        public Object execute() {
                            return 46.access$4800(this.this$1).factory.buildId(this.val$aggr.getContentHash());
                        }
                    }, new Continuation(this, aggr){
                        private final /* synthetic */ Aggregate val$aggr;
                        private final /* synthetic */ 46 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$aggr = val$aggr;
                        }

                        public void receiveResult(Object o) {
                            if (o instanceof Id) {
                                Id aggrNominalKey = (Id)o;
                                if (!aggrNominalKey.equals(46.access$4900(this.this$1).key)) {
                                    if (46.access$4800(this.this$1).logger.level <= 900) {
                                        46.access$4800(this.this$1).logger.log("Cannot validate aggregate " + 46.access$4900(this.this$1).key + ", hash=" + aggrNominalKey);
                                    }
                                    46.access$5000(this.this$1).receiveException(new AggregationException("Cannot validate aggregate -- retry?"));
                                    return;
                                }
                                if (46.access$4800(this.this$1).logger.level <= 500) {
                                    46.access$4800(this.this$1).logger.log("Object " + 46.access$4900(this.this$1).objects[46.access$5100(this.this$1)].key + " (#" + 46.access$5100(this.this$1) + ") successfully retrieved from " + 46.access$4900(this.this$1).key);
                                }
                                46.access$4800(this.this$1).objectStore.insert(this.val$aggr.getComponent(46.access$5100(this.this$1)), new Continuation(this){
                                    private final /* synthetic */ 48 this$2;
                                    {
                                        this.this$2 = this$2;
                                    }

                                    public void receiveResult(Object o) {
                                    }

                                    public void receiveException(Exception e) {
                                    }
                                });
                                46.access$5000(this.this$1).receiveResult(this.val$aggr.getComponent(46.access$5100(this.this$1)));
                            } else {
                                if (46.access$4800(this.this$1).logger.level <= 900) {
                                    46.access$4800(this.this$1).logger.log("retrieveObjectFromAggregate cannot determine content hash, received " + o);
                                }
                                46.access$5000(this.this$1).receiveException(new AggregationException("retrieveObjectFromAggregate cannot determine content hash"));
                            }
                        }

                        public void receiveException(Exception e) {
                            if (46.access$4800(this.this$1).logger.level <= 900) {
                                46.access$4800(this.this$1).logger.logException("retrieveObjectFromAggregate cannot determine content hash, exception ", e);
                            }
                            46.access$5000(this.this$1).receiveException(e);
                        }
                    });
                } else {
                    if (AggregationImpl.this.logger.level <= 900) {
                        AggregationImpl.this.logger.log("retrieveObjectFromAggregate failed; receiveResult(" + o + ")");
                    }
                    command.receiveResult(null);
                }
            }

            public void receiveException(Exception e) {
                if (AggregationImpl.this.logger.level <= 900) {
                    AggregationImpl.this.logger.logException("retrieveObjectFromAggregate failed; receiveException(" + e + ")", e);
                }
                command.receiveException(e);
            }

            static /* synthetic */ AggregationImpl access$4800(46 x0) {
                return x0.AggregationImpl.this;
            }

            static /* synthetic */ AggregateDescriptor access$4900(46 x0) {
                return x0.adc;
            }

            static /* synthetic */ Continuation access$5000(46 x0) {
                return x0.command;
            }

            static /* synthetic */ int access$5100(46 x0) {
                return x0.objDescIndex;
            }
        });
    }

    public void lookup(final Id id, boolean cache, final Continuation command) {
        if (this.logger.level <= 800) {
            this.logger.log("lookup(" + id + ", cache=" + cache + ")");
        }
        this.objectStore.lookup(id, cache, new Continuation(){

            public void receiveResult(Object o) {
                if (o != null) {
                    if (AggregationImpl.this.logger.level <= 500) {
                        AggregationImpl.this.logger.log("NL: Found in PAST: " + id);
                    }
                    command.receiveResult(o);
                } else {
                    AggregateDescriptor adc = AggregationImpl.this.aggregateList.getADC(id);
                    if (adc != null) {
                        int objDescIndex;
                        if (AggregationImpl.this.logger.level <= 500) {
                            AggregationImpl.this.logger.log("NL: Must retrieve from aggregate");
                        }
                        if ((objDescIndex = adc.lookupNewest(id)) < 0) {
                            if (AggregationImpl.this.logger.level <= 900) {
                                AggregationImpl.this.logger.log("NL: Aggregate found, but object not found in aggregate?!? -- aborted");
                            }
                            command.receiveException(new AggregationException("Inconsistency detected in aggregate list -- try restarting the application"));
                            return;
                        }
                        AggregationImpl.this.retrieveObjectFromAggregate(adc, objDescIndex, command);
                    } else {
                        if (AggregationImpl.this.logger.level <= 900) {
                            AggregationImpl.this.logger.log("NL: LOOKUP FAILED, OBJECT NOT FOUND: " + id);
                        }
                        command.receiveResult(null);
                    }
                }
            }

            public void receiveException(Exception e) {
                command.receiveException(e);
            }
        });
    }

    public void lookup(final Id id, final long version, final Continuation command) {
        AggregateDescriptor adc;
        if (this.logger.level <= 800) {
            this.logger.log("lookup(" + id + ", version=" + version + ")");
        }
        if ((adc = this.aggregateList.getADC(new VersionKey(id, version))) != null) {
            int objDescIndex;
            if (this.logger.level <= 500) {
                this.logger.log("VL: Retrieving from aggregate");
            }
            if ((objDescIndex = adc.lookupSpecific(id, version)) < 0) {
                if (this.logger.level <= 900) {
                    this.logger.log("VL: Aggregate found, but object not found in aggregate?!? -- aborted");
                }
                command.receiveException(new AggregationException("Inconsistency detected in aggregate list -- try restarting the application"));
                return;
            }
            this.retrieveObjectFromAggregate(adc, objDescIndex, command);
        } else {
            if (this.logger.level <= 500) {
                this.logger.log("VL: Not found in aggregate list: " + id + "v" + version);
            }
            if (this.aggregateStore instanceof VersioningPast) {
                VersioningPast vaggr = (VersioningPast)((Object)this.aggregateStore);
                vaggr.lookup(id, version, new Continuation(){

                    public void receiveResult(Object o) {
                        if (o != null) {
                            if (AggregationImpl.this.logger.level <= 500) {
                                AggregationImpl.this.logger.log("VL: Found in Aggregate.VersioningPAST: " + id + "v" + version);
                            }
                            command.receiveResult(o);
                        } else {
                            if (AggregationImpl.this.logger.level <= 500) {
                                AggregationImpl.this.logger.log("VL: Not found in Aggregate.VersioningPAST: " + id + "v" + version);
                            }
                            if (AggregationImpl.this.objectStore instanceof VersioningPast) {
                                VersioningPast vpast = (VersioningPast)((Object)AggregationImpl.this.objectStore);
                                vpast.lookup(id, version, new Continuation(this){
                                    private final /* synthetic */ 51 this$1;
                                    {
                                        this.this$1 = this$1;
                                    }

                                    public void receiveResult(Object o) {
                                        if (o != null) {
                                            if (51.access$5300(this.this$1).logger.level <= 500) {
                                                51.access$5300(this.this$1).logger.log("VL: Found in Object.VersioningPAST: " + 51.access$5400(this.this$1) + "v" + 51.access$5500(this.this$1));
                                            }
                                            51.access$5600(this.this$1).receiveResult(o);
                                        } else {
                                            if (51.access$5300(this.this$1).logger.level <= 900) {
                                                51.access$5300(this.this$1).logger.log("VL: LOOKUP FAILED, OBJECT NOT FOUND: " + 51.access$5400(this.this$1) + "v" + 51.access$5500(this.this$1));
                                            }
                                            51.access$5600(this.this$1).receiveResult(null);
                                        }
                                    }

                                    public void receiveException(Exception e) {
                                        51.access$5600(this.this$1).receiveException(e);
                                    }
                                });
                            } else {
                                if (AggregationImpl.this.logger.level <= 500) {
                                    AggregationImpl.this.logger.log("VL: Object store does not support versioning");
                                }
                                command.receiveException(new AggregationException("Cannot find " + id + "v" + version + " -- try rebuilding aggregate list?"));
                            }
                        }
                    }

                    public void receiveException(Exception e) {
                        if (AggregationImpl.this.logger.level <= 900) {
                            AggregationImpl.this.logger.logException("Aggregate.VersioningPAST returned exception for " + id + "v" + version + ": ", e);
                        }
                        command.receiveException(new AggregationException("Aggregate.VersioningPAST returned exception for " + id + "v" + version + ": " + e));
                    }

                    static /* synthetic */ AggregationImpl access$5300(51 x0) {
                        return x0.AggregationImpl.this;
                    }

                    static /* synthetic */ Id access$5400(51 x0) {
                        return x0.id;
                    }

                    static /* synthetic */ long access$5500(51 x0) {
                        return x0.version;
                    }

                    static /* synthetic */ Continuation access$5600(51 x0) {
                        return x0.command;
                    }
                });
            } else {
                if (this.logger.level <= 500) {
                    this.logger.log("VL: Aggregate store does not support versioning");
                }
                if (this.objectStore instanceof VersioningPast) {
                    VersioningPast vpast = (VersioningPast)((Object)this.objectStore);
                    vpast.lookup(id, version, new Continuation(){

                        public void receiveResult(Object o) {
                            if (o != null) {
                                if (AggregationImpl.this.logger.level <= 500) {
                                    AggregationImpl.this.logger.log("VL: Found in Object.VersioningPAST: " + id + "v" + version);
                                }
                                command.receiveResult(o);
                            } else {
                                if (AggregationImpl.this.logger.level <= 900) {
                                    AggregationImpl.this.logger.log("VL: LOOKUP FAILED, OBJECT NOT FOUND: " + id + "v" + version);
                                }
                                command.receiveResult(null);
                            }
                        }

                        public void receiveException(Exception e) {
                            command.receiveException(e);
                        }
                    });
                }
                if (this.logger.level <= 500) {
                    this.logger.log("VL: Object store does not support versioning");
                }
                command.receiveResult(null);
            }
        }
    }

    public void lookup(Id id, Continuation command) {
        this.lookup(id, true, command);
    }

    public void lookupHandles(Id id, long version, int max, Continuation command) {
        ((VersioningPast)((Object)this.aggregateStore)).lookupHandles(id, version, max, command);
    }

    public void lookupHandle(Id id, NodeHandle handle, Continuation command) {
        command.receiveException(new UnsupportedOperationException("LookupHandle() is not supported on Aggregation"));
    }

    public void lookupHandles(final Id id, final int max, final Continuation command) {
        if (this.logger.level <= 800) {
            this.logger.log("lookupHandles(" + id + "," + max + ")");
        }
        this.objectStore.lookupHandles(id, max, new Continuation(){

            public void receiveResult(Object o) {
                PastContentHandle[] result = o instanceof PastContentHandle[] ? (PastContentHandle[])o : new PastContentHandle[]{};
                boolean foundHandle = false;
                for (int i = 0; i < result.length; ++i) {
                    if (result[i] == null) continue;
                    foundHandle = true;
                }
                if (foundHandle) {
                    if (AggregationImpl.this.logger.level <= 500) {
                        AggregationImpl.this.logger.log("lookupHandles(" + id + "," + max + ") handled by PAST; ret=" + o);
                    }
                    command.receiveResult(o);
                } else {
                    AggregateDescriptor adc;
                    if (AggregationImpl.this.logger.level <= 800) {
                        AggregationImpl.this.logger.log("lookupHandles(" + id + "," + max + ") failed, ret=" + o);
                    }
                    if ((adc = AggregationImpl.this.aggregateList.getADC(id)) != null) {
                        int objDescIndex;
                        if (AggregationImpl.this.logger.level <= 500) {
                            AggregationImpl.this.logger.log("lookupHandles: Retrieving from aggregate");
                        }
                        if ((objDescIndex = adc.lookupNewest(id)) < 0) {
                            if (AggregationImpl.this.logger.level <= 900) {
                                AggregationImpl.this.logger.log("lookupHandles: Aggregate found, but object not found in aggregate?!? -- aborted");
                            }
                            command.receiveException(new AggregationException("Inconsistency detected in aggregate list -- try restarting the application"));
                            return;
                        }
                        if (adc.objects[objDescIndex].refreshedLifetime < AggregationImpl.this.environment.getTimeSource().currentTimeMillis()) {
                            if (AggregationImpl.this.logger.level <= 500) {
                                AggregationImpl.this.logger.log("Object " + id + " exists, but has expired -- ignoring");
                            }
                            command.receiveResult(new PastContentHandle[]{null});
                            return;
                        }
                        AggregationImpl.this.retrieveObjectFromAggregate(adc, objDescIndex, new Continuation(this){
                            private final /* synthetic */ 54 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void receiveResult(Object o) {
                                if (54.access$5700(this.this$1).logger.level <= 500) {
                                    54.access$5700(this.this$1).logger.log("lookupHandles: Retrieved from aggregate: " + 54.access$5800(this.this$1) + ", result=" + o);
                                }
                                54.access$5700(this.this$1).objectStore.lookupHandles(54.access$5800(this.this$1), 54.access$5900(this.this$1), 54.access$6000(this.this$1));
                            }

                            public void receiveException(Exception e) {
                                if (54.access$5700(this.this$1).logger.level <= 900) {
                                    54.access$5700(this.this$1).logger.log("lookupHandles: Cannot retrieve from aggregate, exception " + e);
                                }
                                54.access$6000(this.this$1).receiveException(e);
                            }
                        });
                    } else {
                        if (AggregationImpl.this.logger.level <= 800) {
                            AggregationImpl.this.logger.log("lookupHandles: " + id + " is neither in object store nor in aggregate list");
                        }
                        command.receiveResult(new PastContentHandle[]{null});
                    }
                }
            }

            public void receiveException(Exception e) {
                if (AggregationImpl.this.logger.level <= 900) {
                    AggregationImpl.this.logger.log("Exception in lookupHandles: " + e);
                }
                command.receiveException(e);
            }

            static /* synthetic */ AggregationImpl access$5700(54 x0) {
                return x0.AggregationImpl.this;
            }

            static /* synthetic */ Id access$5800(54 x0) {
                return x0.id;
            }

            static /* synthetic */ int access$5900(54 x0) {
                return x0.max;
            }

            static /* synthetic */ Continuation access$6000(54 x0) {
                return x0.command;
            }
        });
    }

    public void fetch(PastContentHandle handle, Continuation command) {
        if (handle instanceof GlacierContentHandle) {
            this.aggregateStore.fetch(handle, command);
        } else {
            this.objectStore.fetch(handle, command);
        }
    }

    public void flush(Id id, Continuation command) {
        Iterator iter = this.waitingList.scan().getIterator();
        boolean objectIsWaiting = false;
        if (this.logger.level <= 800) {
            this.logger.log("flush(" + id + ") invoked");
        }
        while (iter.hasNext()) {
            VersionKey thisKey = (VersionKey)iter.next();
            if (!thisKey.getId().equals(id)) continue;
            objectIsWaiting = true;
            break;
        }
        if (objectIsWaiting) {
            this.formAggregates(command);
        } else {
            command.receiveResult(new Boolean(true));
        }
    }

    public void flush(Continuation command) {
        this.formAggregates(command);
    }

    public void rollback(Id id, Continuation command) {
        AggregateDescriptor adc = this.aggregateList.getADC(id);
        if (adc != null) {
            int objDescIndex = adc.lookupNewest(id);
            if (objDescIndex < 0) {
                if (this.logger.level <= 900) {
                    this.logger.log("Rollback: Aggregate found, but object not found in aggregate?!? -- aborted");
                }
                command.receiveException(new AggregationException("Inconsistency detected in aggregate list -- try restarting the application"));
                return;
            }
            if (this.logger.level <= 500) {
                this.logger.log("Rollback: Found " + adc.objects[objDescIndex].key + "v" + adc.objects[objDescIndex].version);
            }
            this.retrieveObjectFromAggregate(adc, objDescIndex, command);
        }
        if (this.logger.level <= 500) {
            this.logger.log("Rollback: No version of " + id + " found");
        }
        command.receiveResult(null);
    }

    public void reset(Continuation command) {
        this.aggregateList.clear();
        Iterator iter = this.waitingList.scan().getIterator();
        while (iter.hasNext()) {
            VersionKey thisKey = (VersionKey)iter.next();
            this.waitingList.unstore(thisKey, new Continuation(){

                public void receiveResult(Object o) {
                }

                public void receiveException(Exception e) {
                }
            });
        }
        command.receiveResult(new Boolean(true));
    }

    public boolean forward(RouteMessage message) {
        return true;
    }

    public void update(NodeHandle handle, boolean joined) {
    }

    public void deliver(Id id, Message message) {
        AggregationMessage msg = (AggregationMessage)message;
        if (this.logger.level <= 500) {
            this.logger.log("Received message " + msg + " with destination " + id + " from " + msg.getSource().getId());
        }
        if (msg instanceof AggregationTimeoutMessage) {
            AggregationTimeoutMessage gtm = (AggregationTimeoutMessage)msg;
            this.timerExpired((char)gtm.getUID());
            return;
        }
        this.panic("AGGREGATION ERROR - Received message " + msg + " of unknown type.");
    }

    private static AggregationPolicy getDefaultPolicy() {
        return new AggregationDefaultPolicy();
    }

    private static AggregateFactory getDefaultAggregateFactory() {
        return new RawAggregateFactory();
    }

    static /* synthetic */ int access$3200(AggregationImpl x0, PastContent x1) {
        return x0.getSize(x1);
    }
}

