/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.aggregation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.aggregation.AggregateDescriptor;
import rice.p2p.aggregation.AggregationException;
import rice.p2p.aggregation.AggregationStatistics;
import rice.p2p.aggregation.ObjectDescriptor;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.glacier.VersionKey;

public class AggregateList {
    protected final Hashtable aggregateList;
    protected final String configFileName;
    protected final String logFileName;
    protected final String label;
    protected final IdFactory factory;
    protected final PrintStream logFile;
    protected final boolean loggingEnabled;
    protected Id rootKey;
    protected boolean wasReadOK;
    protected long nextSerial;
    protected String instance;
    protected Environment environment;
    protected Logger logger;

    public AggregateList(String configFileName, String label, IdFactory factory, boolean loggingEnabled, String instance, Environment env) throws IOException {
        this.instance = instance;
        this.configFileName = configFileName;
        this.aggregateList = new Hashtable();
        this.factory = factory;
        this.label = label;
        this.rootKey = null;
        this.nextSerial = 0L;
        this.environment = env;
        this.logger = this.environment.getLogManager().getLogger(AggregateList.class, instance);
        this.wasReadOK = this.readFromDisk();
        this.loggingEnabled = loggingEnabled;
        this.logFileName = configFileName + ".log";
        if (loggingEnabled) {
            this.recoverLog();
            this.logFile = new PrintStream(new FileOutputStream(this.logFileName, true));
        } else {
            this.logFile = null;
        }
    }

    public Id getRoot() {
        return this.rootKey;
    }

    public boolean isEmpty() {
        return this.aggregateList.isEmpty();
    }

    public AggregateDescriptor getADC(Id id) {
        return (AggregateDescriptor)this.aggregateList.get(id);
    }

    public Id[] getSomePointers(int referenceThreshold, int max, Id[] excludes) {
        if (this.rootKey == null) {
            return new Id[0];
        }
        if (excludes != null) {
            this.recalculateReferenceCounts(excludes);
        }
        Vector<Id> pointers = new Vector<Id>();
        Enumeration enumeration = this.elements();
        this.resetMarkers();
        while (enumeration.hasMoreElements()) {
            AggregateDescriptor aggr = (AggregateDescriptor)enumeration.nextElement();
            if (aggr.marker) continue;
            aggr.marker = true;
            boolean isExcluded = false;
            if (excludes != null) {
                for (int i = 0; i < excludes.length; ++i) {
                    if (!excludes[i].equals(aggr.key)) continue;
                    isExcluded = true;
                }
            }
            if (aggr.referenceCount >= referenceThreshold || pointers.size() >= max || isExcluded) continue;
            pointers.add(aggr.key);
        }
        return pointers.toArray(new Id[0]);
    }

    public AggregationStatistics getStatistics(long granularity, long range, int nominalReferenceCount) {
        int maxHistoIndex = (int)(range / granularity);
        long now = this.environment.getTimeSource().currentTimeMillis();
        AggregationStatistics stats = new AggregationStatistics(1 + maxHistoIndex, granularity, this.environment);
        Enumeration enumeration = this.elements();
        this.recalculateReferenceCounts(null);
        this.resetMarkers();
        while (enumeration.hasMoreElements()) {
            int aggrPos;
            AggregateDescriptor aggr = (AggregateDescriptor)enumeration.nextElement();
            if (aggr.marker) continue;
            aggr.marker = true;
            ++stats.numAggregatesTotal;
            stats.numObjectsTotal += aggr.objects.length;
            if (aggr.objects.length == 0) {
                ++stats.numPointerArrays;
            }
            if (aggr.referenceCount < nominalReferenceCount) {
                ++stats.criticalAggregates;
            }
            if (aggr.referenceCount < 1) {
                ++stats.orphanedAggregates;
            }
            if ((aggrPos = (int)((aggr.currentLifetime - now) / granularity)) < 0) {
                aggrPos = 0;
            }
            if (aggrPos > maxHistoIndex) {
                aggrPos = maxHistoIndex;
            }
            int n = aggrPos;
            stats.aggregateLifetimeHisto[n] = stats.aggregateLifetimeHisto[n] + 1;
            for (int i = 0; i < aggr.objects.length; ++i) {
                int objPos;
                stats.totalObjectsSize += (long)aggr.objects[i].size;
                if (aggr.objects[i].isAliveAt(now)) {
                    ++stats.numObjectsAlive;
                    stats.liveObjectsSize += (long)aggr.objects[i].size;
                }
                if ((objPos = (int)((aggr.objects[i].refreshedLifetime - now) / granularity)) < 0) {
                    objPos = 0;
                }
                if (objPos > maxHistoIndex) {
                    objPos = maxHistoIndex;
                }
                int n2 = objPos;
                stats.objectLifetimeHisto[n2] = stats.objectLifetimeHisto[n2] + 1;
            }
        }
        return stats;
    }

    private String getLogPrefix() {
        return "COUNT: " + this.environment.getTimeSource().currentTimeMillis() + " AL";
    }

    public void setRoot(Id root) {
        this.rootKey = root;
        this.logEntry("setRoot|" + (root == null ? "null" : root.toStringFull()));
    }

    public void setAggregateLifetime(AggregateDescriptor adc, long lifetime) {
        this.logEntry("setAL|" + adc.key.toStringFull() + "|" + lifetime);
        adc.currentLifetime = lifetime;
    }

    public void setObjectCurrentLifetime(AggregateDescriptor adc, int index, long lifetime) {
        this.logEntry("setOCL|" + adc.key.toStringFull() + "|" + index + "|" + lifetime);
        adc.objects[index].currentLifetime = lifetime;
    }

    public void setObjectRefreshedLifetime(AggregateDescriptor adc, int index, long lifetime) {
        this.logEntry("setORL|" + adc.key.toStringFull() + "|" + index + "|" + lifetime);
        adc.objects[index].refreshedLifetime = lifetime;
    }

    public boolean readOK() {
        return this.wasReadOK;
    }

    public Enumeration elements() {
        return this.aggregateList.elements();
    }

    public void recoverLog() {
        BufferedReader logFile = null;
        long expectedSerial = -1L;
        int entriesReplayed = 0;
        try {
            logFile = new BufferedReader(new FileReader(this.logFileName));
            while (true) {
                String line;
                if ((line = this.readLineSkipComments(logFile)) == null) {
                    logFile.close();
                    break;
                }
                if (!line.startsWith("$") || !line.endsWith("@")) {
                    throw new AggregationException("Malformed log entry (expected $...@): " + line);
                }
                if (line.lastIndexOf(36) != 0 || line.indexOf(64) != line.length() - 1) {
                    throw new AggregationException("Overlapping log entries: " + line);
                }
                String[] parts = line.split("\\|");
                long thisSerial = Long.parseLong(parts[1]);
                if (expectedSerial >= 0L && thisSerial != expectedSerial) {
                    throw new AggregationException("Malformed log entry (expected serial #" + expectedSerial + "): " + line);
                }
                expectedSerial = thisSerial + 1L;
                if (thisSerial > this.nextSerial) {
                    throw new AggregationException("Entries " + this.nextSerial + ".." + (thisSerial - 1L) + " missing from log... cannot recover!");
                }
                if (thisSerial == this.nextSerial) {
                    long lifetime;
                    AggregateDescriptor adc;
                    Id adcKey;
                    if (this.logger.level <= 500) {
                        this.logger.log("Replaying log entry #" + thisSerial);
                    }
                    ++entriesReplayed;
                    if (parts[3].equals("setRoot")) {
                        if (parts[4].equals("null")) {
                            this.rootKey = null;
                            if (this.logger.level <= 400) {
                                this.logger.log("  - rootKey = null");
                            }
                        } else {
                            this.rootKey = this.factory.buildIdFromToString(parts[4]);
                            if (this.logger.level <= 500) {
                                this.logger.log("  - rootKey = " + this.rootKey.toStringFull());
                            }
                        }
                    } else if (parts[3].equals("setAL")) {
                        adcKey = this.factory.buildIdFromToString(parts[4]);
                        long lifetime2 = Long.parseLong(parts[5]);
                        adc = (AggregateDescriptor)this.aggregateList.get(adcKey);
                        if (adc == null) {
                            throw new AggregationException("Cannot find aggregate (" + adcKey.toStringFull() + ": " + line);
                        }
                        adc.currentLifetime = lifetime2;
                        if (this.logger.level <= 400) {
                            this.logger.log("  - lifetime=" + lifetime2 + " in ADC " + adcKey.toStringFull());
                        }
                    } else if (parts[3].equals("setOCL")) {
                        adcKey = this.factory.buildIdFromToString(parts[4]);
                        int index = Integer.parseInt(parts[5]);
                        lifetime = Long.parseLong(parts[6]);
                        AggregateDescriptor adc2 = (AggregateDescriptor)this.aggregateList.get(adcKey);
                        if (adc2 == null) {
                            throw new AggregationException("Cannot find aggregate (" + adcKey.toStringFull() + ": " + line);
                        }
                        if (adc2.objects.length <= index) {
                            throw new AggregationException("Object index mismatch (" + index + "/" + adc2.objects.length + "): " + line);
                        }
                        adc2.objects[index].currentLifetime = lifetime;
                        if (this.logger.level <= 400) {
                            this.logger.log("  - currentLifetime=" + lifetime + " in ADC " + adcKey.toStringFull() + " index " + index);
                        }
                    } else if (parts[3].equals("setORL")) {
                        adcKey = this.factory.buildIdFromToString(parts[4]);
                        int index = Integer.parseInt(parts[5]);
                        lifetime = Long.parseLong(parts[6]);
                        AggregateDescriptor adc3 = (AggregateDescriptor)this.aggregateList.get(adcKey);
                        if (adc3 == null) {
                            throw new AggregationException("Cannot find aggregate (" + adcKey.toStringFull() + ": " + line);
                        }
                        if (adc3.objects.length <= index) {
                            throw new AggregationException("Object index mismatch (" + index + "/" + adc3.objects.length + "): " + line);
                        }
                        adc3.objects[index].refreshedLifetime = lifetime;
                        if (this.logger.level <= 400) {
                            this.logger.log("  - refreshedLifetime=" + lifetime + " in ADC " + adcKey.toStringFull() + " index " + index);
                        }
                    } else if (parts[3].equals("refresh")) {
                        adcKey = this.factory.buildIdFromToString(parts[4]);
                        long lifetime3 = Long.parseLong(parts[5]);
                        adc = (AggregateDescriptor)this.aggregateList.get(adcKey);
                        if (adc == null) {
                            throw new AggregationException("Cannot find aggregate (" + adcKey.toStringFull() + ": " + line);
                        }
                        adc.currentLifetime = lifetime3;
                        for (int i = 0; i < adc.objects.length; ++i) {
                            adc.objects[i].currentLifetime = adc.objects[i].refreshedLifetime;
                        }
                        if (this.logger.level <= 400) {
                            this.logger.log(" - refresh=" + lifetime3 + " in ADC " + adcKey.toStringFull());
                        }
                    } else if (parts[3].equals("removeAggregate")) {
                        adcKey = this.factory.buildIdFromToString(parts[4]);
                        AggregateDescriptor adc4 = (AggregateDescriptor)this.aggregateList.get(adcKey);
                        if (adc4 == null) {
                            throw new AggregationException("Cannot find aggregate (" + adcKey.toStringFull() + ": " + line);
                        }
                        this.removeAggregateDescriptor(adc4, false);
                        if (this.logger.level <= 400) {
                            this.logger.log(" - remove ADC " + adcKey.toStringFull());
                        }
                    } else if (parts[3].equals("addAggregate")) {
                        adcKey = this.factory.buildIdFromToString(parts[4]);
                        AggregateDescriptor adc5 = (AggregateDescriptor)this.aggregateList.get(adcKey);
                        if (adc5 != null) {
                            throw new AggregationException("Aggregate already present (" + adcKey.toStringFull() + ": " + line);
                        }
                        adc5 = this.readAggregate(logFile, adcKey);
                        this.addAggregateDescriptor(adc5, false);
                        if (this.logger.level <= 400) {
                            this.logger.log(" - add ADC " + adcKey.toStringFull());
                        }
                    } else {
                        throw new AggregationException("Unknown command (" + parts[3] + "): " + line);
                    }
                    ++this.nextSerial;
                    continue;
                }
                if (!parts[3].equals("addAggregate")) continue;
                this.readAggregate(logFile, this.factory.buildIdFromToString(parts[4]));
            }
        }
        catch (FileNotFoundException fnfe) {
            if (this.logger.level <= 900) {
                this.logger.log("No aggregate log found; using configuration file only");
            }
        }
        catch (Exception e) {
            if (this.logger.level <= 900) {
                this.logger.logException("Exception while recovering aggregate log: ", e);
            }
            System.exit(1);
        }
        if (entriesReplayed > 0) {
            this.writeToDisk();
            if (this.logger.level <= 900) {
                this.logger.log(entriesReplayed + " entries replayed from aggregate log");
            }
        }
    }

    public void logEntry(String entry) {
        if (this.loggingEnabled) {
            if (this.logFile != null) {
                this.logFile.println("$|" + this.nextSerial++ + "|" + this.environment.getTimeSource().currentTimeMillis() + "|" + entry + "|@");
                this.logFile.flush();
            } else if (this.logger.level <= 900) {
                this.logger.log("Aggregation cannot write to log: " + entry);
            }
        }
    }

    public void clear() {
        this.aggregateList.clear();
        this.rootKey = null;
    }

    public void resetMarkers() {
        Enumeration enumerationeration = this.aggregateList.elements();
        while (enumerationeration.hasMoreElements()) {
            AggregateDescriptor aggr = (AggregateDescriptor)enumerationeration.nextElement();
            aggr.marker = false;
        }
    }

    public void refreshAggregate(AggregateDescriptor adc, long lifetime) {
        this.logEntry("refresh|" + adc.key.toStringFull() + "|" + lifetime);
        adc.currentLifetime = lifetime;
        for (int i = 0; i < adc.objects.length; ++i) {
            adc.objects[i].currentLifetime = adc.objects[i].refreshedLifetime;
        }
    }

    public void addAggregateDescriptor(AggregateDescriptor aggr) {
        this.addAggregateDescriptor(aggr, true);
    }

    private void addAggregateDescriptor(AggregateDescriptor aggr, boolean logThis) {
        int i;
        if (this.logFile != null && logThis && this.loggingEnabled) {
            this.logEntry("addAggregate|" + aggr.key.toStringFull());
            this.writeAggregate(this.logFile, aggr);
            this.logFile.flush();
        }
        this.aggregateList.put(aggr.key, aggr);
        for (i = 0; i < aggr.objects.length; ++i) {
            int objDescIndex;
            this.aggregateList.put(new VersionKey(aggr.objects[i].key, aggr.objects[i].version), aggr);
            AggregateDescriptor prevDesc = (AggregateDescriptor)this.aggregateList.get(aggr.objects[i].key);
            int n = objDescIndex = prevDesc == null ? -1 : prevDesc.lookupNewest(aggr.objects[i].key);
            if (objDescIndex >= 0 && prevDesc.objects[objDescIndex].version > aggr.objects[i].version) continue;
            this.aggregateList.put(aggr.objects[i].key, aggr);
        }
        for (i = 0; i < aggr.pointers.length; ++i) {
            AggregateDescriptor ref = (AggregateDescriptor)this.aggregateList.get(aggr.pointers[i]);
            if (ref == null) continue;
            ref.addReference();
        }
    }

    public void removeAggregateDescriptor(AggregateDescriptor aggr) {
        this.removeAggregateDescriptor(aggr, true);
    }

    private void removeAggregateDescriptor(AggregateDescriptor aggr, boolean logThis) {
        if (logThis) {
            this.logEntry("removeAggregate|" + aggr.key.toStringFull());
        }
        this.aggregateList.remove(aggr.key);
        for (int i = 0; i < aggr.objects.length; ++i) {
            AggregateDescriptor prevDesc2;
            VersionKey vkey = new VersionKey(aggr.objects[i].key, aggr.objects[i].version);
            AggregateDescriptor prevDesc1 = (AggregateDescriptor)this.aggregateList.get(vkey);
            if (prevDesc1 != null && prevDesc1.key.equals(aggr.key)) {
                this.aggregateList.remove(vkey);
            }
            if ((prevDesc2 = (AggregateDescriptor)this.aggregateList.get(aggr.objects[i].key)) == null || !prevDesc2.key.equals(aggr.key)) continue;
            this.aggregateList.remove(aggr.objects[i].key);
        }
        if (this.aggregateList.containsValue(aggr) && this.logger.level <= 900) {
            this.logger.log("Removal from aggregate list incomplete: " + aggr.key.toStringFull());
        }
    }

    public void recalculateReferenceCounts(Id[] excludes) {
        int i;
        AggregateDescriptor aggr;
        Enumeration enumeration = this.aggregateList.elements();
        while (enumeration.hasMoreElements()) {
            aggr = (AggregateDescriptor)enumeration.nextElement();
            aggr.referenceCount = 0;
            aggr.marker = false;
            if (excludes == null) continue;
            for (i = 0; i < excludes.length; ++i) {
                if (!excludes[i].equals(aggr.key)) continue;
                aggr.marker = true;
            }
        }
        enumeration = this.aggregateList.elements();
        while (enumeration.hasMoreElements()) {
            aggr = (AggregateDescriptor)enumeration.nextElement();
            if (aggr.marker) continue;
            aggr.marker = true;
            for (i = 0; i < aggr.pointers.length; ++i) {
                AggregateDescriptor ref = (AggregateDescriptor)this.aggregateList.get(aggr.pointers[i]);
                if (ref == null) continue;
                ref.addReference();
            }
        }
    }

    private String readLineSkipComments(BufferedReader br) throws IOException {
        String line;
        while ((line = br.readLine()) != null && (line.length() == 0 || line.charAt(0) == '#')) {
        }
        return line;
    }

    private AggregateDescriptor readAggregate(BufferedReader reader, Id aggrKey) throws AggregationException, IOException {
        String[] expiresS = this.readLineSkipComments(reader).split("=");
        if (!expiresS[0].equals("expires")) {
            throw new AggregationException("Cannot find expiration date: " + expiresS[0]);
        }
        long expires = Long.parseLong(expiresS[1]);
        String[] objectNumS = this.readLineSkipComments(reader).split("=");
        if (!objectNumS[0].equals("objects")) {
            throw new AggregationException("Cannot find number of objects: " + objectNumS[0]);
        }
        int numObjects = Integer.parseInt(objectNumS[1]);
        ObjectDescriptor[] objects = new ObjectDescriptor[numObjects];
        for (int i = 0; i < numObjects; ++i) {
            String[] objS = this.readLineSkipComments(reader).split("=");
            String[] objArgS = objS[1].split(";");
            String[] objIdS = objArgS[0].split("v");
            objects[i] = new ObjectDescriptor(this.factory.buildIdFromToString(objIdS[0]), Long.parseLong(objIdS[1]), Long.parseLong(objArgS[1]), Long.parseLong(objArgS[2]), Integer.parseInt(objArgS[3]));
        }
        String[] pointerNumS = this.readLineSkipComments(reader).split("=");
        if (!pointerNumS[0].equals("pointers")) {
            throw new AggregationException("Cannot find number of pointers: " + pointerNumS[0]);
        }
        int numPointers = Integer.parseInt(pointerNumS[1]);
        Id[] pointers = new Id[numPointers];
        for (int i = 0; i < numPointers; ++i) {
            String[] ptrS = this.readLineSkipComments(reader).split("=");
            pointers[i] = this.factory.buildIdFromToString(ptrS[1]);
        }
        return new AggregateDescriptor(aggrKey, expires, objects, pointers);
    }

    /*
     * WARNING - void declaration
     */
    public boolean readFromDisk() {
        boolean readSuccessful;
        BufferedReader configFile;
        block14: {
            String fileName;
            this.rootKey = null;
            this.aggregateList.clear();
            if (new File(this.configFileName).exists()) {
                fileName = this.configFileName;
            } else if (new File(this.configFileName + ".new").exists()) {
                fileName = this.configFileName + ".new";
            } else {
                return false;
            }
            configFile = null;
            readSuccessful = false;
            try {
                void var1_1;
                configFile = new BufferedReader(new FileReader((String)var1_1));
                String[] root = this.readLineSkipComments(configFile).split("=");
                if (root[0].equals("nextid")) {
                    this.nextSerial = Long.parseLong(root[1]);
                    root = this.readLineSkipComments(configFile).split("=");
                }
                if (!root[0].equals("root")) {
                    throw new AggregationException("Cannot read root key: " + root[0]);
                }
                this.rootKey = this.factory.buildIdFromToString(root[1]);
                while (true) {
                    String aggrKeyLine;
                    if ((aggrKeyLine = this.readLineSkipComments(configFile)) == null) {
                        readSuccessful = true;
                        break;
                    }
                    String[] aggrKeyS = aggrKeyLine.split("\\[|\\]");
                    Id aggrKey = this.factory.buildIdFromToString(aggrKeyS[1]);
                    AggregateDescriptor adc = this.readAggregate(configFile, aggrKey);
                    this.addAggregateDescriptor(adc, false);
                }
            }
            catch (Exception e) {
                if (this.logger.level > 900) break block14;
                this.logger.logException("Cannot read configuration file: " + this.configFileName + " (e=" + e + ")", e);
            }
        }
        if (configFile != null) {
            try {
                configFile.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!readSuccessful) {
            this.rootKey = null;
            this.aggregateList.clear();
        }
        return readSuccessful;
    }

    private void writeAggregate(PrintStream stream, AggregateDescriptor adc) {
        int i;
        stream.println("expires=" + adc.currentLifetime);
        stream.println("objects=" + adc.objects.length);
        for (i = 0; i < adc.objects.length; ++i) {
            stream.println("obj" + i + "=" + adc.objects[i].key.toStringFull() + "v" + adc.objects[i].version + ";" + adc.objects[i].currentLifetime + ";" + adc.objects[i].refreshedLifetime + ";" + adc.objects[i].size);
        }
        stream.println("pointers=" + adc.pointers.length);
        for (i = 0; i < adc.pointers.length; ++i) {
            stream.println("ptr" + i + "=" + adc.pointers[i].toStringFull());
        }
    }

    public void writeToDisk() {
        block4: {
            if (this.rootKey == null) {
                return;
            }
            try {
                PrintStream configFile = new PrintStream(new FileOutputStream(this.configFileName + ".new"));
                Enumeration enumeration = this.aggregateList.elements();
                this.resetMarkers();
                configFile.println("# Aggregate list at " + this.label + " (" + new Date() + ")");
                configFile.println();
                configFile.println("nextid=" + this.nextSerial);
                configFile.println("root=" + this.rootKey.toStringFull());
                configFile.println();
                while (enumeration.hasMoreElements()) {
                    AggregateDescriptor aggr = (AggregateDescriptor)enumeration.nextElement();
                    if (aggr.marker) continue;
                    configFile.println("[" + aggr.key.toStringFull() + "]");
                    this.writeAggregate(configFile, aggr);
                    configFile.println("");
                    aggr.marker = true;
                }
                configFile.close();
                new File(this.configFileName).delete();
                new File(this.configFileName + ".new").renameTo(new File(this.configFileName));
            }
            catch (IOException ioe) {
                if (this.logger.level > 900) break block4;
                this.logger.logException("AggregationImpl cannot write to its aggregate list: " + this.configFileName + " (" + ioe + ")", ioe);
            }
        }
    }
}

