/*
 * Decompiled with CFR 0.152.
 */
package rice.tutorial.direct;

import java.io.IOException;
import java.util.Vector;
import rice.environment.Environment;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.direct.DirectPastryNodeFactory;
import rice.pastry.direct.EuclideanNetwork;
import rice.pastry.leafset.LeafSet;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.tutorial.direct.MyApp;

public class DirectTutorial {
    Vector apps = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectTutorial(int numNodes, Environment env) throws Exception {
        RandomNodeIdFactory nidFactory = new RandomNodeIdFactory(env);
        EuclideanNetwork simulator = new EuclideanNetwork(env);
        simulator.setMaxSpeed(1.0f);
        DirectPastryNodeFactory factory = new DirectPastryNodeFactory(nidFactory, simulator, env);
        NodeHandle bootHandle = null;
        for (int curNode = 0; curNode < numNodes; ++curNode) {
            PastryNode node = ((PastryNodeFactory)factory).newNode(bootHandle);
            bootHandle = node.getLocalHandle();
            PastryNode pastryNode = node;
            synchronized (pastryNode) {
                while (!node.isReady() && !node.joinFailed()) {
                    node.wait(500L);
                    if (!node.joinFailed()) continue;
                    throw new IOException("Could not join the FreePastry ring.  Reason:" + node.joinFailedReason());
                }
            }
            System.out.println("Finished creating new node " + node);
            MyApp app = new MyApp(node);
            this.apps.add(app);
        }
        simulator.setFullSpeed();
        env.getTimeSource().sleep(10000L);
        for (int i = 0; i < 10; ++i) {
            for (MyApp app : this.apps) {
                Id randId = nidFactory.generateNodeId();
                app.routeMyMsg(randId);
                env.getTimeSource().sleep(100L);
            }
        }
        env.getTimeSource().sleep(1000L);
        for (MyApp app : this.apps) {
            PastryNode node = (PastryNode)app.getNode();
            LeafSet leafSet = node.getLeafSet();
            for (int i = -leafSet.ccwSize(); i <= leafSet.cwSize(); ++i) {
                if (i == 0) continue;
                NodeHandle nh = leafSet.get(i);
                app.routeMyMsgDirect(nh);
                env.getTimeSource().sleep(100L);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Environment env = Environment.directEnvironment();
        try {
            int numNodes = Integer.parseInt(args[0]);
            DirectTutorial directTutorial = new DirectTutorial(numNodes, env);
        }
        catch (Exception e) {
            System.out.println("Usage:");
            System.out.println("java [-cp FreePastry-<version>.jar] rice.tutorial.direct.DirectTutorial numNodes");
            System.out.println("example java rice.tutorial.direct.DirectTutorial 100");
            throw e;
        }
    }
}

