/*
 * Decompiled with CFR 0.152.
 */
package rice.persistence;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.SortedMap;
import java.util.zip.GZIPOutputStream;
import rice.Continuation;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.IdSet;
import rice.p2p.util.ImmutableSortedMap;
import rice.p2p.util.RedBlackMap;
import rice.p2p.util.ReverseTreeMap;
import rice.p2p.util.XMLObjectOutputStream;
import rice.persistence.Storage;

public class MemoryStorage
implements Storage {
    private HashMap storage;
    private ReverseTreeMap metadata;
    private IdSet idSet;
    private int currentSize;
    private IdFactory factory;

    public MemoryStorage(IdFactory factory) {
        this.factory = factory;
        this.idSet = factory.buildIdSet();
        this.storage = new HashMap();
        this.metadata = new ReverseTreeMap();
        this.currentSize = 0;
    }

    public void flush(Continuation c) {
        this.storage = new HashMap();
        this.metadata = new ReverseTreeMap();
        this.idSet = this.factory.buildIdSet();
        this.currentSize = 0;
        c.receiveResult(Boolean.TRUE);
    }

    public void rename(Id oldId, Id newId, Continuation c) {
        if (!this.idSet.isMemberId(oldId)) {
            c.receiveResult(new Boolean(false));
            return;
        }
        this.idSet.removeId(oldId);
        this.idSet.addId(newId);
        this.storage.put(newId, this.storage.get(oldId));
        this.storage.remove(oldId);
        this.metadata.put(newId, this.metadata.get(oldId));
        this.metadata.remove(oldId);
        c.receiveResult(new Boolean(true));
    }

    public void store(Id id, Serializable metadata, Serializable obj, Continuation c) {
        if (id == null || obj == null) {
            c.receiveResult(new Boolean(false));
            return;
        }
        this.currentSize += this.getSize(obj);
        this.storage.put(id, obj);
        this.metadata.put(id, metadata);
        this.idSet.addId(id);
        c.receiveResult(new Boolean(true));
    }

    public void unstore(Id id, Continuation c) {
        Object stored = this.storage.remove(id);
        this.metadata.remove(id);
        this.idSet.removeId(id);
        if (stored != null) {
            this.currentSize -= this.getSize(stored);
            c.receiveResult(new Boolean(true));
        } else {
            c.receiveResult(new Boolean(false));
        }
    }

    public boolean exists(Id id) {
        return this.storage.containsKey(id);
    }

    public Serializable getMetadata(Id id) {
        return (Serializable)this.metadata.get(id);
    }

    public void setMetadata(Id id, Serializable metadata, Continuation command) {
        if (this.exists(id)) {
            this.metadata.put(id, metadata);
        }
        command.receiveResult(new Boolean(this.exists(id)));
    }

    public void getObject(Id id, Continuation c) {
        c.receiveResult(this.storage.get(id));
    }

    public IdSet scan(IdRange range) {
        return this.idSet.subSet(range);
    }

    public IdSet scan() {
        return this.idSet;
    }

    public SortedMap scanMetadata(IdRange range) {
        if (range.isEmpty()) {
            return new RedBlackMap();
        }
        if (range.getCCWId().equals(range.getCWId())) {
            return this.scanMetadata();
        }
        return new ImmutableSortedMap(this.metadata.keySubMap(range.getCCWId(), range.getCWId()));
    }

    public SortedMap scanMetadata() {
        return new ImmutableSortedMap(this.metadata.keyMap());
    }

    public SortedMap scanMetadataValuesHead(Object value) {
        return new ImmutableSortedMap(this.metadata.valueHeadMap(value));
    }

    public SortedMap scanMetadataValuesNull() {
        return new ImmutableSortedMap(this.metadata.valueNullMap());
    }

    public long getTotalSize() {
        return this.currentSize;
    }

    public int getSize() {
        return this.idSet.numElements();
    }

    private int getSize(Object obj) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLObjectOutputStream oos = new XMLObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(baos)));
            oos.writeObject(obj);
            ((ObjectOutputStream)oos).close();
            return baos.toByteArray().length;
        }
        catch (IOException e) {
            throw new RuntimeException("Object " + obj + " was not serialized correctly!");
        }
    }
}

