/*
 * Decompiled with CFR 0.152.
 */
package rice.persistence;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.SortedMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import rice.Continuation;
import rice.environment.logging.Logger;
import rice.environment.processing.WorkRequest;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.IdSet;
import rice.p2p.util.ImmutableSortedMap;
import rice.p2p.util.RedBlackMap;
import rice.p2p.util.ReverseTreeMap;
import rice.p2p.util.XMLObjectInputStream;
import rice.p2p.util.XMLObjectOutputStream;
import rice.persistence.Storage;

public class DatabaseStorage
implements Storage {
    protected rice.environment.Environment env;
    protected Environment dbenv;
    protected Database db;
    protected Database metadb;
    protected IdFactory idf;
    protected ReverseTreeMap meta;
    private Logger logger;

    public DatabaseStorage(IdFactory idf, String name, String rootDir, long size, boolean index, rice.environment.Environment env) throws IOException {
        this(idf, name, rootDir, env);
    }

    public DatabaseStorage(IdFactory idf, String name, String rootDir, long size, rice.environment.Environment env) throws IOException {
        this(idf, name, rootDir, env);
    }

    public DatabaseStorage(IdFactory factory, String rootDir, long size, rice.environment.Environment env) throws IOException {
        this(factory, "default", rootDir, size, env);
    }

    public DatabaseStorage(IdFactory idf, String name, String rootDir, rice.environment.Environment env) throws IOException {
        this.env = env;
        this.logger = env.getLogManager().getLogger(this.getClass(), name);
        this.idf = idf;
        EnvironmentConfig ec = new EnvironmentConfig();
        ec.setAllowCreate(true);
        ec.setTransactional(true);
        try {
            OperationStatus status;
            File dbdir = new File(rootDir, name);
            if (!dbdir.exists()) {
                dbdir.mkdirs();
            }
            this.dbenv = new Environment(dbdir, ec);
            Transaction trans = this.dbenv.beginTransaction(null, null);
            DatabaseConfig dc = new DatabaseConfig();
            dc.setAllowCreate(true);
            dc.setTransactional(true);
            this.db = this.dbenv.openDatabase(trans, "data", dc);
            this.metadb = this.dbenv.openDatabase(trans, "metadata", dc);
            this.meta = new ReverseTreeMap();
            Cursor cur = this.metadb.openCursor(trans, null);
            do {
                DatabaseEntry key = new DatabaseEntry();
                DatabaseEntry value = new DatabaseEntry();
                status = cur.getNext(key, value, null);
                if (key.getData() == null) continue;
                this.meta.put(this.db2id(key), this.dbDeserialize(value));
            } while (status == OperationStatus.SUCCESS);
            cur.close();
            trans.commit();
        }
        catch (DatabaseException e) {
            if (this.logger.level <= 900) {
                this.logger.logException("could not open database " + name + " in " + rootDir + ": ", e);
            }
            throw new IOException("could not open database " + name + " in " + rootDir + ": " + (Object)((Object)e));
        }
    }

    public void store(final Id id, final Serializable metadata, final Serializable obj, Continuation c) {
        if (id == null || obj == null) {
            c.receiveResult(Boolean.FALSE);
            return;
        }
        this.env.getProcessor().processBlockingIO(new WorkRequest(c, this.env.getSelectorManager()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doWork() throws Exception {
                Transaction trans = DatabaseStorage.this.dbenv.beginTransaction(null, null);
                OperationStatus result = DatabaseStorage.this.db.put(trans, DatabaseStorage.this.id2db(id), DatabaseStorage.this.dbSerialize(obj));
                DatabaseStorage.this.metadb.put(trans, DatabaseStorage.this.id2db(id), DatabaseStorage.this.dbSerialize(metadata));
                trans.commit();
                ReverseTreeMap reverseTreeMap = DatabaseStorage.this.meta;
                synchronized (reverseTreeMap) {
                    DatabaseStorage.this.meta.put(id, metadata);
                }
                return result == OperationStatus.SUCCESS;
            }
        });
    }

    public void unstore(final Id id, Continuation c) {
        this.env.getProcessor().processBlockingIO(new WorkRequest(c, this.env.getSelectorManager()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doWork() throws Exception {
                Transaction trans = DatabaseStorage.this.dbenv.beginTransaction(null, null);
                OperationStatus result = DatabaseStorage.this.db.delete(trans, DatabaseStorage.this.id2db(id));
                DatabaseStorage.this.metadb.delete(trans, DatabaseStorage.this.id2db(id));
                trans.commit();
                ReverseTreeMap reverseTreeMap = DatabaseStorage.this.meta;
                synchronized (reverseTreeMap) {
                    DatabaseStorage.this.meta.remove(id);
                }
                return result == OperationStatus.SUCCESS;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(Id id) {
        ReverseTreeMap reverseTreeMap = this.meta;
        synchronized (reverseTreeMap) {
            return this.meta.containsKey(id);
        }
    }

    public void getObject(final Id id, Continuation c) {
        this.env.getProcessor().processBlockingIO(new WorkRequest(c, this.env.getSelectorManager()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doWork() throws Exception {
                Transaction trans = DatabaseStorage.this.dbenv.beginTransaction(null, null);
                DatabaseEntry dbe = new DatabaseEntry();
                OperationStatus result = DatabaseStorage.this.db.get(trans, DatabaseStorage.this.id2db(id), dbe, null);
                trans.commit();
                if (result == OperationStatus.SUCCESS) {
                    return DatabaseStorage.this.dbDeserialize(dbe);
                }
                Transaction tr = DatabaseStorage.this.dbenv.beginTransaction(null, null);
                DatabaseStorage.this.metadb.delete(tr, DatabaseStorage.this.id2db(id));
                tr.commit();
                ReverseTreeMap reverseTreeMap = DatabaseStorage.this.meta;
                synchronized (reverseTreeMap) {
                    DatabaseStorage.this.meta.remove(id);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable getMetadata(Id id) {
        ReverseTreeMap reverseTreeMap = this.meta;
        synchronized (reverseTreeMap) {
            return (Serializable)this.meta.get(id);
        }
    }

    public void setMetadata(final Id id, final Serializable metadata, Continuation c) {
        if (!this.exists(id)) {
            c.receiveResult(new Boolean(false));
            return;
        }
        this.env.getProcessor().processBlockingIO(new WorkRequest(c, this.env.getSelectorManager()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doWork() throws Exception {
                Transaction trans = DatabaseStorage.this.dbenv.beginTransaction(null, null);
                OperationStatus result = DatabaseStorage.this.metadb.put(trans, DatabaseStorage.this.id2db(id), DatabaseStorage.this.dbSerialize(metadata));
                trans.commit();
                ReverseTreeMap reverseTreeMap = DatabaseStorage.this.meta;
                synchronized (reverseTreeMap) {
                    DatabaseStorage.this.meta.put(id, metadata);
                }
                return result == OperationStatus.SUCCESS;
            }
        });
    }

    public void rename(final Id oldId, final Id newId, Continuation c) {
        this.env.getProcessor().processBlockingIO(new WorkRequest(c, this.env.getSelectorManager()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doWork() throws Exception {
                Transaction trans = DatabaseStorage.this.dbenv.beginTransaction(null, null);
                DatabaseEntry dbe = new DatabaseEntry();
                OperationStatus result = DatabaseStorage.this.db.get(trans, DatabaseStorage.this.id2db(oldId), dbe, null);
                if (result != OperationStatus.SUCCESS) {
                    trans.abort();
                    return Boolean.FALSE;
                }
                result = DatabaseStorage.this.db.put(trans, DatabaseStorage.this.id2db(newId), dbe);
                if (result != OperationStatus.SUCCESS) {
                    trans.abort();
                    return Boolean.FALSE;
                }
                dbe = new DatabaseEntry();
                result = DatabaseStorage.this.metadb.get(trans, DatabaseStorage.this.id2db(oldId), dbe, null);
                if (result != OperationStatus.SUCCESS) {
                    trans.abort();
                    return Boolean.FALSE;
                }
                result = DatabaseStorage.this.metadb.put(trans, DatabaseStorage.this.id2db(newId), dbe);
                if (result != OperationStatus.SUCCESS) {
                    trans.abort();
                    return Boolean.FALSE;
                }
                trans.commit();
                ReverseTreeMap reverseTreeMap = DatabaseStorage.this.meta;
                synchronized (reverseTreeMap) {
                    DatabaseStorage.this.meta.put(newId, DatabaseStorage.this.meta.get(oldId));
                    DatabaseStorage.this.meta.remove(oldId);
                }
                return Boolean.TRUE;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdSet scan(IdRange range) {
        if (range.isEmpty()) {
            return this.idf.buildIdSet();
        }
        if (range.getCCWId().equals(range.getCWId())) {
            return this.scan();
        }
        ReverseTreeMap reverseTreeMap = this.meta;
        synchronized (reverseTreeMap) {
            return this.idf.buildIdSet(new ImmutableSortedMap(this.meta.keySubMap(range.getCCWId(), range.getCWId())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdSet scan() {
        ReverseTreeMap reverseTreeMap = this.meta;
        synchronized (reverseTreeMap) {
            return this.idf.buildIdSet(new ImmutableSortedMap(this.meta.keyMap()));
        }
    }

    public SortedMap scanMetadata(IdRange range) {
        if (range.isEmpty()) {
            return new RedBlackMap();
        }
        if (range.getCCWId().equals(range.getCWId())) {
            return this.scanMetadata();
        }
        return new ImmutableSortedMap(this.meta.keySubMap(range.getCCWId(), range.getCWId()));
    }

    public SortedMap scanMetadata() {
        return new ImmutableSortedMap(this.meta.keyMap());
    }

    public SortedMap scanMetadataValuesHead(Object value) {
        return new ImmutableSortedMap(this.meta.valueHeadMap(value));
    }

    public SortedMap scanMetadataValuesNull() {
        return new ImmutableSortedMap(this.meta.valueNullMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        ReverseTreeMap reverseTreeMap = this.meta;
        synchronized (reverseTreeMap) {
            return this.meta.size();
        }
    }

    public long getTotalSize() {
        throw new UnsupportedOperationException("getTotalSize unimplemented for DatabaseStorage");
    }

    public void flush(Continuation c) {
        throw new UnsupportedOperationException("flush unimplemented for DatabaseStorage");
    }

    protected DatabaseEntry id2db(Id id) {
        return new DatabaseEntry(id.toByteArray());
    }

    protected Id db2id(DatabaseEntry dbe) {
        return this.idf.buildId(dbe.getData());
    }

    protected DatabaseEntry dbSerialize(Serializable obj) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLObjectOutputStream objout = new XMLObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(baos)));
            objout.writeObject(obj);
            return new DatabaseEntry(baos.toByteArray());
        }
        catch (IOException e) {
            if (this.logger.level <= 800) {
                this.logger.logException("Problem serializing " + obj + ": ", e);
            }
            throw new RuntimeException("Problem serializing " + obj + ": " + e);
        }
    }

    protected Serializable dbDeserialize(DatabaseEntry dbe) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(dbe.getData());
            XMLObjectInputStream objin = new XMLObjectInputStream(new BufferedInputStream(new GZIPInputStream(bais)));
            return (Serializable)objin.readObject();
        }
        catch (IOException e) {
            if (this.logger.level <= 800) {
                this.logger.logException("Problem deserializing: ", e);
            }
            throw new RuntimeException("Problem deserializing: " + e);
        }
        catch (ClassNotFoundException e) {
            if (this.logger.level <= 800) {
                this.logger.logException("Problem deserializing: ", e);
            }
            throw new RuntimeException("Problem deserializing: " + e);
        }
    }
}

