/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket.nat.sbbi;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Set;
import net.sbbi.upnp.impls.InternetGatewayDevice;
import net.sbbi.upnp.messages.ActionResponse;
import net.sbbi.upnp.messages.UPNPResponseException;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.pastry.socket.nat.NATHandler;

public class SBBINatHandler
implements NATHandler {
    Logger logger;
    Environment environment;
    boolean searchedForFireWall = false;
    InternetGatewayDevice fireWall;
    InetAddress fireWallExternalAddress;
    InetAddress localAddress;
    int findPortTries = 0;
    public static final int MAX_PORT = 65535;

    public SBBINatHandler(Environment env, InetAddress localAddress) {
        this.environment = env;
        this.logger = env.getLogManager().getLogger(SBBINatHandler.class, null);
        this.localAddress = localAddress;
    }

    public synchronized InetAddress findFireWall(InetAddress bindAddress) throws IOException {
        if (this.searchedForFireWall) {
            return this.fireWallExternalAddress;
        }
        this.searchedForFireWall = true;
        int discoveryTimeout = this.environment.getParameters().getInt("nat_discovery_timeout");
        InternetGatewayDevice[] IGDs = InternetGatewayDevice.getDevices((int)discoveryTimeout);
        if (IGDs != null) {
            this.fireWall = IGDs[0];
            try {
                this.fireWallExternalAddress = InetAddress.getByName(this.fireWall.getExternalIPAddress());
            }
            catch (UPNPResponseException ure) {
                if (this.logger.level <= 900) {
                    this.logger.logException("Error:", ure);
                }
                throw new IOException(ure.toString());
            }
        } else {
            throw new IOException("Could not find firewall.  Please enable UPnP on firewall, or set 'find_firewall_policy = never'");
        }
        return this.fireWallExternalAddress;
    }

    public int findAvailableFireWallPort(int internal, int external, int tries, String appName) throws IOException {
        try {
            ++this.findPortTries;
            if (this.findPortTries > tries) {
                throw new IOException("Couldn't find available port on firewall");
            }
            if (this.logger.level <= 500) {
                this.logger.log("findFireWallPort(" + internal + "," + external + ")");
            }
            ActionResponse response = null;
            response = this.fireWall.getSpecificPortMappingEntry(null, external, "TCP");
            if (!this.checkSpecificPortMappingEntryResponse(response, internal, external, "TCP", appName)) {
                return this.findAvailableFireWallPort(internal, external + 1, tries, appName);
            }
            response = this.fireWall.getSpecificPortMappingEntry(null, external, "UDP");
            if (!this.checkSpecificPortMappingEntryResponse(response, internal, external, "UDP", appName)) {
                return this.findAvailableFireWallPort(internal, external + 1, tries, appName);
            }
            return external;
        }
        catch (UPNPResponseException ure) {
            if (this.logger.level <= 900) {
                this.logger.logException("Error:", ure);
            }
            throw new IOException(ure.toString());
        }
    }

    private boolean checkSpecificPortMappingEntryResponse(ActionResponse response, int internal, int external, String type, String app) {
        String newInternalClientString;
        String tempName;
        String appName;
        if (response == null) {
            return true;
        }
        if (this.logger.level <= 300) {
            Set s = response.getOutActionArgumentNames();
            for (String key : s) {
                String val = response.getOutActionArgumentValue(key);
                System.out.println("  " + key + " -> " + val);
            }
        }
        boolean ret = true;
        String internalPortStr = response.getOutActionArgumentValue("NewInternalPort");
        if (internalPortStr != null) {
            try {
                int internalPort = Integer.parseInt(internalPortStr);
                if (internalPort > 65535) {
                    if (this.logger.level < 900) {
                        this.logger.log("Warning, NAT " + this.fireWall.getIGDRootDevice().getModelName() + " returned an invalid value for entry NewInternalPort.  Expected an integer less than " + 65535 + ", got: " + internalPort + ".  Query " + external + ":" + type + "... overwriting entry.");
                    }
                    return true;
                }
                if (internalPort != internal) {
                    if (this.logger.level <= 400) {
                        this.logger.log("internalPort(" + internalPort + ") != internal(" + internal + ")");
                    }
                    ret = false;
                }
            }
            catch (NumberFormatException nfe) {
                if (this.logger.level < 900) {
                    this.logger.log("Warning, NAT " + this.fireWall.getIGDRootDevice().getModelName() + " returned an invalid value for entry NewInternalPort.  Expected an integer, got: " + internalPortStr + ".  Query " + external + ":" + type + "... overwriting entry.");
                }
                return true;
            }
        }
        if ((appName = response.getOutActionArgumentValue("NewPortMappingDescription")) != null && !(tempName = appName.replaceAll(" ", "")).equals("") && !appName.equalsIgnoreCase(app)) {
            if (this.logger.level <= 400) {
                this.logger.log("appName(" + appName + ") != app(" + app + ")");
            }
            ret = false;
        }
        if ((newInternalClientString = response.getOutActionArgumentValue("NewInternalClient")) == null) {
            if (this.logger.level < 900) {
                this.logger.log("Warning, NAT " + this.fireWall.getIGDRootDevice().getModelName() + " returned no value for entry NewInternalClient.  Expected an IP address, got: " + newInternalClientString + ".  Query " + external + ":" + type + "... overwriting entry.");
            }
            return true;
        }
        try {
            InetAddress client = InetAddress.getByName(newInternalClientString);
            if (!client.equals(this.localAddress)) {
                if (this.logger.level <= 400) {
                    this.logger.log("client(" + client + ") != localAddress(" + this.localAddress + ")");
                }
                ret = false;
            }
        }
        catch (Exception e) {
            if (this.logger.level < 900) {
                this.logger.log("Warning, NAT " + this.fireWall.getIGDRootDevice().getModelName() + " returned an invalid value for entry NewInternalClient.  Expected an IP address, got: " + newInternalClientString + ".  Query " + external + ":" + type + "... overwriting entry.");
            }
            return true;
        }
        String enabledString = response.getOutActionArgumentValue("NewEnabled");
        if (enabledString != null) {
            try {
                int enabled = Integer.parseInt(enabledString);
                if (enabled == 0) {
                    if (this.logger.level < 500) {
                        this.logger.log("Warning, NAT " + this.fireWall.getIGDRootDevice().getModelName() + " had an existing rule that was disabled, implicitly overwriting.  " + "Query " + external + ":" + type + "." + "\n  NewInternalPort -> " + internalPortStr + "\n  NewPortMappingDescription -> " + appName + "\n  NewInternalClient -> " + newInternalClientString + "\n  NewEnabled -> " + enabledString);
                    }
                    return true;
                }
                if (enabled != 1) {
                    if (this.logger.level < 900) {
                        this.logger.log("Warning, NAT " + this.fireWall.getIGDRootDevice().getModelName() + " returned an invalid value for entry NewEnabled.  Expected 0 or 1, got: " + enabled + ".  Query " + external + ":" + type + "... overwriting entry.");
                    }
                    return true;
                }
            }
            catch (NumberFormatException nfe) {
                if (this.logger.level < 900) {
                    this.logger.log("Warning, NAT " + this.fireWall.getIGDRootDevice().getModelName() + " returned an invalid value for entry NewEnabled.  Expected 0 or 1, got: " + enabledString + ".  Query " + external + ":" + type + "... overwriting entry.");
                }
                return true;
            }
        }
        if (!ret && this.logger.level < 800) {
            this.logger.log("Warning, NAT " + this.fireWall.getIGDRootDevice().getModelName() + " had an existing rule, trying different port.  " + "Query " + external + ":" + type + "." + "\n  NewInternalPort -> " + internalPortStr + "\n  NewPortMappingDescription -> " + appName + "\n  NewInternalClient -> " + newInternalClientString + "\n  NewEnabled -> " + enabledString);
        }
        return ret;
    }

    public void openFireWallPort(int local, int external, String appName) throws IOException {
        try {
            boolean mapped = true;
            mapped = this.fireWall.addPortMapping(appName, null, local, external, this.localAddress.getHostAddress(), 0, "TCP");
            if (!mapped) {
                throw new IOException("Could not set firewall TCP port forwarding from external:" + this.fireWallExternalAddress + ":" + external + " -> local:" + this.localAddress + ":" + local);
            }
            mapped = this.fireWall.addPortMapping(appName, null, local, external, this.localAddress.getHostAddress(), 0, "UDP");
            if (!mapped) {
                throw new IOException("Could not set firewall UDP port forwarding from external:" + this.fireWallExternalAddress + ":" + external + " -> local:" + this.localAddress + ":" + local);
            }
        }
        catch (UPNPResponseException ure) {
            if (this.logger.level <= 900) {
                this.logger.logException("Error:", ure);
            }
            throw new IOException(ure.toString());
        }
    }

    public InetAddress getFireWallExternalAddress() {
        return this.fireWallExternalAddress;
    }
}

