/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket.appsocket.testing;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Vector;
import rice.environment.Environment;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.commonapi.PastryIdFactory;
import rice.pastry.socket.SocketPastryNodeFactory;
import rice.pastry.socket.appsocket.BlockingAppSocketFactory;
import rice.pastry.socket.appsocket.testing.Echo;
import rice.pastry.standard.RandomNodeIdFactory;

public class Tutorial {
    Vector apps = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tutorial(int bindport, InetSocketAddress bootaddress, Environment env) throws Exception {
        PastryNode node;
        RandomNodeIdFactory nidFactory = new RandomNodeIdFactory(env);
        SocketPastryNodeFactory factory = new SocketPastryNodeFactory(nidFactory, bindport, env);
        PastryIdFactory idFactory = new PastryIdFactory(env);
        NodeHandle bootHandle = null;
        PastryNode pastryNode = node = ((PastryNodeFactory)factory).newNode(bootHandle);
        synchronized (pastryNode) {
            while (!node.isReady() && !node.joinFailed()) {
                node.wait(500L);
                if (!node.joinFailed()) continue;
                throw new IOException("Could not join the FreePastry ring.  Reason:" + node.joinFailedReason());
            }
        }
        System.out.println("Finished creating new node " + node);
        Echo app = new Echo(node, idFactory);
        this.apps.add(app);
    }

    public static void main(String[] args) throws Exception {
        Environment env = new Environment();
        env.getParameters().setString("nat_search_policy", "never");
        int bindport = 9876;
        InetSocketAddress bootaddress = null;
        if (args.length > 0) {
            bindport = Integer.parseInt(args[0]);
        }
        InetAddress bootaddr = InetAddress.getLocalHost();
        int bootport = bindport;
        bootaddress = new InetSocketAddress(bootaddr, bootport);
        new Tutorial(bindport, bootaddress, env);
        BlockingAppSocketFactory asf = new BlockingAppSocketFactory();
        SocketChannel sc = asf.connect(bootaddress, -1050614594);
        sc.write(ByteBuffer.wrap("foo".getBytes()));
        System.out.println("Connected");
        try {
            asf.connect(bootaddress, 123);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        try {
            InetSocketAddress bogus = new InetSocketAddress("123.45.6.78", 56);
            asf.connect(bogus, 123);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

