/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket.appsocket.testing;

import java.io.IOException;
import java.nio.ByteBuffer;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.commonapi.appsocket.AppSocket;
import rice.p2p.commonapi.appsocket.AppSocketReceiver;
import rice.pastry.commonapi.PastryEndpoint;

public class Echo
implements Application {
    protected Endpoint endpoint;
    protected Node node;
    ByteBuffer[] outs;
    ByteBuffer out;
    ByteBuffer[] ins;
    ByteBuffer in;
    int MSG_LENGTH;

    public Echo(Node node, final IdFactory factory) {
        this.endpoint = node.buildEndpoint(this, "myinstance");
        PastryEndpoint pe = (PastryEndpoint)this.endpoint;
        System.out.println("My App Id is:" + pe.getAppId());
        this.node = node;
        this.MSG_LENGTH = node.getLocalNodeHandle().getId().toByteArray().length;
        this.outs = new ByteBuffer[1];
        this.outs[0] = this.out = ByteBuffer.wrap(node.getLocalNodeHandle().getId().toByteArray());
        this.ins = new ByteBuffer[1];
        this.ins[0] = this.in = ByteBuffer.allocate(this.MSG_LENGTH);
        this.endpoint.accept(new AppSocketReceiver(){

            public void receiveSocket(AppSocket socket) {
                socket.register(true, false, 30000, this);
                Echo.this.endpoint.accept(this);
            }

            public void receiveSelectResult(AppSocket socket, boolean canRead, boolean canWrite) {
                Echo.this.in.clear();
                try {
                    long ret = socket.read(Echo.this.ins, 0, Echo.this.ins.length);
                    if (ret != (long)Echo.this.MSG_LENGTH) {
                        System.out.println("Error, we only received part of a message." + ret + " from " + socket);
                        return;
                    }
                    System.out.println(Echo.this.node.getLocalNodeHandle() + " Received message from " + factory.buildId(Echo.this.in.array()));
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }

            public void receiveException(AppSocket socket, Exception e) {
                e.printStackTrace();
            }
        });
        this.endpoint.register();
    }

    public Node getNode() {
        return this.node;
    }

    public void sendMyMsgDirect(NodeHandle nh) {
        System.out.println(this + " opening to " + nh);
        this.endpoint.connect(nh, new AppSocketReceiver(){

            public void receiveSocket(AppSocket socket) {
                socket.register(false, true, 30000, this);
            }

            public void receiveException(AppSocket socket, Exception e) {
                e.printStackTrace();
            }

            public void receiveSelectResult(AppSocket socket, boolean canRead, boolean canWrite) {
                try {
                    socket.write(Echo.this.outs, 0, Echo.this.outs.length);
                    if (!Echo.this.out.hasRemaining()) {
                        socket.close();
                        Echo.this.out.clear();
                    } else {
                        socket.register(false, true, 30000, this);
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }, 30000);
    }

    public void deliver(Id id, Message message) {
        System.out.println(this + " received " + message);
    }

    public void update(NodeHandle handle, boolean joined) {
    }

    public boolean forward(RouteMessage message) {
        return true;
    }

    public String toString() {
        return "MyApp " + this.endpoint.getId();
    }
}

