/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket.appsocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import rice.p2p.commonapi.exception.AppNotRegisteredException;
import rice.p2p.commonapi.exception.AppSocketException;
import rice.p2p.commonapi.exception.NoReceiverAvailableException;
import rice.p2p.util.MathUtils;
import rice.pastry.socket.SocketCollectionManager;

public class BlockingAppSocketFactory {
    public static final byte[] magic_version_direct;
    private int SOCKET_BUFFER_SIZE = 32768;

    public SocketChannel connect(InetSocketAddress addr, int appId) throws IOException, AppSocketException {
        SocketChannel channel = SocketChannel.open();
        channel.socket().setSendBufferSize(this.SOCKET_BUFFER_SIZE);
        channel.socket().setReceiveBufferSize(this.SOCKET_BUFFER_SIZE);
        channel.connect(addr);
        ByteBuffer[] bb = new ByteBuffer[]{ByteBuffer.wrap(magic_version_direct), ByteBuffer.wrap(MathUtils.intToByteArray(appId))};
        channel.write(bb);
        ByteBuffer answer = ByteBuffer.allocate(1);
        channel.read(answer);
        answer.clear();
        byte connectResult = answer.get();
        switch (connectResult) {
            case 0: {
                break;
            }
            case 1: {
                throw new AppNotRegisteredException(appId);
            }
            case 2: {
                throw new NoReceiverAvailableException();
            }
            default: {
                throw new AppSocketException("Unknown error " + connectResult);
            }
        }
        return channel;
    }

    static {
        int mvdLength = SocketCollectionManager.PASTRY_MAGIC_NUMBER.length + 4 + SocketCollectionManager.HEADER_DIRECT.length;
        magic_version_direct = new byte[mvdLength];
        System.arraycopy(SocketCollectionManager.PASTRY_MAGIC_NUMBER, 0, magic_version_direct, 0, SocketCollectionManager.PASTRY_MAGIC_NUMBER.length);
        System.arraycopy(SocketCollectionManager.HEADER_DIRECT, 0, magic_version_direct, 8, SocketCollectionManager.HEADER_DIRECT.length);
    }
}

