/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import rice.environment.logging.Logger;
import rice.pastry.socket.EpochInetSocketAddress;
import rice.pastry.socket.SocketNodeHandle;
import rice.pastry.socket.SocketPastryNode;
import rice.pastry.socket.SocketSourceRouteManager;
import rice.pastry.socket.SourceRoute;
import rice.pastry.socket.WeakHashSet;
import rice.selector.Timer;
import rice.selector.TimerTask;

public class TimerWeakHashSet
implements WeakHashSet {
    static ReferenceQueue queue = new ReferenceQueue();
    SocketPastryNode spn;
    HashMap<EpochInetSocketAddress, SNHWeakReference> hashMap;
    Logger logger;
    int defaultDelay;
    Timer timer;

    public TimerWeakHashSet(int timeout, SocketPastryNode spn) {
        this.timer = spn.getEnvironment().getSelectorManager().getTimer();
        this.defaultDelay = timeout;
        this.spn = spn;
        this.hashMap = new HashMap();
        this.logger = spn.getEnvironment().getLogManager().getLogger(this.getClass(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketNodeHandle coalesce(SocketNodeHandle snh) {
        SocketNodeHandle ret = null;
        HashMap<EpochInetSocketAddress, SNHWeakReference> hashMap = this.hashMap;
        synchronized (hashMap) {
            SNHWeakReference wr = this.hashMap.get(snh.eaddress);
            if (wr != null) {
                ret = wr.getSNH();
            }
            if (ret == null) {
                ret = snh;
                this.hashMap.put(snh.eaddress, new SNHWeakReference(snh));
                snh.setLocalNode(this.spn);
                this.refresh(snh);
            } else if (ret.getNodeId() == null) {
                ret.setNodeId(snh.getNodeId());
            }
        }
        return ret;
    }

    public void refresh(Object key) {
        this.refresh(key, this.defaultDelay);
    }

    public void refresh(Object key, int delay) {
        this.timer.schedule(new HardLinkTimerTask(key), delay);
    }

    public SocketNodeHandle get(EpochInetSocketAddress eisa) {
        SNHWeakReference wr = this.hashMap.get(eisa);
        if (wr == null) {
            return null;
        }
        return wr.getSNH();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getBest() {
        HashMap<EpochInetSocketAddress, SourceRoute> result = new HashMap<EpochInetSocketAddress, SourceRoute>();
        HashMap<EpochInetSocketAddress, SNHWeakReference> hashMap = this.hashMap;
        synchronized (hashMap) {
            for (EpochInetSocketAddress addr : this.hashMap.keySet()) {
                SocketSourceRouteManager.AddressManager am;
                SocketNodeHandle snh;
                SNHWeakReference wr = this.hashMap.get(addr);
                if (wr == null || (snh = wr.getSNH()) == null || (am = snh.addressManager) == null || am.getLiveness() >= 3) continue;
                result.put(addr, am.best);
            }
        }
        return result;
    }

    static {
        Thread expunger = new Thread(new Runnable(){

            public void run() {
                try {
                    while (true) {
                        SNHWeakReference wr = (SNHWeakReference)queue.remove();
                        wr.expunge();
                    }
                }
                catch (InterruptedException ie) {
                    System.out.println("Warning, shutting down TimerWeakHashSet!!!");
                    ie.printStackTrace();
                    return;
                }
            }
        }, "TimerWeakHashSetExpunger");
        expunger.setDaemon(true);
        expunger.start();
    }

    public static class HardLinkTimerTask
    extends TimerTask {
        Object hardLink;

        public HardLinkTimerTask(Object hardLink) {
            this.hardLink = hardLink;
        }

        public void run() {
        }
    }

    private class SNHWeakReference
    extends WeakReference {
        EpochInetSocketAddress eaddress;

        public SNHWeakReference(SocketNodeHandle referent) {
            super(referent, queue);
            this.eaddress = referent.eaddress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void expunge() {
            HashMap<EpochInetSocketAddress, SNHWeakReference> hashMap = TimerWeakHashSet.this.hashMap;
            synchronized (hashMap) {
                SNHWeakReference that = TimerWeakHashSet.this.hashMap.remove(this.eaddress);
                if (that != null && that != this && that.getSNH() != null) {
                    TimerWeakHashSet.this.hashMap.put(that.eaddress, that);
                }
            }
        }

        public int hashCode() {
            return this.eaddress.hashCode();
        }

        public boolean equals(Object o) {
            EpochInetSocketAddress eisa = o instanceof SocketNodeHandle ? ((SocketNodeHandle)o).eaddress : (EpochInetSocketAddress)o;
            return this.eaddress.equals(eisa);
        }

        public SocketNodeHandle getSNH() {
            return (SocketNodeHandle)this.get();
        }
    }
}

