/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import rice.environment.logging.Logger;
import rice.environment.params.Parameters;
import rice.environment.random.RandomSource;
import rice.environment.time.TimeSource;
import rice.p2p.commonapi.appsocket.AppSocketReceiver;
import rice.p2p.commonapi.exception.NodeIsDeadException;
import rice.p2p.util.TimerWeakHashMap;
import rice.pastry.NodeHandleFactory;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.PJavaSerializedMessage;
import rice.pastry.messaging.PRawMessage;
import rice.pastry.routing.RouteMessage;
import rice.pastry.socket.EpochInetSocketAddress;
import rice.pastry.socket.PendingAppSocket;
import rice.pastry.socket.SocketBuffer;
import rice.pastry.socket.SocketCollectionManager;
import rice.pastry.socket.SocketNodeHandle;
import rice.pastry.socket.SocketPastryNode;
import rice.pastry.socket.SourceRoute;
import rice.pastry.socket.TimerWeakHashSet;

public class SocketSourceRouteManager {
    public long CHECK_DEAD_THROTTLE;
    public long PING_THROTTLE;
    public int NUM_SOURCE_ROUTE_ATTEMPTS;
    public int PROX_TIMEOUT;
    public int DEFAULT_RTO;
    int RTO_UBOUND;
    int RTO_LBOUND;
    double gainH;
    double gainG;
    private SocketPastryNode spn;
    private TimeSource time;
    private SocketCollectionManager manager;
    private EpochInetSocketAddress localAddress;
    private Logger logger;
    HashSet hardLinks = new HashSet();
    TimerWeakHashSet nodeHandles;

    protected SocketSourceRouteManager(SocketPastryNode node, EpochInetSocketAddress bindAddress, EpochInetSocketAddress proxyAddress, RandomSource random) throws IOException {
        this.spn = node;
        this.time = this.spn.getEnvironment().getTimeSource();
        Parameters p = node.getEnvironment().getParameters();
        this.CHECK_DEAD_THROTTLE = p.getLong("pastry_socket_srm_check_dead_throttle");
        this.PING_THROTTLE = p.getLong("pastry_socket_srm_ping_throttle");
        this.NUM_SOURCE_ROUTE_ATTEMPTS = p.getInt("pastry_socket_srm_num_source_route_attempts");
        this.PROX_TIMEOUT = p.getInt("pastry_socket_srm_proximity_timeout");
        this.DEFAULT_RTO = p.getInt("pastry_socket_srm_default_rto");
        this.RTO_UBOUND = p.getInt("pastry_socket_srm_rto_ubound");
        this.RTO_LBOUND = p.getInt("pastry_socket_srm_rto_lbound");
        this.gainH = p.getDouble("pastry_socket_srm_gain_h");
        this.gainG = p.getDouble("pastry_socket_srm_gain_g");
        this.nodeHandles = new TimerWeakHashSet(30000, this.spn);
        this.logger = node.getEnvironment().getLogManager().getLogger(SocketSourceRouteManager.class, null);
        this.manager = new SocketCollectionManager(node, this, bindAddress, proxyAddress, random);
        this.localAddress = bindAddress;
    }

    public HashMap getBest() {
        return this.nodeHandles.getBest();
    }

    public void destroy() throws IOException {
        if (this.spn.getEnvironment().getSelectorManager().isSelectorThread()) {
            this.manager.destroy();
        } else {
            this.spn.getEnvironment().getSelectorManager().invoke(new Runnable(){

                public void run() {
                    block2: {
                        try {
                            SocketSourceRouteManager.this.destroy();
                        }
                        catch (IOException ioe) {
                            if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level > 900) break block2;
                            SocketSourceRouteManager.this.logger.logException("Exception while destrying SocketSourceRouteManager", ioe);
                        }
                    }
                }
            });
        }
    }

    public SocketCollectionManager getManager() {
        return this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AddressManager getAddressManager(EpochInetSocketAddress address, boolean search) {
        TimerWeakHashSet timerWeakHashSet = this.nodeHandles;
        synchronized (timerWeakHashSet) {
            AddressManager manager = this.getAddressManager(address);
            if (manager == null) {
                manager = this.putAddressManager(address, search);
            }
            return manager;
        }
    }

    public SocketNodeHandle coalesce(SocketNodeHandle newHandle) {
        return this.nodeHandles.coalesce(newHandle);
    }

    public SocketNodeHandle getNodeHandle(EpochInetSocketAddress address) {
        SocketNodeHandle ret = this.nodeHandles.get(address);
        if (ret == null || ret.getNodeId() == null) {
            return null;
        }
        return ret;
    }

    public AddressManager getAddressManager(EpochInetSocketAddress address) {
        SocketNodeHandle snh = this.nodeHandles.get(address);
        if (snh == null) {
            return null;
        }
        return snh.addressManager;
    }

    public AddressManager putAddressManager(EpochInetSocketAddress address, boolean search) {
        SocketNodeHandle snh = this.nodeHandles.get(address);
        if (snh == null) {
            snh = this.nodeHandles.coalesce(new SocketNodeHandle(address, null));
        }
        if (snh.addressManager != null) {
            throw new IllegalStateException("Address manager for address " + address + " already exists.");
        }
        AddressManager manager = new AddressManager(snh, search);
        this.spn.getEnvironment().getSelectorManager().getTimer().schedule(new TimerWeakHashMap.HardLinkTimerTask(manager), 30000L);
        snh.addressManager = manager;
        return manager;
    }

    public void bootstrap(EpochInetSocketAddress address, Message msg) throws IOException {
        this.manager.bootstrap(SourceRoute.build(address), msg);
    }

    public void send(EpochInetSocketAddress address, Message msg) throws IOException {
        PRawMessage rm = msg instanceof PRawMessage ? (PRawMessage)msg : new PJavaSerializedMessage(msg);
        SocketBuffer buffer = new SocketBuffer(this.manager.defaultDeserializer, (NodeHandleFactory)this.manager.pastryNode);
        buffer.serialize(rm, true);
        this.send(address, buffer);
    }

    public void send(final EpochInetSocketAddress address, final SocketBuffer message) {
        if (this.spn.getEnvironment().getSelectorManager().isSelectorThread()) {
            this.getAddressManager(address, true).send(message);
        } else {
            if (this.logger.level <= 500) {
                this.logger.log("Application attempted to send " + message + " to " + address + " on a non-selector thread.");
            }
            this.spn.getEnvironment().getSelectorManager().invoke(new Runnable(){

                public void run() {
                    SocketSourceRouteManager.this.getAddressManager(address, true).send(message);
                }
            });
        }
    }

    public void connect(final EpochInetSocketAddress address, final int appAddress, final AppSocketReceiver receiver, final int timeout) {
        if (this.spn.getEnvironment().getSelectorManager().isSelectorThread()) {
            this.getAddressManager(address, true).connect(appAddress, receiver, timeout);
        } else {
            if (this.logger.level <= 500) {
                this.logger.log("Application " + appAddress + " attempted to open a connection to " + address + " on a non-selector thread.");
            }
            this.spn.getEnvironment().getSelectorManager().invoke(new Runnable(){

                public void run() {
                    SocketSourceRouteManager.this.getAddressManager(address, true).connect(appAddress, receiver, timeout);
                }
            });
        }
    }

    public void ping(EpochInetSocketAddress address) {
        AddressManager am = this.getAddressManager(address);
        if (am == null) {
            this.manager.ping(SourceRoute.build(address));
        } else {
            am.ping();
        }
    }

    public void checkLiveness(EpochInetSocketAddress address) {
        this.getAddressManager(address, true).checkLiveness();
    }

    public int proximity(EpochInetSocketAddress address) {
        AddressManager am = this.getAddressManager(address);
        if (am == null) {
            return 3600000;
        }
        return am.proximity();
    }

    public int getLiveness(EpochInetSocketAddress address) {
        return this.getAddressManager(address, true).getLiveness();
    }

    protected void markDead(SourceRoute route) {
        AddressManager am;
        if (this.logger.level <= 500) {
            this.logger.log("(SSRM) Found route " + route + " to be dead");
        }
        if ((am = this.getAddressManager(route.getLastHop())) != null) {
            am.markDead(route);
        }
    }

    protected void markDead(EpochInetSocketAddress address) {
        AddressManager am = this.getAddressManager(address);
        if (am != null) {
            am.markDeadForever();
        }
    }

    protected void markAlive(SourceRoute route) {
        if (this.logger.level <= 500) {
            this.logger.log("(SSRM) Found route " + route + " to be alive");
        }
        this.getAddressManager(route.getLastHop(), false).markAlive(route);
    }

    protected int proximity(SourceRoute route) {
        return this.getAddressManager(route.getLastHop(), false).proximity();
    }

    protected int rto(SourceRoute route) {
        return this.getAddressManager(route.getLastHop(), false).rto();
    }

    protected void markSuspected(SourceRoute route) {
        if (this.logger.level <= 500) {
            this.logger.log("(SSRM) Found route " + route + " to be suspected");
        }
        this.getAddressManager(route.getLastHop(), false).markSuspected(route);
    }

    protected synchronized void markProximity(SourceRoute route, int proximity) {
        this.getAddressManager(route.getLastHop(), false).markProximity(route, proximity);
    }

    protected void reroute(EpochInetSocketAddress address, SocketBuffer m) {
        if (m.discard) {
            if (this.logger.level <= 500) {
                this.logger.log("(SSRM) Dropping garbage in resend message " + m + " address " + address + " " + this.getNodeHandle(address) + " with liveness " + this.getLiveness(address));
            }
            return;
        }
        switch (this.getLiveness(address)) {
            case 1: {
                if (this.logger.level <= 800) {
                    this.logger.log("(SSRM) Attempting to resend message " + m + " to alive address " + address + " " + this.getNodeHandle(address));
                }
                this.send(address, m);
                return;
            }
            case 2: {
                if (m.isRouteMessage()) {
                    if (m.getOptions().multipleHopsAllowed() && m.getOptions().rerouteIfSuspected()) {
                        if (this.logger.level <= 800) {
                            this.logger.log("(SSRM) Attempting to reroute route message " + m + " because suspected address " + address + " " + this.getNodeHandle(address));
                        }
                        RouteMessage rm = m.getRouteMessage();
                        rm.nextHop = null;
                        this.spn.receiveMessage(rm);
                        return;
                    }
                } else {
                    if (this.logger.level <= 800) {
                        this.logger.log("(SSRM) Attempting to resend message " + m + " to alive address " + address + " " + this.getNodeHandle(address));
                    }
                    this.send(address, m);
                    return;
                }
            }
            case 3: 
            case 4: {
                if (!m.isRouteMessage() || !m.getOptions().multipleHopsAllowed()) break;
                if (this.logger.level <= 800) {
                    this.logger.log("(SSRM) Attempting to reroute route message " + m + " because dead address " + address + " " + this.getNodeHandle(address));
                }
                RouteMessage rm = m.getRouteMessage();
                rm.nextHop = null;
                this.spn.receiveMessage(rm);
                return;
            }
        }
        if (this.logger.level <= 800) {
            this.logger.log("(SSRM) Dropping message " + m + " because next hop " + address + " " + this.getNodeHandle(address) + " is dead!");
        }
    }

    protected SourceRoute[] getAllRoutes(EpochInetSocketAddress destination) {
        Vector result = new Vector(this.NUM_SOURCE_ROUTE_ATTEMPTS);
        this.walkLeafSet(destination, this.NUM_SOURCE_ROUTE_ATTEMPTS, result);
        LinkedList ll = new LinkedList();
        while (result.size() > 0) {
            ll.add(result.remove(this.spn.getEnvironment().getRandomSource().nextInt(result.size())));
        }
        ll.addFirst(SourceRoute.build(destination));
        if (this.logger.level <= 400) {
            String s = "";
            Iterator i = ll.iterator();
            while (i.hasNext()) {
                s = s + " " + i.next();
            }
            this.logger.log("getAllRoutes(" + destination + "):" + ll.size() + "," + this.spn.getLeafSet().getUniqueCount() + "/" + this.NUM_SOURCE_ROUTE_ATTEMPTS + s);
        } else if (this.logger.level <= 500) {
            this.logger.log("getAllRoutes(" + destination + "):" + ll.size() + "," + this.spn.getLeafSet().getUniqueCount() + "/" + this.NUM_SOURCE_ROUTE_ATTEMPTS);
        }
        return ll.toArray(new SourceRoute[0]);
    }

    private Collection walkLeafSet(EpochInetSocketAddress destination, int numRequested, Collection result) {
        LeafSet leafset = this.spn.getLeafSet();
        for (int i = 1; i < leafset.maxSize() / 2; ++i) {
            SocketNodeHandle snh = (SocketNodeHandle)leafset.get(-i);
            if (this.addMember(snh, destination, result) && --numRequested == 0) {
                return result;
            }
            snh = (SocketNodeHandle)leafset.get(i);
            if (!this.addMember(snh, destination, result) || --numRequested != 0) continue;
            return result;
        }
        return result;
    }

    private boolean addMember(SocketNodeHandle handle, EpochInetSocketAddress destination, Collection result) {
        if (!(handle == null || handle.isLocal() || handle.getEpochAddress().equals(destination) || this.getBestRoute(handle.getEpochAddress()) == null || this.getBestRoute(handle.getEpochAddress()).goesThrough(destination))) {
            result.add(this.getBestRoute(handle.getEpochAddress()).append(destination));
            return true;
        }
        return false;
    }

    protected SourceRoute getBestRoute(EpochInetSocketAddress address) {
        AddressManager am = this.getAddressManager(address);
        if (am == null || am.getLiveness() == 3 || am.getLiveness() == 4) {
            return null;
        }
        return am.best;
    }

    protected class AddressManager {
        protected SocketNodeHandle address;
        protected SourceRoute best;
        protected LinkedList queue;
        protected LinkedList pendingAppSockets;
        protected HashMap routes;
        protected int liveness;
        protected long updated;

        public AddressManager(SocketNodeHandle address, boolean search) {
            this.address = address;
            this.queue = new LinkedList();
            this.pendingAppSockets = new LinkedList();
            this.routes = new HashMap();
            this.liveness = 2;
            this.updated = 0L;
            if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level <= 500) {
                SocketSourceRouteManager.this.logger.log("(SSRM) ADDRESS MANAGER CREATED AT " + SocketSourceRouteManager.this.localAddress + " FOR " + address);
            }
            if (search) {
                this.getRouteManager(SourceRoute.build(address.eaddress)).checkLiveness();
                this.updated = SocketSourceRouteManager.this.spn.getEnvironment().getTimeSource().currentTimeMillis();
            }
            if (address.getNodeId() != null && address.isLocal()) {
                this.best = SourceRoute.build(address.eaddress);
            }
        }

        protected SourceRouteManager getRouteManager(SourceRoute route) {
            if (route == null) {
                throw new IllegalArgumentException("route is null in " + this.toString());
            }
            SourceRouteManager result = (SourceRouteManager)this.routes.get(route);
            if (result == null) {
                result = new SourceRouteManager(route);
                this.routes.put(route, result);
            }
            return result;
        }

        public int proximity() {
            if (this.best == null) {
                return 3600000;
            }
            return this.getRouteManager(this.best).proximity();
        }

        public int rto() {
            if (this.best == null) {
                return SocketSourceRouteManager.this.DEFAULT_RTO;
            }
            return this.getRouteManager(this.best).rto();
        }

        public int getLiveness() {
            return this.liveness;
        }

        protected synchronized void markAlive(SourceRoute route) {
            this.getRouteManager(route).markAlive();
            if (this.best == null) {
                if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level <= 500) {
                    SocketSourceRouteManager.this.logger.log("(SSRM) No previous best route existed to " + this.address + " route " + route + " is now the best");
                }
                this.best = route;
            }
            if (this.best.getNumHops() > route.getNumHops() || this.best.getNumHops() == route.getNumHops() && this.getRouteManager(this.best).proximity() > this.getRouteManager(route).proximity()) {
                if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level <= 500) {
                    SocketSourceRouteManager.this.logger.log("(SSRM) Route " + route + " is better than previous best route " + this.best + " - replacing");
                }
                this.best = route;
                if (this.address != null) {
                    this.address.update(SocketNodeHandle.PROXIMITY_CHANGED);
                }
            }
            this.setAlive();
        }

        protected synchronized void markSuspected(SourceRoute route) {
            this.getRouteManager(route).markSuspected();
            if ((this.best == null || this.best.equals(route)) && this.liveness < 3) {
                this.setSuspected();
            }
        }

        protected synchronized void markDead(SourceRoute route) {
            this.getRouteManager(route).markDead();
            if (this.liveness >= 3) {
                return;
            }
            if (this.best == null || route.equals(this.best)) {
                this.best = null;
                SourceRoute[] routes = SocketSourceRouteManager.this.getAllRoutes(route.getLastHop());
                boolean found = false;
                for (int i = 0; i < routes.length; ++i) {
                    if (!this.getRouteManager(routes[i]).checkLiveness()) continue;
                    found = true;
                }
                if (!found) {
                    this.setDead();
                }
            }
        }

        protected synchronized void markDeadForever() {
            this.best = null;
            this.setDeadForever();
        }

        protected synchronized void markProximity(SourceRoute route, int proximity) {
            this.getRouteManager(route).markAlive();
            this.getRouteManager(route).markProximity(proximity);
            if (this.best == null) {
                if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level <= 500) {
                    SocketSourceRouteManager.this.logger.log("(SSRM) No previous best route existed to " + this.address + " route " + route + " is now the best");
                }
                this.best = route;
            }
            this.setAlive();
            if (route.equals(this.best) && this.address != null) {
                this.address.update(SocketNodeHandle.PROXIMITY_CHANGED);
            }
        }

        public synchronized void send(SocketBuffer message) {
            if (this.liveness == 3) {
                this.getRouteManager(SourceRoute.build(this.address.eaddress)).checkLiveness();
                this.updated = SocketSourceRouteManager.this.spn.getEnvironment().getTimeSource().currentTimeMillis();
            }
            if (this.best == null) {
                this.queue.addLast(message);
                SocketSourceRouteManager.this.hardLinks.add(this);
            } else if (!this.getRouteManager(this.best).isOpen()) {
                this.queue.addLast(message);
                SocketSourceRouteManager.this.hardLinks.add(this);
                this.getRouteManager(this.best).checkLiveness();
                this.best = null;
                this.updated = SocketSourceRouteManager.this.spn.getEnvironment().getTimeSource().currentTimeMillis();
            } else {
                this.getRouteManager(this.best).send(message);
            }
        }

        public synchronized void connect(int appAddress, AppSocketReceiver receiver, int timeout) {
            if (this.liveness == 3) {
                this.getRouteManager(SourceRoute.build(this.address.eaddress)).checkLiveness();
                this.updated = SocketSourceRouteManager.this.spn.getEnvironment().getTimeSource().currentTimeMillis();
            }
            if (this.best == null) {
                this.pendingAppSockets.addLast(new PendingAppSocket(appAddress, receiver));
                SocketSourceRouteManager.this.hardLinks.add(this);
            } else {
                this.getRouteManager(this.best).connect(appAddress, receiver, timeout);
            }
        }

        public void ping() {
            if (SocketSourceRouteManager.this.spn.getEnvironment().getTimeSource().currentTimeMillis() - this.updated > SocketSourceRouteManager.this.PING_THROTTLE) {
                this.updated = SocketSourceRouteManager.this.spn.getEnvironment().getTimeSource().currentTimeMillis();
                switch (this.liveness) {
                    case 4: {
                        return;
                    }
                    case 3: {
                        if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level <= 500) {
                            SocketSourceRouteManager.this.logger.log("(SSRM) PING: PINGING DEAD ADDRESS " + this.address + " - JUST IN CASE, NO HARM ANYWAY");
                        }
                        this.getRouteManager(SourceRoute.build(this.address.eaddress)).ping();
                        break;
                    }
                    default: {
                        if (this.best == null) break;
                        this.getRouteManager(this.best).ping();
                        if (this.best.isDirect()) break;
                        this.getRouteManager(SourceRoute.build(this.address.eaddress)).ping();
                    }
                }
            }
        }

        public void checkLiveness() {
            this.updated = SocketSourceRouteManager.this.spn.getEnvironment().getTimeSource().currentTimeMillis();
            switch (this.liveness) {
                case 4: {
                    return;
                }
                case 3: {
                    if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level <= 500) {
                        SocketSourceRouteManager.this.logger.log("(SSRM) CHECKLIVENESS: CHECKING DEAD ON DEAD ADDRESS " + this.address + " - JUST IN CASE, NO HARM ANYWAY");
                    }
                    this.getRouteManager(SourceRoute.build(this.address.eaddress)).checkLiveness();
                    break;
                }
                default: {
                    if (this.best == null) break;
                    this.getRouteManager(this.best).checkLiveness();
                    if (this.best.isDirect()) break;
                    this.getRouteManager(SourceRoute.build(this.address.eaddress)).checkLiveness();
                }
            }
        }

        protected void setAlive() {
            if (this.best == null) {
                throw new IllegalStateException("best is null in " + this.toString());
            }
            while (!this.queue.isEmpty()) {
                this.getRouteManager(this.best).send((SocketBuffer)this.queue.removeFirst());
            }
            while (!this.pendingAppSockets.isEmpty()) {
                PendingAppSocket pas = (PendingAppSocket)this.pendingAppSockets.removeFirst();
                this.getRouteManager(this.best).connect(pas.appAddress, pas.receiver, 0);
            }
            if (this.queue.isEmpty() && this.pendingAppSockets.isEmpty()) {
                SocketSourceRouteManager.this.hardLinks.remove(this);
            }
            switch (this.liveness) {
                case 3: {
                    this.liveness = 1;
                    if (this.address != null) {
                        this.address.update(SocketNodeHandle.DECLARED_LIVE);
                    }
                    if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level > 500) break;
                    SocketSourceRouteManager.this.logger.log("COUNT: " + SocketSourceRouteManager.this.localAddress + " Found address " + this.address + " to be alive again.");
                    break;
                }
                case 2: {
                    this.liveness = 1;
                    if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level > 500) break;
                    SocketSourceRouteManager.this.logger.log("COUNT: " + SocketSourceRouteManager.this.localAddress + " Found address " + this.address + " to be unsuspected.");
                    break;
                }
                case 4: {
                    if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level > 900) break;
                    SocketSourceRouteManager.this.logger.log("ERROR: Found dead-forever handle to " + this.address + " to be alive again!");
                }
            }
        }

        protected void setSuspected() {
            switch (this.liveness) {
                case 1: {
                    this.liveness = 2;
                    if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level > 500) break;
                    SocketSourceRouteManager.this.logger.log("COUNT: " + SocketSourceRouteManager.this.spn.getEnvironment().getTimeSource().currentTimeMillis() + " " + SocketSourceRouteManager.this.localAddress + " Found address " + this.address + " to be suspected.");
                    break;
                }
                case 3: {
                    if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level > 900) break;
                    SocketSourceRouteManager.this.logger.log("ERROR: Found node handle " + this.address + " to be suspected from dead - should not happen!");
                    break;
                }
                case 4: {
                    if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level > 900) break;
                    SocketSourceRouteManager.this.logger.log("ERROR: Found node handle " + this.address + " to be suspected from dead forever - should never ever happen!");
                }
            }
            Object[] array = this.queue.toArray();
            for (int i = 0; i < array.length; ++i) {
                SocketBuffer sb = (SocketBuffer)array[i];
                if (!sb.isRouteMessage() || !sb.getOptions().multipleHopsAllowed() || !sb.getOptions().rerouteIfSuspected()) continue;
                SocketSourceRouteManager.this.reroute(this.address.eaddress, sb);
                this.queue.remove(sb);
            }
            if (this.queue.isEmpty() && this.pendingAppSockets.isEmpty()) {
                SocketSourceRouteManager.this.hardLinks.remove(this);
            }
        }

        protected void setDead() {
            switch (this.liveness) {
                case 3: {
                    return;
                }
                case 4: {
                    if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level > 900) break;
                    SocketSourceRouteManager.this.logger.log("ERROR: Found node handle " + this.address + " to be dead from dead forever - should not happen!");
                    break;
                }
                default: {
                    this.best = null;
                    this.liveness = 3;
                    if (this.address != null) {
                        this.address.update(SocketNodeHandle.DECLARED_DEAD);
                    }
                    if (this.address.eaddress != null) {
                        SocketSourceRouteManager.this.manager.declaredDead(this.address.eaddress);
                    }
                    if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level > 500) break;
                    SocketSourceRouteManager.this.logger.log("COUNT: " + SocketSourceRouteManager.this.localAddress + " Found address " + this.address + " to be dead.");
                }
            }
            this.purgeQueue();
        }

        public String toString() {
            return "AM" + this.address;
        }

        protected void setDeadForever() {
            switch (this.liveness) {
                case 4: {
                    return;
                }
                case 3: {
                    this.liveness = 4;
                    if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level > 500) break;
                    SocketSourceRouteManager.this.logger.log("COUNT: " + SocketSourceRouteManager.this.localAddress + " Found address " + this.address + " to be dead forever.");
                    break;
                }
                default: {
                    this.best = null;
                    this.liveness = 4;
                    if (this.address != null) {
                        this.address.update(SocketNodeHandle.DECLARED_DEAD);
                    }
                    if (((SocketSourceRouteManager)SocketSourceRouteManager.this).logger.level > 500) break;
                    SocketSourceRouteManager.this.logger.log("COUNT: " + SocketSourceRouteManager.this.localAddress + " Found address " + this.address + " to be dead forever.");
                }
            }
            this.purgeQueue();
        }

        protected void purgeQueue() {
            while (!this.queue.isEmpty()) {
                SocketSourceRouteManager.this.reroute(this.address.eaddress, (SocketBuffer)this.queue.removeFirst());
            }
            while (!this.pendingAppSockets.isEmpty()) {
                PendingAppSocket pas = (PendingAppSocket)this.pendingAppSockets.removeFirst();
                pas.receiver.receiveException(null, new NodeIsDeadException());
            }
            SocketSourceRouteManager.this.hardLinks.remove(this);
        }

        public class SourceRouteManager {
            int RTO;
            double RTT;
            double standardD;
            protected SourceRoute route;
            protected int liveness;
            protected int proximity;
            protected long proximityTimeout;
            protected long updated;
            protected boolean pending;

            public SourceRouteManager(SourceRoute route) {
                this.RTO = SocketSourceRouteManager.this.DEFAULT_RTO;
                this.RTT = 0.0;
                this.standardD = (double)this.RTO / 4.0;
                if (route == null) {
                    throw new IllegalArgumentException("route is null");
                }
                this.route = route;
                this.liveness = 2;
                this.proximity = 3600000;
                this.proximityTimeout = SocketSourceRouteManager.this.time.currentTimeMillis() + (long)SocketSourceRouteManager.this.PROX_TIMEOUT;
                this.pending = false;
                this.updated = 0L;
            }

            public int rto() {
                return this.RTO;
            }

            public int proximity() {
                long now = SocketSourceRouteManager.this.time.currentTimeMillis();
                if (this.proximityTimeout > now) {
                    return this.proximity;
                }
                this.proximity = (int)this.RTT;
                this.proximityTimeout = now + (long)SocketSourceRouteManager.this.PROX_TIMEOUT;
                return this.proximity;
            }

            protected void markAlive() {
                this.liveness = 1;
                this.pending = false;
            }

            protected void markSuspected() {
                this.liveness = 2;
            }

            protected void markDead() {
                this.liveness = 3;
                this.pending = false;
            }

            protected void markProximity(int proximity) {
                if (proximity < 0) {
                    throw new IllegalArgumentException("proximity must be >= 0, was:" + proximity);
                }
                this.updateRTO(proximity);
                if (this.proximity > proximity) {
                    this.proximityTimeout = SocketSourceRouteManager.this.time.currentTimeMillis();
                    this.proximity = proximity;
                }
            }

            private void updateRTO(long m) {
                double err = (double)m - this.RTT;
                double absErr = err;
                if (absErr < 0.0) {
                    absErr *= -1.0;
                }
                this.RTT += SocketSourceRouteManager.this.gainG * err;
                this.standardD += SocketSourceRouteManager.this.gainH * (absErr - this.standardD);
                this.RTO = (int)(this.RTT + 4.0 * this.standardD);
                if (this.RTO > SocketSourceRouteManager.this.RTO_UBOUND) {
                    this.RTO = SocketSourceRouteManager.this.RTO_UBOUND;
                }
                if (this.RTO < SocketSourceRouteManager.this.RTO_LBOUND) {
                    this.RTO = SocketSourceRouteManager.this.RTO_LBOUND;
                }
            }

            protected boolean checkLiveness() {
                if (this.pending) {
                    return true;
                }
                if (this.liveness < 3 || this.updated < SocketSourceRouteManager.this.spn.getEnvironment().getTimeSource().currentTimeMillis() - SocketSourceRouteManager.this.CHECK_DEAD_THROTTLE) {
                    this.updated = SocketSourceRouteManager.this.spn.getEnvironment().getTimeSource().currentTimeMillis();
                    this.pending = true;
                    SocketSourceRouteManager.this.manager.checkLiveness(this.route);
                    return true;
                }
                return false;
            }

            public synchronized void send(SocketBuffer message) {
                SocketSourceRouteManager.this.manager.send(this.route, message, AddressManager.this);
            }

            public synchronized void connect(int appId, AppSocketReceiver receiver, int timeout) {
                SocketSourceRouteManager.this.manager.connect(this.route, appId, receiver, timeout);
            }

            public void ping() {
                SocketSourceRouteManager.this.manager.ping(this.route);
            }

            public boolean isOpen() {
                return SocketSourceRouteManager.this.manager.isOpen(this.route);
            }

            public String toString() {
                return "SRM" + this.route;
            }
        }
    }
}

