/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.CloneableLogManager;
import rice.environment.logging.LogManager;
import rice.environment.logging.Logger;
import rice.environment.params.Parameters;
import rice.environment.processing.Processor;
import rice.environment.processing.simple.SimpleProcessor;
import rice.environment.random.RandomSource;
import rice.environment.random.simple.SimpleRandomSource;
import rice.environment.time.simulated.DirectTimeSource;
import rice.p2p.commonapi.CancellableTask;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeHandleFactory;
import rice.pastry.NodeIdFactory;
import rice.pastry.PastryNode;
import rice.pastry.dist.DistPastryNodeFactory;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.MessageDispatch;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RoutingTable;
import rice.pastry.socket.EpochInetSocketAddress;
import rice.pastry.socket.PingManager;
import rice.pastry.socket.SocketBuffer;
import rice.pastry.socket.SocketChannelReader;
import rice.pastry.socket.SocketChannelWriter;
import rice.pastry.socket.SocketCollectionManager;
import rice.pastry.socket.SocketNodeHandle;
import rice.pastry.socket.SocketPastryNode;
import rice.pastry.socket.SocketSourceRouteManager;
import rice.pastry.socket.SourceRoute;
import rice.pastry.socket.messaging.IPAddressRequestMessage;
import rice.pastry.socket.messaging.IPAddressResponseMessage;
import rice.pastry.socket.messaging.LeafSetRequestMessage;
import rice.pastry.socket.messaging.LeafSetResponseMessage;
import rice.pastry.socket.messaging.NodeIdRequestMessage;
import rice.pastry.socket.messaging.NodeIdResponseMessage;
import rice.pastry.socket.messaging.PingMessage;
import rice.pastry.socket.messaging.RouteRowRequestMessage;
import rice.pastry.socket.messaging.RouteRowResponseMessage;
import rice.pastry.socket.messaging.RoutesRequestMessage;
import rice.pastry.socket.messaging.RoutesResponseMessage;
import rice.pastry.socket.nat.NATHandler;
import rice.pastry.socket.nat.StubNATHandler;
import rice.pastry.standard.ConsistentJoinProtocol;
import rice.pastry.standard.PeriodicLeafSetProtocol;
import rice.pastry.standard.StandardRouteSetProtocol;
import rice.pastry.standard.StandardRouter;
import rice.selector.SelectionKeyHandler;
import rice.selector.SelectorManager;

public class SocketPastryNodeFactory
extends DistPastryNodeFactory {
    public static final int ALWAYS = 1;
    public static final int PREFIX_MATCH = 2;
    public static final int NEVER = 3;
    public static final int OVERWRITE = 1;
    public static final int USE_DIFFERENT_PORT = 2;
    public static final int FAIL = 3;
    private NodeIdFactory nidFactory;
    private int port;
    private int leafSetMaintFreq;
    private int routeSetMaintFreq;
    private RandomSource random;
    private InetAddress localAddress;
    InetAddress[] addressList;
    protected int testFireWallPolicy;
    protected int findFireWallPolicy;
    NATHandler natHandler;
    String firewallAppName;
    int firewallSearchTries;
    MessageDeserializer deserializer = new SPNFDeserializer();
    NodeHandleFactory nhf = new NodeHandleFactory(){

        public NodeHandle readNodeHandle(InputBuffer buf) throws IOException {
            return SocketNodeHandle.build(buf);
        }
    };
    static final byte[] TOTAL_HEADER = new byte[SocketCollectionManager.TOTAL_HEADER_SIZE + 4];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketPastryNodeFactory(NodeIdFactory nf, InetAddress bindAddress, int startPort, Environment env, NATHandler handler) throws IOException {
        super(env);
        if (env.getTimeSource() instanceof DirectTimeSource) {
            throw new IllegalArgumentException("SocketPastryNodeFactory is not compatible with the DirectTimeSource in the environment.  Please use the SimpleTimeSource or an equivalent.");
        }
        this.environment = env;
        this.nidFactory = nf;
        this.port = startPort;
        Parameters params = env.getParameters();
        this.firewallSearchTries = params.getInt("nat_find_port_max_tries");
        this.firewallAppName = params.getString("nat_app_name");
        this.natHandler = handler;
        this.localAddress = bindAddress;
        if (this.localAddress == null && params.contains("socket_bindAddress")) {
            this.localAddress = params.getInetAddress("socket_bindAddress");
        }
        if (this.localAddress == null) {
            this.localAddress = InetAddress.getLocalHost();
            Socket temp = null;
            ServerSocket test2 = null;
            if (this.localAddress.isLoopbackAddress() && !params.getBoolean("pastry_socket_allow_loopback")) {
                try {
                    temp = new Socket(params.getString("pastry_socket_known_network_address"), params.getInt("pastry_socket_known_network_address_port"));
                    if (temp.getLocalAddress().equals(this.localAddress)) {
                        throw new IllegalStateException("Cannot bind to " + this.localAddress + ":" + this.port);
                    }
                    this.localAddress = temp.getLocalAddress();
                    temp.close();
                    temp = null;
                    if (this.logger.level <= 900) {
                        this.logger.log("Error binding to default IP, using " + this.localAddress + ":" + this.port);
                    }
                    try {
                        test2 = new ServerSocket();
                        test2.bind(new InetSocketAddress(this.localAddress, this.port));
                    }
                    catch (SocketException e2) {
                        throw new IllegalStateException("Cannot bind to " + this.localAddress + ":" + this.port, e2);
                    }
                }
                finally {
                    try {
                        if (test2 != null) {
                            test2.close();
                        }
                    }
                    catch (Exception e) {}
                    try {
                        if (temp != null) {
                            temp.close();
                        }
                    }
                    catch (Exception e) {}
                }
            }
        }
        if (this.natHandler == null) {
            if (params.contains("nat_handler_class")) {
                try {
                    Class<?> natHandlerClass = Class.forName(params.getString("nat_handler_class"));
                    Class[] args = new Class[]{Environment.class, InetAddress.class};
                    Constructor<?> constructor = natHandlerClass.getConstructor(args);
                    Object[] foo = new Object[]{this.environment, this.localAddress};
                    this.natHandler = (NATHandler)constructor.newInstance(foo);
                }
                catch (ClassNotFoundException e) {
                    if (this.logger.level <= 800) {
                        this.logger.log("Didn't find UPnP libs, skipping UPnP");
                    }
                    this.natHandler = new StubNATHandler(this.environment, this.localAddress);
                }
                catch (NoClassDefFoundError e) {
                    if (this.logger.level <= 800) {
                        this.logger.log("Didn't find UPnP libs, skipping UPnP");
                    }
                    this.natHandler = new StubNATHandler(this.environment, this.localAddress);
                }
                catch (Exception e) {
                    if (this.logger.level <= 900) {
                        this.logger.logException("Error constructing NATHandler.", e);
                    }
                    throw new RuntimeException(e);
                }
            } else {
                this.natHandler = new StubNATHandler(this.environment, this.localAddress);
            }
        }
        this.leafSetMaintFreq = params.getInt("pastry_leafSetMaintFreq");
        this.routeSetMaintFreq = params.getInt("pastry_routeSetMaintFreq");
        this.random = params.contains("pastry_socket_use_own_random") && params.getBoolean("pastry_socket_use_own_random") ? (params.contains("pastry_socket_random_seed") && !params.getString("pastry_socket_random_seed").equalsIgnoreCase("clock") ? new SimpleRandomSource(params.getLong("pastry_socket_random_seed"), env.getLogManager(), "socket") : new SimpleRandomSource(env.getLogManager(), "socket")) : env.getRandomSource();
    }

    public SocketPastryNodeFactory(NodeIdFactory nf, int startPort, Environment env) throws IOException {
        this(nf, null, startPort, env, null);
    }

    public SourceRoute[] getRoutes(NodeHandle handle, NodeHandle local) throws IOException {
        SocketNodeHandle wHandle = (SocketNodeHandle)handle;
        RoutesResponseMessage lm = (RoutesResponseMessage)this.getResponse(wHandle.getAddress(this.addressList), new RoutesRequestMessage());
        return lm.getRoutes();
    }

    public LeafSet getLeafSet(NodeHandle handle) throws IOException {
        SocketNodeHandle wHandle = (SocketNodeHandle)handle;
        LeafSetResponseMessage lm = (LeafSetResponseMessage)this.getResponse(wHandle.getAddress(this.addressList), new LeafSetRequestMessage());
        return lm.getLeafSet();
    }

    public CancellableTask getLeafSet(NodeHandle handle, final Continuation c) {
        SocketNodeHandle wHandle = (SocketNodeHandle)handle;
        return this.getResponse(wHandle.getAddress(this.addressList), new LeafSetRequestMessage(), new Continuation(){

            public void receiveResult(Object result) {
                LeafSetResponseMessage lm = (LeafSetResponseMessage)result;
                c.receiveResult(lm.getLeafSet());
            }

            public void receiveException(Exception result) {
                c.receiveException(result);
            }
        });
    }

    public RouteSet[] getRouteRow(NodeHandle handle, int row) throws IOException {
        SocketNodeHandle wHandle = (SocketNodeHandle)handle;
        RouteRowResponseMessage rm = (RouteRowResponseMessage)this.getResponse(wHandle.getAddress(this.addressList), new RouteRowRequestMessage(row));
        return rm.getRouteRow();
    }

    public CancellableTask getRouteRow(NodeHandle handle, int row, final Continuation c) {
        SocketNodeHandle wHandle = (SocketNodeHandle)handle;
        return this.getResponse(wHandle.getAddress(this.addressList), new RouteRowRequestMessage(row), new Continuation(){

            public void receiveResult(Object result) {
                RouteRowResponseMessage rm = (RouteRowResponseMessage)result;
                c.receiveResult(rm.getRouteRow());
            }

            public void receiveException(Exception result) {
                c.receiveException(result);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getProximity(NodeHandle local, NodeHandle handle) {
        EpochInetSocketAddress lAddress = ((SocketNodeHandle)local).getEpochAddress();
        EpochInetSocketAddress rAddress = ((SocketNodeHandle)handle).getEpochAddress();
        if (lAddress.getAddress(this.addressList).equals(rAddress.getAddress(this.addressList))) {
            return 3600000;
        }
        DatagramSocket socket = null;
        SourceRoute route = SourceRoute.build(new EpochInetSocketAddress[]{rAddress});
        try {
            socket = new DatagramSocket(lAddress.getAddress(this.addressList).getPort());
            socket.setSoTimeout(5000);
            SocketBuffer sb = new SocketBuffer(lAddress, route, new PingMessage(this.environment.getTimeSource().currentTimeMillis()));
            if (this.logger.level <= 500) {
                this.logger.log("Sending Ping to " + rAddress + " from " + lAddress);
            }
            socket.send(new DatagramPacket(sb.getBuffer().array(), sb.getBuffer().limit(), rAddress.getAddress(this.addressList)));
            long start = this.environment.getTimeSource().currentTimeMillis();
            socket.receive(new DatagramPacket(new byte[10000], 10000));
            int n = (int)(this.environment.getTimeSource().currentTimeMillis() - start);
            return n;
        }
        catch (IOException e) {
            if (this.logger.level <= 500) {
                this.logger.logException("Error in getProximity(" + local + "," + handle + ") ", e);
            }
            int n = 3600000;
            return n;
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeHandle generateNodeHandle(InetSocketAddress address, int timeout) {
        if (timeout <= 0) {
            return this.generateNodeHandle(address);
        }
        TimerContinuation c = new TimerContinuation();
        CancellableTask task = this.generateNodeHandle(address, c);
        if (task == null) {
            return null;
        }
        TimerContinuation timerContinuation = c;
        synchronized (timerContinuation) {
            try {
                c.wait(timeout);
            }
            catch (InterruptedException ie) {
                return null;
            }
        }
        task.cancel();
        if (this.logger.level <= 400) {
            this.logger.log("SPNF.generateNodeHandle() returning " + c.ret + " after trying to contact " + address);
        }
        return (NodeHandle)c.ret;
    }

    public NodeHandle generateNodeHandle(InetSocketAddress address) {
        if (this.logger.level <= 500) {
            this.logger.log("Socket: Contacting bootstrap node " + address);
        }
        try {
            NodeIdResponseMessage rm = (NodeIdResponseMessage)this.getResponse(address, new NodeIdRequestMessage());
            return new SocketNodeHandle(new EpochInetSocketAddress(address, rm.getEpoch()), rm.getNodeId());
        }
        catch (IOException e) {
            if (this.logger.level <= 500) {
                this.logger.logException("Error connecting to address " + address + ": ", e);
            } else if (this.logger.level <= 900) {
                this.logger.log("Error connecting to address " + address + ": " + e);
            }
            return null;
        }
    }

    public CancellableTask generateNodeHandle(final InetSocketAddress address, final Continuation c) {
        if (this.logger.level <= 500) {
            this.logger.log("Socket: Contacting bootstrap node " + address);
        }
        return this.getResponse(address, new NodeIdRequestMessage(), new Continuation(){

            public void receiveResult(Object result) {
                NodeIdResponseMessage rm = (NodeIdResponseMessage)result;
                c.receiveResult(new SocketNodeHandle(new EpochInetSocketAddress(address, rm.getEpoch()), rm.getNodeId()));
            }

            public void receiveException(Exception result) {
                if (((SocketPastryNodeFactory)SocketPastryNodeFactory.this).logger.level <= 900) {
                    SocketPastryNodeFactory.this.logger.log("Error connecting to address " + address + ": " + result);
                }
                c.receiveException(result);
            }
        });
    }

    public PastryNode newNode(NodeHandle bootstrap) {
        return this.newNode(bootstrap, this.nidFactory.generateNodeId());
    }

    public PastryNode newNode(NodeHandle bootstrap, Id nodeId) {
        return this.newNode(bootstrap, nodeId, null);
    }

    public PastryNode newNode(NodeHandle bootstrap, InetSocketAddress proxy) {
        return this.newNode(bootstrap, this.nidFactory.generateNodeId(), proxy);
    }

    public synchronized PastryNode newNode(NodeHandle bootstrap, Id nodeId, InetSocketAddress pAddress) {
        try {
            return this.newNode(bootstrap, nodeId, pAddress, true);
        }
        catch (BindException e) {
            if (this.logger.level <= 900) {
                this.logger.log("Warning: " + e);
            }
            if (this.environment.getParameters().getBoolean("pastry_socket_increment_port_after_construction")) {
                ++this.port;
                try {
                    return this.newNode(bootstrap, nodeId, pAddress);
                }
                catch (StackOverflowError soe) {
                    if (this.logger.level <= 1000) {
                        this.logger.log("SEVERE: SocketPastryNodeFactory: Could not bind on any ports!" + soe);
                    }
                    throw soe;
                }
            }
            if (this.environment.getParameters().getBoolean("pastry_factory_multipleNodes")) {
                this.environment.destroy();
            }
            throw new RuntimeException(e);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public synchronized PastryNode newNode(NodeHandle bootstrap, Id nodeId, InetSocketAddress pAddress, boolean throwException) throws IOException {
        if (!throwException) {
            return this.newNode(bootstrap, nodeId, pAddress);
        }
        if (bootstrap == null && this.logger.level <= 900) {
            this.logger.log("No bootstrap node provided, starting a new ring binding to address " + this.localAddress + ":" + this.port + "...");
        }
        Environment environment = this.environment;
        if (this.environment.getParameters().getBoolean("pastry_factory_multipleNodes") && this.environment.getLogManager() instanceof CloneableLogManager) {
            LogManager lman = ((CloneableLogManager)this.environment.getLogManager()).clone("0x" + nodeId.toStringBare());
            SelectorManager sman = this.environment.getSelectorManager();
            Processor proc = this.environment.getProcessor();
            if (this.environment.getParameters().getBoolean("pastry_factory_selectorPerNode")) {
                sman = new SelectorManager(nodeId.toString() + " Selector", this.environment.getTimeSource(), lman);
            }
            if (this.environment.getParameters().getBoolean("pastry_factory_processorPerNode")) {
                proc = new SimpleProcessor(nodeId.toString() + " Processor");
            }
            environment = new Environment(sman, proc, this.environment.getRandomSource(), this.environment.getTimeSource(), lman, this.environment.getParameters(), this.environment.getExceptionStrategy());
            this.environment.addDestructable(environment);
        }
        long epoch = this.random.nextLong();
        EpochInetSocketAddress localAddress = null;
        EpochInetSocketAddress proxyAddress = null;
        SocketPastryNode pn = new SocketPastryNode(nodeId, environment);
        environment.addDestructable(pn);
        SocketSourceRouteManager srManager = null;
        localAddress = this.getEpochAddress(this.port, epoch);
        boolean probeForExternalAddress = environment.getParameters().getBoolean("probe_for_external_address");
        if (pAddress == null) {
            if (environment.getParameters().contains("external_address")) {
                pAddress = environment.getParameters().getInetSocketAddress("external_address");
            } else if (probeForExternalAddress) {
                int timeout = environment.getParameters().getInt("pastry_proxy_connectivity_timeout");
                int tries = environment.getParameters().getInt("pastry_proxy_connectivity_tries");
                if (bootstrap == null) {
                    throw new IOException("Cannot probe for external address without a bootstrap node to use as a probe target");
                }
                InetSocketAddress[] verifyAddresses = new InetSocketAddress[]{((SocketNodeHandle)bootstrap).eaddress.address[0]};
                pAddress = SocketPastryNodeFactory.verifyConnection(timeout, tries, localAddress.getInnermostAddress(), verifyAddresses, environment, this.logger);
            }
        }
        if (!probeForExternalAddress) {
            int availableFireWallPort;
            this.findFireWallIfNecessary();
            if (pAddress == null) {
                if (this.natHandler.getFireWallExternalAddress() == null) {
                    proxyAddress = localAddress;
                } else {
                    availableFireWallPort = this.natHandler.findAvailableFireWallPort(this.port, this.port, this.firewallSearchTries, this.firewallAppName);
                    this.natHandler.openFireWallPort(this.port, availableFireWallPort, this.firewallAppName);
                    proxyAddress = new EpochInetSocketAddress(new InetSocketAddress[]{new InetSocketAddress(this.natHandler.getFireWallExternalAddress(), availableFireWallPort), localAddress.getInnermostAddress()}, epoch);
                }
            } else {
                if (this.natHandler.getFireWallExternalAddress() != null) {
                    availableFireWallPort = this.natHandler.findAvailableFireWallPort(this.port, pAddress.getPort(), this.firewallSearchTries, this.firewallAppName);
                    if (availableFireWallPort == pAddress.getPort()) {
                        this.natHandler.openFireWallPort(this.port, availableFireWallPort, this.firewallAppName);
                    } else {
                        switch (this.getFireWallPolicyVariable("nat_state_policy")) {
                            case 1: {
                                this.natHandler.openFireWallPort(this.port, pAddress.getPort(), this.firewallAppName);
                                break;
                            }
                            case 3: {
                                throw new BindException("Firewall is already bound to the requested port:" + pAddress);
                            }
                            case 2: {
                                this.natHandler.openFireWallPort(this.port, availableFireWallPort, this.firewallAppName);
                                pAddress = new InetSocketAddress(pAddress.getAddress(), availableFireWallPort);
                            }
                        }
                    }
                }
                proxyAddress = new EpochInetSocketAddress(new InetSocketAddress[]{pAddress, localAddress.getInnermostAddress()}, epoch);
            }
        } else {
            proxyAddress = new EpochInetSocketAddress(new InetSocketAddress[]{pAddress, localAddress.getInnermostAddress()}, epoch);
        }
        this.updateAddressList(proxyAddress);
        SocketNodeHandle temp = new SocketNodeHandle(proxyAddress, nodeId);
        NodeHandle[] nearest = this.getNearest(temp, bootstrap);
        srManager = new SocketSourceRouteManager(pn, localAddress, proxyAddress, this.random);
        if (environment.getParameters().getBoolean("pastry_socket_increment_port_after_construction")) {
            ++this.port;
        }
        pn.setSocketSourceRouteManager(srManager);
        SocketNodeHandle localhandle = new SocketNodeHandle(proxyAddress, nodeId);
        localhandle = (SocketNodeHandle)pn.coalesce(localhandle);
        MessageDispatch msgDisp = new MessageDispatch(pn);
        RoutingTable routeTable = new RoutingTable(localhandle, this.rtMax, this.rtBase, pn);
        LeafSet leafSet = new LeafSet((NodeHandle)localhandle, (int)this.lSetSize, routeTable);
        StandardRouter router = new StandardRouter(pn);
        StandardRouteSetProtocol rsProtocol = new StandardRouteSetProtocol(pn, routeTable, environment);
        pn.setElements(localhandle, msgDisp, leafSet, routeTable);
        router.register();
        rsProtocol.register();
        pn.setSocketElements(proxyAddress, this.leafSetMaintFreq, this.routeSetMaintFreq);
        PeriodicLeafSetProtocol lsProtocol = new PeriodicLeafSetProtocol((PastryNode)pn, localhandle, leafSet, routeTable);
        lsProtocol.register();
        ConsistentJoinProtocol jProtocol = new ConsistentJoinProtocol((PastryNode)pn, (NodeHandle)localhandle, routeTable, leafSet, lsProtocol);
        jProtocol.register();
        if (bootstrap != null) {
            bootstrap = (SocketNodeHandle)pn.coalesce(bootstrap);
            switch (this.getFireWallPolicyVariable("firewall_test_policy")) {
                case 3: {
                    break;
                }
                case 2: {
                    if (!this.localAddressIsProbablyNatted()) break;
                }
                default: {
                    Continuation.ExternalContinuation ec = new Continuation.ExternalContinuation();
                    pn.testFireWall(bootstrap, ec, 5000, 3);
                    ec.sleep();
                    Boolean resultB = (Boolean)ec.getResult();
                    boolean result = resultB;
                    if (result) break;
                    throw new RuntimeException("Firewall test failed for local:" + proxyAddress.getInnermostAddress() + " external:" + proxyAddress.address[0]);
                }
            }
        }
        if (nearest != null && nearest.length > 0) {
            for (int i = 0; i < nearest.length; ++i) {
                nearest[i] = pn.coalesce(nearest[i]);
            }
        }
        pn.doneNode(nearest);
        return pn;
    }

    private void updateAddressList(EpochInetSocketAddress proxyAddress) {
        this.addressList = new InetAddress[proxyAddress.address.length];
        for (int i = 0; i < this.addressList.length; ++i) {
            this.addressList[i] = proxyAddress.address[i].getAddress();
        }
    }

    protected void findFireWallIfNecessary() throws IOException {
        switch (this.getFireWallPolicyVariable("nat_search_policy")) {
            case 3: {
                return;
            }
            case 2: {
                if (this.localAddressIsProbablyNatted()) break;
                return;
            }
        }
        this.natHandler.findFireWall(this.localAddress);
    }

    protected int getFireWallPolicyVariable(String key) {
        String val = this.environment.getParameters().getString(key);
        if (val.equalsIgnoreCase("prefix")) {
            return 2;
        }
        if (val.equalsIgnoreCase("change")) {
            return 2;
        }
        if (val.equalsIgnoreCase("never")) {
            return 3;
        }
        if (val.equalsIgnoreCase("overwrite")) {
            return 1;
        }
        if (val.equalsIgnoreCase("always")) {
            return 1;
        }
        if (val.equalsIgnoreCase("fail")) {
            return 3;
        }
        throw new RuntimeException("Unknown value " + val + " for " + key);
    }

    protected boolean localAddressIsProbablyNatted() {
        String ip = this.localAddress.getHostAddress();
        String nattedNetworkPrefixes = this.environment.getParameters().getString("nat_network_prefixes");
        String[] nattedNetworkPrefix = nattedNetworkPrefixes.split(";");
        for (int i = 0; i < nattedNetworkPrefix.length; ++i) {
            if (!ip.startsWith(nattedNetworkPrefix[i])) continue;
            return true;
        }
        return false;
    }

    protected Message getResponse(InetSocketAddress address, Message message) throws IOException {
        SocketChannelWriter writer = new SocketChannelWriter(this.environment, SourceRoute.build(new EpochInetSocketAddress(address, -1L)));
        SocketChannelReader reader = new SocketChannelReader(this.environment, SourceRoute.build(new EpochInetSocketAddress(address, -1L)));
        SocketChannel channel = SocketChannel.open();
        channel.configureBlocking(true);
        channel.socket().connect(address, 20000);
        channel.socket().setSoTimeout(20000);
        writer.enqueue(TOTAL_HEADER);
        writer.enqueue(message);
        writer.write(channel);
        SocketBuffer o = null;
        while (o == null) {
            o = reader.read(channel);
        }
        if (this.logger.level <= 400) {
            this.logger.log("SPNF.getResponse(): Closing " + channel);
        }
        channel.socket().shutdownOutput();
        channel.socket().close();
        channel.close();
        if (this.logger.level <= 400) {
            this.logger.log("SPNF.getResponse(): Closed " + channel);
        }
        return o.deserialize(this.deserializer);
    }

    protected CancellableTask getResponse(final InetSocketAddress address, final Message message, final Continuation c) {
        final SocketChannelWriter writer = new SocketChannelWriter(this.environment, SourceRoute.build(new EpochInetSocketAddress(address, -1L)));
        final SocketChannelReader reader = new SocketChannelReader(this.environment, SourceRoute.build(new EpochInetSocketAddress(address, -1L)));
        writer.enqueue(TOTAL_HEADER);
        try {
            writer.enqueue(message);
        }
        catch (IOException ioe) {
            c.receiveException(ioe);
            return null;
        }
        try {
            final SocketChannel channel = SocketChannel.open();
            channel.configureBlocking(false);
            final SelectionKey key = this.environment.getSelectorManager().register(channel, new SelectionKeyHandler(){

                public void connect(SelectionKey key) {
                    if (((SocketPastryNodeFactory)SocketPastryNodeFactory.this).logger.level <= 500) {
                        SocketPastryNodeFactory.this.logger.log("SPNF.getResponse(" + address + "," + message + ").connect()");
                    }
                    try {
                        if (channel.finishConnect()) {
                            key.interestOps(key.interestOps() & 0xFFFFFFF7);
                        }
                        if (((SocketPastryNodeFactory)SocketPastryNodeFactory.this).logger.level <= 500) {
                            SocketPastryNodeFactory.this.logger.log("(SPNF) Found connectable channel - completed connection");
                        }
                    }
                    catch (IOException ioe) {
                        this.handleException(ioe);
                    }
                }

                public void read(SelectionKey key) {
                    if (((SocketPastryNodeFactory)SocketPastryNodeFactory.this).logger.level <= 500) {
                        SocketPastryNodeFactory.this.logger.log("SPNF.getResponse(" + address + "," + message + ").read()");
                    }
                    try {
                        SocketBuffer o = null;
                        while (o == null) {
                            o = reader.read(channel);
                        }
                        channel.socket().close();
                        channel.close();
                        key.cancel();
                        c.receiveResult(o.deserialize(SocketPastryNodeFactory.this.deserializer));
                    }
                    catch (IOException ioe) {
                        this.handleException(ioe);
                    }
                }

                public void write(SelectionKey key) {
                    if (((SocketPastryNodeFactory)SocketPastryNodeFactory.this).logger.level <= 500) {
                        SocketPastryNodeFactory.this.logger.log("SPNF.getResponse(" + address + "," + message + ").write()");
                    }
                    try {
                        if (writer.write(channel)) {
                            key.interestOps(1);
                        }
                    }
                    catch (IOException ioe) {
                        this.handleException(ioe);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleException(Exception e) {
                    try {
                        channel.socket().close();
                        channel.close();
                        channel.keyFor(SocketPastryNodeFactory.this.environment.getSelectorManager().getSelector()).cancel();
                    }
                    catch (IOException ioe) {
                        if (((SocketPastryNodeFactory)SocketPastryNodeFactory.this).logger.level <= 900) {
                            SocketPastryNodeFactory.this.logger.logException("Error while trying requesting " + message + " from " + address, e);
                        }
                    }
                    finally {
                        c.receiveException(e);
                    }
                }
            }, 0);
            if (this.logger.level <= 500) {
                this.logger.log("(SPNF) Initiating socket connection to address " + address);
            }
            if (channel.connect(address)) {
                key.interestOps(5);
            } else {
                key.interestOps(13);
            }
            return new CancellableTask(){

                public void run() {
                }

                public boolean cancel() {
                    SocketPastryNodeFactory.this.environment.getSelectorManager().invoke(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            block5: {
                                try {
                                    SelectionKey selectionKey = key;
                                    synchronized (selectionKey) {
                                        channel.socket().close();
                                        channel.close();
                                        key.cancel();
                                    }
                                }
                                catch (Exception ioe) {
                                    if (((SocketPastryNodeFactory)SocketPastryNodeFactory.this).logger.level > 900) break block5;
                                    SocketPastryNodeFactory.this.logger.logException("Error cancelling task.", ioe);
                                }
                            }
                        }
                    });
                    return true;
                }

                public long scheduledExecutionTime() {
                    return 0L;
                }
            };
        }
        catch (IOException ioe) {
            c.receiveException(ioe);
            return null;
        }
    }

    private EpochInetSocketAddress getEpochAddress(int portNumber, long epoch) {
        EpochInetSocketAddress result = null;
        result = new EpochInetSocketAddress(new InetSocketAddress(this.localAddress, portNumber), epoch);
        return result;
    }

    public static InetSocketAddress verifyConnection(int timeout, InetSocketAddress local, InetSocketAddress[] existing, Environment env, Logger logger) throws IOException {
        return SocketPastryNodeFactory.verifyConnection(timeout, 1, local, existing, env, logger);
    }

    public static InetSocketAddress verifyConnection(int timeout, int tries, InetSocketAddress local, InetSocketAddress[] existingInput, Environment env, Logger logger) throws IOException {
        int existingLength = 0;
        for (int i = 0; i < existingInput.length; ++i) {
            if (existingInput[i].equals(local)) continue;
            ++existingLength;
        }
        if (existingLength == 0) {
            if (existingInput.length == 0) {
                throw new IllegalArgumentException("verifyConnection(" + local + ") called without any addresses to connect to.");
            }
            throw new IllegalArgumentException("verifyConnection(" + local + "," + existingInput[0] + ") called with only self as address to connect to, this is not allowed.");
        }
        InetSocketAddress[] existing = new InetSocketAddress[existingLength];
        int index = 0;
        for (int i = 0; i < existingInput.length; ++i) {
            if (existingInput[i].equals(local)) continue;
            existing[index] = existingInput[i];
            ++index;
        }
        if (logger.level <= 800) {
            logger.log("Verifying connection of local node " + local + " using " + existing[0] + " and " + existing.length + " more");
        }
        DatagramSocket socket = null;
        try {
            socket = new DatagramSocket(local);
            SocketTimeoutException toThrow = null;
            int subTimeout = timeout / (int)(Math.pow(2.0, tries) - 1.0);
            if (subTimeout < 1) {
                subTimeout = 1;
            }
            for (int curTry = 0; curTry < tries; ++curTry) {
                socket.setSoTimeout(subTimeout);
                for (int i = 0; i < existing.length; ++i) {
                    SocketBuffer sb = new SocketBuffer(new EpochInetSocketAddress(local), SourceRoute.build(new EpochInetSocketAddress(existing[i])), new IPAddressRequestMessage(env.getTimeSource().currentTimeMillis()));
                    DatagramPacket send = new DatagramPacket(sb.getBuffer().array(), sb.getBuffer().limit(), existing[i]);
                    socket.send(send);
                }
                DatagramPacket receive = new DatagramPacket(new byte[10000], 10000);
                try {
                    socket.receive(receive);
                }
                catch (SocketTimeoutException e) {
                    toThrow = e;
                }
                subTimeout *= 2;
                int headerLength = 42;
                if (receive.getLength() <= headerLength) continue;
                byte[] data = new byte[receive.getLength() - headerLength];
                System.arraycopy(receive.getData(), headerLength, data, 0, data.length);
                InetSocketAddress inetSocketAddress = ((IPAddressResponseMessage)new SocketBuffer(data, null).deserialize(new PingManager.PMDeserializer(logger))).getAddress();
                return inetSocketAddress;
            }
            throw toThrow;
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    static {
        System.arraycopy(SocketCollectionManager.PASTRY_MAGIC_NUMBER, 0, TOTAL_HEADER, 0, SocketCollectionManager.PASTRY_MAGIC_NUMBER.length);
        System.arraycopy(SocketCollectionManager.HEADER_DIRECT, 0, TOTAL_HEADER, 8, SocketCollectionManager.HEADER_SIZE);
    }

    class SPNFDeserializer
    implements MessageDeserializer {
        SPNFDeserializer() {
        }

        public rice.p2p.commonapi.Message deserialize(InputBuffer buf, short type, int priority, rice.p2p.commonapi.NodeHandle sender) throws IOException {
            switch (type) {
                case 7: {
                    return new NodeIdResponseMessage(buf);
                }
                case 5: {
                    return new LeafSetResponseMessage(buf, SocketPastryNodeFactory.this.nhf);
                }
                case 13: {
                    return new RoutesResponseMessage(buf);
                }
                case 11: {
                    return new RouteRowResponseMessage(buf, SocketPastryNodeFactory.this.nhf, null);
                }
            }
            if (((SocketPastryNodeFactory)SocketPastryNodeFactory.this).logger.level <= 1000) {
                SocketPastryNodeFactory.this.logger.log("SERIOUS ERROR: Received unknown message address: 0type:" + type);
            }
            return null;
        }
    }

    static class TimerContinuation
    implements Continuation {
        public Object ret = null;
        public Exception exception = null;

        TimerContinuation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receiveResult(Object result) {
            TimerContinuation timerContinuation = this;
            synchronized (timerContinuation) {
                this.ret = result;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receiveException(Exception result) {
            TimerContinuation timerContinuation = this;
            synchronized (timerContinuation) {
                this.exception = result;
                this.notify();
            }
        }
    }
}

