/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.IOException;
import java.util.HashSet;
import rice.Continuation;
import rice.environment.Environment;
import rice.p2p.commonapi.appsocket.AppSocketReceiver;
import rice.p2p.commonapi.exception.AppNotRegisteredException;
import rice.p2p.commonapi.exception.AppSocketException;
import rice.p2p.commonapi.exception.NoReceiverAvailableException;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.client.PastryAppl;
import rice.pastry.dist.DistPastryNode;
import rice.pastry.messaging.Message;
import rice.pastry.socket.EpochInetSocketAddress;
import rice.pastry.socket.PingResponseListener;
import rice.pastry.socket.SocketAppSocket;
import rice.pastry.socket.SocketNodeHandle;
import rice.pastry.socket.SocketSourceRouteManager;
import rice.pastry.socket.SourceRoute;
import rice.selector.TimerTask;

public class SocketPastryNode
extends DistPastryNode {
    private EpochInetSocketAddress address;
    SocketSourceRouteManager srManager;
    HashSet fireWallContinuations = new HashSet();

    protected SocketPastryNode(Id id, Environment e) {
        super(id, e);
    }

    public SocketSourceRouteManager getSocketSourceRouteManager() {
        return this.srManager;
    }

    public void setSocketElements(EpochInetSocketAddress address, int lsmf, int rsmf) {
        this.address = address;
        this.leafSetMaintFreq = lsmf;
        this.routeSetMaintFreq = rsmf;
    }

    public void doneNode(NodeHandle[] bootstrap) {
        super.doneNode(bootstrap);
        this.initiateJoin(bootstrap);
    }

    public String toString() {
        return "SocketNodeHandle (" + this.getNodeId() + "/" + this.address + ")";
    }

    public void destroy() {
        if (this.getEnvironment().getSelectorManager().isSelectorThread()) {
            try {
                super.destroy();
                if (this.srManager != null) {
                    this.srManager.destroy();
                }
            }
            catch (IOException e) {
                this.getEnvironment().getLogManager().getLogger(SocketPastryNode.class, "ERROR: Got exception " + e + " while resigning node!");
            }
        } else {
            this.getEnvironment().getSelectorManager().invoke(new Runnable(){

                public void run() {
                    SocketPastryNode.this.destroy();
                }
            });
        }
    }

    public NodeHandle coalesce(NodeHandle newHandle) {
        return this.srManager.coalesce((SocketNodeHandle)newHandle);
    }

    public void setSocketSourceRouteManager(SocketSourceRouteManager srManager) {
        this.srManager = srManager;
    }

    public void send(NodeHandle handle, Message message) {
        SocketNodeHandle snh = (SocketNodeHandle)handle;
        if (this.logger.level <= 400) {
            this.logger.log("send(" + snh + "," + message + ")");
        }
        if (snh.isLocal()) {
            this.receiveMessage(message);
        } else {
            try {
                this.getSocketSourceRouteManager().send(snh.getEpochAddress(), message);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    public void testFireWall(NodeHandle bootstrap, Continuation c, int timeout, int tries) {
        for (int i = 0; i < tries; ++i) {
            Continuation.ExternalContinuation ec = new Continuation.ExternalContinuation();
            this.testFireWall(bootstrap, ec, 5000);
            ec.sleep();
            Boolean resultB = (Boolean)ec.getResult();
            boolean result = resultB;
            if (result) {
                c.receiveResult(true);
                return;
            }
            try {
                Thread.sleep(this.getEnvironment().getRandomSource().nextInt(timeout));
                continue;
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        }
        c.receiveResult(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFireWall(NodeHandle bootstrap, final Continuation c, int timeout) {
        if (this.logger.level <= 400) {
            this.logger.log("testFireWall(" + bootstrap + "," + timeout + ")");
        }
        HashSet hashSet = this.fireWallContinuations;
        synchronized (hashSet) {
            this.fireWallContinuations.add(c);
        }
        this.getEnvironment().getSelectorManager().getTimer().schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                HashSet hashSet = SocketPastryNode.this.fireWallContinuations;
                synchronized (hashSet) {
                    if (SocketPastryNode.this.fireWallContinuations.remove(c)) {
                        c.receiveResult(false);
                    }
                }
            }
        }, timeout);
        SocketNodeHandle snh = (SocketNodeHandle)bootstrap;
        EpochInetSocketAddress[] rt = new EpochInetSocketAddress[]{snh.getEpochAddress(), this.address};
        SourceRoute sr = SourceRoute.build(rt);
        if (this.logger.level <= 400) {
            this.logger.log("testFireWall(" + bootstrap + "," + timeout + "):" + sr);
        }
        this.srManager.getManager().getPingManager().ping(sr, new PingResponseListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void pingResponse(SourceRoute path, long RTT, long timeHeardFrom) {
                HashSet hashSet = SocketPastryNode.this.fireWallContinuations;
                synchronized (hashSet) {
                    if (SocketPastryNode.this.fireWallContinuations.remove(c)) {
                        c.receiveResult(true);
                    }
                }
            }
        });
    }

    public void connect(NodeHandle handle, AppSocketReceiver receiver, PastryAppl appl, int timeout) {
        SocketNodeHandle snh = (SocketNodeHandle)handle;
        if (this.logger.level <= 400) {
            this.logger.log("Opening app socket " + appl.getAddress() + " to " + handle);
        }
        this.getSocketSourceRouteManager().connect(snh.getEpochAddress(), appl.getAddress(), receiver, timeout);
    }

    public void acceptAppSocket(SocketAppSocket socket, int appId) throws AppSocketException {
        PastryAppl acceptorAppl = this.getMessageDispatch().getDestinationByAddress(appId);
        if (acceptorAppl == null) {
            throw new AppNotRegisteredException(appId);
        }
        if (!acceptorAppl.receiveSocket(socket)) {
            throw new NoReceiverAvailableException();
        }
    }

    public NodeHandle readNodeHandle(InputBuffer buf) throws IOException {
        return this.coalesce(SocketNodeHandle.build(buf));
    }

    public int proximity(NodeHandle nh) {
        if (nh.getNodeId().equals(this.getNodeId())) {
            return 0;
        }
        return this.getSocketSourceRouteManager().proximity(((SocketNodeHandle)nh).eaddress);
    }
}

