/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Observable;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.Id;
import rice.pastry.PastryNode;
import rice.pastry.dist.DistNodeHandle;
import rice.pastry.messaging.Message;
import rice.pastry.socket.EpochInetSocketAddress;
import rice.pastry.socket.SocketPastryNode;
import rice.pastry.socket.SocketSourceRouteManager;

public class SocketNodeHandle
extends DistNodeHandle {
    static final long serialVersionUID = -5452528188786429274L;
    public static final int LIVENESS_DEAD_FOREVER = 4;
    public static final int DEFAULT_PROXIMITY = 3600000;
    protected EpochInetSocketAddress eaddress;
    transient SocketSourceRouteManager.AddressManager addressManager;

    public SocketNodeHandle(EpochInetSocketAddress address, Id nodeId) {
        super(nodeId);
        this.eaddress = address;
    }

    public EpochInetSocketAddress getEpochAddress() {
        return this.eaddress;
    }

    public int getLiveness() {
        SocketPastryNode spn = (SocketPastryNode)this.getLocalNode();
        if (spn == null || this.getLocalNode().getLocalHandle() == null) {
            return 1;
        }
        if (this.isLocal()) {
            return 1;
        }
        EpochInetSocketAddress localEaddr = ((SocketNodeHandle)this.getLocalNode().getLocalHandle()).eaddress;
        if (localEaddr.addressEquals(this.eaddress) && this.eaddress.epoch != localEaddr.epoch) {
            return 4;
        }
        return spn.getSocketSourceRouteManager().getLiveness(this.eaddress);
    }

    public void markDeadForever() {
        SocketPastryNode spn = (SocketPastryNode)this.getLocalNode();
        spn.getSocketSourceRouteManager().getAddressManager(this.eaddress, false).markDeadForever();
    }

    public InetSocketAddress getAddress(InetAddress[] addressList) {
        return this.eaddress.getAddress(addressList);
    }

    public InetSocketAddress getAddress() {
        return this.eaddress.address[0];
    }

    public boolean checkLiveness() {
        SocketPastryNode spn = (SocketPastryNode)this.getLocalNode();
        if (spn != null) {
            spn.getSocketSourceRouteManager().checkLiveness(this.eaddress);
        }
        return this.isAlive();
    }

    public boolean isLocal() {
        this.assertLocalNode();
        return this.getLocalNode().getLocalHandle().equals(this);
    }

    public void receiveMessage(Message msg) {
        this.assertLocalNode();
        this.getLocalNode().send(this, msg);
    }

    public void bootstrap(Message msg) throws IOException {
        ((SocketPastryNode)this.getLocalNode()).getSocketSourceRouteManager().bootstrap(this.eaddress, msg);
    }

    public String toString() {
        return "[SNH: " + this.nodeId + "/" + this.eaddress + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SocketNodeHandle)) {
            return false;
        }
        SocketNodeHandle other = (SocketNodeHandle)obj;
        return other.getNodeId().equals(this.getNodeId()) && other.eaddress.equals(this.eaddress);
    }

    public int hashCode() {
        return this.getNodeId().hashCode() ^ this.eaddress.hashCode();
    }

    public int proximity() {
        PastryNode spn = this.getLocalNode();
        if (spn == null) {
            return 3600000;
        }
        return spn.proximity(this);
    }

    public boolean ping() {
        SocketPastryNode spn = (SocketPastryNode)this.getLocalNode();
        if (spn != null && spn.srManager != null) {
            spn.srManager.ping(this.eaddress);
        }
        return this.isAlive();
    }

    public void update(Observable o, Object obj) {
    }

    public void setNodeId(Id nodeId) {
        this.nodeId = nodeId;
    }

    public void setLocalNode(SocketPastryNode spn) {
        this.localnode = spn;
        this.logger = spn.getEnvironment().getLogManager().getLogger(this.getClass(), null);
    }

    static SocketNodeHandle build(InputBuffer buf) throws IOException {
        EpochInetSocketAddress eaddr = EpochInetSocketAddress.build(buf);
        Id nid = Id.build(buf);
        return new SocketNodeHandle(eaddr, nid);
    }

    public void serialize(OutputBuffer buf) throws IOException {
        this.eaddress.serialize(buf);
        this.nodeId.serialize(buf);
    }
}

