/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.PJavaSerializedMessage;
import rice.pastry.messaging.PRawMessage;
import rice.pastry.socket.SocketBuffer;
import rice.pastry.socket.SocketNodeHandle;
import rice.pastry.socket.SocketPastryNode;
import rice.pastry.socket.SourceRoute;

public class SocketChannelWriter {
    private final int MAXIMUM_QUEUE_LENGTH;
    private SocketPastryNode spn;
    private ByteBuffer buffer;
    private LinkedList queue;
    protected SourceRoute path;
    protected Environment environment;
    protected Logger logger;
    static long bytesWritten;

    public SocketChannelWriter(SocketPastryNode spn, SourceRoute path) {
        this(spn.getEnvironment(), path);
        this.spn = spn;
    }

    public SocketChannelWriter(Environment env, SourceRoute path) {
        this.environment = env;
        this.path = path;
        this.MAXIMUM_QUEUE_LENGTH = env.getParameters().getInt("pastry_socket_writer_max_queue_length");
        this.queue = new LinkedList();
        this.logger = this.environment.getLogManager().getLogger(SocketChannelWriter.class, null);
    }

    protected void setPath(SourceRoute path) {
        this.path = path;
    }

    public boolean isEmpty() {
        return this.buffer == null && this.queue.size() == 0;
    }

    public LinkedList getQueue() {
        return this.queue;
    }

    public boolean enqueue(Message msg) throws IOException {
        PRawMessage rm = msg instanceof PRawMessage ? (PRawMessage)msg : new PJavaSerializedMessage(msg);
        return this.enqueue(new SocketBuffer(rm));
    }

    public boolean enqueue(byte[] msg) {
        return this.enqueue(new SocketBuffer(msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueue(SocketBuffer o) {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.addToQueue(o);
            if (this.queue.size() > this.MAXIMUM_QUEUE_LENGTH) {
                Object remove = this.queue.removeLast();
                if (this.logger.level <= 900) {
                    this.logger.log("(W): Maximum TCP queue length of " + this.MAXIMUM_QUEUE_LENGTH + " reached to " + this.path + " - message " + remove + " will be dropped.");
                }
                return false;
            }
            if (this.queue.size() == this.MAXIMUM_QUEUE_LENGTH / 2 && this.logger.level <= 900) {
                this.logger.log("ERROR: Queue to " + this.path + " has " + this.queue.size() + " elements - probably a bad sign - enqueue of " + o);
            }
        }
        return true;
    }

    public void reset() {
        this.queue = new LinkedList();
        this.buffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean write(SocketChannel sc) throws IOException {
        while (true) {
            LinkedList linkedList = this.queue;
            synchronized (linkedList) {
                if (this.buffer == null) {
                    if (this.queue.isEmpty()) {
                        return true;
                    }
                    if (this.logger.level <= 400) {
                        this.logger.log("(W) About to serialize object " + this.queue.getFirst());
                    }
                    SocketBuffer sbuf = (SocketBuffer)this.queue.getFirst();
                    this.buffer = sbuf.getBuffer();
                    if (this.buffer == null) {
                        this.queue.removeFirst();
                        return this.write(sc);
                    }
                    if (this.spn != null) {
                        this.spn.broadcastSentListeners(sbuf.getInnermostAddress(), sbuf.getInnermostType(), this.path == null ? (InetSocketAddress)sc.socket().getRemoteSocketAddress() : this.path.getLastHop().getAddress(((SocketNodeHandle)this.spn.getLocalHandle()).eaddress), this.buffer.limit(), 0);
                    }
                    if (this.logger.level <= 400) {
                        this.logger.log("COUNT: Sent message " + sbuf + " of size " + this.buffer.limit() + " to " + this.path);
                    }
                }
                int j = this.buffer.limit();
                int i = sc.write(this.buffer);
                if (this.logger.level <= 400) {
                    this.logger.log("Wrote " + i + " of " + j + " bytes of message " + this.queue.getFirst() + " of size " + this.buffer.limit() + " to " + this.path);
                }
                if (this.logger.level <= 300) {
                    this.logger.log("(W) Wrote " + i + " of " + j + " bytes to " + sc.socket().getRemoteSocketAddress());
                }
                if (this.buffer.remaining() != 0) {
                    return false;
                }
                if (this.logger.level <= 400) {
                    this.logger.log("(W) Finished writing message " + this.queue.getFirst() + " - queue now contains " + (this.queue.size() - 1) + " items");
                }
                this.queue.removeFirst();
                this.buffer = null;
            }
        }
    }

    private void addToQueue(SocketBuffer buf) {
        if (this.queue.size() > 0) {
            int i;
            for (i = 1; i < this.queue.size(); ++i) {
                SocketBuffer p = (SocketBuffer)this.queue.get(i);
                if (p.priority > buf.priority) break;
            }
            if (this.logger.level <= 400) {
                this.logger.log("COUNT: Enqueueing message " + buf + " at location " + i + " in the pending queue (priority " + buf.priority + ")");
            }
            this.queue.add(i, buf);
        } else {
            this.queue.addLast(buf);
        }
    }
}

