/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import rice.environment.logging.Logger;
import rice.p2p.util.rawserialization.SimpleInputBuffer;
import rice.pastry.socket.EpochInetSocketAddress;
import rice.pastry.socket.SocketCollectionManager;
import rice.pastry.socket.SocketPastryNode;

public class SocketChannelRepeater {
    protected int REPEATER_BUFFER_SIZE;
    private static int HEADER_BUFFER_SIZE = 2;
    private boolean connected;
    private SocketPastryNode spn;
    private SocketChannel original;
    private SocketCollectionManager.SourceRouteManager manager;
    private ByteBuffer buffer1;
    private ByteBuffer buffer2;
    private ByteBuffer headerBuffer;
    private Logger logger;

    public SocketChannelRepeater(SocketPastryNode spn, SocketCollectionManager.SourceRouteManager manager) {
        this.spn = spn;
        this.logger = spn.getEnvironment().getLogManager().getLogger(SocketChannelRepeater.class, null);
        this.manager = manager;
        this.REPEATER_BUFFER_SIZE = spn.getEnvironment().getParameters().getInt("pastry_socket_repeater_buffer_size");
        this.headerBuffer = ByteBuffer.allocateDirect(HEADER_BUFFER_SIZE);
        this.buffer1 = ByteBuffer.allocateDirect(this.REPEATER_BUFFER_SIZE);
        this.buffer2 = ByteBuffer.allocateDirect(this.REPEATER_BUFFER_SIZE);
    }

    public static EpochInetSocketAddress decodeHeader(byte[] array) throws IOException {
        return SocketChannelRepeater.decodeHeader(array, 0);
    }

    public static EpochInetSocketAddress[] decodeFullHeader(byte[] array, int num) throws IOException {
        EpochInetSocketAddress[] ret = new EpochInetSocketAddress[num];
        SimpleInputBuffer ib = new SimpleInputBuffer(array);
        for (int i = 0; i < num; ++i) {
            ret[i] = EpochInetSocketAddress.build(ib);
        }
        return ret;
    }

    public static EpochInetSocketAddress decodeHeader(byte[] array, int offset) throws IOException {
        SimpleInputBuffer ib = new SimpleInputBuffer(array);
        for (int i = 0; i < offset; ++i) {
            EpochInetSocketAddress.build(ib);
        }
        return EpochInetSocketAddress.build(ib);
    }

    private ByteBuffer getBuffer(SocketChannel sc, boolean reading) {
        if (reading == (sc == this.original)) {
            return this.buffer1;
        }
        return this.buffer2;
    }

    public boolean read(SocketChannel sc) throws IOException {
        if (this.original == null) {
            this.original = sc;
        }
        if (!this.connected) {
            int read = sc.read(this.headerBuffer);
            if (read == -1) {
                throw new IOException("Error on read - the channel has been closed.");
            }
            if (this.headerBuffer.remaining() == 0) {
                if (this.headerBuffer.capacity() == HEADER_BUFFER_SIZE) {
                    this.headerBuffer.flip();
                    short lengthOfNextAddress = this.headerBuffer.asShortBuffer().get();
                    this.headerBuffer = ByteBuffer.allocateDirect(lengthOfNextAddress);
                    return this.read(sc);
                }
                this.processHeaderBuffer(sc);
                ByteBuffer buffer = this.getBuffer(sc, true);
                buffer.put(SocketCollectionManager.PASTRY_MAGIC_NUMBER);
                buffer.put(new byte[4]);
                buffer.flip();
                return true;
            }
            return false;
        }
        ByteBuffer buffer = this.getBuffer(sc, true);
        int read = sc.read(buffer);
        if (this.logger.level <= 400) {
            this.logger.log("Read " + read + " bytes of data..." + buffer.remaining());
        }
        this.spn.broadcastReceivedListeners(0, (short)0, (InetSocketAddress)sc.socket().getRemoteSocketAddress(), read, 16);
        if (read == -1) {
            throw new ClosedChannelException();
        }
        if (read > 0) {
            buffer.flip();
            return true;
        }
        return false;
    }

    public boolean write(SocketChannel sc) throws IOException {
        ByteBuffer buffer = this.getBuffer(sc, false);
        int j = buffer.limit();
        int i = sc.write(buffer);
        if (this.logger.level <= 400) {
            this.logger.log("Wrote " + i + " of " + j + " bytes to " + sc.socket().getRemoteSocketAddress());
        }
        this.spn.broadcastSentListeners(0, (short)0, (InetSocketAddress)sc.socket().getRemoteSocketAddress(), i, 16);
        if (buffer.remaining() == 0) {
            buffer.flip();
            buffer.clear();
            return true;
        }
        return false;
    }

    private void processHeaderBuffer(SocketChannel sc) throws IOException {
        this.headerBuffer.flip();
        byte[] headerArray = new byte[this.headerBuffer.capacity()];
        this.headerBuffer.get(headerArray);
        EpochInetSocketAddress address = SocketChannelRepeater.decodeHeader(headerArray);
        if (this.logger.level <= 500) {
            this.logger.log("Connecting SocketChannelRepeater to " + address + " from " + sc.socket().getRemoteSocketAddress());
        }
        this.manager.createConnection(address);
        this.connected = true;
    }
}

