/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.util.MathUtils;
import rice.pastry.NodeHandle;
import rice.pastry.NodeHandleFactory;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.PRawMessage;
import rice.pastry.messaging.RawMessageDelivery;
import rice.pastry.routing.RouteMessage;
import rice.pastry.routing.RouterAddress;
import rice.pastry.routing.SendOptions;
import rice.pastry.socket.EpochInetSocketAddress;
import rice.pastry.socket.SocketCollectionManager;
import rice.pastry.socket.SocketNodeHandle;
import rice.pastry.socket.SocketPastryNode;
import rice.pastry.socket.SourceRoute;

public class SocketBuffer
implements RawMessageDelivery {
    private MessageDeserializer defaultDeserializer;
    private NodeHandleFactory nhf;
    private SocketPastryNode spn;
    private int address;
    private short type;
    int priority;
    private NodeHandle sender;
    private SendOptions sendOpts;
    short rmSubType = (short)-2;
    int rmSubAddress = -2;
    byte[] bytes = null;
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final byte[] ZERO = new byte[8];
    SocketDataInputStream str;
    private ByteBuffer buffer;
    ExposedDataOutputStream o;
    ExposedByteArrayOutputStream ebaos;
    boolean discard = false;

    public SocketBuffer(MessageDeserializer defaultDeserializer, NodeHandleFactory nhf) {
        this.defaultDeserializer = defaultDeserializer;
        this.nhf = nhf;
        this.initialize(1024);
    }

    public SocketBuffer(byte[] input, SocketPastryNode spn) throws IOException {
        this.bytes = input;
        this.str = new SocketDataInputStream(new ByteArrayInputStream(input));
        this.nhf = spn;
        this.spn = spn;
        this.address = this.str.readInt();
        boolean hasSender = this.str.readBoolean();
        this.priority = this.str.readByte();
        this.type = this.str.readShort();
        if (hasSender) {
            this.sender = spn == null ? SocketNodeHandle.build(this.str) : spn.readNodeHandle(this.str);
        }
    }

    public SocketBuffer(EpochInetSocketAddress address, SourceRoute path, PRawMessage msg) throws IOException {
        this(address, path);
        this.serialize(msg, false);
    }

    private SocketBuffer(EpochInetSocketAddress address, SourceRoute path) throws IOException {
        int i;
        this.initialize(1024);
        this.o.write(SocketCollectionManager.PASTRY_MAGIC_NUMBER);
        this.o.writeInt(0);
        this.o.writeByte((byte)1);
        int numHops = path.getNumHops() + 1;
        this.o.writeByte((byte)numHops);
        short length = address.getSerializedLength();
        for (i = 0; i < path.getNumHops(); ++i) {
            length = (short)(length + path.getHop(i).getSerializedLength());
        }
        this.o.writeShort(length);
        address.serialize(this.o);
        for (i = 0; i < path.getNumHops(); ++i) {
            path.getHop(i).serialize(this.o);
        }
    }

    public SocketBuffer(SourceRoute path, int appId) throws IOException {
        this.initialize(1024);
        this.o.write(SocketCollectionManager.PASTRY_MAGIC_NUMBER);
        this.o.writeInt(0);
        for (int i = 1; i < path.getNumHops(); ++i) {
            this.o.write(SocketCollectionManager.HEADER_SOURCE_ROUTE, 0, SocketCollectionManager.HEADER_SOURCE_ROUTE.length);
            this.o.writeShort(path.getHop(i).getSerializedLength());
            path.getHop(i).serialize(this.o);
        }
        this.o.write(SocketCollectionManager.HEADER_DIRECT, 0, SocketCollectionManager.HEADER_DIRECT.length);
        this.o.write(MathUtils.intToByteArray(appId), 0, 4);
    }

    public SocketBuffer(byte[] output) {
        this.buffer = ByteBuffer.wrap(output);
        this.priority = -1;
        this.discard = true;
    }

    public SocketBuffer(PRawMessage rm) throws IOException {
        this.initialize(1024);
        this.serialize(rm, true);
    }

    protected void initialize(int size) {
        this.ebaos = new ExposedByteArrayOutputStream(size);
        this.o = new ExposedDataOutputStream(this.ebaos, size);
    }

    public boolean isRouteMessage() {
        return this.address == RouterAddress.getCode() && this.type == -23525;
    }

    public SendOptions getOptions() {
        return this.sendOpts;
    }

    public RouteMessage getRouteMessage() {
        try {
            return (RouteMessage)this.deserialize(null);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void serialize(PRawMessage msg, boolean reset) throws IOException {
        boolean includeSize = reset;
        if (reset) {
            this.o.reset();
            this.ebaos.reset();
        }
        int o_offset = this.o.bytesWritten();
        if (includeSize) {
            this.o.write(ZERO, 0, 4);
        }
        this.address = msg.getDestination();
        this.o.writeInt(this.address);
        this.sender = msg.getSender();
        boolean hasSender = this.sender != null;
        this.o.writeBoolean(hasSender);
        this.priority = msg.getPriority();
        if (this.priority > 127) {
            throw new IllegalStateException("Priority must be in the range of -128 to 127.  Lower values are higher priority. Priority of " + msg + " was " + this.priority + ".");
        }
        if (this.priority < -128) {
            throw new IllegalStateException("Priority must be in the range of -128 to 127.  Lower values are higher priority. Priority of " + msg + " was " + this.priority + ".");
        }
        this.o.writeByte((byte)this.priority);
        this.type = msg.getType();
        this.o.writeShort(this.type);
        if (this.isRouteMessage()) {
            RouteMessage rm = (RouteMessage)msg;
            this.sendOpts = rm.getOptions();
            this.rmSubAddress = rm.getAuxAddress();
            this.rmSubType = rm.getInternalType();
        }
        if (hasSender) {
            msg.getSender().serialize(this.o);
        }
        int amtToSkip = this.o.bytesWritten();
        msg.serialize(this.o);
        this.o.flush();
        int totalSize = this.ebaos.size();
        this.buffer = ByteBuffer.wrap(this.ebaos.buf());
        this.buffer.clear();
        if (includeSize) {
            this.buffer.position(o_offset);
            int messageSize = totalSize - 4;
            this.buffer.putInt(messageSize);
        }
        this.buffer.clear();
        this.buffer.limit(totalSize);
        this.str = new SocketDataInputStream(new ByteArrayInputStream(this.buffer.array()));
        int skipped = this.str.skipBytes(amtToSkip);
        if (skipped != amtToSkip) {
            throw new RuntimeException("Couldn't skip the right amount of bytes. Attempted:" + amtToSkip + " skipped:" + skipped);
        }
    }

    public ByteBuffer getBuffer() {
        if (this.buffer != null) {
            return this.buffer;
        }
        this.buffer = (ByteBuffer)ByteBuffer.wrap(this.ebaos.buf()).limit(this.o.bytesWritten());
        return this.buffer;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getAddress() {
        return this.address;
    }

    public Message deserialize(MessageDeserializer md) throws IOException {
        if (md == null) {
            md = this.defaultDeserializer;
        }
        if (this.isRouteMessage()) {
            RouteMessage rm = RouteMessage.build(this.str, this.nhf, this.spn);
            this.rmSubAddress = rm.getAuxAddress();
            this.rmSubType = rm.getInternalType();
            return rm;
        }
        Message m = (Message)md.deserialize(this.str, this.type, this.priority, this.sender);
        return m;
    }

    public short getInnermostType() {
        if (this.isRouteMessage()) {
            return this.rmSubType;
        }
        return this.type;
    }

    public int getInnermostAddress() {
        if (this.isRouteMessage()) {
            return this.rmSubAddress;
        }
        return this.address;
    }

    public short getType() {
        return this.type;
    }

    public void setType(short type) {
        this.type = type;
    }

    public String toString() {
        if (this.isRouteMessage()) {
            return "SocketBuffer[RouteMessage[" + this.rmSubType + "@" + this.rmSubAddress + "]]";
        }
        return "SocketBuffer a:" + this.address + " t:" + this.type;
    }

    static class SocketDataInputStream
    extends DataInputStream
    implements InputBuffer {
        public SocketDataInputStream(ByteArrayInputStream arg0) {
            super(arg0);
        }

        public int bytesRemaining() {
            try {
                return this.available();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return -1;
            }
        }
    }

    static class ExposedDataOutputStream
    extends DataOutputStream
    implements OutputBuffer {
        int capacity;

        public ExposedDataOutputStream(OutputStream sub, int capacity) {
            super(sub);
            this.capacity = capacity;
        }

        public int bytesRemaining() {
            return this.capacity - this.size();
        }

        public void reset() {
            this.written = 0;
        }

        public int bytesWritten() {
            return this.written;
        }

        public void writeByte(byte v) throws IOException {
            this.write(v);
        }

        public void writeChar(char v) throws IOException {
            this.writeChar((int)v);
        }

        public void writeShort(short v) throws IOException {
            this.writeShort((int)v);
        }
    }

    static class ExposedByteArrayOutputStream
    extends ByteArrayOutputStream {
        public ExposedByteArrayOutputStream(int size) {
            super(size);
        }

        public byte[] buf() {
            return this.buf;
        }
    }
}

