/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import rice.p2p.commonapi.appsocket.AppSocket;
import rice.p2p.commonapi.appsocket.AppSocketReceiver;
import rice.p2p.commonapi.exception.AppNotRegisteredException;
import rice.p2p.commonapi.exception.AppSocketException;
import rice.p2p.commonapi.exception.NoReceiverAvailableException;
import rice.p2p.commonapi.exception.TimeoutException;
import rice.pastry.socket.SocketBuffer;
import rice.pastry.socket.SocketCollectionManager;
import rice.pastry.socket.SourceRoute;
import rice.selector.SelectionKeyHandler;
import rice.selector.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketAppSocket
extends SelectionKeyHandler
implements AppSocket {
    public static final byte CONNECTION_UNKNOWN_ERROR = -1;
    public static final byte CONNECTION_UNKNOWN = -100;
    public static final byte CONNECTION_OK = 0;
    public static final byte CONNECTION_NO_APP = 1;
    public static final byte CONNECTION_NO_ACCEPTOR = 2;
    private final SocketCollectionManager manager;
    protected SelectionKey key;
    protected SocketChannel channel;
    protected AppSocketReceiver receiver;
    protected AppSocketReceiver reader;
    protected AppSocketReceiver writer;
    ByteBuffer toWrite;
    byte connectResult = (byte)-100;
    int appId;
    Hashtable timers = new Hashtable();

    public SocketAppSocket(SocketCollectionManager manager, SelectionKey key, int appId) throws IOException {
        this.appId = appId;
        this.manager = manager;
        this.acceptConnection(key);
    }

    public SocketAppSocket(SocketCollectionManager manager, SourceRoute path, int appId, AppSocketReceiver receiver, int timeout) throws IOException {
        this.appId = appId;
        this.receiver = receiver;
        this.manager = manager;
        if (manager.logger.level <= 500) {
            manager.logger.log("Opening connection with path " + path);
        }
        SocketBuffer sb = new SocketBuffer(path, appId);
        this.toWrite = sb.getBuffer();
        this.createConnection(path);
        this.startTimer(timeout, receiver);
    }

    public String toString() {
        return "SAS{" + this.appId + "}" + this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownOutput() {
        boolean closeMe = false;
        SocketAppSocket socketAppSocket = this;
        synchronized (socketAppSocket) {
            if (this.key == null) {
                throw new IllegalStateException("Socket already closed.");
            }
            try {
                if (this.manager.logger.level <= 500) {
                    this.manager.logger.log("Shutting down output on app connection " + this);
                }
                this.manager.appSocketClosed(this);
                if (this.channel != null) {
                    this.channel.socket().shutdownOutput();
                } else if (this.manager.logger.level <= 1000) {
                    this.manager.logger.log("ERROR: Unable to shutdown output on channel; channel is null!");
                }
            }
            catch (IOException e) {
                if (this.manager.logger.level <= 1000) {
                    this.manager.logger.log("ERROR: Received exception " + e + " while shutting down output.");
                }
                closeMe = true;
            }
        }
        this.manager.pastryNode.getEnvironment().getSelectorManager().modifyKey(this.key);
        if (closeMe) {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        List<AppSocketReceiver> timers = null;
        InetSocketAddress myAddress = null;
        SocketAppSocket socketAppSocket = this;
        synchronized (socketAppSocket) {
            block12: {
                if (!this.manager.pastryNode.getEnvironment().getSelectorManager().isSelectorThread()) {
                    this.manager.pastryNode.getEnvironment().getSelectorManager().invoke(new Runnable(){

                        public void run() {
                            SocketAppSocket.this.close();
                        }
                    });
                }
                if (this.key == null) {
                    if (this.manager.logger.level <= 900) {
                        this.manager.logger.log("Already closed connection with " + this);
                    }
                    return;
                }
                try {
                    if (this.manager.logger.level <= 500) {
                        this.manager.logger.log("Closing connection with " + this);
                    }
                    this.manager.appSocketClosed(this);
                    this.key.cancel();
                    this.key.attach(null);
                    this.key = null;
                    this.manager.unIdentifiedSM.remove(this);
                    if (this.channel != null) {
                        myAddress = (InetSocketAddress)this.channel.socket().getRemoteSocketAddress();
                        this.channel.close();
                        this.channel = null;
                    }
                }
                catch (IOException e) {
                    if (this.manager.logger.level > 1000) break block12;
                    this.manager.logger.log("ERROR: Recevied exception " + e + " while closing socket!");
                }
            }
            timers = this.cancelTimers();
        }
        if (this.manager.pastryNode != null) {
            this.manager.pastryNode.broadcastChannelClosed(myAddress);
        }
        for (AppSocketReceiver rec : timers) {
            rec.receiveException(this, new TimeoutException());
        }
    }

    private List<AppSocketReceiver> cancelTimers() {
        ArrayList<AppSocketReceiver> list = new ArrayList<AppSocketReceiver>();
        Iterator i = this.timers.keySet().iterator();
        while (i.hasNext()) {
            AppSocketReceiver rec = (AppSocketReceiver)i.next();
            list.add(rec);
            TimerTask timer = (TimerTask)this.timers.get(rec);
            timer.cancel();
            i.remove();
        }
        return list;
    }

    @Override
    public synchronized void modifyKey(SelectionKey key) {
        int flag = 0;
        if (this.reader != null) {
            flag |= 1;
        }
        if (this.writer != null) {
            flag |= 4;
        }
        if (this.toWrite != null) {
            flag |= 4;
        }
        if (this.connectResult == -100) {
            flag |= 1;
        }
        key.interestOps(flag);
    }

    @Override
    public void connect(SelectionKey key) {
        try {
            if (this.channel.finishConnect()) {
                key.interestOps(key.interestOps() & 0xFFFFFFF7);
            }
            if (this.manager.logger.level <= 500) {
                this.manager.logger.log("(SM) Found connectable channel - completed connection");
            }
        }
        catch (Exception e) {
            if (this.manager.logger.level <= 500) {
                this.manager.logger.logException("(SM) Unable to connect to " + this, e);
            }
            this.exceptionAndClose(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(SelectionKey key) {
        AppSocketReceiver temp = null;
        SocketAppSocket socketAppSocket = this;
        synchronized (socketAppSocket) {
            if (this.connectResult == -100) {
                try {
                    this.clearTimer(this.receiver);
                    this.manager.pastryNode.getEnvironment().getSelectorManager().modifyKey(key);
                    ByteBuffer answer = ByteBuffer.allocate(1);
                    ((SocketChannel)key.channel()).read(answer);
                    answer.clear();
                    this.connectResult = answer.get();
                    switch (this.connectResult) {
                        case 0: {
                            this.receiver.receiveSocket(this);
                            return;
                        }
                        case 1: {
                            this.exceptionAndClose(new AppNotRegisteredException(this.appId));
                            return;
                        }
                        case 2: {
                            this.exceptionAndClose(new NoReceiverAvailableException());
                            return;
                        }
                    }
                    this.exceptionAndClose(new AppSocketException("Unknown error " + this.connectResult));
                    return;
                }
                catch (IOException ioe) {
                    this.exceptionAndClose(ioe);
                    return;
                }
            }
            if (this.reader == null) {
                key.interestOps(key.interestOps() & 0xFFFFFFFE);
                return;
            }
            temp = this.reader;
            this.clearTimer(this.reader);
            this.reader = null;
        }
        temp.receiveSelectResult(this, true, false);
        this.manager.pastryNode.getEnvironment().getSelectorManager().modifyKey(key);
    }

    private void startTimer(int millis, final AppSocketReceiver theReceiver) {
        if (this.key == null) {
            throw new IllegalStateException("Socket " + this + " already Closed");
        }
        if (millis <= 0) {
            return;
        }
        this.clearTimer(theReceiver);
        TimerTask timer = new TimerTask(){

            public void run() {
                SocketAppSocket.this.timers.remove(theReceiver);
                theReceiver.receiveException(SocketAppSocket.this, new TimeoutException());
                SocketAppSocket.this.close();
            }
        };
        this.timers.put(theReceiver, timer);
        this.manager.pastryNode.getEnvironment().getSelectorManager().getTimer().schedule(timer, millis);
    }

    private void clearTimer(AppSocketReceiver theReceiver) {
        if (theReceiver == null) {
            return;
        }
        TimerTask timer = (TimerTask)this.timers.remove(theReceiver);
        if (timer == null) {
            return;
        }
        timer.cancel();
        timer = null;
    }

    private void exceptionAndClose(Exception e) {
        this.clearTimer(this.receiver);
        this.receiver.receiveException(this, e);
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(SelectionKey key) {
        AppSocketReceiver temp = null;
        SocketAppSocket socketAppSocket = this;
        synchronized (socketAppSocket) {
            if (this.toWrite != null) {
                try {
                    ((SocketChannel)key.channel()).write(this.toWrite);
                }
                catch (IOException ioe) {
                    this.exceptionAndClose(ioe);
                }
                if (this.toWrite.hasRemaining()) {
                    return;
                }
                this.toWrite = null;
            }
            if (this.writer == null) {
                key.interestOps(key.interestOps() & 0xFFFFFFFB);
                return;
            }
            temp = this.writer;
            this.clearTimer(this.writer);
            this.writer = null;
        }
        temp.receiveSelectResult(this, false, true);
        this.manager.pastryNode.getEnvironment().getSelectorManager().modifyKey(key);
    }

    protected void acceptConnection(SelectionKey key) throws IOException {
        this.connectResult = 0;
        this.channel = (SocketChannel)key.channel();
        this.key = this.manager.pastryNode.getEnvironment().getSelectorManager().register(key.channel(), this, 0);
        this.toWrite = ByteBuffer.allocate(1);
        try {
            this.manager.pastryNode.acceptAppSocket(this, this.appId);
            this.toWrite.put((byte)0);
        }
        catch (AppNotRegisteredException anre) {
            if (this.manager.logger.level <= 900) {
                this.manager.logger.log("Sending error to connecter " + this.channel + " " + anre);
            }
            this.toWrite.put((byte)1);
        }
        catch (NoReceiverAvailableException nrae) {
            if (this.manager.logger.level <= 900) {
                this.manager.logger.log("Sending error to connecter " + this.channel + " " + nrae);
            }
            this.toWrite.put((byte)2);
        }
        catch (AppSocketException ase) {
            if (this.manager.logger.level <= 900) {
                this.manager.logger.log("Sending error to connecter " + this.channel + " " + ase);
            }
            this.toWrite.put((byte)-1);
        }
        this.toWrite.clear();
        key.interestOps(key.interestOps() | 4);
        if (this.manager.logger.level <= 500) {
            this.manager.logger.log("(SM) Accepted app connection from " + this.channel.socket().getRemoteSocketAddress());
        }
    }

    protected void createConnection(SourceRoute path) throws IOException {
        this.channel = SocketChannel.open();
        this.channel.socket().setSendBufferSize(this.manager.SOCKET_BUFFER_SIZE);
        this.channel.socket().setReceiveBufferSize(this.manager.SOCKET_BUFFER_SIZE);
        this.channel.configureBlocking(false);
        this.key = this.manager.pastryNode.getEnvironment().getSelectorManager().register(this.channel, this, 0);
        if (this.manager.logger.level <= 500) {
            this.manager.logger.log("(SM) Initiating socket connection to path " + path);
        }
        this.manager.pastryNode.broadcastChannelOpened(path.getFirstHop().getAddress(this.manager.localAddress), 6);
        if (this.channel.connect(path.getFirstHop().getAddress(this.manager.localAddress))) {
            this.key.interestOps(5);
        } else {
            this.key.interestOps(13);
        }
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.channel.read(dsts, offset, length);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.channel.write(srcs, offset, length);
    }

    @Override
    public synchronized void register(boolean wantToRead, boolean wantToWrite, int timeout, AppSocketReceiver receiver) {
        if (this.key == null) {
            throw new IllegalStateException("Socket " + this + " is already closed.");
        }
        if (wantToWrite && this.writer != null && this.writer != receiver) {
            throw new IllegalStateException("Already registered " + this.writer + " for writing, you can't register " + receiver + " for writing as well!");
        }
        if (wantToRead) {
            if (this.reader != null && this.reader != receiver) {
                throw new IllegalStateException("Already registered " + this.reader + " for reading, you can't register " + receiver + " for reading as well!");
            }
            this.reader = receiver;
        }
        if (wantToWrite) {
            this.writer = receiver;
        }
        this.startTimer(timeout, receiver);
        this.manager.pastryNode.getEnvironment().getSelectorManager().modifyKey(this.key);
    }
}

