/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.routing;

import java.io.IOException;
import java.io.Serializable;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeHandleFactory;
import rice.pastry.PastryNode;
import rice.pastry.commonapi.PastryEndpointMessage;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.PJavaSerializedDeserializer;
import rice.pastry.messaging.PJavaSerializedMessage;
import rice.pastry.messaging.PRawMessage;
import rice.pastry.routing.RouterAddress;
import rice.pastry.routing.SendOptions;

public class RouteMessage
extends PRawMessage
implements Serializable,
rice.p2p.commonapi.RouteMessage {
    private static final long serialVersionUID = 3492981895989180093L;
    public static final short TYPE = -23525;
    private Id target;
    private NodeHandle prevNode;
    private transient SendOptions opts;
    private int auxAddress;
    public transient NodeHandle nextHop;
    private Message internalMsg;
    private PRawMessage rawInternalMsg = null;
    private InputBuffer serializedMsg;
    private NodeHandleFactory nhf;
    PastryNode pn;
    boolean hasSender;
    byte internalPriority;
    short internalType;
    private RMDeserializer endpointDeserializer = new RMDeserializer();

    public RouteMessage(Id target, Message msg) {
        this(target, msg, null, null);
    }

    public RouteMessage(Id target, Message msg, SendOptions opts) {
        this(target, msg, null, opts);
    }

    public RouteMessage(NodeHandle dest, Message msg, SendOptions opts) {
        this(dest.getNodeId(), msg, dest, opts);
    }

    public RouteMessage(Id target, Message msg, NodeHandle firstHop) {
        this(target, msg, firstHop, null);
    }

    private static PRawMessage convert(Message msg) {
        if (msg instanceof PRawMessage) {
            PRawMessage prm = (PRawMessage)msg;
            if (prm.getType() == 0) {
                throw new RuntimeException("Cannot route a PJavaSerializedMessage, this is used internally in RouteMessage.");
            }
            return prm;
        }
        return new PJavaSerializedMessage(msg);
    }

    public RouteMessage(Id target, PRawMessage msg, NodeHandle firstHop, SendOptions opts) {
        this(target, (Message)msg, firstHop, opts);
        this.rawInternalMsg = msg;
        if (msg != null) {
            this.internalType = msg.getType();
        }
    }

    public RouteMessage(Id target, Message msg, NodeHandle firstHop, SendOptions opts) {
        super(RouterAddress.getCode());
        this.target = target;
        this.internalMsg = msg;
        this.nextHop = firstHop;
        this.opts = opts;
        if (this.opts == null) {
            this.opts = new SendOptions();
        }
        if (msg != null) {
            this.auxAddress = msg.getDestination();
        }
    }

    public boolean routeMessage(NodeHandle localHandle) {
        if (this.nextHop == null) {
            return false;
        }
        this.setSender(localHandle);
        NodeHandle handle = this.nextHop;
        this.nextHop = null;
        this.prevNode = localHandle;
        if (localHandle.equals(handle)) {
            localHandle.getLocalNode().send(handle, this.internalMsg);
        } else {
            localHandle.getLocalNode().send(handle, this);
        }
        return true;
    }

    public Id getTarget() {
        return this.target;
    }

    public NodeHandle getPrevNode() {
        return this.prevNode;
    }

    public void setPrevNode(NodeHandle n) {
        this.prevNode = n;
    }

    public NodeHandle getNextHop() {
        return this.nextHop;
    }

    public void setNextHop(NodeHandle nh) {
        this.nextHop = nh;
    }

    public int getPriority() {
        if (this.internalMsg != null) {
            return this.internalMsg.getPriority();
        }
        return this.internalPriority;
    }

    public int getDestination() {
        if (this.nextHop == null || this.auxAddress == 0) {
            return super.getDestination();
        }
        return this.auxAddress;
    }

    public Message unwrap() {
        if (this.internalMsg != null) {
            return this.internalMsg;
        }
        try {
            this.endpointDeserializer.setSubDeserializer(this.endpointDeserializer);
            return this.unwrap(this.endpointDeserializer);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public SendOptions getOptions() {
        if (this.opts == null) {
            this.opts = new SendOptions();
        }
        return this.opts;
    }

    public String toString() {
        if (this.internalMsg == null) {
            return "[ serialized{" + this.auxAddress + "," + this.internalType + "} ]";
        }
        String str = "[ " + this.internalMsg + " ]";
        return str;
    }

    public rice.p2p.commonapi.Id getDestinationId() {
        return this.getTarget();
    }

    public rice.p2p.commonapi.NodeHandle getNextHopHandle() {
        return this.nextHop;
    }

    public rice.p2p.commonapi.Message getMessage() {
        return ((PastryEndpointMessage)this.unwrap()).getMessage();
    }

    public rice.p2p.commonapi.Message getMessage(MessageDeserializer md) throws IOException {
        this.endpointDeserializer.setSubDeserializer(md);
        return ((PastryEndpointMessage)this.unwrap(this.endpointDeserializer)).getMessage();
    }

    public void setDestinationId(rice.p2p.commonapi.Id id) {
        this.target = (Id)id;
    }

    public void setNextHopHandle(rice.p2p.commonapi.NodeHandle nextHop) {
        this.nextHop = (NodeHandle)nextHop;
    }

    public void setMessage(rice.p2p.commonapi.Message message) {
        ((PastryEndpointMessage)this.unwrap()).setMessage(message);
    }

    public void setMessage(RawMessage message) {
        ((PastryEndpointMessage)this.unwrap()).setMessage(message);
    }

    public static RouteMessage build(InputBuffer buf, NodeHandleFactory nhf, PastryNode pn) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                int auxAddress = buf.readInt();
                Id target = Id.build(buf);
                NodeHandle prev = nhf.readNodeHandle(buf);
                return new RouteMessage(target, auxAddress, prev, buf, nhf, pn);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }

    public RouteMessage(Id target, int auxAddress, NodeHandle prev, InputBuffer buf, NodeHandleFactory nhf, PastryNode pn) throws IOException {
        this(target, null, null, null);
        this.hasSender = buf.readBoolean();
        this.internalPriority = buf.readByte();
        this.internalType = buf.readShort();
        this.prevNode = prev;
        this.serializedMsg = buf;
        this.nhf = nhf;
        this.pn = pn;
        this.auxAddress = auxAddress;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        buf.writeInt(this.auxAddress);
        this.target.serialize(buf);
        this.prevNode.serialize(buf);
        if (this.serializedMsg != null) {
            buf.writeBoolean(this.hasSender);
            buf.writeByte(this.internalPriority);
            byte[] raw = new byte[this.serializedMsg.bytesRemaining()];
            this.serializedMsg.read(raw);
            buf.write(raw, 0, raw.length);
            this.serializedMsg = null;
        } else {
            NodeHandle sender;
            boolean hasSender;
            if (this.rawInternalMsg == null) {
                this.rawInternalMsg = RouteMessage.convert(this.internalMsg);
            }
            boolean bl = hasSender = (sender = this.rawInternalMsg.getSender()) != null;
            if (hasSender) {
                buf.writeBoolean(true);
            } else {
                buf.writeBoolean(false);
            }
            int priority = this.rawInternalMsg.getPriority();
            if (priority > 127) {
                throw new IllegalStateException("Priority must be in the range of -128 to 127.  Lower values are higher priority. Priority of " + this.rawInternalMsg + " was " + priority + ".");
            }
            if (priority < -128) {
                throw new IllegalStateException("Priority must be in the range of -128 to 127.  Lower values are higher priority. Priority of " + this.rawInternalMsg + " was " + priority + ".");
            }
            buf.writeByte((byte)priority);
            buf.writeShort(this.rawInternalMsg.getType());
            if (hasSender) {
                sender.serialize(buf);
            }
            this.rawInternalMsg.serialize(buf);
        }
    }

    public Message unwrap(MessageDeserializer md) throws IOException {
        if (this.internalMsg != null) {
            return this.internalMsg;
        }
        NodeHandle internalSender = null;
        if (this.hasSender) {
            internalSender = this.nhf.readNodeHandle(this.serializedMsg);
        }
        this.internalMsg = (Message)md.deserialize(this.serializedMsg, this.internalType, this.internalPriority, internalSender);
        this.serializedMsg = null;
        this.nhf = null;
        return this.internalMsg;
    }

    public short getType() {
        return -23525;
    }

    public int getAuxAddress() {
        return this.auxAddress;
    }

    public short getInternalType() {
        if (this.rawInternalMsg != null) {
            return this.rawInternalMsg.getType();
        }
        if (this.internalMsg != null) {
            if (this.internalMsg instanceof RawMessage) {
                return ((RawMessage)((Object)this.internalMsg)).getType();
            }
            return 0;
        }
        return -1;
    }

    class RMDeserializer
    extends PJavaSerializedDeserializer {
        MessageDeserializer sub;

        public RMDeserializer() {
            super(null);
        }

        public void setSubDeserializer(MessageDeserializer md) {
            this.sub = md;
        }

        public Message deserialize(InputBuffer buf, short type, int priority, NodeHandle sender) throws IOException {
            this.pn = RouteMessage.this.pn;
            switch (type) {
                case 2: {
                    return new PastryEndpointMessage(RouteMessage.this.auxAddress, buf, this.sub, sender);
                }
            }
            return null;
        }
    }
}

