/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.leafset.testing;

import java.io.IOException;
import java.util.ArrayList;
import rice.environment.Environment;
import rice.p2p.commonapi.appsocket.AppSocketReceiver;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeSetEventSource;
import rice.pastry.NodeSetListener;
import rice.pastry.PastryNode;
import rice.pastry.ScheduledMessage;
import rice.pastry.client.PastryAppl;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Message;
import rice.pastry.routing.RoutingTable;

public class MergeTest {
    public static LeafSet getLeafSet(String str) {
        String[] a = str.split("\\[");
        assert (a.length == 2);
        String[] b = a[1].split("]");
        assert (b.length == 2);
        String s_ccw = a[0];
        String s_cw = b[1];
        String s_base = b[0];
        NodeHandle[] ccw = MergeTest.getHandles(s_ccw);
        MergeTest.flip(ccw);
        NodeHandle base = MergeTest.getHandles(s_base)[0];
        NodeHandle[] cw = MergeTest.getHandles(s_cw);
        LeafSet ls = new LeafSet(base, 24, true, cw, ccw);
        return ls;
    }

    public static void flip(NodeHandle[] nds) {
        for (int a = 0; a < nds.length / 2; ++a) {
            int b = nds.length - a - 1;
            NodeHandle temp = nds[a];
            nds[a] = nds[b];
            nds[b] = temp;
        }
    }

    public static NodeHandle[] getHandles(String str) {
        ArrayList<TestNodeHandle> list = new ArrayList<TestNodeHandle>();
        String[] a = str.split("[< ]");
        for (int ctr = 0; ctr < a.length; ++ctr) {
            if (a[ctr].length() <= 3) continue;
            assert (a[ctr].substring(0, 2).equals("0x"));
            assert (a[ctr].substring(a[ctr].length() - 3, a[ctr].length()).equals("..>"));
            a[ctr] = a[ctr].substring(2, a[ctr].length() - 3);
            list.add(new TestNodeHandle(Id.build(a[ctr])));
        }
        return list.toArray(new NodeHandle[0]);
    }

    public static void main(String[] args) {
        Environment env = new Environment();
        String s_ls1 = "<0xD74D4F..><0xD7B075..><0xD98A9D..><0xDAC7F0..><0xDB39A6..><0xDD5A73..><0xE050B3..><0xE0B735..><0xE33A04..><0xE48D40..><0xE678CB..><0xE73F09..> [ <0xEA5EAF..> ] <0xEBC2BB..><0xEBD2CB..><0xEF7F43..><0xF09044..><0xF10B96..><0xF33C36..><0xF64DA9..><0xF66CD9..><0xF9E251..><0xFB7F46..><0xFC1B02..><0xFC4718..>";
        LeafSet ls1 = MergeTest.getLeafSet(s_ls1);
        String s_ls2 = " [ <0xEA1020..> ] ";
        LeafSet ls2 = MergeTest.getLeafSet(s_ls2);
        PastryNode pn = new PastryNode((Id)ls2.get(0).getId(), env){

            public NodeHandle readNodeHandle(InputBuffer buf) throws IOException {
                return null;
            }

            public void send(NodeHandle handle, Message message) {
            }

            public ScheduledMessage scheduleMsgAtFixedRate(Message msg, long delay, long period) {
                return null;
            }

            public ScheduledMessage scheduleMsg(Message msg, long delay) {
                return null;
            }

            public ScheduledMessage scheduleMsg(Message msg, long delay, long period) {
                return null;
            }

            public int proximity(NodeHandle nh) {
                return 0;
            }

            public void nodeIsReady() {
            }

            public void initiateJoin(NodeHandle[] bootstrap) {
            }

            public void connect(NodeHandle handle, AppSocketReceiver receiver, PastryAppl appl, int timeout) {
            }

            public NodeHandle coalesce(NodeHandle newHandle) {
                return null;
            }
        };
        RoutingTable rt = new RoutingTable(ls2.get(0), 1, 4, pn);
        ls2.addNodeSetListener(new NodeSetListener(){

            public void nodeSetUpdate(NodeSetEventSource nodeSetEventSource, NodeHandle handle, boolean added) {
                System.out.println("nodeSetUpdate(" + handle + "," + added + ")");
            }
        });
        ls2.merge(ls1, ls1.get(0), rt, false, null);
        env.destroy();
    }

    public static class TestNodeHandle
    extends NodeHandle {
        private Id id;

        public TestNodeHandle(Id id) {
            this.id = id;
        }

        public Id getNodeId() {
            return this.id;
        }

        public int getLiveness() {
            return 1;
        }

        public int proximity() {
            return 1;
        }

        public boolean ping() {
            return true;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TestNodeHandle) {
                return ((TestNodeHandle)obj).id.equals(this.id);
            }
            return false;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public void receiveMessage(Message m) {
        }

        public String toString() {
            return this.id.toString();
        }

        public void serialize(OutputBuffer buf) throws IOException {
            throw new RuntimeException("not implemented.");
        }
    }
}

