/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import rice.environment.logging.Logger;
import rice.pastry.direct.Delivery;
import rice.pastry.direct.DirectNodeHandle;
import rice.pastry.direct.DirectPastryNode;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.messaging.Message;

class MessageDelivery
implements Delivery {
    protected Message msg;
    protected DirectPastryNode node;
    protected Logger logger;
    protected int seq;
    NetworkSimulator networkSimulator;
    DirectNodeHandle from;

    public MessageDelivery(Message m, DirectPastryNode pn, DirectNodeHandle from, NetworkSimulator sim) {
        this.msg = m;
        this.node = pn;
        this.from = from;
        this.networkSimulator = sim;
        this.seq = pn.seq++;
        this.logger = pn.getLogger();
    }

    public void deliver() {
        if (this.logger.level <= 500) {
            this.logger.log("MD: deliver " + this.msg + " to " + this.node);
        }
        this.node.receiveMessage(this.msg);
        this.networkSimulator.notifySimulatorListenersReceived(this.msg, this.from, this.node.getLocalHandle());
    }

    public int getSeq() {
        return this.seq;
    }
}

