/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.direct.DirectPastryNode;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.messaging.Message;

public class DirectNodeHandle
extends NodeHandle
implements Observer {
    private transient DirectPastryNode remoteNode;
    public transient NetworkSimulator simulator;

    DirectNodeHandle(DirectPastryNode ln, DirectPastryNode rn, NetworkSimulator sim) {
        this.localnode = ln;
        this.logger = ln.getEnvironment().getLogManager().getLogger(this.getClass(), null);
        if (rn == null) {
            throw new IllegalArgumentException("rn must be non-null");
        }
        this.remoteNode = rn;
        this.simulator = sim;
        rn.addObserver(this);
    }

    public DirectPastryNode getRemote() {
        return this.remoteNode;
    }

    public Id getNodeId() {
        return this.remoteNode.getNodeId();
    }

    public int getLiveness() {
        if (this.remoteNode.isAlive()) {
            return 1;
        }
        return 3;
    }

    public NetworkSimulator getSimulator() {
        return this.simulator;
    }

    public void notifyObservers(Object arg) {
        this.setChanged();
        super.notifyObservers(arg);
    }

    public boolean ping() {
        return this.isAlive();
    }

    public final void assertLocalNode() {
        if (DirectPastryNode.getCurrentNode() == null) {
            throw new RuntimeException("PANIC: localnode is null in " + this + "@" + System.identityHashCode(this));
        }
    }

    public int proximity() {
        this.assertLocalNode();
        return this.getLocalNode().proximity(this);
    }

    public void receiveMessage(Message msg) {
        DirectPastryNode.getCurrentNode().send(this, msg);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return this.getNodeId().hashCode();
    }

    public String toString() {
        return "[DNH " + this.getNodeId() + "]";
    }

    public void update(Observable arg0, Object arg1) {
        if (!this.remoteNode.isAlive()) {
            this.notifyObservers(NodeHandle.DECLARED_DEAD);
        }
    }

    public void serialize(OutputBuffer buf) throws IOException {
        throw new RuntimeException("Should not be called.");
    }
}

