/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.environment.params.Parameters;
import rice.environment.random.RandomSource;
import rice.environment.random.simple.SimpleRandomSource;
import rice.environment.time.TimeSource;
import rice.environment.time.simulated.DirectTimeSource;
import rice.p2p.commonapi.CancellableTask;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.ScheduledMessage;
import rice.pastry.direct.Delivery;
import rice.pastry.direct.DeliveryTimerTask;
import rice.pastry.direct.DirectNodeHandle;
import rice.pastry.direct.DirectPastryNode;
import rice.pastry.direct.DirectTimerTask;
import rice.pastry.direct.MessageDelivery;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.direct.NodeRecord;
import rice.pastry.direct.SimulatorListener;
import rice.pastry.direct.TestRecord;
import rice.pastry.messaging.Message;
import rice.selector.SelectorManager;
import rice.selector.TimerTask;

public abstract class BasicNetworkSimulator
implements NetworkSimulator {
    Vector nodes = new Vector();
    Environment environment;
    TimeSource timeSource;
    private boolean isDirectTimeSource = false;
    private TestRecord testRecord;
    protected Logger logger;
    protected RandomSource random;
    protected int MIN_DELAY = 1;
    protected SelectorManager manager;
    protected final int maxDiameter;
    protected final int minDelay;
    boolean running = false;
    long maxSpeedRequestSystemTime = 0L;
    long maxSpeedRequestSimTime = 0L;
    float maxSpeed = 0.0f;
    boolean printedDirectTimeSourceWarning = false;
    List<SimulatorListener> listeners = new ArrayList<SimulatorListener>();

    public BasicNetworkSimulator(Environment env) {
        this.environment = env;
        this.manager = this.environment.getSelectorManager();
        this.manager.useLoopListeners(false);
        Parameters params = env.getParameters();
        this.maxDiameter = params.getInt("pastry_direct_max_diameter");
        this.minDelay = params.getInt("pastry_direct_min_delay");
        this.random = params.contains("pastry_direct_use_own_random") && params.getBoolean("pastry_direct_use_own_random") ? (params.contains("pastry_direct_random_seed") && !params.getString("pastry_direct_random_seed").equalsIgnoreCase("clock") ? new SimpleRandomSource(params.getLong("pastry_direct_random_seed"), env.getLogManager(), "direct") : new SimpleRandomSource(env.getLogManager(), "direct")) : env.getRandomSource();
        this.logger = env.getLogManager().getLogger(this.getClass(), null);
        this.timeSource = env.getTimeSource();
        if (this.timeSource instanceof DirectTimeSource) {
            this.isDirectTimeSource = true;
        }
        this.manager.setSelect(false);
        this.testRecord = null;
        this.start();
    }

    public void start() {
        this.manager.invoke(new Runnable(){

            public void run() {
                if (BasicNetworkSimulator.this.running) {
                    return;
                }
                BasicNetworkSimulator.this.running = true;
                BasicNetworkSimulator.this.manager.invoke(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        if (!BasicNetworkSimulator.this.running) {
                            return;
                        }
                        try {
                            if (!BasicNetworkSimulator.this.simulate()) {
                                SelectorManager selectorManager = BasicNetworkSimulator.this.manager;
                                synchronized (selectorManager) {
                                    try {
                                        BasicNetworkSimulator.this.manager.wait(100L);
                                    }
                                    catch (InterruptedException ie) {
                                        BasicNetworkSimulator.this.logger.logException("BasicNetworkSimulator interrupted.", ie);
                                    }
                                }
                            }
                            BasicNetworkSimulator.this.manager.invoke(this);
                        }
                        catch (InterruptedException ie) {
                            if (BasicNetworkSimulator.this.logger.level <= 1000) {
                                BasicNetworkSimulator.this.logger.logException("BasicNetworkSimulator.start()", ie);
                            }
                            BasicNetworkSimulator.this.stop();
                        }
                    }
                });
            }
        });
    }

    public void stop() {
        this.manager.invoke(new Runnable(){

            public void run() {
                BasicNetworkSimulator.this.running = false;
            }
        });
    }

    public TestRecord getTestRecord() {
        return this.testRecord;
    }

    public void setTestRecord(TestRecord tr) {
        this.testRecord = tr;
    }

    private void addTask(TimerTask dtt) {
        if (this.logger.level <= 500) {
            this.logger.log("addTask(" + dtt + ")");
        }
        this.manager.getTimer().schedule(dtt);
    }

    public CancellableTask enqueueDelivery(Delivery d, int delay) {
        long time = this.timeSource.currentTimeMillis() + (long)delay;
        if (this.logger.level <= 500) {
            this.logger.log("BNS: enqueueDelivery " + d + ":" + time);
        }
        DeliveryTimerTask dtt = null;
        dtt = new DeliveryTimerTask(d, time, d.getSeq());
        this.addTask(dtt);
        return dtt;
    }

    public ScheduledMessage deliverMessage(Message msg, DirectPastryNode node) {
        if (this.logger.level <= 500) {
            this.logger.log("BNS: deliver " + msg + " to " + node);
        }
        DirectTimerTask dtt = null;
        DirectNodeHandle sender = null;
        sender = (DirectNodeHandle)msg.getSender();
        if (sender == null || sender.isAlive()) {
            MessageDelivery md = new MessageDelivery(msg, node, (DirectNodeHandle)node.getLocalHandle(), this);
            dtt = new DirectTimerTask(md, this.timeSource.currentTimeMillis());
            this.addTask(dtt);
        }
        return dtt;
    }

    public ScheduledMessage deliverMessage(Message msg, DirectPastryNode node, DirectNodeHandle from, int delay) {
        if (this.logger.level <= 500) {
            this.logger.log("BNS: deliver(" + delay + ") " + msg + " to " + node);
        }
        DirectTimerTask dtt = null;
        DirectNodeHandle sender = null;
        sender = (DirectNodeHandle)msg.getSender();
        if (sender == null || sender.isAlive()) {
            MessageDelivery md = new MessageDelivery(msg, node, from, this);
            dtt = new DirectTimerTask(md, this.timeSource.currentTimeMillis() + (long)delay);
            this.addTask(dtt);
        }
        return dtt;
    }

    public ScheduledMessage deliverMessage(Message msg, DirectPastryNode node, DirectNodeHandle from, int delay, int period) {
        DirectTimerTask dtt = null;
        DirectNodeHandle sender = null;
        sender = (DirectNodeHandle)msg.getSender();
        if (sender == null || sender.isAlive()) {
            MessageDelivery md = new MessageDelivery(msg, node, from, this);
            dtt = new DirectTimerTask(md, this.timeSource.currentTimeMillis() + (long)delay, period);
            this.addTask(dtt);
        }
        return dtt;
    }

    public ScheduledMessage deliverMessageFixedRate(Message msg, DirectPastryNode node, DirectNodeHandle from, int delay, int period) {
        DirectTimerTask dtt = null;
        DirectNodeHandle sender = null;
        sender = (DirectNodeHandle)msg.getSender();
        if (sender == null || sender.isAlive()) {
            MessageDelivery md = new MessageDelivery(msg, node, from, this);
            dtt = new DirectTimerTask(md, this.timeSource.currentTimeMillis() + (long)delay, period, true);
            this.addTask(dtt);
        }
        return dtt;
    }

    public void setMaxSpeed(float speed) {
        if (!this.isDirectTimeSource && !this.printedDirectTimeSourceWarning) {
            if (this.logger.level <= 900) {
                this.logger.log("Invalid TimeSource for setMaxSpeed()/setFullSpeed().  Use Environment.directEnvironment() to construct your Environment.");
            }
            this.printedDirectTimeSourceWarning = true;
        }
        this.maxSpeedRequestSystemTime = System.currentTimeMillis();
        this.maxSpeedRequestSimTime = this.timeSource.currentTimeMillis();
        this.maxSpeed = speed;
    }

    public void setFullSpeed() {
        this.setMaxSpeed(-1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean simulate() throws InterruptedException {
        if (!this.isDirectTimeSource) {
            return true;
        }
        if (!this.environment.getSelectorManager().isSelectorThread()) {
            throw new RuntimeException("Must be on selector thread");
        }
        SelectorManager selectorManager = this.manager;
        synchronized (selectorManager) {
            long scheduledExecutionTime = this.manager.getNextTaskExecutionTime();
            if (scheduledExecutionTime < 0L) {
                if (this.logger.level <= 500) {
                    this.logger.log("taskQueue is empty");
                }
                return false;
            }
            if (scheduledExecutionTime > this.timeSource.currentTimeMillis()) {
                long neededSysDelay;
                long sysTime;
                long sysTimeDiff;
                long maxSimTime;
                long newSimTime = scheduledExecutionTime;
                if (this.maxSpeed > 0.0f && (maxSimTime = (long)((float)this.maxSpeedRequestSimTime + (float)(sysTimeDiff = (sysTime = System.currentTimeMillis()) - this.maxSpeedRequestSystemTime) * this.maxSpeed)) < newSimTime && (neededSysDelay = (long)((float)(newSimTime - maxSimTime) / this.maxSpeed)) >= 1L) {
                    this.manager.wait(neededSysDelay);
                    long now = System.currentTimeMillis();
                    long delay = now - sysTime;
                    if (delay < neededSysDelay) {
                        return true;
                    }
                }
                if (this.logger.level <= 400) {
                    this.logger.log("the time is now " + newSimTime);
                }
                ((DirectTimeSource)this.timeSource).setTime(newSimTime);
            }
        }
        return true;
    }

    public boolean isAlive(DirectNodeHandle nh) {
        return nh.getRemote().isAlive();
    }

    public void destroy(DirectPastryNode node) {
        node.destroy();
    }

    public float networkDelay(DirectNodeHandle a, DirectNodeHandle b) {
        NodeRecord nra = a.getRemote().record;
        NodeRecord nrb = b.getRemote().record;
        if (nra == null || nrb == null) {
            throw new Error("asking about node proximity for unknown node(s)");
        }
        return nra.networkDelay(nrb);
    }

    public float proximity(DirectNodeHandle a, DirectNodeHandle b) {
        NodeRecord nra = a.getRemote().record;
        NodeRecord nrb = b.getRemote().record;
        if (nra == null || nrb == null) {
            throw new Error("asking about node proximity for unknown node(s)");
        }
        return nra.proximity(nrb);
    }

    public DirectNodeHandle getClosest(DirectNodeHandle nh) {
        Iterator it = this.nodes.iterator();
        DirectNodeHandle bestHandle = null;
        float bestProx = Float.MAX_VALUE;
        while (it.hasNext()) {
            DirectPastryNode theNode = (DirectPastryNode)it.next();
            float theProx = theNode.record.proximity(nh.getRemote().record);
            Id theId = theNode.getNodeId();
            if (!theNode.isAlive() || !theNode.isReady() || theId.equals(nh.getNodeId()) || !(theProx < bestProx)) continue;
            bestProx = theProx;
            bestHandle = (DirectNodeHandle)theNode.getLocalHandle();
        }
        return bestHandle;
    }

    public void registerNode(DirectPastryNode dpn) {
        this.nodes.add(dpn);
    }

    public void removeNode(DirectPastryNode node) {
        this.nodes.remove(node);
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSimulatorListener(SimulatorListener sl) {
        List<SimulatorListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(sl)) {
                return false;
            }
            this.listeners.add(sl);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSimulatorListener(SimulatorListener sl) {
        List<SimulatorListener> list = this.listeners;
        synchronized (list) {
            return this.listeners.remove(sl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySimulatorListenersSent(Message m, NodeHandle from, NodeHandle to, int delay) {
        ArrayList<SimulatorListener> temp;
        List<SimulatorListener> list = this.listeners;
        synchronized (list) {
            temp = new ArrayList<SimulatorListener>(this.listeners);
        }
        for (SimulatorListener listener : temp) {
            listener.messageSent(m, from, to, delay);
        }
    }

    public void notifySimulatorListenersReceived(Message m, NodeHandle from, NodeHandle to) {
    }
}

