/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.CancellableTask;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.leafset.LeafSet;
import rice.pastry.routing.RouteSet;

public abstract class PastryNodeFactory {
    protected final byte rtMax;
    protected final byte lSetSize;
    protected final byte rtBase;
    protected Hashtable<NodeHandle, Hashtable<NodeHandle, Integer>> pingCache = new Hashtable();
    protected Environment environment;
    protected Logger logger;

    public PastryNodeFactory(Environment env) {
        this.environment = env;
        this.rtMax = (byte)this.environment.getParameters().getInt("pastry_rtMax");
        this.rtBase = (byte)this.environment.getParameters().getInt("pastry_rtBaseBitLength");
        this.lSetSize = (byte)this.environment.getParameters().getInt("pastry_lSetSize");
        this.logger = env.getLogManager().getLogger(this.getClass(), null);
    }

    public abstract PastryNode newNode(NodeHandle var1);

    public abstract PastryNode newNode(NodeHandle var1, Id var2);

    public abstract LeafSet getLeafSet(NodeHandle var1) throws IOException;

    public abstract CancellableTask getLeafSet(NodeHandle var1, Continuation var2);

    public abstract RouteSet[] getRouteRow(NodeHandle var1, int var2) throws IOException;

    public abstract CancellableTask getRouteRow(NodeHandle var1, int var2, Continuation var3);

    public abstract int getProximity(NodeHandle var1, NodeHandle var2);

    public Environment getEnvironment() {
        return this.environment;
    }

    protected int proximity(NodeHandle local, NodeHandle handle) {
        Hashtable<NodeHandle, Integer> localTable = this.pingCache.get(local);
        if (localTable == null) {
            localTable = new Hashtable();
            this.pingCache.put(local, localTable);
        }
        if (localTable.get(handle) == null) {
            int value = this.getProximity(local, handle);
            localTable.put(handle, value);
            return value;
        }
        return localTable.get(handle);
    }

    private void purgeProximityCache(NodeHandle local) {
        this.pingCache.remove(local);
    }

    public NodeHandle[] sortedProximityCache(NodeHandle local) {
        final Hashtable<NodeHandle, Integer> localTable = this.pingCache.get(local);
        if (localTable == null) {
            return null;
        }
        localTable.remove(local);
        ArrayList<NodeHandle> handles = new ArrayList<NodeHandle>(localTable.keySet());
        Collections.sort(handles, new Comparator<NodeHandle>(){

            @Override
            public int compare(NodeHandle a, NodeHandle b) {
                return (Integer)localTable.get(a) - (Integer)localTable.get(b);
            }
        });
        return handles.toArray(new NodeHandle[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeHandle[] getNearest(NodeHandle local, NodeHandle seed) {
        try {
            if (seed == null) {
                NodeHandle[] nodeHandleArray = null;
                return nodeHandleArray;
            }
            NodeHandle currentClosest = seed;
            NodeHandle nearNode = seed;
            nearNode = this.closestToMe(local, nearNode, this.getLeafSet(nearNode));
            int depth = 160 / this.rtBase;
            int i = 0;
            if (!this.environment.getParameters().getString("pns_num_rows_to_use").equalsIgnoreCase("all")) {
                i = depth - this.environment.getParameters().getInt("pns_num_rows_to_use");
            }
            if (i < 0) {
                i = 0;
            }
            while (i < depth) {
                nearNode = this.closestToMe(local, nearNode, this.getRouteRow(nearNode, i));
                ++i;
            }
            while (!(currentClosest = nearNode).equals(nearNode = this.closestToMe(local, nearNode, this.getRouteRow(nearNode, depth - 1)))) {
            }
            if (nearNode.getLocalNode() == null && local.getLocalNode() != null) {
                nearNode = local.getLocalNode().coalesce(nearNode);
            }
            NodeHandle[] nodeHandleArray = this.sortedProximityCache(local);
            return nodeHandleArray;
        }
        catch (IOException e) {
            if (this.logger.level <= 900) {
                this.logger.logException("ERROR occured while finding best bootstrap.", e);
            }
            NodeHandle[] nodeHandleArray = new NodeHandle[]{seed};
            return nodeHandleArray;
        }
        finally {
            this.purgeProximityCache(local);
        }
    }

    private NodeHandle closestToMe(NodeHandle local, NodeHandle handle, LeafSet leafSet) {
        int i;
        Vector<NodeHandle> handles = new Vector<NodeHandle>();
        for (i = 1; i <= leafSet.cwSize(); ++i) {
            handles.add(leafSet.get(i));
        }
        for (i = -leafSet.ccwSize(); i < 0; ++i) {
            handles.add(leafSet.get(i));
        }
        return this.closestToMe(local, handle, handles.toArray(new NodeHandle[0]));
    }

    private NodeHandle closestToMe(NodeHandle local, NodeHandle handle, RouteSet[] routeSets) {
        Vector<NodeHandle> handles = new Vector<NodeHandle>();
        for (int i = 0; i < routeSets.length; ++i) {
            RouteSet set = routeSets[i];
            if (set == null) continue;
            for (int j = 0; j < set.size(); ++j) {
                handles.add(set.get(j));
            }
        }
        return this.closestToMe(local, handle, handles.toArray(new NodeHandle[0]));
    }

    private NodeHandle closestToMe(NodeHandle local, NodeHandle handle, NodeHandle[] handles) {
        NodeHandle closestNode = handle;
        int nearestdist = this.proximity(local, closestNode);
        for (int i = 0; i < handles.length; ++i) {
            NodeHandle tempNode = handles[i];
            int prox = this.proximity(local, tempNode);
            if (prox <= 0 || prox >= nearestdist || !tempNode.isAlive()) continue;
            nearestdist = prox;
            closestNode = tempNode;
        }
        return closestNode;
    }
}

