/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.scribe.testing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import rice.environment.Environment;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.p2p.commonapi.testing.CommonAPITest;
import rice.p2p.scribe.Scribe;
import rice.p2p.scribe.ScribeClient;
import rice.p2p.scribe.ScribeContent;
import rice.p2p.scribe.ScribeImpl;
import rice.p2p.scribe.ScribePolicy;
import rice.p2p.scribe.Topic;
import rice.p2p.scribe.messaging.SubscribeMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScribeRegrTest
extends CommonAPITest {
    public static String INSTANCE = "ScribeRegrTest";
    protected ScribeImpl[] scribes;
    protected TestScribePolicy[] policies;

    public ScribeRegrTest(Environment env) throws IOException {
        super(env);
        this.scribes = new ScribeImpl[this.NUM_NODES];
        this.policies = new TestScribePolicy[this.NUM_NODES];
    }

    public TestScribeContent buildTestScribeContent(Topic topic, int numMessages) {
        return new TestScribeContent(topic, numMessages);
    }

    @Override
    public void setupParams(Environment env) {
        super.setupParams(env);
        env.getParameters().setInt("p2p_scribe_message_timeout", 3000);
    }

    public static void main(String[] args) throws IOException {
        Environment env = ScribeRegrTest.parseArgs(args);
        ScribeRegrTest scribeTest = new ScribeRegrTest(env);
        scribeTest.start();
        env.destroy();
    }

    @Override
    protected void processNode(int num, Node node) {
        this.scribes[num] = new ScribeImpl(node, INSTANCE);
        this.policies[num] = new TestScribePolicy(this.scribes[num]);
        this.scribes[num].setPolicy(this.policies[num]);
    }

    @Override
    protected void runTest() {
        if (this.NUM_NODES < 2) {
            System.out.println("The DistScribeRegrTest must be run with at least 2 nodes for proper testing.  Use the '-nodes n' to specify the number of nodes.");
            return;
        }
        this.testBasic(1, "Basic");
        this.testBasic(2, "Partial (1)");
        this.testBasic(4, "Partial (2)");
        this.testMultiSubscribe(1, "Basic");
        this.testSingleRoot("Single rooted Trees");
        this.testAPI();
        this.testFailureNotification();
        this.testMaintenance();
    }

    protected void testBasic(int skip, String name) {
        int i;
        int i2;
        int i3;
        this.sectionStart(name + " Scribe Networks");
        int NUM_MESSAGES = 5;
        int SKIP = skip;
        Topic topic = new Topic(this.generateId());
        TestScribeClient[] clients = new TestScribeClient[this.NUM_NODES / SKIP];
        this.stepStart(name + " Tree Construction");
        for (int i4 = 0; i4 < this.NUM_NODES / SKIP; ++i4) {
            clients[i4] = new TestScribeClient((Scribe)this.scribes[i4], topic, i4);
            this.scribes[i4].subscribe(topic, clients[i4]);
            this.simulate();
        }
        int numWithParent = 0;
        for (int i5 = 0; i5 < this.NUM_NODES / SKIP; ++i5) {
            if (this.scribes[i5].getParent(topic) == null) continue;
            ++numWithParent;
        }
        if (numWithParent < this.NUM_NODES / SKIP - 1) {
            this.stepDone("FAILURE", "Expected at least " + (this.NUM_NODES / SKIP - 1) + " nodes with parents, found " + numWithParent);
        } else {
            this.stepDone("SUCCESS");
        }
        this.stepStart(name + " Publish");
        ScribeImpl local = this.scribes[this.environment.getRandomSource().nextInt(this.NUM_NODES / SKIP)];
        for (int i6 = 0; i6 < NUM_MESSAGES; ++i6) {
            local.publish(topic, this.buildTestScribeContent(topic, i6));
            this.simulate();
        }
        boolean failed = false;
        for (i3 = 0; i3 < this.NUM_NODES / SKIP; ++i3) {
            if (clients[i3].getPublishMessages().size() == NUM_MESSAGES) continue;
            this.stepDone("FAILURE", "Expected client " + clients[i3] + " to receive all messages, received " + clients[i3].getPublishMessages().size());
            failed = true;
        }
        if (!failed) {
            this.stepDone("SUCCESS");
        }
        this.stepStart(name + " Anycast - No Accept");
        local = this.scribes[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        local.anycast(topic, this.buildTestScribeContent(topic, 59));
        this.simulate();
        failed = false;
        for (i3 = 0; i3 < this.NUM_NODES / SKIP; ++i3) {
            if (clients[i3].getAnycastMessages().size() == 0) continue;
            this.stepDone("FAILURE", "Expected no accepters for anycast, found one at " + this.scribes[i3]);
            failed = true;
        }
        if (!failed) {
            this.stepDone("SUCCESS");
        }
        this.stepStart(name + " Anycast - 1 Accept");
        TestScribeClient client = clients[this.environment.getRandomSource().nextInt(this.NUM_NODES / SKIP)];
        client.acceptAnycast(true);
        local = this.scribes[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        local.anycast(topic, this.buildTestScribeContent(topic, 59));
        this.simulate();
        failed = false;
        for (i2 = 0; i2 < this.NUM_NODES / SKIP; ++i2) {
            if (clients[i2].equals(client)) {
                if (clients[i2].getAnycastMessages().size() == 1) continue;
                this.stepDone("FAILURE", "Expected node to accept anycast at " + client + " accepted " + clients[i2].getAnycastMessages().size() + " local " + local);
                failed = true;
                continue;
            }
            if (clients[i2].getAnycastMessages().size() == 0) continue;
            this.stepDone("FAILURE", "Expected no accepters for anycast, found one at " + this.scribes[i2]);
            failed = true;
        }
        if (!failed) {
            this.stepDone("SUCCESS");
        }
        this.stepStart(name + " Anycast - All Accept");
        for (i2 = 0; i2 < this.NUM_NODES / SKIP; ++i2) {
            clients[i2].acceptAnycast(true);
        }
        local = this.scribes[this.environment.getRandomSource().nextInt(this.NUM_NODES / SKIP)];
        local.anycast(topic, this.buildTestScribeContent(topic, 59));
        this.simulate();
        int total = 0;
        for (i = 0; i < this.NUM_NODES / SKIP; ++i) {
            total += clients[i].getAnycastMessages().size();
        }
        if (total != 2) {
            this.stepDone("FAILURE", "Expected 2 anycast messages to be found, found " + total);
        } else {
            this.stepDone("SUCCESS");
        }
        this.stepStart(name + " Unsubscribe");
        for (i = 0; i < this.NUM_NODES / SKIP; ++i) {
            this.scribes[i].unsubscribe(topic, (ScribeClient)clients[i]);
            this.simulate();
        }
        local = this.scribes[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        local.publish(topic, this.buildTestScribeContent(topic, 100));
        this.simulate();
        failed = false;
        for (i = 0; i < this.NUM_NODES / SKIP; ++i) {
            if (clients[i].getPublishMessages().size() == NUM_MESSAGES) continue;
            this.stepDone("FAILURE", "Expected client " + clients[i] + " to receive no additional messages, received " + clients[i].getPublishMessages().size());
            failed = true;
        }
        if (!failed) {
            this.stepDone("SUCCESS");
        }
        this.stepStart(name + " Tree Completely Demolished");
        failed = false;
        for (i = 0; i < this.NUM_NODES; ++i) {
            if (this.scribes[i].getClients(topic).size() > 0) {
                this.stepDone("FAILURE", "Expected scribe " + this.scribes[i] + " to have no clients, had " + this.scribes[i].getClients(topic).size());
                failed = true;
            }
            if (this.scribes[i].getChildren(topic).length > 0) {
                this.stepDone("FAILURE", "Expected scribe " + this.scribes[i] + " to have no children, had " + this.scribes[i].getChildren(topic).length);
                failed = true;
            }
            if (this.scribes[i].getParent(topic) == null) continue;
            this.stepDone("FAILURE", "Expected scribe " + this.scribes[i] + " to have no parent, had " + this.scribes[i].getParent(topic));
            failed = true;
        }
        if (!failed) {
            this.stepDone("SUCCESS");
        }
        this.sectionDone();
    }

    protected void testMultiSubscribe(int skip, String name) {
        int i;
        int i2;
        int i3;
        this.sectionStart(name + " MultiSubscription Scribe Network");
        int NUM_MESSAGES = 5;
        int SKIP = skip;
        int NUM_TOPICS = 2;
        TestScribeClient[] clients = new TestScribeClient[this.NUM_NODES];
        ArrayList<Topic> topics = new ArrayList<Topic>(2);
        int[] id1 = new int[]{0, 0, 0, 0, Integer.MIN_VALUE};
        int[] id2 = new int[]{0, 0, 0, 0, 0};
        topics.add(new Topic(this.FACTORY.buildId(id1)));
        topics.add(new Topic(this.FACTORY.buildId(id2)));
        this.stepStart(name + " Tree Construction (Parent Independence)");
        for (int i4 = 0; i4 < this.NUM_NODES; ++i4) {
            clients[i4] = new TestScribeClient((Scribe)this.scribes[i4], topics, i4);
            this.scribes[i4].subscribe(topics, (ScribeClient)clients[i4], null, null);
            this.simulate();
        }
        boolean numWithParent = false;
        for (int i5 = 0; i5 < this.NUM_NODES; ++i5) {
            if (this.scribes[i5].getParent((Topic)topics.get(0)) != this.scribes[i5].getParent((Topic)topics.get(1))) continue;
            this.stepDone("FAILURE", "Topics " + topics.get(0) + " and " + topics.get(1) + " had same parent " + this.scribes[i5].getParent((Topic)topics.get(0)) + " on node " + this.scribes[i5].getEndpoint().getLocalNodeHandle());
        }
        this.stepDone("SUCCESS");
        this.stepStart(name + " Publish");
        ScribeImpl local = this.scribes[this.environment.getRandomSource().nextInt(this.NUM_NODES / SKIP)];
        for (int i6 = 0; i6 < NUM_MESSAGES; ++i6) {
            for (Topic topic : topics) {
                local.publish(topic, this.buildTestScribeContent(topic, i6));
            }
            this.simulate();
        }
        boolean failed = false;
        for (int i7 = 0; i7 < this.NUM_NODES / SKIP; ++i7) {
            if (clients[i7].getPublishMessages().size() == NUM_MESSAGES * NUM_TOPICS) continue;
            this.stepDone("FAILURE", "Expected client " + clients[i7] + " to receive all messages, received " + clients[i7].getPublishMessages().size());
            failed = true;
        }
        if (!failed) {
            this.stepDone("SUCCESS");
        }
        this.stepStart(name + " Anycast - No Accept");
        local = this.scribes[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        for (Topic topic : topics) {
            local.anycast(topic, this.buildTestScribeContent(topic, 59));
        }
        this.simulate();
        failed = false;
        for (int i8 = 0; i8 < this.NUM_NODES / SKIP; ++i8) {
            if (clients[i8].getAnycastMessages().size() == 0) continue;
            this.stepDone("FAILURE", "Expected no accepters for anycast, found one at " + this.scribes[i8]);
            failed = true;
        }
        if (!failed) {
            this.stepDone("SUCCESS");
        }
        this.stepStart(name + " Anycast - 1 Accept");
        TestScribeClient client = clients[this.environment.getRandomSource().nextInt(this.NUM_NODES / SKIP)];
        client.acceptAnycast(true);
        local = this.scribes[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        for (Topic topic : topics) {
            local.anycast(topic, this.buildTestScribeContent(topic, 59));
        }
        this.simulate();
        failed = false;
        for (i3 = 0; i3 < this.NUM_NODES / SKIP; ++i3) {
            if (clients[i3].equals(client)) {
                if (clients[i3].getAnycastMessages().size() == NUM_TOPICS) continue;
                this.stepDone("FAILURE", "Expected node to accept " + NUM_TOPICS + " anycasts at " + client + " accepted " + clients[i3].getAnycastMessages().size() + " local " + local);
                failed = true;
                continue;
            }
            if (clients[i3].getAnycastMessages().size() == 0) continue;
            this.stepDone("FAILURE", "Expected no accepters for anycast, found one at " + this.scribes[i3]);
            failed = true;
        }
        if (!failed) {
            this.stepDone("SUCCESS");
        }
        this.stepStart(name + " Anycast - All Accept");
        for (i3 = 0; i3 < this.NUM_NODES / SKIP; ++i3) {
            clients[i3].acceptAnycast(true);
        }
        local = this.scribes[this.environment.getRandomSource().nextInt(this.NUM_NODES / SKIP)];
        for (Topic topic : topics) {
            local.anycast(topic, this.buildTestScribeContent(topic, 59));
        }
        this.simulate();
        int total = 0;
        for (i2 = 0; i2 < this.NUM_NODES / SKIP; ++i2) {
            total += clients[i2].getAnycastMessages().size();
        }
        if (total != NUM_TOPICS * 2) {
            this.stepDone("FAILURE", "Expected " + NUM_TOPICS * 2 + " anycast messages to be found, found " + total);
        } else {
            this.stepDone("SUCCESS");
        }
        this.stepStart(name + " Unsubscribe");
        for (i2 = 0; i2 < this.NUM_NODES / SKIP; ++i2) {
            for (Topic topic : topics) {
                this.scribes[i2].unsubscribe(topic, (ScribeClient)clients[i2]);
            }
            this.simulate();
        }
        local = this.scribes[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
        for (Topic topic : topics) {
            local.publish(topic, this.buildTestScribeContent(topic, 100));
        }
        this.simulate();
        failed = false;
        for (i = 0; i < this.NUM_NODES / SKIP; ++i) {
            if (clients[i].getPublishMessages().size() == NUM_MESSAGES * NUM_TOPICS) continue;
            this.stepDone("FAILURE", "Expected client " + clients[i] + " to receive no additional messages, received " + clients[i].getPublishMessages().size());
            failed = true;
        }
        if (!failed) {
            this.stepDone("SUCCESS");
        }
        this.stepStart(name + " Tree Completely Demolished");
        failed = false;
        for (i = 0; i < this.NUM_NODES; ++i) {
            for (Topic topic : topics) {
                if (this.scribes[i].getClients(topic).size() > 0) {
                    this.stepDone("FAILURE", "Expected scribe " + this.scribes[i] + " to have no clients, had " + this.scribes[i].getClients(topic).size());
                    failed = true;
                }
                if (this.scribes[i].getChildren(topic).length > 0) {
                    this.stepDone("FAILURE", "Expected scribe " + this.scribes[i] + " to have no children, had " + this.scribes[i].getChildren(topic).length);
                    failed = true;
                }
                if (this.scribes[i].getParent(topic) == null) continue;
                this.stepDone("FAILURE", "Expected scribe " + this.scribes[i] + " to have no parent, had " + this.scribes[i].getParent(topic));
                failed = true;
            }
        }
        if (!failed) {
            this.stepDone("SUCCESS");
        }
        this.sectionDone();
    }

    protected void testAPI() {
        int i;
        int i2;
        this.sectionStart("Scribe API Functionality");
        int NUM_MESSAGES = 5;
        Topic topic = new Topic(this.generateId());
        TestScribeClient[] clients = new TestScribeClient[this.NUM_NODES];
        this.stepStart("Tree Construction");
        for (i2 = 0; i2 < this.NUM_NODES; ++i2) {
            this.policies[i2].allowSubscribe(false);
        }
        for (i2 = 0; i2 < this.NUM_NODES / 2; ++i2) {
            clients[i2] = new TestScribeClient((Scribe)this.scribes[i2], topic, i2);
            this.scribes[i2].subscribe(topic, clients[i2]);
            this.simulate();
        }
        int numWithParent = 0;
        for (int i3 = 0; i3 < this.NUM_NODES; ++i3) {
            if (this.scribes[i3].getParent(topic) == null) continue;
            ++numWithParent;
        }
        if (numWithParent < this.NUM_NODES / 2 - 1) {
            this.stepDone("FAILURE", "Expected at least " + (this.NUM_NODES / 2 - 1) + " nodes with parents, found " + numWithParent);
        } else if (numWithParent > this.NUM_NODES / 2) {
            this.stepDone("FAILURE", "Expected no more than " + this.NUM_NODES / 2 + " nodes with parents, due to policy, found " + numWithParent);
        } else {
            this.stepDone("SUCCESS");
        }
        this.stepStart("Drop Child");
        ScribeImpl scribe = null;
        TestScribeClient client = null;
        TestScribePolicy policy = null;
        for (i = 0; i < this.NUM_NODES && scribe == null; ++i) {
            if (this.scribes[i].getChildren(topic).length <= 0) continue;
            scribe = this.scribes[i];
            client = clients[i];
            policy = this.policies[i];
        }
        if (scribe == null) {
            this.stepDone("FAILURE", "Could not find any scribes with children");
        } else {
            NodeHandle child = scribe.getChildren(topic)[0];
            policy.neverAllowSubscribe(true);
            scribe.removeChild(topic, child);
            this.simulate();
            ScribeImpl local = this.scribes[this.environment.getRandomSource().nextInt(this.NUM_NODES)];
            for (int i4 = 0; i4 < NUM_MESSAGES; ++i4) {
                local.publish(topic, this.buildTestScribeContent(topic, i4));
                this.simulate();
            }
            boolean failed = false;
            for (int i5 = 0; i5 < this.NUM_NODES / 2; ++i5) {
                if (clients[i5].getPublishMessages().size() == NUM_MESSAGES) continue;
                this.stepDone("FAILURE", "Expected client " + clients[i5] + " to receive all messages, received " + clients[i5].getPublishMessages().size());
                failed = true;
            }
            NodeHandle[] children = scribe.getChildren(topic);
            if (Arrays.asList(children).contains(child)) {
                this.stepDone("FAILURE", "Child resubscribed to previous node, policy should prevent this.");
                failed = true;
            }
            if (!failed) {
                this.stepDone("SUCCESS");
            }
        }
        this.stepStart("Reset Policies");
        for (i = 0; i < this.NUM_NODES; ++i) {
            this.policies[i].allowSubscribe(true);
            this.policies[i].neverAllowSubscribe(false);
        }
        this.stepDone("SUCCESS");
        this.sectionDone();
    }

    protected void testFailureNotification() {
        int i;
        this.sectionStart("Subscribe Failure Notification");
        Topic topic = new Topic(this.generateId());
        this.stepStart("Policy Change");
        for (i = 0; i < this.NUM_NODES; ++i) {
            this.policies[i].neverAllowSubscribe(true);
        }
        this.stepDone("SUCCESS");
        this.stepStart("Force Root To Accept");
        TestScribeClient client = new TestScribeClient((Scribe)this.scribes[this.NUM_NODES - 1], topic, this.NUM_NODES - 1);
        this.scribes[this.NUM_NODES - 1].subscribe(topic, client);
        this.simulate();
        if (client.getSubscribeFailed()) {
            this.stepDone("FAILURE", "Expected subscribe to succeed because we force the root to accept 1 child.");
        } else {
            this.stepDone("SUCCESS");
        }
        this.stepStart("Subscribe Attempt");
        i = this.environment.getRandomSource().nextInt(this.NUM_NODES - 1);
        while (this.scribes[i].isRoot(topic)) {
            i = this.environment.getRandomSource().nextInt(this.NUM_NODES - 1);
        }
        client = new TestScribeClient((Scribe)this.scribes[i], topic, i);
        this.scribes[i].subscribe(topic, client);
        this.simulate();
        this.stepDone("SUCCESS");
        this.stepStart("Failure Notification Delivered");
        if (!client.getSubscribeFailed()) {
            this.stepDone("FAILURE", "Expected subscribe to fail, but did not.");
        } else {
            this.stepDone("SUCCESS");
        }
        this.stepStart("Policy Reset");
        for (int j = 0; j < this.NUM_NODES; ++j) {
            this.policies[j].neverAllowSubscribe(false);
        }
        this.stepDone("SUCCESS");
        this.sectionDone();
    }

    protected void testSingleRoot(String name) {
        this.sectionStart(name + "");
        int numTrees = 10;
        boolean failed = false;
        for (int num = 0; num < numTrees; ++num) {
            Topic topic = new Topic(this.generateId());
            TestScribeClient[] clients = new TestScribeClient[this.NUM_NODES];
            this.stepStart(name + " TopicId=" + topic.getId());
            for (int i = 0; i < this.NUM_NODES; ++i) {
                clients[i] = new TestScribeClient((Scribe)this.scribes[i], topic, i);
                this.scribes[i].subscribe(topic, clients[i]);
                this.simulate();
            }
            int numRoot = 0;
            for (int i = 0; i < this.NUM_NODES; ++i) {
                if (!this.scribes[i].isRoot(topic)) continue;
                ++numRoot;
            }
            if (numRoot != 1) {
                this.stepDone("FAILURE", "Number of roots= " + numRoot);
                failed = true;
                continue;
            }
            this.stepDone("SUCCESS");
        }
        this.sectionDone();
    }

    protected void testMaintenance() {
        int i;
        this.sectionStart("Tree Maintenance Under Node Death");
        int NUM_MESSAGES = 5;
        Topic topic = new Topic(this.generateId());
        TestScribeClient[] clients = new TestScribeClient[this.NUM_NODES];
        this.stepStart("Tree Construction");
        for (int i2 = 0; i2 < this.NUM_NODES; ++i2) {
            clients[i2] = new TestScribeClient((Scribe)this.scribes[i2], topic, i2);
            this.scribes[i2].subscribe(topic, clients[i2]);
            this.simulate();
        }
        int numWithParent = 0;
        for (i = 0; i < this.NUM_NODES; ++i) {
            if (this.scribes[i].getParent(topic) == null) continue;
            ++numWithParent;
        }
        if (numWithParent < this.NUM_NODES - 1) {
            this.stepDone("FAILURE", "Expected at least " + (this.NUM_NODES - 1) + " nodes with parents, found " + numWithParent);
        } else {
            this.stepDone("SUCCESS");
        }
        this.stepStart("Killing Nodes");
        for (i = 0; i < this.NUM_NODES / 2; ++i) {
            System.out.println("Killing " + this.scribes[i].getId());
            this.scribes[i].destroy();
            this.kill(i);
            this.simulate();
        }
        this.waitToRecoverFromKilling(this.scribes[0].MESSAGE_TIMEOUT);
        this.stepDone("SUCCESS");
        this.stepStart("Tree Recovery");
        int localIndex = this.environment.getRandomSource().nextInt(this.NUM_NODES / 2) + this.NUM_NODES / 2;
        ScribeImpl local = this.scribes[localIndex];
        for (int i3 = 0; i3 < NUM_MESSAGES; ++i3) {
            local.publish(topic, this.buildTestScribeContent(topic, i3));
            this.simulate();
        }
        boolean failed = false;
        for (int i4 = this.NUM_NODES / 2; i4 < this.NUM_NODES; ++i4) {
            if (clients[i4].getPublishMessages().size() == NUM_MESSAGES) continue;
            this.stepDone("FAILURE", "Expected client " + this.nodes[i4] + ":" + clients[i4] + " to receive all messages, received " + clients[i4].getPublishMessages().size());
            failed = true;
        }
        if (!failed) {
            this.stepDone("SUCCESS");
        }
        this.sectionDone();
    }

    private Id generateId() {
        byte[] data = new byte[20];
        this.environment.getRandomSource().nextBytes(data);
        return this.FACTORY.buildId(data);
    }

    public static List<Topic> buildListOf1(Topic topic) {
        ArrayList<Topic> ret = new ArrayList<Topic>(1);
        ret.add(topic);
        return ret;
    }

    public class TestScribePolicy
    extends ScribePolicy.DefaultScribePolicy {
        protected Scribe scribe;
        protected boolean allowSubscribe;
        protected boolean neverAllowSubscribe;

        public TestScribePolicy(Scribe scribe) {
            super(scribe.getEnvironment());
            this.scribe = scribe;
            this.allowSubscribe = true;
            this.neverAllowSubscribe = false;
        }

        public void allowSubscribe(boolean allowSubscribe) {
            this.allowSubscribe = allowSubscribe;
        }

        public void neverAllowSubscribe(boolean neverAllowSubscribe) {
            this.neverAllowSubscribe = neverAllowSubscribe;
        }

        public boolean allowSubscribe(SubscribeMessage message, ScribeClient[] clients, NodeHandle[] children) {
            return !this.neverAllowSubscribe && (this.allowSubscribe || clients.length > 0 || this.scribe.isRoot(message.getTopic()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TestScribeClient
    implements ScribeClient {
        protected Scribe scribe;
        protected int i;
        protected Vector publishMessages;
        protected Vector anycastMessages;
        protected List<Topic> topics;
        protected boolean acceptAnycast;
        protected boolean subscribeFailed;

        public TestScribeClient(Scribe scribe, Topic topic, int i) {
            this(scribe, ScribeRegrTest.buildListOf1(topic), i);
        }

        public TestScribeClient(Scribe scribe, List<Topic> topics, int i) {
            this.scribe = scribe;
            this.i = i;
            this.topics = topics;
            this.publishMessages = new Vector();
            this.anycastMessages = new Vector();
            this.acceptAnycast = false;
            this.subscribeFailed = false;
        }

        public List<ScribeContent> getPublishMessages() {
            return this.publishMessages;
        }

        public List<ScribeContent> getAnycastMessages() {
            return this.anycastMessages;
        }

        public void acceptAnycast(boolean value) {
            this.acceptAnycast = value;
        }

        @Override
        public boolean anycast(Topic topic, ScribeContent content) {
            if (this.acceptAnycast) {
                this.anycastMessages.add(content);
            }
            return this.acceptAnycast;
        }

        @Override
        public void deliver(Topic topic, ScribeContent content) {
            this.publishMessages.add(content);
        }

        @Override
        public void childAdded(Topic topic, NodeHandle child) {
        }

        @Override
        public void childRemoved(Topic topic, NodeHandle child) {
        }

        @Override
        public void subscribeFailed(Topic topic) {
            this.subscribeFailed = true;
            this.scribe.subscribe(topic, this);
        }

        public boolean getSubscribeFailed() {
            return this.subscribeFailed;
        }

        public String toString() {
            if (this.topics.size() == 1) {
                return this.topics.get(0).toString();
            }
            String s = "";
            for (Topic topic : this.topics) {
                s = s + this.topics.toString() + " ";
            }
            return s;
        }
    }

    protected static class TestRouteMessage
    implements RouteMessage {
        private Id id;
        private NodeHandle nextHop;
        private Message message;

        public TestRouteMessage(Id id, NodeHandle nextHop, Message message) {
            this.id = id;
            this.nextHop = nextHop;
            this.message = message;
        }

        public Id getDestinationId() {
            return this.id;
        }

        public NodeHandle getNextHopHandle() {
            return this.nextHop;
        }

        public Message getMessage() {
            return this.message;
        }

        public Message getMessage(MessageDeserializer md) {
            return this.message;
        }

        public void setDestinationId(Id id) {
            this.id = id;
        }

        public void setNextHopHandle(NodeHandle nextHop) {
            this.nextHop = nextHop;
        }

        public void setMessage(Message message) {
            this.message = message;
        }

        public void setMessage(RawMessage message) {
            this.message = message;
        }
    }

    protected static class TestScribeContent
    implements ScribeContent {
        protected Topic topic;
        protected int num;

        public TestScribeContent(Topic topic, int num) {
            this.topic = topic;
            this.num = num;
        }

        public boolean equals(Object o) {
            if (!(o instanceof TestScribeContent)) {
                return false;
            }
            return ((TestScribeContent)o).topic.equals(this.topic) && ((TestScribeContent)o).num == this.num;
        }

        public String toString() {
            return "TestScribeContent(" + this.topic + ", " + this.num + ")";
        }
    }
}

