/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.scribe.testing;

import java.io.IOException;
import rice.environment.Environment;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.scribe.ScribeContent;
import rice.p2p.scribe.Topic;
import rice.p2p.scribe.rawserialization.RawScribeContent;
import rice.p2p.scribe.rawserialization.ScribeContentDeserializer;
import rice.p2p.scribe.testing.ScribeRegrTest;

public class RawScribeRegrTest
extends ScribeRegrTest {
    public RawScribeRegrTest(Environment env) throws IOException {
        super(env);
    }

    public ScribeRegrTest.TestScribeContent buildTestScribeContent(Topic topic, int num) {
        return new RawTestScribeContent(topic, num);
    }

    protected void processNode(int num, Node node) {
        super.processNode(num, node);
        this.scribes[num].setContentDeserializer(new ScribeContentDeserializer(){

            public ScribeContent deserializeScribeContent(InputBuffer buf, Endpoint endpoint, short contentType) throws IOException {
                switch (contentType) {
                    case 1: {
                        return new RawTestScribeContent(buf, endpoint);
                    }
                }
                throw new IllegalArgumentException("Unknown type: " + contentType);
            }
        });
    }

    public static void main(String[] args) throws IOException {
        Environment env = RawScribeRegrTest.parseArgs(args);
        RawScribeRegrTest scribeTest = new RawScribeRegrTest(env);
        scribeTest.start();
        env.destroy();
    }

    protected static class RawTestScribeContent
    extends ScribeRegrTest.TestScribeContent
    implements RawScribeContent {
        public static final short TYPE = 1;

        public RawTestScribeContent(Topic topic, int num) {
            super(topic, num);
        }

        public short getType() {
            return 1;
        }

        public RawTestScribeContent(InputBuffer buf, Endpoint endpoint) throws IOException {
            super(new Topic(buf, endpoint), buf.readInt());
        }

        public void serialize(OutputBuffer buf) throws IOException {
            this.topic.serialize(buf);
            buf.writeInt(this.num);
        }
    }
}

