/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.scribe;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import rice.environment.Environment;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.scribe.Scribe;
import rice.p2p.scribe.ScribeClient;
import rice.p2p.scribe.ScribeContent;
import rice.p2p.scribe.Topic;
import rice.p2p.scribe.messaging.AnycastMessage;
import rice.p2p.scribe.messaging.ScribeMessage;
import rice.p2p.scribe.messaging.SubscribeMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ScribePolicy {
    public List<Topic> allowSubscribe(Scribe var1, NodeHandle var2, List<Topic> var3, ScribeContent var4);

    public void directAnycast(AnycastMessage var1, NodeHandle var2, Collection<NodeHandle> var3);

    public void childAdded(Topic var1, NodeHandle var2);

    public void childRemoved(Topic var1, NodeHandle var2);

    public void recvAnycastFail(Topic var1, NodeHandle var2, ScribeContent var3);

    public void intermediateNode(ScribeMessage var1);

    public static class LimitedScribePolicy
    extends DefaultScribePolicy {
        protected int maxChildren;

        public LimitedScribePolicy(int max, Environment env) {
            super(env);
            this.maxChildren = max;
        }

        public boolean allowSubscribe(SubscribeMessage message, ScribeClient[] clients, NodeHandle[] children) {
            return children.length < this.maxChildren - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultScribePolicy
    implements ScribePolicy {
        protected Environment environment;

        public DefaultScribePolicy(Environment env) {
            this.environment = env;
        }

        @Override
        public List<Topic> allowSubscribe(Scribe scribe, NodeHandle source, List<Topic> topics, ScribeContent content) {
            Iterator<Topic> i = topics.iterator();
            while (i.hasNext()) {
                Topic topic = i.next();
                if (this.allowSubscribe(new BogusSubscribeMessage(source, topic, 0, content), scribe.getClients(topic).toArray(new ScribeClient[0]), scribe.getChildrenOfTopic(topic).toArray(new NodeHandle[0]))) continue;
                i.remove();
            }
            return topics;
        }

        public boolean allowSubscribe(SubscribeMessage message, ScribeClient[] clients, NodeHandle[] children) {
            return true;
        }

        @Override
        public void directAnycast(AnycastMessage message, NodeHandle parent, Collection<NodeHandle> theChildren) {
            if (parent != null) {
                message.addLast(parent);
            }
            ArrayList<NodeHandle> children = new ArrayList<NodeHandle>(theChildren);
            while (!children.isEmpty()) {
                message.addFirst(children.remove(this.environment.getRandomSource().nextInt(children.size())));
            }
        }

        @Override
        public void childAdded(Topic topic, NodeHandle child) {
        }

        @Override
        public void childRemoved(Topic topic, NodeHandle child) {
        }

        @Override
        public void intermediateNode(ScribeMessage message) {
        }

        @Override
        public void recvAnycastFail(Topic topic, NodeHandle failedAtNode, ScribeContent content) {
        }

        class BogusSubscribeMessage
        extends SubscribeMessage {
            ScribeContent theContent;

            public BogusSubscribeMessage(NodeHandle source, Topic topic, int i, ScribeContent content) {
                super(source, topic, i, null);
                this.theContent = content;
            }

            public ScribeContent getContent() {
                return this.theContent;
            }
        }
    }
}

