/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.past.messaging;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.past.messaging.ContinuationMessage;
import rice.p2p.past.rawserialization.PastContentDeserializer;
import rice.p2p.past.rawserialization.RawPastContent;

public class LookupMessage
extends ContinuationMessage {
    public static final short TYPE = 6;
    private Id id;
    private boolean cached = false;
    private NodeHandle handle;

    public LookupMessage(int uid, Id id, NodeHandle source, Id dest) {
        super(uid, source, dest);
        this.id = id;
    }

    public Id getId() {
        return this.id;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCached() {
        this.cached = true;
    }

    public void addHop(NodeHandle handle) {
        this.handle = handle;
    }

    public NodeHandle getPreviousNodeHandle() {
        return this.handle;
    }

    public String toString() {
        return "[LookupMessage for " + this.id + " data " + this.response + "]";
    }

    public short getType() {
        return 6;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        if (this.response != null && this.response instanceof RawPastContent) {
            super.serialize(buf, false);
            RawPastContent rpc = (RawPastContent)this.response;
            buf.writeShort(rpc.getType());
            rpc.serialize(buf);
        } else {
            super.serialize(buf, true);
        }
        buf.writeBoolean(this.handle != null);
        if (this.handle != null) {
            this.handle.serialize(buf);
        }
        buf.writeShort(this.id.getType());
        this.id.serialize(buf);
        buf.writeBoolean(this.cached);
    }

    public static LookupMessage build(InputBuffer buf, Endpoint endpoint, PastContentDeserializer pcd) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return new LookupMessage(buf, endpoint, pcd);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }

    private LookupMessage(InputBuffer buf, Endpoint endpoint, PastContentDeserializer pcd) throws IOException {
        super(buf, endpoint);
        if (this.serType == S_SUB) {
            short contentType = buf.readShort();
            this.response = pcd.deserializePastContent(buf, endpoint, contentType);
        }
        if (buf.readBoolean()) {
            this.handle = endpoint.readNodeHandle(buf);
        }
        try {
            this.id = endpoint.readId(buf, buf.readShort());
        }
        catch (IllegalArgumentException iae) {
            System.out.println(iae + " " + this + " serType:" + this.serType + " UID:" + this.getUID() + " d:" + this.dest + " s:" + this.source);
            throw iae;
        }
        this.cached = buf.readBoolean();
    }
}

