/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.multiring;

import java.util.Vector;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.p2p.multiring.MultiringNode;
import rice.p2p.multiring.RingId;

public class MultiringNodeCollection {
    public int BASE;
    protected Vector nodes = new Vector();

    public MultiringNodeCollection(MultiringNode node, int BASE) {
        this.nodes.add(node);
        this.BASE = BASE;
    }

    public void addNode(MultiringNode node) {
        if (!node.getNodeId().equals(((MultiringNode)this.nodes.elementAt(0)).getNodeId())) {
            throw new IllegalArgumentException("Node added does not have the correct nodeId!");
        }
        this.broadcastNewNode(node);
        this.nodes.add(node);
    }

    protected void broadcastNewNode(MultiringNode node) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            MultiringNode thisNode = (MultiringNode)this.nodes.elementAt(i);
            if (thisNode.getRingId().equals(node.getRingId())) {
                throw new IllegalArgumentException("ERROR: Attempt to add already-existing ringId " + node + " " + node.getId() + " " + thisNode + " " + thisNode.getId());
            }
            thisNode.nodeAdded(node.getRingId());
            node.nodeAdded(thisNode.getRingId());
        }
    }

    protected void route(RingId id, RawMessage message, String application) {
        MultiringNode best = (MultiringNode)this.nodes.elementAt(0);
        for (int i = 1; i < this.nodes.size(); ++i) {
            MultiringNode thisNode = (MultiringNode)this.nodes.elementAt(i);
            int bestShared = this.getLengthOfSharedPrefix((RingId)best.getId(), id);
            int thisShared = this.getLengthOfSharedPrefix((RingId)thisNode.getId(), id);
            int bestLength = this.getLength((RingId)best.getId());
            int thisLength = this.getLength((RingId)thisNode.getId());
            if (thisShared <= bestShared && (thisShared != bestShared || thisLength >= bestLength)) continue;
            best = thisNode;
        }
        best.route(id, message, application);
    }

    protected int getLength(RingId a) {
        byte[] ba = a.getRingId().toByteArray();
        for (int i = 0; i < ba.length / this.BASE; ++i) {
            boolean zero = true;
            for (int j = 0; j < this.BASE; ++j) {
                if (ba[ba.length - 1 - (this.BASE * i + j)] == 0) continue;
                zero = false;
            }
            if (!zero) continue;
            return i;
        }
        return ba.length / this.BASE;
    }

    protected int getLengthOfSharedPrefix(RingId a, RingId b) {
        byte[] ba = a.getRingId().toByteArray();
        byte[] bb = b.getRingId().toByteArray();
        for (int i = 0; i < ba.length / this.BASE; ++i) {
            boolean same = true;
            for (int j = 0; j < this.BASE; ++j) {
                if (ba[ba.length - 1 - (this.BASE * i + j)] == bb[ba.length - 1 - (this.BASE * i + j)]) continue;
                same = false;
            }
            if (same) continue;
            return i;
        }
        return ba.length / this.BASE;
    }
}

