/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.multiring;

import java.io.IOException;
import java.util.List;
import rice.Continuation;
import rice.Executable;
import rice.environment.Environment;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.CancellableTask;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.NodeHandleSet;
import rice.p2p.commonapi.appsocket.AppSocketReceiver;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.p2p.multiring.MultiringIdRange;
import rice.p2p.multiring.MultiringNode;
import rice.p2p.multiring.MultiringNodeHandle;
import rice.p2p.multiring.MultiringNodeHandleSet;
import rice.p2p.multiring.RingId;
import rice.p2p.util.rawserialization.JavaSerializedMessage;

public class MultiringEndpoint
implements Endpoint {
    protected MultiringNode node;
    protected Application application;
    protected Endpoint endpoint;

    protected MultiringEndpoint(MultiringNode node, Endpoint endpoint, Application application) {
        this.node = node;
        this.endpoint = endpoint;
        this.application = application;
    }

    public Id getId() {
        return RingId.build(this.node.getRingId(), this.endpoint.getId());
    }

    public void route(Id id, Message message, NodeHandle hint) {
        if (message instanceof RawMessage) {
            this.route(id, (RawMessage)message, hint);
        } else {
            this.route(id, new JavaSerializedMessage(message), hint);
        }
    }

    public void route(Id id, RawMessage message, NodeHandle hint) {
        RingId mId = (RingId)id;
        MultiringNodeHandle mHint = (MultiringNodeHandle)hint;
        if (mId == null) {
            if (mHint.getRingId().equals(this.node.getRingId())) {
                this.endpoint.route(null, message, mHint.getHandle());
            } else {
                this.route(mHint.getId(), message, null);
            }
        } else if (mId.getRingId().equals(this.node.getRingId())) {
            if (mHint != null && mHint.getRingId().equals(this.node.getRingId())) {
                this.endpoint.route(mId.getId(), message, mHint.getHandle());
            } else {
                this.endpoint.route(mId.getId(), message, null);
            }
        } else {
            this.node.getCollection().route(mId, message, this.getInstance());
        }
    }

    public NodeHandleSet localLookup(Id id, int num, boolean safe) {
        return new MultiringNodeHandleSet(this.node.getRingId(), this.endpoint.localLookup(((RingId)id).getId(), num, safe));
    }

    public NodeHandleSet neighborSet(int num) {
        return new MultiringNodeHandleSet(this.node.getRingId(), this.endpoint.neighborSet(num));
    }

    public NodeHandleSet replicaSet(Id id, int maxRank) {
        if (((RingId)id).getRingId().equals(this.node.getRingId())) {
            return new MultiringNodeHandleSet(this.node.getRingId(), this.endpoint.replicaSet(((RingId)id).getId(), maxRank));
        }
        return new MultiringNodeHandleSet(((RingId)id).getRingId(), this.node.getNode().getIdFactory().buildNodeHandleSet());
    }

    public NodeHandleSet replicaSet(Id id, int maxRank, NodeHandle root, NodeHandleSet set) {
        if (((RingId)id).getRingId().equals(this.node.getRingId())) {
            return new MultiringNodeHandleSet(this.node.getRingId(), this.endpoint.replicaSet(((RingId)id).getId(), maxRank, ((MultiringNodeHandle)root).getHandle(), ((MultiringNodeHandleSet)set).getSet()));
        }
        return new MultiringNodeHandleSet(((RingId)id).getRingId(), this.node.getNode().getIdFactory().buildNodeHandleSet());
    }

    public IdRange range(NodeHandle handle, int rank, Id lkey) {
        IdRange result;
        if (lkey != null) {
            lkey = ((RingId)lkey).getId();
        }
        if ((result = this.endpoint.range(((MultiringNodeHandle)handle).getHandle(), rank, lkey)) != null) {
            return new MultiringIdRange(this.node.getRingId(), result);
        }
        return null;
    }

    public IdRange range(NodeHandle handle, int rank, Id lkey, boolean cumulative) {
        IdRange result;
        if (lkey != null) {
            lkey = ((RingId)lkey).getId();
        }
        if ((result = this.endpoint.range(((MultiringNodeHandle)handle).getHandle(), rank, lkey, cumulative)) != null) {
            return new MultiringIdRange(this.node.getRingId(), result);
        }
        return null;
    }

    public NodeHandle getLocalNodeHandle() {
        return new MultiringNodeHandle(this.node.getRingId(), this.endpoint.getLocalNodeHandle());
    }

    public CancellableTask scheduleMessage(Message message, long delay) {
        return this.endpoint.scheduleMessage(message, delay);
    }

    public CancellableTask scheduleMessage(Message message, long delay, long period) {
        return this.endpoint.scheduleMessage(message, delay, period);
    }

    public CancellableTask scheduleMessageAtFixedRate(Message message, long delay, long period) {
        return this.endpoint.scheduleMessageAtFixedRate(message, delay, period);
    }

    public List networkNeighbors(int num) {
        return this.endpoint.networkNeighbors(num);
    }

    public void process(Executable task, Continuation command) {
        this.endpoint.process(task, command);
    }

    protected void deliver(RingId id, Message target) {
        this.application.deliver(id, target);
    }

    public String getInstance() {
        return "multiring" + this.endpoint.getInstance();
    }

    public Environment getEnvironment() {
        return this.node.getEnvironment();
    }

    public void connect(NodeHandle handle, AppSocketReceiver receiver, int timeout) {
        MultiringNodeHandle mHandle = (MultiringNodeHandle)handle;
        this.endpoint.connect(mHandle.getHandle(), receiver, timeout);
    }

    public void accept(AppSocketReceiver receiver) {
        this.endpoint.accept(receiver);
    }

    public void setDeserializer(MessageDeserializer md) {
        this.endpoint.setDeserializer(md);
    }

    public MessageDeserializer getDeserializer() {
        return this.endpoint.getDeserializer();
    }

    public Id readId(InputBuffer buf, short type) throws IOException {
        if (type == RingId.TYPE) {
            return new RingId(buf, this.endpoint);
        }
        return this.endpoint.readId(buf, type);
    }

    public NodeHandle readNodeHandle(InputBuffer buf) throws IOException {
        return new MultiringNodeHandle(buf, this.endpoint);
    }

    public IdRange readIdRange(InputBuffer buf) throws IOException {
        return new MultiringIdRange(buf, this.endpoint);
    }

    public NodeHandle coalesce(NodeHandle handle) {
        if (handle instanceof MultiringNodeHandle) {
            MultiringNodeHandle mnh = (MultiringNodeHandle)handle;
            mnh.handle = this.endpoint.coalesce(mnh.handle);
            return mnh;
        }
        return this.endpoint.coalesce(handle);
    }

    public NodeHandleSet readNodeHandleSet(InputBuffer buf, short type) throws IOException {
        switch (type) {
            case 10: {
                return new MultiringNodeHandleSet(buf, this.endpoint);
            }
        }
        return this.endpoint.readNodeHandleSet(buf, type);
    }

    public String toString() {
        return "MRE[" + this.endpoint + "]";
    }

    public void register() {
        this.endpoint.register();
    }

    public int proximity(NodeHandle nh) {
        return this.endpoint.proximity(nh);
    }
}

