/*
 * Decompiled with CFR 0.152.
 */
package rice;

import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.selector.SelectorManager;

public interface Continuation {
    public void receiveResult(Object var1);

    public void receiveException(Exception var1);

    public static class NamedContinuation
    implements Continuation {
        protected Continuation parent;
        protected String name;

        public NamedContinuation(String name, Continuation command) {
            this.name = name;
            this.parent = command;
        }

        public void receiveResult(Object result) {
            this.parent.receiveResult(result);
        }

        public void receiveException(Exception result) {
            this.parent.receiveException(result);
        }

        public String toString() {
            return this.name;
        }
    }

    public static class MultiContinuation {
        protected Object[] result;
        protected boolean[] haveResult;
        protected Continuation parent;
        protected boolean done;

        public MultiContinuation(Continuation parent, int num) {
            this.parent = parent;
            this.result = new Object[num];
            this.haveResult = new boolean[num];
            this.done = false;
        }

        public Continuation getSubContinuation(final int index) {
            return new Continuation(){

                public void receiveResult(Object o) {
                    MultiContinuation.this.receive(index, o);
                }

                public void receiveException(Exception e) {
                    MultiContinuation.this.receive(index, e);
                }
            };
        }

        protected void receive(int index, Object o) {
            if (!this.done && !this.haveResult[index]) {
                this.haveResult[index] = true;
                this.result[index] = o;
                try {
                    if (this.isDone()) {
                        this.done = true;
                        this.parent.receiveResult(this.getResult());
                    }
                }
                catch (Exception e) {
                    this.done = true;
                    this.parent.receiveException(e);
                }
            }
        }

        public boolean isDone() throws Exception {
            for (int i = 0; i < this.haveResult.length; ++i) {
                if (this.haveResult[i]) continue;
                return false;
            }
            return true;
        }

        public Object getResult() {
            return this.result;
        }
    }

    public static abstract class ExternalRunnable
    extends ExternalContinuationRunnable {
        protected abstract Object execute() throws Exception;

        protected void execute(Continuation c) throws Exception {
            c.receiveResult(this.execute());
        }
    }

    public static abstract class ExternalContinuationRunnable
    implements Runnable {
        private ExternalContinuation e = new ExternalContinuation();

        public void run() {
            try {
                this.execute(this.e);
            }
            catch (Exception exc) {
                this.e.receiveException(exc);
            }
        }

        protected abstract void execute(Continuation var1) throws Exception;

        public Object invoke(SelectorManager sm) throws Exception {
            sm.invoke(this);
            this.e.sleep();
            if (this.e.exceptionThrown()) {
                throw this.e.getException();
            }
            return this.e.getResult();
        }

        public Object invoke(Environment env) throws Exception {
            return this.invoke(env.getSelectorManager());
        }
    }

    public static class ExternalContinuation
    implements Continuation {
        protected Exception exception;
        protected Object result;
        protected boolean done = false;

        public synchronized void receiveResult(Object o) {
            this.result = o;
            this.done = true;
            this.notify();
        }

        public synchronized void receiveException(Exception e) {
            this.exception = e;
            this.done = true;
            this.notify();
        }

        public Object getResult() {
            if (this.exception != null) {
                throw new IllegalArgumentException("Exception was thrown in ExternalContinuation, but getResult() called!");
            }
            return this.result;
        }

        public Exception getException() {
            return this.exception;
        }

        public synchronized void sleep() {
            try {
                while (!this.done) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                this.exception = e;
            }
        }

        public boolean exceptionThrown() {
            return this.exception != null;
        }
    }

    public static abstract class SimpleContinuation
    implements Continuation {
        public void receiveException(Exception result) {
            this.receiveResult(result);
        }
    }

    public static class ListenerContinuation
    implements Continuation {
        protected String name;
        protected Logger logger;

        public ListenerContinuation(String name, Environment env) {
            this.name = name;
            this.logger = env.getLogManager().getLogger(this.getClass(), null);
        }

        public void receiveResult(Object result) {
        }

        public void receiveException(Exception result) {
            if (this.logger.level <= 900) {
                this.logger.logException("ERROR - Received exception " + result + " during task " + this.name, result);
            }
        }
    }

    public static abstract class ErrorContinuation
    implements Continuation {
        protected Continuation parent;

        public ErrorContinuation(Continuation continuation) {
            this.parent = continuation;
        }

        public void receiveResult(Object result) {
            this.parent.receiveResult(result);
        }
    }

    public static abstract class StandardContinuation
    implements Continuation {
        protected Continuation parent;

        public StandardContinuation(Continuation continuation) {
            this.parent = continuation;
        }

        public void receiveException(Exception result) {
            this.parent.receiveException(result);
        }
    }
}

