/*************************************************************************

"FreePastry" Peer-to-Peer Application Development Substrate 

Copyright 2002, Rice University. All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

- Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.

- Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

- Neither  the name  of Rice  University (RICE) nor  the names  of its
contributors may be  used to endorse or promote  products derived from
this software without specific prior written permission.

This software is provided by RICE and the contributors on an "as is"
basis, without any representations or warranties of any kind, express
or implied including, but not limited to, representations or
warranties of non-infringement, merchantability or fitness for a
particular purpose. In no event shall RICE or contributors be liable
for any direct, indirect, incidental, special, exemplary, or
consequential damages (including, but not limited to, procurement of
substitute goods or services; loss of use, data, or profits; or
business interruption) however caused and on any theory of liability,
whether in contract, strict liability, or tort (including negligence
or otherwise) arising in any way out of the use of this software, even
if advised of the possibility of such damage.

********************************************************************************/

package rice.pastry;

import java.io.*;
import java.util.*;

/**
 * Class which stores a list of LocalNodes waiting to have their local pastry
 * node to be set non-null.
 *
 * @version $Id: PendingLocalNodesList.java,v 1.5 2005/03/11 00:58:10 jeffh Exp
 *      $
 * @author Alan Mislove
 */
public class PendingLocalNodesList {

  // maps ObjectInputStream -> LinkedList (of LocalNodes)
  private HashMap map = new HashMap();

  /**
   * Sets all of the pending local nodes read in by the given input stream.
   *
   * @param in The input stream reading the LocalNodes
   * @param node The local pastry node.
   */
  public void setPending(ObjectInputStream in, PastryNode node) {
    LinkedList pending = null;

    synchronized (this) {
      pending = (LinkedList) map.remove(in);
    }

    if (pending != null) {
      Iterator iter = pending.iterator();
      while (iter.hasNext()) {
        LocalNodeI ln = (LocalNodeI) iter.next();

        if (Log.ifp(8)) {
          System.out.println("setting local node " + node + " to " + ln);
        }

        if (ln.getLocalNode() != null) {
          System.out.println("setting local node twice! " + node + " to " + ln);
        }

        ln.setLocalNode(node);
      }
    }
  }

  /**
   * Adds a pending LocalNode to the list of pending LocalNodes.
   *
   * @param in The input stream reading the LocalNode
   * @param client The LocalNodeI itself
   */
  public synchronized void addPending(ObjectInputStream in, LocalNodeI client) {
    LinkedList pendinglist = (LinkedList) map.get(in);

    if (pendinglist == null) {
      map.put(in, pendinglist = new LinkedList());
    }

    if (Log.ifp(8)) {
      System.out.println("pending " + this + " on list " + in);
    }

    pendinglist.add(client);
  }
}
