/*************************************************************************

"FreePastry" Peer-to-Peer Application Development Substrate 

Copyright 2002, Rice University. All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

- Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.

- Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

- Neither  the name  of Rice  University (RICE) nor  the names  of its
contributors may be  used to endorse or promote  products derived from
this software without specific prior written permission.

This software is provided by RICE and the contributors on an "as is"
basis, without any representations or warranties of any kind, express
or implied including, but not limited to, representations or
warranties of non-infringement, merchantability or fitness for a
particular purpose. In no event shall RICE or contributors be liable
for any direct, indirect, incidental, special, exemplary, or
consequential damages (including, but not limited to, procurement of
substitute goods or services; loss of use, data, or profits; or
business interruption) however caused and on any theory of liability,
whether in contract, strict liability, or tort (including negligence
or otherwise) arising in any way out of the use of this software, even
if advised of the possibility of such damage.

********************************************************************************/

package rice.pastry;

import java.io.*;
import java.util.*;

import rice.pastry.messaging.*;

/**
 * Interface that some Serializable classes (such as NodeHandle and Certificate)
 * implement, if they want to be kept informed of what node they're on. Think of
 * this as a pattern. One implementation of this is provided (LocalNodeImpl),
 * but if a class cannot use this implementation (for reasons such as multiple
 * inheritance), it should implement LocalNode and provide the methods below.
 * NOTE: All implementations of local nodes should override their readObject()
 * methods in order to add the following lines: in.defaultReadObject();
 * LocalNode.pending.addPending(in, this) which will schedule the LocalNode to
 * have it's local node to be set to non-null.
 *
 * @version $Id: LocalNodeI.java,v 1.3 2005/03/14 21:33:08 jeffh Exp $
 * @author Alan Mislove
 */
public interface LocalNodeI extends Serializable {

  /**
   * Refer to README.handles_localnode.
   */
  public static PendingLocalNodesList pending = new PendingLocalNodesList();

  /**
   * Accessor method.
   *
   * @return The LocalNode value
   */
  public PastryNode getLocalNode();

  /**
   * Accessor method. Notifies the overridable afterSetLocalNode.
   *
   * @param pn The new LocalNode value
   */
  public void setLocalNode(PastryNode pn);

  /**
   * May be called from handle etc methods to ensure that local node has been
   * set, either on construction or on deserialization/receivemsg.
   */
  public void assertLocalNode();
}
