/*************************************************************************

"FreePastry" Peer-to-Peer Application Development Substrate 

Copyright 2002, Rice University. All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

- Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.

- Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

- Neither  the name  of Rice  University (RICE) nor  the names  of its
contributors may be  used to endorse or promote  products derived from
this software without specific prior written permission.

This software is provided by RICE and the contributors on an "as is"
basis, without any representations or warranties of any kind, express
or implied including, but not limited to, representations or
warranties of non-infringement, merchantability or fitness for a
particular purpose. In no event shall RICE or contributors be liable
for any direct, indirect, incidental, special, exemplary, or
consequential damages (including, but not limited to, procurement of
substitute goods or services; loss of use, data, or profits; or
business interruption) however caused and on any theory of liability,
whether in contract, strict liability, or tort (including negligence
or otherwise) arising in any way out of the use of this software, even
if advised of the possibility of such damage.

********************************************************************************/

package rice.p2p.commonapi;

import java.io.*;

/**
 * @(#) RouteMessage.java This interface is a container which represents a
 * message, as it is about to be forwarded to another node.
 *
 * @version $Id: RouteMessage.java,v 1.6 2005/03/11 00:58:02 jeffh Exp $
 * @author Alan Mislove
 * @author Peter Druschel
 */
public interface RouteMessage extends Serializable {

  /**
   * Returns the destination Id for this message
   *
   * @return The destination Id
   */
  public Id getDestinationId();

  /**
   * Returns the next hop handle for this message
   *
   * @return The next hop
   */
  public NodeHandle getNextHopHandle();

  /**
   * Returns the enclosed message inside of this message
   *
   * @return The enclosed message
   */
  public Message getMessage();

  /**
   * Sets the destination Id for this message
   *
   * @param id The destination Id
   */
  public void setDestinationId(Id id);

  /**
   * Sets the next hop handle for this message
   *
   * @param nextHop The next hop for this handle
   */
  public void setNextHopHandle(NodeHandle nextHop);

  /**
   * Sets the internal message for this message
   *
   * @param message The internal message
   */
  public void setMessage(Message message);

}

