/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.pkcs;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class SignerInfo
implements DEREncodable {
    private DERInteger version;
    private IssuerAndSerialNumber issuerAndSerialNumber;
    private AlgorithmIdentifier digAlgorithm;
    private DERConstructedSet authenticatedAttributes;
    private AlgorithmIdentifier digEncryptionAlgorithm;
    private ASN1OctetString encryptedDigest;
    private DERConstructedSet unauthenticatedAttributes;

    public static SignerInfo getInstance(Object object) {
        if (object instanceof SignerInfo) {
            return (SignerInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new SignerInfo((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public SignerInfo(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.version = (DERInteger)enumeration.nextElement();
        this.issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(enumeration.nextElement());
        this.digAlgorithm = AlgorithmIdentifier.getInstance(enumeration.nextElement());
        Object e = enumeration.nextElement();
        if (e instanceof ASN1TaggedObject) {
            this.authenticatedAttributes = null;
            this.digEncryptionAlgorithm = AlgorithmIdentifier.getInstance(enumeration.nextElement());
        } else {
            this.authenticatedAttributes = null;
            this.digEncryptionAlgorithm = AlgorithmIdentifier.getInstance(e);
        }
        this.encryptedDigest = DEROctetString.getInstance(enumeration.nextElement());
        this.unauthenticatedAttributes = enumeration.hasMoreElements() ? null : null;
    }

    public DERInteger getVersion() {
        return this.version;
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return this.issuerAndSerialNumber;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digAlgorithm;
    }

    public ASN1OctetString getEncryptedDigest() {
        return this.encryptedDigest;
    }

    public AlgorithmIdentifier getDigestEncryptionAlgorithm() {
        return this.digEncryptionAlgorithm;
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.version);
        dERConstructedSequence.addObject(this.issuerAndSerialNumber);
        dERConstructedSequence.addObject(this.digAlgorithm);
        if (this.authenticatedAttributes != null) {
            dERConstructedSequence.addObject(new DERTaggedObject(false, 0, this.authenticatedAttributes));
        }
        dERConstructedSequence.addObject(this.digEncryptionAlgorithm);
        dERConstructedSequence.addObject(this.encryptedDigest);
        if (this.unauthenticatedAttributes != null) {
            dERConstructedSequence.addObject(new DERTaggedObject(false, 1, this.unauthenticatedAttributes));
        }
        return dERConstructedSequence;
    }
}

