/*************************************************************************

"FreePastry" Peer-to-Peer Application Development Substrate 

Copyright 2002, Rice University. All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

- Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.

- Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

- Neither  the name  of Rice  University (RICE) nor  the names  of its
contributors may be  used to endorse or promote  products derived from
this software without specific prior written permission.

This software is provided by RICE and the contributors on an "as is"
basis, without any representations or warranties of any kind, express
or implied including, but not limited to, representations or
warranties of non-infringement, merchantability or fitness for a
particular purpose. In no event shall RICE or contributors be liable
for any direct, indirect, incidental, special, exemplary, or
consequential damages (including, but not limited to, procurement of
substitute goods or services; loss of use, data, or profits; or
business interruption) however caused and on any theory of liability,
whether in contract, strict liability, or tort (including negligence
or otherwise) arising in any way out of the use of this software, even
if advised of the possibility of such damage.

********************************************************************************/

package rice.pastry;

import java.lang.Comparable;
import java.io.*;
import java.util.*;

/**
 * Represents a Pastry identifier for a node.
 *
 * @version $Id: NodeId.java,v 1.26 2005/03/11 00:58:10 jeffh Exp $
 * @author Peter Druschel
 * @author Alan Mislove
 */
public class NodeId extends Id {

  /**
   * Support for coalesced Ids - ensures only one copy of each Id is in memory
   */
  private static WeakHashMap NODEID_MAP = new WeakHashMap();

  /**
   * This is the bit length of the node ids. If it is n, then there are 2^n
   * different Pastry nodes. We currently assume that it is divisible by 32.
   */
  public final static int nodeIdBitLength = IdBitLength;

  /**
   * serialver for backwards compatibility
   */
  final static long serialVersionUID = 4346947555837618045L;

  /**
   * Constructor.
   *
   * @param material an array of length at least IdBitLength/32 containing raw
   *      Id material.
   */
  private NodeId(int material[]) {
    super(material);
  }

  /**
   * Define readResolve, which will replace the deserialized object with the
   * canootical one (if one exists) to ensure Id coalescing.
   *
   * @return The real Id
   * @exception ObjectStreamException DESCRIBE THE EXCEPTION
   */
  private Object readResolve() throws ObjectStreamException {
    return resolve(NODEID_MAP, this);
  }

  /**
   * Constructor.
   *
   * @param material an array of length at least IdBitLength/32 containing raw
   *      Id material.
   * @return DESCRIBE THE RETURN VALUE
   */
  public static NodeId buildNodeId(int material[]) {
    return (NodeId) resolve(NODEID_MAP, new NodeId(material));
  }

  /**
   * Constructor.
   *
   * @param material an array of length at least IdBitLength/8 containing raw Id
   *      material.
   * @return DESCRIBE THE RETURN VALUE
   */
  public static NodeId buildNodeId(byte[] material) {
    return buildNodeId(trans(material));
  }

  /**
   * Constructor. It constructs a new Id with a value of 0 for all bits.
   *
   * @return DESCRIBE THE RETURN VALUE
   */
  public static NodeId buildNodeId() {
    return buildNodeId(new int[nlen]);
  }
}

