/*************************************************************************

"FreePastry" Peer-to-Peer Application Development Substrate 

Copyright 2002, Rice University. All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

- Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.

- Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

- Neither  the name  of Rice  University (RICE) nor  the names  of its
contributors may be  used to endorse or promote  products derived from
this software without specific prior written permission.

This software is provided by RICE and the contributors on an "as is"
basis, without any representations or warranties of any kind, express
or implied including, but not limited to, representations or
warranties of non-infringement, merchantability or fitness for a
particular purpose. In no event shall RICE or contributors be liable
for any direct, indirect, incidental, special, exemplary, or
consequential damages (including, but not limited to, procurement of
substitute goods or services; loss of use, data, or profits; or
business interruption) however caused and on any theory of liability,
whether in contract, strict liability, or tort (including negligence
or otherwise) arising in any way out of the use of this software, even
if advised of the possibility of such damage.

********************************************************************************/

package rice.pastry;

import java.io.*;
import java.util.*;

import rice.pastry.messaging.*;

/**
 * This interface is for any objects who need to automatically have the
 * PastryNode assigned to it upon reception off of the wire. As of FreePastry
 * 1.4.1, this is now done by the PastryObjectInputStream. The main object that
 * needs this is the NodeHandle. So that NodeHandle.receiveMessage() will work.
 * When using the commonAPI, this is not necessary.
 *
 * @version $Id: LocalNodeI.java,v 1.5 2005/08/12 14:28:34 jeffh Exp $
 * @author Alan Mislove
 */
public interface LocalNodeI extends Serializable {

  /**
   * Accessor method.
   *
   * @return The LocalNode value
   */
  public PastryNode getLocalNode();

  /**
   * Accessor method. Notifies the overridable afterSetLocalNode.
   *
   * @param pn The new LocalNode value
   */
  public void setLocalNode(PastryNode pn);

  /**
   * May be called from handle etc methods to ensure that local node has been
   * set, either on construction or on deserialization/receivemsg.
   */
  public void assertLocalNode();
}
