/*************************************************************************

"FreePastry" Peer-to-Peer Application Development Substrate 

Copyright 2002, Rice University. All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

- Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.

- Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

- Neither  the name  of Rice  University (RICE) nor  the names  of its
contributors may be  used to endorse or promote  products derived from
this software without specific prior written permission.

This software is provided by RICE and the contributors on an "as is"
basis, without any representations or warranties of any kind, express
or implied including, but not limited to, representations or
warranties of non-infringement, merchantability or fitness for a
particular purpose. In no event shall RICE or contributors be liable
for any direct, indirect, incidental, special, exemplary, or
consequential damages (including, but not limited to, procurement of
substitute goods or services; loss of use, data, or profits; or
business interruption) however caused and on any theory of liability,
whether in contract, strict liability, or tort (including negligence
or otherwise) arising in any way out of the use of this software, even
if advised of the possibility of such damage.

********************************************************************************/

package rice.p2p.past.messaging;

import rice.*;
import rice.p2p.commonapi.*;
import rice.p2p.past.*;

/**
 * @(#) InsertMessage.java This class represents a message which is an insert
 * request in past.
 *
 * @version $Id: InsertMessage.java,v 1.10 2005/03/11 00:58:05 jeffh Exp $
 * @author Alan Mislove
 * @author Ansley Post
 * @author Peter Druschel
 */
public class InsertMessage extends ContinuationMessage {

  // the data to insert
  /**
   * DESCRIBE THE FIELD
   */
  protected PastContent content;

  // serailver for bward compatibility
  final static long serialVersionUID = -7027957470028259605L;

  /**
   * Constructor which takes a unique integer Id, as well as the data to be
   * stored
   *
   * @param uid The unique id
   * @param content The content to be inserted
   * @param source The source address
   * @param dest The destination address
   */
  public InsertMessage(int uid, PastContent content, NodeHandle source, Id dest) {
    super(uid, source, dest);

    this.content = content;
  }

  /**
   * Method which returns the content
   *
   * @return The contained content
   */
  public PastContent getContent() {
    return content;
  }

  /**
   * Method which builds a response for this message, using the provided object
   * as a result.
   *
   * @param o The object argument
   */
  public void receiveResult(Object o) {
    super.receiveResult(o);
    content = null;
  }

  /**
   * Method which builds a response for this message, using the provided
   * exception, which was thrown
   *
   * @param e The exception argument
   */
  public void receiveException(Exception e) {
    super.receiveException(e);
    content = null;
  }

  /**
   * Returns a string representation of this message
   *
   * @return A string representing this message
   */
  public String toString() {
    return "[InsertMessage for " + content + "]";
  }
}

