/*************************************************************************

"FreePastry" Peer-to-Peer Application Development Substrate 

Copyright 2002, Rice University. All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

- Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.

- Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

- Neither  the name  of Rice  University (RICE) nor  the names  of its
contributors may be  used to endorse or promote  products derived from
this software without specific prior written permission.

This software is provided by RICE and the contributors on an "as is"
basis, without any representations or warranties of any kind, express
or implied including, but not limited to, representations or
warranties of non-infringement, merchantability or fitness for a
particular purpose. In no event shall RICE or contributors be liable
for any direct, indirect, incidental, special, exemplary, or
consequential damages (including, but not limited to, procurement of
substitute goods or services; loss of use, data, or profits; or
business interruption) however caused and on any theory of liability,
whether in contract, strict liability, or tort (including negligence
or otherwise) arising in any way out of the use of this software, even
if advised of the possibility of such damage.

********************************************************************************/

package rice.p2p.commonapi;

import java.io.*;

/**
 * @(#) IdRange.java Represents a contiguous range of Ids.
 *
 * @version $Id: IdRange.java,v 1.10 2005/03/11 00:58:02 jeffh Exp $
 * @author Alan Mislove
 * @author Peter Druschel
 */
public interface IdRange extends Serializable {

  /**
   * test if a given key lies within this range
   *
   * @param key the key
   * @return true if the key lies within this range, false otherwise
   */
  public boolean containsId(Id key);

  /**
   * get counterclockwise edge of range
   *
   * @return the id at the counterclockwise edge of the range (inclusive)
   */
  public Id getCCWId();

  /**
   * get clockwise edge of range
   *
   * @return the id at the clockwise edge of the range (exclusive)
   */
  public Id getCWId();

  /**
   * get the complement of this range
   *
   * @return This range's complement
   */
  public IdRange getComplementRange();

  /**
   * merges the given range with this range
   *
   * @param range DESCRIBE THE PARAMETER
   * @return The merge
   */
  public IdRange mergeRange(IdRange range);

  /**
   * diffs the given range with this range
   *
   * @param range DESCRIBE THE PARAMETER
   * @return The merge
   */
  public IdRange diffRange(IdRange range);

  /**
   * intersects the given range with this range
   *
   * @param range DESCRIBE THE PARAMETER
   * @return The merge
   */
  public IdRange intersectRange(IdRange range);

  /**
   * returns whether or not this range is empty
   *
   * @return Whether or not this range is empty
   */
  public boolean isEmpty();
}


