/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;

public abstract class ASN1OctetString
extends DERObject {
    byte[] string;

    public static ASN1OctetString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return ASN1OctetString.getInstance(aSN1TaggedObject.getObject());
    }

    public static ASN1OctetString getInstance(Object object) {
        if (object == null || object instanceof ASN1OctetString) {
            return (ASN1OctetString)object;
        }
        if (object instanceof ASN1TaggedObject) {
            return ASN1OctetString.getInstance(((ASN1TaggedObject)object).getObject());
        }
        if (object instanceof BERConstructedSequence) {
            Vector vector = new Vector();
            Enumeration enumeration = ((BERConstructedSequence)object).getObjects();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            return new BERConstructedOctetString(vector);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public ASN1OctetString(byte[] byArray) {
        this.string = byArray;
    }

    public ASN1OctetString(DEREncodable dEREncodable) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            dEROutputStream.writeObject(dEREncodable);
            dEROutputStream.close();
            this.string = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Error processing object : " + iOException.toString());
        }
    }

    public byte[] getOctets() {
        return this.string;
    }

    public int hashCode() {
        byte[] byArray = this.getOctets();
        int n = 0;
        int n2 = 0;
        while (n2 != byArray.length) {
            n ^= (byArray[n2] & 0xFF) << n2 % 4;
            ++n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        byte[] byArray;
        if (object == null || !(object instanceof DEROctetString)) {
            return false;
        }
        DEROctetString dEROctetString = (DEROctetString)object;
        byte[] byArray2 = dEROctetString.getOctets();
        if (byArray2.length != (byArray = this.getOctets()).length) {
            return false;
        }
        int n = 0;
        while (n != byArray2.length) {
            if (byArray2[n] != byArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    abstract void encode(DEROutputStream var1) throws IOException;
}

