/*************************************************************************

"FreePastry" Peer-to-Peer Application Development Substrate 

Copyright 2002, Rice University. All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

- Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.

- Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

- Neither  the name  of Rice  University (RICE) nor  the names  of its
contributors may be  used to endorse or promote  products derived from
this software without specific prior written permission.

This software is provided by RICE and the contributors on an "as is"
basis, without any representations or warranties of any kind, express
or implied including, but not limited to, representations or
warranties of non-infringement, merchantability or fitness for a
particular purpose. In no event shall RICE or contributors be liable
for any direct, indirect, incidental, special, exemplary, or
consequential damages (including, but not limited to, procurement of
substitute goods or services; loss of use, data, or profits; or
business interruption) however caused and on any theory of liability,
whether in contract, strict liability, or tort (including negligence
or otherwise) arising in any way out of the use of this software, even
if advised of the possibility of such damage.

********************************************************************************/

package rice.pastry;

import java.util.*;

/**
 * An interface to a generic set of nodes.
 *
 * @version $Id: NodeSetI.java 2302 2005-03-11 00:58:26Z jeffh $
 * @author Andrew Ladd
 */

public interface NodeSetI extends rice.p2p.commonapi.NodeHandleSet {
  /**
   * Puts a NodeHandle into the set.
   *
   * @param handle the handle to put.
   * @return true if the put succeeded, false otherwise.
   */

  public boolean put(NodeHandle handle);

  /**
   * Finds the NodeHandle associated with the NodeId.
   *
   * @param nid a node id.
   * @return the handle associated with that id or null if no such handle is
   *      found.
   */

  public NodeHandle get(NodeId nid);


  /**
   * Gets the ith element in the set.
   *
   * @param i an index.
   * @return the handle associated with that id or null if no such handle is
   *      found.
   */

  public NodeHandle get(int i);

  /**
   * Verifies if the set contains this particular id.
   *
   * @param nh DESCRIBE THE PARAMETER
   * @return true if that node id is in the set, false otherwise.
   */

  public boolean member(NodeHandle nh);

  /**
   * Removes a node id and its handle from the set.
   *
   * @param nh DESCRIBE THE PARAMETER
   * @return the node handle removed or null if nothing.
   */

  public NodeHandle remove(NodeHandle nh);

  /**
   * Gets the size of the set.
   *
   * @return the size.
   */

  public int size();

  /**
   * Gets the index of the element with the given node id.
   *
   * @param nid the node id.
   * @return the index or throws a NoSuchElementException.
   * @exception NoSuchElementException DESCRIBE THE EXCEPTION
   */

  public int getIndex(NodeId nid) throws NoSuchElementException;

  /**
   * Gets the Index attribute of the NodeSetI object
   *
   * @param nh DESCRIBE THE PARAMETER
   * @return The Index value
   * @exception NoSuchElementException DESCRIBE THE EXCEPTION
   */
  public int getIndex(NodeHandle nh) throws NoSuchElementException;
}
