/*************************************************************************

"FreePastry" Peer-to-Peer Application Development Substrate 

Copyright 2002, Rice University. All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

- Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.

- Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

- Neither  the name  of Rice  University (RICE) nor  the names  of its
contributors may be  used to endorse or promote  products derived from
this software without specific prior written permission.

This software is provided by RICE and the contributors on an "as is"
basis, without any representations or warranties of any kind, express
or implied including, but not limited to, representations or
warranties of non-infringement, merchantability or fitness for a
particular purpose. In no event shall RICE or contributors be liable
for any direct, indirect, incidental, special, exemplary, or
consequential damages (including, but not limited to, procurement of
substitute goods or services; loss of use, data, or profits; or
business interruption) however caused and on any theory of liability,
whether in contract, strict liability, or tort (including negligence
or otherwise) arising in any way out of the use of this software, even
if advised of the possibility of such damage.

********************************************************************************/
package rice.p2p.aggregation;

import rice.p2p.commonapi.*;
import rice.p2p.past.*;
import rice.p2p.past.gc.*;

/**
 * DESCRIBE THE CLASS
 *
 * @version $Id: pretty.settings 2305 2005-03-11 20:22:33Z jeffh $
 * @author jeffh
 */
class AggregateHandle implements PastContentHandle, GCPastContentHandle {

  /**
   * DESCRIBE THE FIELD
   */
  protected Id id;
  /**
   * DESCRIBE THE FIELD
   */
  protected NodeHandle handle;
  /**
   * DESCRIBE THE FIELD
   */
  protected long version;
  /**
   * DESCRIBE THE FIELD
   */
  protected long expiration;

  /**
   * Constructor for AggregateHandle.
   *
   * @param handle DESCRIBE THE PARAMETER
   * @param id DESCRIBE THE PARAMETER
   * @param version DESCRIBE THE PARAMETER
   * @param expiration DESCRIBE THE PARAMETER
   */
  public AggregateHandle(NodeHandle handle, Id id, long version, long expiration) {
    this.id = id;
    this.handle = handle;
    this.version = version;
    this.expiration = expiration;
  }

  /**
   * Gets the Id attribute of the AggregateHandle object
   *
   * @return The Id value
   */
  public Id getId() {
    return id;
  }

  /**
   * Gets the NodeHandle attribute of the AggregateHandle object
   *
   * @return The NodeHandle value
   */
  public NodeHandle getNodeHandle() {
    return handle;
  }

  /**
   * Gets the Version attribute of the AggregateHandle object
   *
   * @return The Version value
   */
  public long getVersion() {
    return version;
  }

  /**
   * Gets the Expiration attribute of the AggregateHandle object
   *
   * @return The Expiration value
   */
  public long getExpiration() {
    return expiration;
  }

}

